/*
 * gtapi.h
 * GnuTime module
 *
 * Copyright (C) 1998 Rasca, Berlin
 * EMail: thron@gmx.de
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GTAPI_H__
#define __GTAPI_H__

#include <gt/gtatoms.h>
#include <gt/gttypes.h>

void *alloc_atom (int);

void *gt_alloc_atom (int type, int nmb);
void gt_atom_free (gt_atom *);
int gt_write_atom (gt_atom *, FILE *);
unsigned int gt_time(void);
gt_atom *gt_get_movie (FILE *);

void gt_swap2byte (ui16 *);
void gt_swap4byte (ui32 *);

int gt_write2byte (ui16, FILE *fp);
int gt_write4byte (ui32, FILE *fp);

int gt_read2byte (ui16 *, FILE *fp);
int gt_read4byte (ui32 *, FILE *fp);

gt_movie *gt_movie_new (int type, int tracks, const char *file);
void gt_movie_free (gt_movie *);
int gt_movie_add_atom (gt_movie *, gt_atom *);
int gt_movie_write_moov (gt_movie *, const char *file);
gt_trak_atom *gt_track_new (int id, int width, int height, int type, int subs);
gt_minf_atom *gt_media_info_new (int type, int subatoms);
gt_mdia_atom *gt_media_new (int type, int time, int subatoms);
gt_dinf_atom *gt_data_info_new (int subatoms);
gt_stbl_atom *gt_sample_new (int format, int width,int height,int,int subatoms);
void gt_atom_add (gt_atom *, gt_atom *);
#endif
