/*
 * app_data.h,
 *
 * Copyright (C) 1997 Rasca Gmelch, Berlin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* some flags
 *  */
#define FLG_NONE                        0
#define FLG_MNG_CLONE                   1
#define FLG_RUN_VERBOSE                 2
#define FLG_EXPAND_TO_24BIT             4
#define FLG_MULTI_IMAGE                 8
#define FLG_USE_SHM                     16
#define FLG_USE_DGA                     32
#define FLG_USE_V4L                     64
#define FLG_SOURCE                      (FLG_USE_DGA | FLG_USE_SHM | FLG_USE_V4L)
#define FLG_REC_SND                     128
#define FLG_SYNC                        256
#define FLG_NOGUI                       512
#define FLG_AUDIO_WANTED                1024
#define FLG_AUTO_CONTINUE               2048

/* moving AppData definition here to make it available to options.c, control.c etc.
 */
typedef struct {
    float fps;      /* frames per second */
    char *file;     /* file pattern */
    int targetCodec; /* for video encoding */
    int verbose;    /* verbose level */
    int flags;
    int cap_width;
    int cap_height;
    int cap_pos_x;
    int cap_pos_y;
    float time;     /* time in seconds to record */
    int frames;
    int start_no;
    int step;
    int compress;
    int quality;
    int bpp;        /* bits per pixel */
    int mouseWanted; /* 0 none , 1 white , 2 black */
    char *source;
    char *snddev;
    int sndrate;
    int sndsize;
    int sndchannels;
    char *play_cmd;
    char *video_cmd;
    char *edit_cmd;
    char *help_cmd;
    char *device;
    Boolean use_clone;
} AppData;

