/*
 * gtk2_frame.c,
 *
 * Copyright (C) 1997 Rasca Gmelch, Berlin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * This file contains routines for setting up and handling the selection
 * rectangle. Both Xt and GTK2 versions are in here now.
 *
 */

#include "../config.h" //autoconf output
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include "Xw/Toggle.h"
#include "Xw/Label.h"
#include "frame.h"
#include "gtk2_frame.h"
#include "app_data.h"
#include "job.h"

#include "gtk/gtk.h"
#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h>
#include "gtk2_support.h"

/*
 * some globals
 */
static GtkWidget *myGtkTop, *myGtkLeft, *myGtkRight, *myGtkBottom, *myGtkBlind;
static int old_topwin_x, old_topwin_y;
extern XRectangle XVC_frame_rectangle;
extern int XVC_frame_lock;


#define GLADE_HOOKUP_OBJECT_NO_REF(component, widget, name) \
g_object_set_data(G_OBJECT(component), name, widget)



/*
 *   Change Frame due to user input
 *
 */
void
GtkChangeFrame(int x, int y, int width, int height, Boolean reposition_control) {
    int frame_width = FRAME_WIDTH;
    int max_width, max_height;
    GdkScreen *myscreen;
    int pwidth, pheight;
    extern GtkWidget *window1;
    Display *dpy;
    
    Job *job = job_ptr();
    
    /* we have to adjust it to viewable areas
     */
    if ( ! (job->flags & FLG_NOGUI ) ) {
        myscreen = GTK_WINDOW(myGtkTop)->screen;
        max_width = gdk_screen_get_width(myscreen);
        max_height= gdk_screen_get_height(myscreen);
    } else {
        dpy = XOpenDisplay(NULL);
        max_width = WidthOfScreen(DefaultScreenOfDisplay(dpy));
        max_height = HeightOfScreen(DefaultScreenOfDisplay(dpy));
    }
    #ifdef DEBUG
    printf("ChangeFrame() screen = %dx%d selection=%dx%d\n",
    max_width, max_height, width, height);
    #endif
    if (x < 0)
        x = 0;
    if (width > max_width)
        width = max_width;
    if (x + width > max_width)
        x = max_width - width;
    
    if (height > max_height)
        height = max_height;
    if (y + height > max_height)
        y = max_height - height;
    if (y < 0)
        y = 0;
    
    if ( ! (job->flags & FLG_NOGUI ) ) {
        gtk_widget_set_size_request(myGtkTop, (width + 2 * FRAME_WIDTH), FRAME_WIDTH);
        gtk_window_move(GTK_WINDOW(myGtkTop), (x - FRAME_WIDTH), (y - FRAME_WIDTH));
        gtk_widget_set_size_request(myGtkLeft, FRAME_WIDTH, height);
        gtk_window_move(GTK_WINDOW(myGtkLeft), (x - FRAME_WIDTH), y);
        gtk_widget_set_size_request(myGtkBottom, (width + 2 * FRAME_WIDTH), FRAME_WIDTH);
        gtk_window_move(GTK_WINDOW(myGtkBottom), (x - FRAME_WIDTH), (y+height));
        gtk_widget_set_size_request(myGtkRight, FRAME_WIDTH, height);
        gtk_window_move(GTK_WINDOW(myGtkRight), (x+width), y);
        
        if (myGtkBlind)
            gtk_window_move(GTK_WINDOW(myGtkBlind), x, y);
    }
    
    XVC_frame_rectangle.x = x;
    XVC_frame_rectangle.y = y;
    XVC_frame_rectangle.width = width;
    XVC_frame_rectangle.height= height;
    
    if (!IsFrameLocked() && (!(job->flags & FLG_NOGUI)) && reposition_control ) {
        gtk_window_get_size( GTK_WINDOW(window1), &pwidth, &pheight);
        pwidth += FRAME_OFFSET;
        pheight += FRAME_OFFSET;
        
        if ( ( y - pheight - 30 ) >= 0 ) {
            // FIXME: find out how to determine title bar height, if possible
            // don't know real title bar height ...
            // If I knew, I perhaps didn't absolutely need to unlock the frame
            // if a position is given ...
            gtk_window_move(GTK_WINDOW(window1), x, ( y - pheight - 30 ) );
        } else {
            if ( ( y + pheight + height ) < max_height ) {
                gtk_window_move(GTK_WINDOW(window1), x, ( y + height + FRAME_OFFSET ) );
            } else {
                if ( x > pwidth ) {
                    gtk_window_move(GTK_WINDOW(window1), (x - pwidth), y );
                } else {
                    if ( ( x + width + pwidth ) < max_width ) {
                        gtk_window_move(GTK_WINDOW(window1), ( x + width + FRAME_OFFSET ), y );
                    }
                    // ansonsten lass das GUI wo es ist ...
                }
            }
        }
    }
    
    
}


//
// on move of window move frame too if locked
static gint on_configure_event(GtkWidget *w, GdkEventConfigure *e) {
    gint x, y, pwidth, pheight;
    
    if (IsFrameLocked()) {
        x = ((GdkEventConfigure*) e)->x;
        y = ((GdkEventConfigure*) e)->y;
        pwidth = ((GdkEventConfigure*) e)->width;
        pheight = ((GdkEventConfigure*) e)->height;
        y += pheight + FRAME_OFFSET;
        GtkChangeFrame(x, y, XVC_frame_rectangle.width, XVC_frame_rectangle.height, FALSE);
    }
    return FALSE;
}


void
GtkCreateFrame(GtkWindow *topwin, int width, int height, int flags) {
    gint	x, y, pwidth, pheight;
    GdkScreen *g_screen;
    GdkWindow *g_root_win, *g_top, *g_left, *g_right, *g_bottom;
    GtkWidget *gw_top, *gw_left, *gw_right, *gw_bottom;
    GdkCursor *cursor;
    GdkColor g_col;
    GdkColormap *colormap;
    GdkGC *gc;

    int n;
    
    #ifdef DEBUG
    printf("GtkCreateFrame() %d %d\n", width, height);
    #endif
    
    gtk_window_set_gravity( GTK_WINDOW(topwin), GDK_GRAVITY_NORTH_WEST );
    gtk_window_get_position( GTK_WINDOW(topwin), &x, &y);
    gtk_window_get_size( GTK_WINDOW(topwin), &pwidth, &pheight);
    gtk_window_set_gravity( GTK_WINDOW(topwin), GDK_GRAVITY_STATIC );
    gtk_window_get_position( GTK_WINDOW(topwin), &x, &y);
    gtk_window_get_size( GTK_WINDOW(topwin), &pwidth, &pheight);
    //	printf("pos: %i/%i , size: %i/%i\n", x, y, pwidth, pheight);
    
    if (x < 0)
        x = 0;
    y += pheight + FRAME_OFFSET;
    if (y < 0)
        y = 0;
    XVC_frame_rectangle.width = width;
    XVC_frame_rectangle.height= height;
    XVC_frame_rectangle.x = x;
    XVC_frame_rectangle.y = y;
    
    if ( ! ( flags & FLG_NOGUI ) ) {
        //top of frame
        myGtkTop = gtk_dialog_new();
        gtk_widget_set_size_request(myGtkTop, (width + 2 * FRAME_WIDTH), FRAME_WIDTH);
        gtk_widget_set_sensitive(myGtkTop, FALSE);
        //	gtk_widget_set_sensitive (myGtkTop, TRUE);
        gtk_window_set_title(GTK_WINDOW(myGtkTop), "myGtkTop");
        GTK_WINDOW(myGtkTop)->type = GTK_WINDOW_POPUP;
        gtk_window_set_resizable(GTK_WINDOW(myGtkTop), FALSE);
        //	gtk_window_set_resizable (GTK_WINDOW (myGtkTop), TRUE);
        gtk_dialog_set_has_separator(GTK_DIALOG(myGtkTop), FALSE);
        GLADE_HOOKUP_OBJECT_NO_REF(myGtkTop, myGtkTop, "myGtkTop");
        //	cursor = gdk_cursor_new( GDK_TOP_SIDE );
        //	gw_top = GTK_WIDGET (myGtkTop);
        //	printf("gw_top gtk widget pointer: %p\n", gw_top);
        //	g_top = gtk_widget_get_parent_window ( GTK_WIDGET( myGtkTop ));
        //	printf("g_top gdk window pointer: %p\n", g_top);
        //	gdk_window_set_cursor (g_top, cursor);
        colormap = gtk_widget_get_colormap(myGtkTop);
        if (gdk_color_parse("red", &g_col)){
            if (gdk_colormap_alloc_color(colormap, &g_col, FALSE, TRUE)) {
                gtk_widget_modify_bg (myGtkTop, GTK_STATE_NORMAL, &g_col);
                gtk_widget_modify_bg (myGtkTop, GTK_STATE_ACTIVE, &g_col);
                gtk_widget_modify_bg (myGtkTop, GTK_STATE_PRELIGHT, &g_col);
                gtk_widget_modify_bg (myGtkTop, GTK_STATE_INSENSITIVE, &g_col);
                gtk_widget_modify_bg (myGtkTop, GTK_STATE_SELECTED, &g_col);

                gtk_widget_modify_fg (myGtkTop, GTK_STATE_NORMAL, &g_col);
                gtk_widget_modify_fg (myGtkTop, GTK_STATE_ACTIVE, &g_col);
                gtk_widget_modify_fg (myGtkTop, GTK_STATE_PRELIGHT, &g_col);
                gtk_widget_modify_fg (myGtkTop, GTK_STATE_INSENSITIVE, &g_col);
                gtk_widget_modify_fg (myGtkTop, GTK_STATE_SELECTED, &g_col);
            }
        }
        gtk_widget_show(myGtkTop);
        gtk_window_move(GTK_WINDOW(myGtkTop), (x - FRAME_WIDTH), (y - FRAME_WIDTH));
        
        //left side of frame
        myGtkLeft = gtk_dialog_new();
        gtk_widget_set_size_request(myGtkLeft, FRAME_WIDTH, height);
        gtk_widget_set_sensitive(myGtkLeft, FALSE);
        gtk_window_set_title(GTK_WINDOW(myGtkLeft), "myGtkLeft");
        GTK_WINDOW(myGtkLeft)->type = GTK_WINDOW_POPUP;
        gtk_window_set_resizable(GTK_WINDOW(myGtkLeft), FALSE);
        gtk_dialog_set_has_separator(GTK_DIALOG(myGtkLeft), FALSE);
        GLADE_HOOKUP_OBJECT_NO_REF(myGtkLeft, myGtkLeft, "myGtkLeft");
        colormap = gtk_widget_get_colormap(myGtkLeft);
        if (gdk_color_parse("red", &g_col)){
            if (gdk_colormap_alloc_color(colormap, &g_col, FALSE, TRUE)) {
                gtk_widget_modify_bg (myGtkLeft, GTK_STATE_NORMAL, &g_col);
                gtk_widget_modify_bg (myGtkLeft, GTK_STATE_ACTIVE, &g_col);
                gtk_widget_modify_bg (myGtkLeft, GTK_STATE_PRELIGHT, &g_col);
                gtk_widget_modify_bg (myGtkLeft, GTK_STATE_INSENSITIVE, &g_col);
                gtk_widget_modify_bg (myGtkLeft, GTK_STATE_SELECTED, &g_col);

                gtk_widget_modify_fg (myGtkLeft, GTK_STATE_NORMAL, &g_col);
                gtk_widget_modify_fg (myGtkLeft, GTK_STATE_ACTIVE, &g_col);
                gtk_widget_modify_fg (myGtkLeft, GTK_STATE_PRELIGHT, &g_col);
                gtk_widget_modify_fg (myGtkLeft, GTK_STATE_INSENSITIVE, &g_col);
                gtk_widget_modify_fg (myGtkLeft, GTK_STATE_SELECTED, &g_col);
            }
        }
        gtk_widget_show(myGtkLeft);
        gtk_window_move(GTK_WINDOW(myGtkLeft), (x - FRAME_WIDTH), y);
        
        //bottom of frame
        myGtkBottom = gtk_dialog_new();
        gtk_widget_set_size_request(myGtkBottom, (width + 2 * FRAME_WIDTH), FRAME_WIDTH);
        gtk_widget_set_sensitive(myGtkBottom, FALSE);
        gtk_window_set_title(GTK_WINDOW(myGtkBottom), "myGtkBottom");
        GTK_WINDOW(myGtkBottom)->type = GTK_WINDOW_POPUP;
        gtk_window_set_resizable(GTK_WINDOW(myGtkBottom), FALSE);
        gtk_dialog_set_has_separator(GTK_DIALOG(myGtkBottom), FALSE);
        GLADE_HOOKUP_OBJECT_NO_REF(myGtkBottom, myGtkBottom, "myGtkBottom");
        colormap = gtk_widget_get_colormap(myGtkBottom);
        if (gdk_color_parse("red", &g_col)){
            if (gdk_colormap_alloc_color(colormap, &g_col, FALSE, TRUE)) {
                gtk_widget_modify_bg (myGtkBottom, GTK_STATE_NORMAL, &g_col);
                gtk_widget_modify_bg (myGtkBottom, GTK_STATE_ACTIVE, &g_col);
                gtk_widget_modify_bg (myGtkBottom, GTK_STATE_PRELIGHT, &g_col);
                gtk_widget_modify_bg (myGtkBottom, GTK_STATE_INSENSITIVE, &g_col);
                gtk_widget_modify_bg (myGtkBottom, GTK_STATE_SELECTED, &g_col);

                gtk_widget_modify_fg (myGtkBottom, GTK_STATE_NORMAL, &g_col);
                gtk_widget_modify_fg (myGtkBottom, GTK_STATE_ACTIVE, &g_col);
                gtk_widget_modify_fg (myGtkBottom, GTK_STATE_PRELIGHT, &g_col);
                gtk_widget_modify_fg (myGtkBottom, GTK_STATE_INSENSITIVE, &g_col);
                gtk_widget_modify_fg (myGtkBottom, GTK_STATE_SELECTED, &g_col);
            }
        }
        gtk_widget_show(myGtkBottom);
        gtk_window_move(GTK_WINDOW(myGtkBottom), (x - FRAME_WIDTH), (y+height));
        
        //right side of frame
        myGtkRight = gtk_dialog_new();
        gtk_widget_set_size_request(myGtkRight, FRAME_WIDTH, height);
        gtk_widget_set_sensitive(myGtkRight, FALSE);
        gtk_window_set_title(GTK_WINDOW(myGtkRight), "myGtkRight");
        GTK_WINDOW(myGtkRight)->type = GTK_WINDOW_POPUP;
        gtk_window_set_resizable(GTK_WINDOW(myGtkRight), FALSE);
        gtk_dialog_set_has_separator(GTK_DIALOG(myGtkRight), FALSE);
        GLADE_HOOKUP_OBJECT_NO_REF(myGtkRight, myGtkRight, "myGtkRight");
        colormap = gtk_widget_get_colormap(myGtkRight);
        if (gdk_color_parse("red", &g_col)){
            if (gdk_colormap_alloc_color(colormap, &g_col, FALSE, TRUE)) {
                gtk_widget_modify_bg (myGtkRight, GTK_STATE_NORMAL, &g_col);
                gtk_widget_modify_bg (myGtkRight, GTK_STATE_ACTIVE, &g_col);
                gtk_widget_modify_bg (myGtkRight, GTK_STATE_PRELIGHT, &g_col);
                gtk_widget_modify_bg (myGtkRight, GTK_STATE_INSENSITIVE, &g_col);
                gtk_widget_modify_bg (myGtkRight, GTK_STATE_SELECTED, &g_col);

                gtk_widget_modify_fg (myGtkRight, GTK_STATE_NORMAL, &g_col);
                gtk_widget_modify_fg (myGtkRight, GTK_STATE_ACTIVE, &g_col);
                gtk_widget_modify_fg (myGtkRight, GTK_STATE_PRELIGHT, &g_col);
                gtk_widget_modify_fg (myGtkRight, GTK_STATE_INSENSITIVE, &g_col);
                gtk_widget_modify_fg (myGtkRight, GTK_STATE_SELECTED, &g_col);
            }
        }
        gtk_widget_show(myGtkRight);
        gtk_window_move(GTK_WINDOW(myGtkRight), (x+width), y);
        
        if (flags & FLG_USE_V4L) {
            myGtkBlind = gtk_dialog_new();
            gtk_widget_set_size_request(myGtkBlind, width, height);
            gtk_widget_set_sensitive(myGtkBlind, FALSE);
            gtk_window_set_title(GTK_WINDOW(myGtkRight), "myGtkBlind");
            GTK_WINDOW(myGtkBlind)->type = GTK_WINDOW_POPUP;
            gtk_window_set_resizable(GTK_WINDOW(myGtkBlind), FALSE);
            gtk_dialog_set_has_separator(GTK_DIALOG(myGtkBlind), FALSE);
            GLADE_HOOKUP_OBJECT_NO_REF(myGtkBlind, myGtkBlind, "myGtkBlind");
            
            gtk_widget_show(myGtkBlind);
            gtk_window_move(GTK_WINDOW(myGtkBlind), x, y);
            
            //FIXME: right now the label for the Video Source is missing
            /*		myGtkBlind = XtVaCreatePopupShell ("blind", overrideShellWidgetClass, parent,
             XtNx, x+FRAME_WIDTH,
             XtNy, y+FRAME_WIDTH,
             XtNwidth, width,
             XtNheight, height,
             NULL);
             XtVaCreateManagedWidget ("text", xwLabelWidgetClass, blind,
             XtNlabel, "Source: Video4Linux", NULL);
             XtPopup(blind, XtGrabNone); */
        }
        
        //connect event-handler to configure event of gtk control window to redraw the
        //selection frame if the control is moved and the frame is locked
        g_signal_connect((gpointer) topwin, "configure-event",
        G_CALLBACK(on_configure_event), NULL);
        
    }
    XVC_frame_lock = 1;
    
}


void DestroyFrame() {
    gtk_widget_destroy(myGtkBottom);
    gtk_widget_destroy(myGtkRight);
    gtk_widget_destroy(myGtkLeft);
    gtk_widget_destroy(myGtkTop);
    if (myGtkBlind) {
        gtk_widget_destroy(myGtkBlind);
    }
}

