/* **********************************************************
 * Copyright (C) 1998-2004 VMware, Inc.
 * All Rights Reserved
 * **********************************************************/


#ifndef VM_VERSION_H
#define VM_VERSION_H

#define INCLUDE_ALLOW_USERLEVEL
#define INCLUDE_ALLOW_VMMEXT
#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMNIXMOD
#define INCLUDE_ALLOW_VMKERNEL

#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"


#if !(   defined(VMX86_SERVER)   \
      || defined(VMX86_WGS)      \
      || defined(VMX86_DESKTOP)  \
      || defined(VMX86_ENTERPRISE_DESKTOP) \
      || defined(VMX86_CONSOLE)  \
      || defined(VMX86_MUI)  	   \
      || defined(VMX86_API)      \
      || defined(VMX86_VPX)      \
      || defined(VMX86_WBC)      \
      || defined(VMX86_SDK)      \
      || defined(VMX86_TOOLS)    \
      || defined(VMX86_V2V)      \
      || defined(VMX86_SYSIMAGE) \
      || defined(VMX86_VCB)      \
      || defined(VMX86_VMLS)     \
      || defined(VMX86_P2V)      \
      || defined(VMX86_DTX))
#   if defined(_WIN32)
      /*
       * XXX Make the product be Workstation by default if none of the defines
       * XXX above are not defined in defs-globaldefs.mk -- Edward A. Waugh
       */
#      define VMX86_DESKTOP
#   else
#      error Unknown product
#   endif
#endif


/*
 * buildNumber.h is generated by make/mk/buildNumber.mk to match
 * the build number defined by the BUILD_NUMBER variable at the
 * beginning of every build.
 * --Jeremy Bar
 */
#include "buildNumber.h"

#ifdef VMX86_DEVEL
#   ifdef VMX86_DEBUG
#      define COMPILATION_OPTION "DEBUG"
#   else
#      define COMPILATION_OPTION "OPT"
#   endif
#else
#   ifdef VMX86_ALPHA
#      define COMPILATION_OPTION "ALPHA"
#   elif defined(VMX86_BETA)
#      ifdef VMX86_EXPERIMENTAL
#         define COMPILATION_OPTION "BETA-EXPERIMENTAL"
#      else
#         define COMPILATION_OPTION "BETA"
#      endif
#   elif defined(VMX86_RELEASE)
#      define COMPILATION_OPTION "Release"
#   elif defined(VMX86_OPT)
#      define COMPILATION_OPTION "OPT"
#   elif defined(VMX86_DEBUG)
#      define COMPILATION_OPTION "DEBUG"
#   endif
#endif


/*
 * This is used so we can identify the build and release type
 * in any generated core files.
 */

#define BUILD_VERSION COMPILATION_OPTION BUILD_NUMBER


/* Hard-coded expiration date */
#define DATE_DAY_MAX 31
#define DATE_MONTH_MAX 12
#define ENCODE_DATE(year, month, day) ((year) * ((DATE_MONTH_MAX + 1) * (DATE_DAY_MAX + 1)) + (month) * (DATE_DAY_MAX + 1) + (day))
#if !defined(VMX86_DEVEL) && defined(BUILD_EXPIRE)
#   if defined(VMX86_SERVER)
#      define HARD_EXPIRE ENCODE_DATE(2006, 8, 6)
#   elif defined(VMX86_WGS)
#      define HARD_EXPIRE ENCODE_DATE(2006, 8, 6)
#   elif defined(VMX86_DESKTOP)
#      define HARD_EXPIRE ENCODE_DATE(2006, 8, 6)
#   elif defined(VMX86_P2V)
#      define HARD_EXPIRE ENCODE_DATE(2006, 8, 6)
#   elif defined(VMX86_V2V)
#      define HARD_EXPIRE ENCODE_DATE(2006, 8, 6)
#   elif defined(VMX86_SYSIMAGE)
#      define HARD_EXPIRE ENCODE_DATE(2006, 8, 6)
#   elif defined(VMX86_VCB)
#      define HARD_EXPIRE ENCODE_DATE(2006, 8, 6)
#   elif defined(VMX86_VPX)
#      define HARD_EXPIRE ENCODE_DATE(2006, 8, 6)
#   elif defined(VMX86_WBC)
#      define HARD_EXPIRE ENCODE_DATE(2006, 8, 6)
#   elif defined(VMX86_SDK)
#      define HARD_EXPIRE ENCODE_DATE(2006, 8, 6)
#   endif
#endif


/****
 ****
 **** PLEASE use the various PRODUCT_* and *_NAME defines as though
 **** they were variables -- do not embed them in format strings,
 **** since they could contain a "%" sign or actually be a variable
 **** someday.
 ****
 ****/

/*
 * This generic name should be used when referring to any product of the
 * VMware product line, like VMware Workstation, VMware Server, and so
 * on...
 */
#define PRODUCT_GENERIC_NAME "VMware"
#define PRODUCT_GENERIC_NAME_UPPER "VMWARE"
#define PRODUCT_GENERIC_NAME_LOWER "vmware"

/*
 *  The following is used by VMware Server web update dialog
 */
#define VMWARE_SERVER_PRODUCT "VMware Server"

/*
 * This name should be used when referring to VMware Tools
 */
#define VMWARE_TOOLS_SHORT_NAME PRODUCT_GENERIC_NAME " Tools"

/*
 * This name should be used when referring to the company
 */
#define COMPANY_NAME       "VMware, Inc."
#define COPYRIGHT_YEARS    "1998-2006"
#define COPYRIGHT_STRING   "Copyright \251 " COPYRIGHT_YEARS " " COMPANY_NAME
#define UTF8_COPYRIGHT_STRING   "Copyright \302\251 " COPYRIGHT_YEARS " " COMPANY_NAME
#define RIGHT_RESERVED     "All rights reserved."
#define PATENTS_STRING     "Protected by one or more of U.S. Patent Nos.\n6,397,242, 6,496,847, 6,704,925, 6,711,672, 6,725,289,\n6,735,601, 6,785,886, 6,789,156, 6,795,966, 6,880,022,\n6,944,699, 6,961,806 and 6,961,941; patents pending."
#define TRADEMARK_STRING   "VMware, the VMware \"boxes\" logo and design, Virtual SMP and VMotion are\nregistered trademarks or trademarks of VMware, Inc. in the United States\nand/or other jurisdictions."
#define MICROSOFT_TRADEMARK_STRING "Microsoft, Windows and Windows NT are registered trademarks of Microsoft Corporation."
#define LINUX_TRADEMARK_STRING     "Linux is a registered trademark of Linus Torvalds."
#define FREEBSD_TRADEMARK_STRING   "FreeBSD is a registered trademark of the FreeBSD Foundation."
#define SOLARIS_TRADEMARK_STRING   "Solaris is a registered trademark of Sun Microsystems, Inc."
#define NETWARE_TRADEMARK_STRING   "NetWare is a registered trademark of Novell, Inc."
#define GENERIC_TRADEMARK_STRING   "All other marks and names mentioned herein may be trademarks of their\nrespective companies."

/* Used in .rc files on the Win32 platform --hpreg */
#if defined(VMX86_DESKTOP)
#  if defined(VMX86_ENTERPRISE_DESKTOP)                    // ACE
#    define PRODUCT_VERSION    1,0,0,BUILD_NUMBER_NUMERIC
#  elif defined(VMX86_DESKTOP_PLAYER)                      // Player
#    define PRODUCT_VERSION    1,0,0,BUILD_NUMBER_NUMERIC
#  else                                                    // Workstation
#    define PRODUCT_VERSION    5,5,0,BUILD_NUMBER_NUMERIC
#  endif
#else                                                      // VMserver
#  define PRODUCT_VERSION    1,0,0,BUILD_NUMBER_NUMERIC
#endif

/*
 * The VIE components are shared by different products and may be updated by newer
 * installers. Since the installer replaces the component files based on the version
 * resource, it's important that the file version be monotonically increasing. As
 * a result, these components need their own file version number that is
 * independent of the VMX86_XXX macros. This goes into the FILEVERSION property of
 * the version resources. The first release of this stuff was with VPX which had a
 * FILEVERSION of 1,0,0,BUILD_NUMBER_NUMERIC
 *
 * P2VA 2.0     : 2,1,2
 * VPX 1.2      : 2,1,3
 * V2V 1.0      : 2.2.0
 * SYSIMAGE 1.0 : 2.2.1 or later (TBD)
 * Symantec     : 2.2.2 7/2005
 * VC 2.0       : 2.2.3
 * P2V 2.1      : 2.2.4 (also used for WS55 betas and RC)
 * V2V 1.5      : 2.2.5 V2V 1.5 released with WS55
 * WS 5.1       : 2.2.5 to be set when WS55 branches
 * VCB 1.0      : 3.0.0 esx-dali: first release with vmacore + vstor3Bus
 * VMI 2.0      : 3.1.0
 * P2VA 3.0     : 3.?.?
 */
#define VIE_FILEVERSION 2,2,5,BUILD_NUMBER_NUMERIC

/*
 * This string can be a little more "free form".  The license
 * manager doesn't depend on it.  This is the version that will
 * be used by the build process, the UI, etc.  Things people see.
 *
 * If platforms are on different version numbers, manage it here.
 *
 * Manage version numbers for each product here.
 *
 *  NOTE:  BE AWARE that Makefiles and build scripts depend
 *         on these defines.
 *
 */

/*
 * This is the Scripting API (VmCOM, VmPerl, VmXXX) version number.
 * It is independent of the main VMX product version number.
 * The first released Scripting API from branch server02 has
 * version 2.0.0 to distinguish it from the legacy Perl API.
 *
 * Rules for updating the version:
 * - New features bump either major or minor version, depending on
 *   the magnitude of the change.
 * - A change that deprecates or obsoletes any existing interfaces
 *   requires a major version bump.
 * - Use explicit numbers and not defines!
 */
#define API_SCRIPTING_VERSION "1.0.0"

#define API_VMDB_VERSION "e.x.p"
#define ESX_VERSION "e.x.p"
#define GSX_VERSION "1.0.0"
#define VMSERVER_VERSION "1.0.0"
#define WORKSTATION_VERSION "1.0.0"
#define WORKSTATION_ENTERPRISE_VERSION "0.0.0"
#define MUI_VERSION "1.0.0"
#define CONSOLE_VERSION "1.0.0"
#define P2V_VERSION "e.x.p"
#define P2V_FILE_VERSION 3,0,0,0
#define PLAYER_VERSION "1.0.0"
#define V2V_VERSION "1.5.0"
#define V2V_FILE_VERSION 1,5,0,0
#define SYSIMAGE_VERSION "e.x.p"
#define SYSIMAGE_FILE_VERSION 1,0,0,0
#define VCB_VERSION "e.x.p"
#define VCB_FILE_VERSION 1,0,0,0
#define VPX_VERSION "e.x.p"
#define WBC_VERSION "e.x.p"
#define SDK_VERSION "e.x.p"
#define TFL_VERSION "1.0.0"
#define TFBSD_VERSION "1.0.0"
#define TFSOL_VERSION "1.0.0"
#define TFNW_VERSION "1.0.0"
#define TFWIN_VERSION "1.0.0"
#define FOUNDRY_VERSION "1.0.0"
#define VMLS_VERSION "e.x.p"
#define DTX_VERSION "e.x.p"

#define PRODUCT_API_SCRIPTING_VERSION API_SCRIPTING_VERSION " " BUILD_NUMBER

#if defined(VMX86_SERVER)
#  define PRODUCT_VERSION_NUMBER ESX_VERSION
#elif defined(VMX86_WGS_MIGRATION)
#  define PRODUCT_VERSION_NUMBER GSX_MIGRATION_VERSION
#elif defined(VMX86_WGS)
#  define PRODUCT_VERSION_NUMBER VMSERVER_VERSION
#elif defined(VMX86_MUI)
#  define PRODUCT_VERSION_NUMBER MUI_VERSION
#elif defined(VMX86_DESKTOP)            // Workstation family:
#  if defined(VMX86_ENTERPRISE_DESKTOP) // ACE
#     define PRODUCT_VERSION_NUMBER WORKSTATION_ENTERPRISE_VERSION
#  elif defined (VMX86_DESKTOP_PLAYER)  // Player
#     define PRODUCT_VERSION_NUMBER PLAYER_VERSION
#  else                                 // Workstation
#     define PRODUCT_VERSION_NUMBER WORKSTATION_VERSION
#  endif
#elif defined(VMX86_API)
#  define PRODUCT_VERSION_NUMBER API_SCRIPTING_VERSION
#elif defined(VMX86_VPX)
#  define PRODUCT_VERSION_NUMBER VPX_VERSION
#elif defined(VMX86_WBC)
#  define PRODUCT_VERSION_NUMBER WBC_VERSION
#elif defined(VMX86_SDK)
#  define PRODUCT_VERSION_NUMBER SDK_VERSION
#elif defined(VMX86_TFL)
#  define PRODUCT_VERSION_NUMBER TFL_VERSION
#elif defined(VMX86_P2V)
#  define PRODUCT_VERSION_NUMBER P2V_VERSION
#elif defined(VMX86_V2V)
#  define PRODUCT_VERSION_NUMBER V2V_VERSION
#elif defined(VMX86_SYSIMAGE)
#  define PRODUCT_VERSION_NUMBER SYSIMAGE_VERSION
#elif defined(VMX86_VCB)
#  define PRODUCT_VERSION_NUMBER VCB_VERSION
#elif defined(VMX86_TFBSD)
#  define PRODUCT_VERSION_NUMBER TFBSD_VERSION
#elif defined(VMX86_TFSOL)
#  define PRODUCT_VERSION_NUMBER TFSOL_VERSION
#elif defined(VMX86_TFNW)
#  define PRODUCT_VERSION_NUMBER TFNW_VERSION
#elif defined(VMX86_TFWIN)
#  define PRODUCT_VERSION_NUMBER TFWIN_VERSION
#elif defined(VMX86_FOUNDRY)
#  define PRODUCT_VERSION_NUMBER FOUNDRY_VERSION
#elif defined(VMX86_VMLS)
#  define PRODUCT_VERSION_NUMBER VMLS_VERSION
#elif defined(VMX86_DTX)
#  define PRODUCT_VERSION_NUMBER DTX_VERSION
#endif

#define PRODUCT_VERSION_STRING PRODUCT_VERSION_NUMBER " " BUILD_NUMBER

/*
 * The license manager requires that PRODUCT_VERSION_STRING matches the
 * following pattern: <x>[.<y>][.<z>].
 *
 * If platforms are on different version numbers, manage it here.
 */

#if defined(VMX86_TOOLS)
/* This product doesn't use a license */
#  define PRODUCT_VERSION_STRING_FOR_LICENSE ""
#  define PRODUCT_LICENSE_VERSION "0.0"
#else
#  if defined(VMX86_SERVER)
#    define PRODUCT_LICENSE_VERSION "2.0"
#  elif defined(VMX86_WGS_MIGRATION)
#    define PRODUCT_LICENSE_VERSION "1.0"
#  elif defined(VMX86_WGS)
#    define PRODUCT_LICENSE_VERSION "3.0"
#  elif defined(VMX86_ENTERPRISE_DESKTOP)
#    define PRODUCT_LICENSE_VERSION "1.0"
#  elif defined(VMX86_DESKTOP)
#    define PRODUCT_LICENSE_VERSION "5.5"
#  elif defined(VMX86_VPX)
#    define PRODUCT_LICENSE_VERSION "1.0"
#  elif defined(VMX86_WBC)
#    define PRODUCT_LICENSE_VERSION "1.0"
#  elif defined(VMX86_SDK)
#    define PRODUCT_LICENSE_VERSION "1.0"
#  elif defined(VMX86_P2V)
#    define PRODUCT_LICENSE_VERSION "1.0"
#  elif defined(VMX86_V2V)
#    define PRODUCT_LICENSE_VERSION "1.0"
#  else
#    define PRODUCT_LICENSE_VERSION "0.0"
#  endif
#  define PRODUCT_VERSION_STRING_FOR_LICENSE PRODUCT_LICENSE_VERSION " " BUILD_NUMBER
#endif

/*
 * The configuration file version string should be changed
 * whenever we make incompatible changes to the config file
 * format or to the meaning of settings.  When we do this,
 * we must also add code that detects the change and can
 * convert an old config file to a new one.
 */

#define CONFIG_VERSION_VARIABLE		"config.version"

/*
 * PREF_VERSION_VARIABLE somehow cannot be written through Dictionary_Write
 * (there is a bug after the first reload). So it's not used.
 */
/* #define PREF_VERSION_VARIABLE		"preferences.version"*/

#define CONFIG_VERSION_DEFAULT		"1"	/* if no version in file*/
#define CONFIG_VERSION                  "8"

#define CONFIG_VERSION_UNIFIEDSVGAME	"3"	/* Merged (S)VGA for WinME*/
#define CONFIG_VERSION_UNIFIEDSVGA	"4"	/* Merged (S)VGA enabled.  -J.*/
#define CONFIG_VERSION_440BX		"5"	/* 440bx becomes default */
#define CONFIG_VERSION_NEWMACSTYLE	"3"	/* ethernet?.oldMACStyle */
#define CONFIG_VERSION_WS2              "2"     /* config version of WS2.0.x */
#define CONFIG_VERSION_MIGRATION        "6"     /* migration work for WS3 */
#define CONFIG_VERSION_ESX2             "6"     /* config version of ESX 2.x */
#define CONFIG_VERSION_UNDOPOINT        "7"     /* Undopoint paradigm (WS40) */
#define CONFIG_VERSION_WS4              "7"     /* config version of WS4.0.x */
#define CONFIG_VERSION_MSNAP            "8"     /* Multiple Snapshots */

#define PRODUCT_SCALABLE_SERVER_NAME PRODUCT_GENERIC_NAME " ESX Server"
#define PRODUCT_ESX_SMP_NAME PRODUCT_GENERIC_NAME " Virtual SMP for ESX Server"
#define PRODUCT_WGS_NAME PRODUCT_GENERIC_NAME " Server"
#define PRODUCT_VMSERVER_NAME PRODUCT_GENERIC_NAME " Server"
#define PRODUCT_VMSERVER_SMP_NAME PRODUCT_GENERIC_NAME " Virtual SMP for VMware Server"
#define PRODUCT_GSX_SMP_NAME PRODUCT_GENERIC_NAME " Virtual SMP for VMware Server"
#define PRODUCT_WORKSTATION_NAME PRODUCT_GENERIC_NAME " Workstation"
#define PRODUCT_PLAYER_NAME PRODUCT_GENERIC_NAME " Player"
#define PRODUCT_WORKSTATION_ENTERPRISE_NAME PRODUCT_GENERIC_NAME " ACE"
#define PRODUCT_MUI_NAME PRODUCT_GENERIC_NAME " Management Interface"
#define PRODUCT_CONSOLE_NAME PRODUCT_GENERIC_NAME " Server Console"

/* For VMware Server licensing */
#define PRODUCT_NAME_ORIG          PRODUCT_GENERIC_NAME " GSX Server"
#define PRODUCT_GSX_SMP_NAME_ORIG  PRODUCT_GENERIC_NAME " Virtual SMP for GSX Server"

#define PRODUCT_VMLS_SHORT_NAME "VMLS"
#define PRODUCT_VMLS_NAME PRODUCT_GENERIC_NAME " License Server"

#define PRODUCT_P2V_SHORT_NAME "P2V"
#define PRODUCT_P2V_NAME PRODUCT_GENERIC_NAME " P2V Assistant"

#define PRODUCT_V2V_SHORT_NAME "V2V"
#define PRODUCT_V2V_NAME PRODUCT_GENERIC_NAME " Virtual Machine Importer"

#define PRODUCT_SYSIMAGE_SHORT_NAME "SysImage"
#define PRODUCT_SYSIMAGE_NAME PRODUCT_GENERIC_NAME " System Image Framework"

#define PRODUCT_VCB_SHORT_NAME "VCB"
#define PRODUCT_VCB_NAME PRODUCT_GENERIC_NAME " Consolidated Backup"

#define PRODUCT_API_SCRIPTING_COM_SHORT_NAME "VmCOM"
#define PRODUCT_API_SCRIPTING_PERL_SHORT_NAME "VmPerl"

#define PRODUCT_API_SCRIPTING_COM_NAME PRODUCT_GENERIC_NAME " " PRODUCT_API_SCRIPTING_COM_SHORT_NAME " Scripting API"

#define PRODUCT_API_SCRIPTING_PERL_NAME PRODUCT_GENERIC_NAME " " PRODUCT_API_SCRIPTING_PERL_SHORT_NAME " Scripting API"

#define PRODUCT_VPX_NAME PRODUCT_GENERIC_NAME " VirtualCenter"

#define PRODUCT_WBC_NAME PRODUCT_GENERIC_NAME " WebCenter"

#define PRODUCT_SDK_NAME PRODUCT_GENERIC_NAME " SDK"

#define PRODUCT_DTX_NAME PRODUCT_GENERIC_NAME " DTX"

// XXX VMvisor is the underlying technology for possibly several products,
// XXX not the product. Fix when names are decided.
#define PRODUCT_VMVISOR_NAME PRODUCT_GENERIC_NAME " VMvisor"

#if defined(VMVISOR)
# define PRODUCT_SHORT_NAME PRODUCT_VMVISOR_NAME
#elif defined(VMX86_SERVER)
# define PRODUCT_SHORT_NAME PRODUCT_SCALABLE_SERVER_NAME
#elif defined(VMX86_WGS_MIGRATION)
# define PRODUCT_SHORT_NAME PRODUCT_WGS_MIGRATION_NAME
#elif defined(VMX86_WGS)
#  if defined(VMX86_CONSOLE)
#     define PRODUCT_SHORT_NAME PRODUCT_CONSOLE_NAME
#  else
#     define PRODUCT_SHORT_NAME PRODUCT_VMSERVER_NAME
#  endif
#elif defined(VMX86_MUI)
# define PRODUCT_SHORT_NAME PRODUCT_MUI_NAME
#elif defined(VMX86_DESKTOP)
#  if defined(VMX86_ENTERPRISE_DESKTOP)
#     define PRODUCT_SHORT_NAME PRODUCT_WORKSTATION_ENTERPRISE_NAME
#  elif defined(VMX86_DESKTOP_PLAYER)
#     define PRODUCT_SHORT_NAME PRODUCT_PLAYER_NAME
#  else
#     define PRODUCT_SHORT_NAME PRODUCT_WORKSTATION_NAME
#  endif
#elif defined(VMX86_TOOLS)
# define PRODUCT_SHORT_NAME VMWARE_TOOLS_SHORT_NAME
#elif defined(VMX86_API)
#  if _WIN32
#     define PRODUCT_SHORT_NAME PRODUCT_API_SCRIPTING_COM_NAME
#  else
#     define PRODUCT_SHORT_NAME PRODUCT_API_SCRIPTING_PERL_NAME
#  endif
#elif defined(VMX86_VPX)
# define PRODUCT_SHORT_NAME PRODUCT_VPX_NAME
#elif defined(VMX86_WBC)
# define PRODUCT_SHORT_NAME PRODUCT_WBC_NAME
#elif defined(VMX86_SDK)
# define PRODUCT_SHORT_NAME PRODUCT_SDK_NAME
#elif defined(VMX86_P2V)
# define PRODUCT_SHORT_NAME PRODUCT_P2V_NAME
#elif defined(VMX86_V2V)
# define PRODUCT_SHORT_NAME PRODUCT_V2V_NAME
#elif defined(VMX86_SYSIMAGE)
# define PRODUCT_SHORT_NAME PRODUCT_SYSIMAGE_NAME
#elif defined(VMX86_VCB)
# define PRODUCT_SHORT_NAME PRODUCT_VCB_NAME
#elif defined(VMX86_VMLS)
# define PRODUCT_SHORT_NAME PRODUCT_VMLS_NAME
#elif defined(VMX86_DTX)
# define PRODUCT_SHORT_NAME PRODUCT_DTX_NAME
#endif


/*
 * Names of programs
 */

#if defined(VMX86_CONSOLE) && !defined(_WIN32)
   #define VMWARE_EXECUTABLE PRODUCT_GENERIC_NAME_LOWER "-server-console"
#else
#define VMWARE_EXECUTABLE PRODUCT_GENERIC_NAME_LOWER
#endif

#define VMWARE_VMX_EXECUTABLE PRODUCT_GENERIC_NAME_LOWER "-vmx"
#define CCAGENT_DISPLAY_NAME   PRODUCT_VPX_NAME " Agent"
#if defined(__linux__) || defined(__FreeBSD__)
#   define VMAUTHD_EXECUTABLE PRODUCT_GENERIC_NAME_LOWER "-authd"
#else
#   define VMAUTHD_DISPLAY_NAME   "VMware Authorization Service"
#   define VMSERVERD_DISPLAY_NAME "VMware Registration Service"
#   define VMNAT_DISPLAY_NAME     "VMware NAT Service"
#   define TOOLS_SERVICE_DISPLAY_NAME  "VMware Tools Service"
#   define TOOLS_SERVICE_NAME          "VMTools"
#   define VMAUTHD_SERVICE_NAME   "VMAuthdService"
#endif


/*
 * Configuration paths
 */

#if defined(__linux__) || defined(__FreeBSD__) || defined(sun)
#   define PRODUCT_NAME PRODUCT_SHORT_NAME
/*
 * Checked against the ProductID field of licenses.  This ensures that
 * a license intended for one flavor of the product will not allow
 * another flavor of the product to run.
 */
#   if defined(VMX86_SERVER)
#      define PRODUCT_NAME_FOR_LICENSE PRODUCT_NAME
#      define PRODUCT_SMP_NAME_FOR_LICENSE PRODUCT_ESX_SMP_NAME
#   elif defined(VMX86_DESKTOP)
#      define PRODUCT_NAME_FOR_LICENSE PRODUCT_NAME " for Linux"
#      define PRODUCT_SMP_NAME_FOR_LICENSE "" // None
#   elif defined(VMX86_WGS_MIGRATION)
#      define PRODUCT_NAME_FOR_LICENSE PRODUCT_NAME " for Linux"
#      define PRODUCT_SMP_NAME_FOR_LICENSE "" // None
#   elif defined(VMX86_WGS) && !defined(VMX86_CONSOLE)
#      define PRODUCT_NAME_FOR_LICENSE PRODUCT_NAME_ORIG " for Linux"
#      define PRODUCT_SMP_NAME_FOR_LICENSE PRODUCT_GSX_SMP_NAME_ORIG " for Linux"
#   else   /* It is a product that doesn't use a license */
#      define PRODUCT_NAME_FOR_LICENSE PRODUCT_NAME
#      define PRODUCT_SMP_NAME_FOR_LICENSE "" // None
#   endif

/* Default for the 'libdir' config variable */
/*
 * The APIs are installed as separate products and must have their own
 * configuration and library directories.  The remote console checks at
 * run time, and the MUI is not really a separate product.
 */
#   if defined(VMX86_API)
#      define DEFAULT_LIBDIRECTORY "/usr/lib/" PRODUCT_GENERIC_NAME_LOWER "-api"
#      define VMWARE_HOST_DIRECTORY "/etc/" PRODUCT_GENERIC_NAME_LOWER "-api"
#   elif defined (VMX86_CONSOLE)
#      define DEFAULT_LIBDIRECTORY "/usr/lib/" PRODUCT_GENERIC_NAME_LOWER "-server-console"
#      define VMWARE_HOST_DIRECTORY "/etc/" PRODUCT_GENERIC_NAME_LOWER "-server-console"
#   else
#      define DEFAULT_LIBDIRECTORY "/usr/lib/" PRODUCT_GENERIC_NAME_LOWER
#      define VMWARE_HOST_DIRECTORY "/etc/" PRODUCT_GENERIC_NAME_LOWER
#   endif

/* For host specific files */
#   define VMWARE_USER_SUBDIRECTORY "." PRODUCT_GENERIC_NAME_LOWER
/* For user specific files */
#   define VMWARE_USER_DIRECTORY "~/" VMWARE_USER_SUBDIRECTORY
#   define VMWARE_MODULE_NAME "/dev/vmmon"
#   define VMWARE_CONFIG PRODUCT_GENERIC_NAME_LOWER "-config.pl"
#   define VMWARE_CONNECT_SOCKET_DIRECTORY "/var/run/" PRODUCT_GENERIC_NAME_LOWER

#elif _WIN32

/* PRODUCT_SHORT_NAME and PRODUCT_FULL_NAME are used to display the name
   depending on how much space we have */
#   define PRODUCT_FULL_NAME PRODUCT_SHORT_NAME
#   define PRODUCT_NAME PRODUCT_FULL_NAME

/* Directory name in the registry */
#define PRODUCT_REG_NAME PRODUCT_NAME

/*
 * Checked against the ProductID field of licenses. This ensures that
 * a license intended for one flavor of the product will not allow
 * another flavor of the product to run.
 */
#   if defined(VMX86_DESKTOP)
#      define PRODUCT_NAME_FOR_LICENSE PRODUCT_NAME " for Win32"
#      define PRODUCT_SMP_NAME_FOR_LICENSE "" // None
#   elif defined(VMX86_WGS_MIGRATION)
#      define PRODUCT_NAME_FOR_LICENSE PRODUCT_NAME " for Win32"
#      define PRODUCT_SMP_NAME_FOR_LICENSE "" // None
#   elif defined(VMX86_WGS) && !defined(VMX86_CONSOLE)
#      define PRODUCT_NAME_FOR_LICENSE PRODUCT_NAME_ORIG " for Win32"
#      define PRODUCT_SMP_NAME_FOR_LICENSE PRODUCT_GSX_SMP_NAME_ORIG " for Win32"
#   else
#      define PRODUCT_NAME_FOR_LICENSE PRODUCT_REG_NAME
#      define PRODUCT_SMP_NAME_FOR_LICENSE "" // None
#   endif

#define PRIVATE_REG_KEY "Private"

#else
#   error "No default directory information specified!"
#endif

/* For VMware Server licensing */
#if defined(VMX86_WGS)
#define PRODUCT_SMP_NAME           PRODUCT_GSX_SMP_NAME
#else
#define PRODUCT_SMP_NAME           PRODUCT_SMP_NAME_FOR_LICENSE
#endif

/*
 * Used when referring to an unspecified member of the VMware product line
 * ex. "This file was created by an incompatible version of PRODUCT_LINE_NAME"
 */
#define PRODUCT_LINE_NAME PRODUCT_GENERIC_NAME " software"

#define PRODUCT_REG_PATH "SOFTWARE\\" COMPANY_NAME "\\" PRODUCT_REG_NAME
#define PRIVATE_REG_PATH PRODUCT_REG_PATH "\\" PRIVATE_REG_KEY

/*
 * Defines used primarily in Tools, but perhaps useful elsewhere.  Only error
 * on unrecognized platform during Tools builds.  Note that NetWare must come
 * before linux below since it uses the Linux gcc which automatically defines
 * linux; the other platforms don't have this issue.
 */
#ifdef N_PLAT_NLM
#  define PRODUCT_NAME_PLATFORM         PRODUCT_NAME " for NetWare"
#  define PLATFORM_TRADEMARK_STRING     NETWARE_TRADEMARK_STRING
#elif defined(linux)
#  define PRODUCT_NAME_PLATFORM         PRODUCT_NAME " for Linux"
#  define PLATFORM_TRADEMARK_STRING     LINUX_TRADEMARK_STRING
#elif defined(_WIN32)
#  define PRODUCT_NAME_PLATFORM         PRODUCT_NAME " for Windows"
#  define PLATFORM_TRADEMARK_STRING     MICROSOFT_TRADEMARK_STRING
#elif defined(__FreeBSD__)
#  define PRODUCT_NAME_PLATFORM         PRODUCT_NAME " for FreeBSD"
#  define PLATFORM_TRADEMARK_STRING     FREEBSD_TRADEMARK_STRING
#elif defined(sun)
#  define PRODUCT_NAME_PLATFORM         PRODUCT_NAME " for Solaris"
#  define PLATFORM_TRADEMARK_STRING     SOLARIS_TRADEMARK_STRING
#else
#  ifdef VMX86_TOOLS
#    error "Define product and trademark strings for this platform."
#  endif
#endif

/*
 * This allows UIs and guest binaries to know what kind of VMX they are dealing
 * with. Don't change those values (only add new ones if needed) because they
 * rely on them --hpreg
 */

typedef enum {
   VMX_TYPE_UNSET,
   VMX_TYPE_EXPRESS, /* This deprecated type was used for VMware Express */
   VMX_TYPE_SCALABLE_SERVER,
   VMX_TYPE_WGS,
   VMX_TYPE_WORKSTATION,
   VMX_TYPE_WORKSTATION_ENTERPRISE
} VMX_Type;


/*
 * This allows UIs and guest binaries to know what platform the VMX is running.
 */

typedef enum {
   VMX_PLATFORM_UNSET,
   VMX_PLATFORM_LINUX,
   VMX_PLATFORM_WIN32,
} VMX_Platform;


/*
 * UI versions
 *
 * Note that these only make sense in the context of the server type
 */

#define  UI_VERSION_OLD            1  // pre-versioned UIs
#define  UI_VERSION_ESX15          2
#define  UI_VERSION_GSX20          2
#define  UI_VERSION_ESX20          3
#define  UI_VERSION_GSX25          3
// Skip one just in case we want to insert ESX21 in between here for neatness
#define  UI_VERSION_GSX30          5
#define  UI_VERSION_VMSERVER10     6

#define  UI_VERSION                6  // Current UI version

#endif /* VM_VERSION_H */
