/* Premake's Lua scripts, as static data buffers for release mode builds */
/* DO NOT EDIT - this file is autogenerated - see BUILD.txt */
/* To regenerate this file, run: premake4 embed */ 

const char* builtin_scripts[] = {
	/* base/os.lua */
	"function os.executef(cmd, ...)\ncmd = string.format(cmd, unpack(arg))\nreturn os.execute(cmd)\nend\nfunction os.findlib(libname)\nlocal path, formats\nif os.is(\"windows\") then\nformats = { \"%s.dll\", \"%s\" }\npath = os.getenv(\"PATH\")\nelseif os.is(\"haiku\") then\nformats = { \"lib%s.so\", \"%s.so\" }\npath = os.getenv(\"LIBRARY_PATH\")\nelse\nif os.is(\"macosx\") then\nformats = { \"lib%s.dylib\", \"%s.dylib\" }\npath = os.getenv(\"DYLD_LIBRARY_PATH\")\nelse\nformats = { \"lib%s.so\", \"%s.so\" }\npath = os.getenv(\"LD_LIBRARY_PATH\") or \"\"\nio.input(\"/etc/ld.so.conf\")\nif io.input() then\nfor line in io.lines() do\npath = path .. \":\" .. line\nend\nio.input():close()\nend\nend\ntable.insert(formats, \"%s\")\npath = (path or \"\") .. \":/lib:/usr/lib:/usr/local/lib\"\nend\nfor _, fmt in ipairs(formats) do\nlocal name = string.format(fmt, libname)\nlocal result = os.pathsearch(name, path)\nif result then return result end\nend\nend\nfunction os.get()\nreturn _OPTIONS.os or _OS\nend\nfunction os.is(i"
	"d)\nreturn (os.get():lower() == id:lower())\nend\nlocal function domatch(result, mask, wantfiles)\nif mask:startswith(\"./\") then\nmask = mask:sub(3)\nend\nlocal basedir = mask\nlocal starpos = mask:find(\"%*\")\nif starpos then\nbasedir = basedir:sub(1, starpos - 1)\nend\nbasedir = path.getdirectory(basedir)\nif (basedir == \".\") then basedir = \"\" end\nlocal recurse = mask:find(\"**\", nil, true)\nmask = path.wildcards(mask)\nlocal function matchwalker(basedir)\nlocal wildcard = path.join(basedir, \"*\")\nlocal m = os.matchstart(wildcard)\nwhile (os.matchnext(m)) do\nlocal isfile = os.matchisfile(m)\nif ((wantfiles and isfile) or (not wantfiles and not isfile)) then\nlocal fname = path.join(basedir, os.matchname(m))\nif fname:match(mask) == fname then\ntable.insert(result, fname)\nend\nend\nend\nos.matchdone(m)\nif recurse then\nm = os.matchstart(wildcard)\nwhile (os.matchnext(m)) do\nif not os.matchisfile(m) then\nlocal dirname = os.matchname(m)\nmatchwalker(path.join(basedir, dirname))\nend\nend\nos.mat"
	"chdone(m)\nend\nend\nmatchwalker(basedir)\nend\nfunction os.matchdirs(...)\nlocal result = { }\nfor _, mask in ipairs(arg) do\ndomatch(result, mask, false)\nend\nreturn result\nend\nfunction os.matchfiles(...)\nlocal result = { }\nfor _, mask in ipairs(arg) do\ndomatch(result, mask, true)\nend\nreturn result\nend\nlocal builtin_mkdir = os.mkdir\nfunction os.mkdir(p)\nlocal dir = iif(p:startswith(\"/\"), \"/\", \"\")\nfor part in p:gmatch(\"[^/]+\") do\ndir = dir .. part\nif (part ~= \"\" and not path.isabsolute(part) and not os.isdir(dir)) then\nlocal ok, err = builtin_mkdir(dir)\nif (not ok) then\nreturn nil, err\nend\nend\ndir = dir .. \"/\"\nend\nreturn true\nend\nfunction os.outputof(cmd)\nlocal pipe = io.popen(cmd)\nlocal result = pipe:read('*a')\npipe:close()\nreturn result\nend\nlocal builtin_rmdir = os.rmdir\nfunction os.rmdir(p)\nlocal dirs = os.matchdirs(p .. \"/*\")\nfor _, dname in ipairs(dirs) do\nos.rmdir(dname)\nend\nlocal files = os.matchfiles(p .. \"/*\")\nfor _, fname in ipairs(files) do\nos."
	"remove(fname)\nend\nbuiltin_rmdir(p)\nend\n",

	/* base/path.lua */
	"function path.getabsolute(p)\np = path.translate(p, \"/\")\nif (p == \"\") then p = \".\" end\nlocal result = iif (path.isabsolute(p), nil, os.getcwd())\nfor n, part in ipairs(p:explode(\"/\", true)) do\nif (part == \"\" and n == 1) then\nresult = \"/\"\nelseif (part == \"..\") then\nresult = path.getdirectory(result)\nelseif (part ~= \".\") then\nresult = path.join(result, part)\nend\nend\nresult = iif(result:endswith(\"/\"), result:sub(1, -2), result)\nreturn result\nend\nfunction path.getbasename(p)\nlocal name = path.getname(p)\nlocal i = name:findlast(\".\", true)\nif (i) then\nreturn name:sub(1, i - 1)\nelse\nreturn name\nend\nend\nfunction path.getdirectory(p)\nlocal i = p:findlast(\"/\", true)\nif (i) then\nif i > 1 then i = i - 1 end\nreturn p:sub(1, i)\nelse\nreturn \".\"\nend\nend\nfunction path.getdrive(p)\nlocal ch1 = p:sub(1,1)\nlocal ch2 = p:sub(2,2)\nif ch2 == \":\" then\nreturn ch1\nend\nend\nfunction path.getextension(p)\nlocal i = p:findlast(\".\", true)\nif (i) then\nreturn p:sub(i)\nelse\n"
	"return \"\"\nend\nend\nfunction path.getname(p)\nlocal i = p:findlast(\"[/\\\\]\")\nif (i) then\nreturn p:sub(i + 1)\nelse\nreturn p\nend\nend\nfunction path.getrelative(src, dst)\nsrc = path.getabsolute(src)\ndst = path.getabsolute(dst)\nif (src == dst) then\nreturn \".\"\nend\nif dst:startswith(\"$\") then\nreturn dst\nend\nsrc = src .. \"/\"\ndst = dst .. \"/\"\nlocal idx = 0\nwhile (true) do\nlocal tst = src:find(\"/\", idx + 1, true)\nif tst then\nif src:sub(1,tst) == dst:sub(1,tst) then\nidx = tst\nelse\nbreak\nend\nelse\nbreak\nend\nend\nlocal first = src:find(\"/\", 0, true)\nif idx <= first then\nreturn dst:sub(1, -2)\nend\nsrc = src:sub(idx + 1)\ndst = dst:sub(idx + 1)\nlocal result = \"\"\nidx = src:find(\"/\")\nwhile (idx) do\nresult = result .. \"../\"\nidx = src:find(\"/\", idx + 1)\nend\nresult = result .. dst\nreturn result:sub(1, -2)\nend\nfunction path.iscfile(fname)\nlocal extensions = { \".c\", \".s\", \".m\" }\nlocal ext = path.getextension(fname):lower()\nreturn table.contains(extensions,"
	" ext)\nend\nfunction path.iscppfile(fname)\nlocal extensions = { \".cc\", \".cpp\", \".cxx\", \".c\", \".s\", \".m\", \".mm\" }\nlocal ext = path.getextension(fname):lower()\nreturn table.contains(extensions, ext)\nend\nfunction path.isresourcefile(fname)\nlocal extensions = { \".rc\" }\nlocal ext = path.getextension(fname):lower()\nreturn table.contains(extensions, ext)\nend\nfunction path.join(leading, trailing)\nleading = leading or \"\"\nif (not trailing) then\nreturn leading\nend\nif (path.isabsolute(trailing)) then\nreturn trailing\nend\nif (leading == \".\") then\nleading = \"\"\nend\nif (leading:len() > 0 and not leading:endswith(\"/\")) then\nleading = leading .. \"/\"\nend\nreturn leading .. trailing\nend\nfunction path.rebase(p, oldbase, newbase)\np = path.getabsolute(path.join(oldbase, p))\np = path.getrelative(newbase, p)\nreturn p\nend\nfunction path.translate(p, sep)\nif (type(p) == \"table\") then\nlocal result = { }\nfor _, value in ipairs(p) do\ntable.insert(result, path.translate(value))\nen"
	"d\nreturn result\nelse\nif (not sep) then\nif (os.is(\"windows\")) then\nsep = \"\\\\\"\nelse\nsep = \"/\"\nend\nend\nlocal result = p:gsub(\"[/\\\\]\", sep)\nreturn result\nend\nend\nfunction path.wildcards(pattern)\npattern = pattern:gsub(\"([%+%.%-%^%$%(%)%%])\", \"%%%1\")\npattern = pattern:gsub(\"%*%*\", \"\\001\")\npattern = pattern:gsub(\"%*\", \"\\002\")\npattern = pattern:gsub(\"\\001\", \".*\")\npattern = pattern:gsub(\"\\002\", \"[^/]*\")\nreturn pattern\nend\n",

	/* base/string.lua */
	"function string.explode(s, pattern, plain)\nif (pattern == '') then return false end\nlocal pos = 0\nlocal arr = { }\nfor st,sp in function() return s:find(pattern, pos, plain) end do\ntable.insert(arr, s:sub(pos, st-1))\npos = sp + 1\nend\ntable.insert(arr, s:sub(pos))\nreturn arr\nend\nfunction string.findlast(s, pattern, plain)\nlocal curr = 0\nrepeat\nlocal next = s:find(pattern, curr + 1, plain)\nif (next) then curr = next end\nuntil (not next)\nif (curr > 0) then\nreturn curr\nend\nend\nfunction string.startswith(haystack, needle)\nreturn (haystack:find(needle, 1, true) == 1)\nend\n",

	/* base/table.lua */
	"function table.contains(t, value)\nfor _,v in pairs(t) do\nif (v == value) then\nreturn true\nend\nend\nreturn false\nend\nfunction table.extract(arr, fname)\nlocal result = { }\nfor _,v in ipairs(arr) do\ntable.insert(result, v[fname])\nend\nreturn result\nend\nfunction table.flatten(arr)\nlocal result = { }\nlocal function flatten(arr)\nfor _, v in ipairs(arr) do\nif type(v) == \"table\" then\nflatten(v)\nelse\ntable.insert(result, v)\nend\nend\nend\nflatten(arr)\nreturn result\nend\nfunction table.implode(arr, before, after, between)\nlocal result = \"\"\nfor _,v in ipairs(arr) do\nif (result ~= \"\" and between) then\nresult = result .. between\nend\nresult = result .. before .. v .. after\nend\nreturn result\nend\nfunction table.isempty(t)\nreturn not next(t)\nend\nfunction table.join(...)\nlocal result = { }\nfor _,t in ipairs(arg) do\nif type(t) == \"table\" then\nfor _,v in ipairs(t) do\ntable.insert(result, v)\nend\nelse\ntable.insert(result, t)\nend\nend\nreturn result\nend\nfunction table.keys(tbl)"
	"\nlocal keys = {}\nfor k, _ in pairs(tbl) do\ntable.insert(keys, k)\nend\nreturn keys\nend\nfunction table.translate(arr, translation)\nlocal result = { }\nfor _, value in ipairs(arr) do\nlocal tvalue\nif type(translation) == \"function\" then\ntvalue = translation(value)\nelse\ntvalue = translation[value]\nend\nif (tvalue) then\ntable.insert(result, tvalue)\nend\nend\nreturn result\nend\n",

	/* base/io.lua */
	"function io.capture()\nio.captured = ''\nend\nfunction io.endcapture()\nlocal captured = io.captured\nio.captured = nil\nreturn captured\nend\nlocal builtin_open = io.open\nfunction io.open(fname, mode)\nif (mode) then\nif (mode:find(\"w\")) then\nlocal dir = path.getdirectory(fname)\nok, err = os.mkdir(dir)\nif (not ok) then\nerror(err, 0)\nend\nend\nend\nreturn builtin_open(fname, mode)\nend\nfunction io.printf(msg, ...)\nif (not io.eol) then\nio.eol = \"\\n\"\nend\nlocal s\nif type(msg) == \"number\" then\ns = string.rep(\"\\t\", msg) .. string.format(unpack(arg))\nelse\ns = string.format(msg, unpack(arg))\nend\nif io.captured then\nio.captured = io.captured .. s .. io.eol\nelse\nio.write(s)\nio.write(io.eol)\nend\nend\n_p = io.printf\n",

	/* base/globals.lua */
	"premake = { }\npremake.platforms = \n{\nNative = \n{ \ncfgsuffix       = \"\",\n},\nx32 = \n{ \ncfgsuffix       = \"32\",\n},\nx64 = \n{ \ncfgsuffix       = \"64\",\n},\nUniversal = \n{ \ncfgsuffix       = \"univ\",\n},\nUniversal32 = \n{ \ncfgsuffix       = \"univ32\",\n},\nUniversal64 = \n{ \ncfgsuffix       = \"univ64\",\n},\nPS3 = \n{ \ncfgsuffix       = \"ps3\",\niscrosscompiler = true,\nnosharedlibs    = true,\nnamestyle       = \"PS3\",\n},\nXbox360 = \n{ \ncfgsuffix       = \"xbox360\",\niscrosscompiler = true,\nnamestyle       = \"windows\",\n},\n}\nlocal builtin_dofile = dofile\nfunction dofile(fname)\nlocal oldcwd = os.getcwd()\nlocal oldfile = _SCRIPT\nif (not os.isfile(fname)) then\nlocal path = os.pathsearch(fname, _OPTIONS[\"scripts\"], os.getenv(\"PREMAKE_PATH\"))\nif (path) then\nfname = path..\"/\"..fname\nend\nend\n_SCRIPT = path.getabsolute(fname)\nlocal newcwd = path.getdirectory(_SCRIPT)\nos.chdir(newcwd)\nlocal a, b, c, d, e, f = builtin_dofile(_SCRIPT)\n_SCRIPT = oldfile\nos.chdir(oldcw"
	"d)\nreturn a, b, c, d, e, f\nend\nfunction iif(expr, trueval, falseval)\nif (expr) then\nreturn trueval\nelse\nreturn falseval\nend\nend\nfunction include(fname)\nreturn dofile(fname .. \"/premake4.lua\")\nend\nfunction printf(msg, ...)\nprint(string.format(msg, unpack(arg)))\nend\nlocal builtin_type = type\nfunction type(t)\nlocal mt = getmetatable(t)\nif (mt) then\nif (mt.__type) then\nreturn mt.__type\nend\nend\nreturn builtin_type(t)\nend\n",

	/* base/action.lua */
	"premake.action = { }\npremake.action.list = { }\nfunction premake.action.add(a)\nlocal missing\nfor _, field in ipairs({\"description\", \"trigger\"}) do\nif (not a[field]) then\nmissing = field\nend\nend\nif (missing) then\nerror(\"action needs a \" .. missing, 3)\nend\npremake.action.list[a.trigger] = a\nend\nfunction premake.action.call(name)\nlocal a = premake.action.list[name]\nfor sln in premake.solution.each() do\nif a.onsolution then\na.onsolution(sln)\nend\nfor prj in premake.solution.eachproject(sln) do\nif a.onproject then\na.onproject(prj)\nend\nend\nend\nif a.execute then\na.execute()\nend\nend\nfunction premake.action.current()\nreturn premake.action.get(_ACTION)\nend\nfunction premake.action.get(name)\nreturn premake.action.list[name]\nend\nfunction premake.action.each()\nlocal keys = { }\nfor _, action in pairs(premake.action.list) do\ntable.insert(keys, action.trigger)\nend\ntable.sort(keys)\nlocal i = 0\nreturn function()\ni = i + 1\nreturn premake.action.list[keys[i]]\nend\nend\nfunction pre"
	"make.action.set(name)\n_ACTION = name\nlocal action = premake.action.get(name)\nif action then\n_OS = action.os or _OS\nend\nend\nfunction premake.action.supports(action, feature)\nif not action then\nreturn false\nend\nif action.valid_languages then\nif table.contains(action.valid_languages, feature) then\nreturn true\nend\nend\nif action.valid_kinds then\nif table.contains(action.valid_kinds, feature) then\nreturn true\nend\nend\nreturn false\nend\n",

	/* base/option.lua */
	"premake.option = { }\npremake.option.list = { }\nfunction premake.option.add(opt)\nlocal missing\nfor _, field in ipairs({ \"description\", \"trigger\" }) do\nif (not opt[field]) then\nmissing = field\nend\nend\nif (missing) then\nerror(\"option needs a \" .. missing, 3)\nend\npremake.option.list[opt.trigger] = opt\nend\nfunction premake.option.get(name)\nreturn premake.option.list[name]\nend\nfunction premake.option.each()\nlocal keys = { }\nfor _, option in pairs(premake.option.list) do\ntable.insert(keys, option.trigger)\nend\ntable.sort(keys)\nlocal i = 0\nreturn function()\ni = i + 1\nreturn premake.option.list[keys[i]]\nend\nend\nfunction premake.option.validate(values)\nfor key, value in pairs(values) do\nlocal opt = premake.option.get(key)\nif (not opt) then\nreturn false, \"invalid option '\" .. key .. \"'\"\nend\nif (opt.value and value == \"\") then\nreturn false, \"no value specified for option '\" .. key .. \"'\"\nend\nif (opt.allowed) then\nfor _, match in ipairs(opt.allowed) do\nif (match[1] == "
	"value) then return true end\nend\nreturn false, \"invalid value '\" .. value .. \"' for option '\" .. key .. \"'\"\nend\nend\nreturn true\nend\n",

	/* base/tree.lua */
	"premake.tree = { }\nlocal tree = premake.tree\nfunction premake.tree.new(n)\nlocal t = {\nname = n,\nchildren = { }\n}\nreturn t\nend\nfunction premake.tree.add(tr, p)\nif p == \".\" then\nreturn tr\nend\nlocal parentnode = tree.add(tr, path.getdirectory(p))\nlocal childname = path.getname(p)\nif childname == \"..\" then\nreturn parentnode\nend\nlocal childnode = parentnode.children[childname]\nif not childnode or childnode.path ~= p then\nchildnode = tree.insert(parentnode, tree.new(childname))\nchildnode.path = p\nend\nreturn childnode\nend\nfunction premake.tree.insert(parent, child)\ntable.insert(parent.children, child)\nif child.name then\nparent.children[child.name] = child\nend\nchild.parent = parent\nreturn child\nend\nfunction premake.tree.getlocalpath(node)\nif node.parent.path then\nreturn node.name\nelse\nreturn node.path\nend\nend\nfunction premake.tree.remove(node)\nlocal children = node.parent.children\nfor i = 1, #children do\nif children[i] == node then\ntable.remove(children, i)\nend\nend\nno"
	"de.children = {}\nend\nfunction premake.tree.sort(tr)\ntree.traverse(tr, {\nonnode = function(node)\ntable.sort(node.children, function(a,b)\nreturn a.name < b.name\nend)\nend\n}, true)\nend\nfunction premake.tree.traverse(t, fn, includeroot)\nlocal donode, dochildren\ndonode = function(node, fn, depth)\nif node.isremoved then \nreturn \nend\nif fn.onnode then \nfn.onnode(node, depth) \nend\nif #node.children > 0 then\nif fn.onbranch then \nfn.onbranch(node, depth) \nend\ndochildren(node, fn, depth + 1)\nelse\nif fn.onleaf then \nfn.onleaf(node, depth) \nend\nend\nend\ndochildren = function(parent, fn, depth)\nlocal i = 1\nwhile i <= #parent.children do\nlocal node = parent.children[i]\ndonode(node, fn, depth)\nif node == parent.children[i] then\ni = i + 1\nend\nend\nend\nif includeroot then\ndonode(t, fn, 0)\nelse\ndochildren(t, fn, 0)\nend\nend\n",

	/* base/solution.lua */
	"premake.solution = { }\npremake.solution.list = { }\nfunction premake.solution.new(name)\nlocal sln = { }\ntable.insert(premake.solution.list, sln)\npremake.solution.list[name] = sln\nsetmetatable(sln, { __type=\"solution\" })\nsln.name           = name\nsln.basedir        = os.getcwd()\nsln.projects       = { }\nsln.blocks         = { }\nsln.configurations = { }\nreturn sln\nend\nfunction premake.solution.each()\nlocal i = 0\nreturn function ()\ni = i + 1\nif i <= #premake.solution.list then\nreturn premake.solution.list[i]\nend\nend\nend\nfunction premake.solution.eachproject(sln)\nlocal i = 0\nreturn function ()\ni = i + 1\nif (i <= #sln.projects) then\nreturn premake.solution.getproject(sln, i)\nend\nend\nend\nfunction premake.solution.get(key)\nreturn premake.solution.list[key]\nend\nfunction premake.solution.getproject(sln, idx)\nlocal prj = sln.projects[idx]\nlocal cfg = premake.getconfig(prj)\ncfg.name = prj.name\nreturn cfg\nend\n",

	/* base/project.lua */
	"premake.project = { }\nfunction premake.project.buildsourcetree(prj)\nlocal tr = premake.tree.new(prj.name)\nfor _, fname in ipairs(prj.files) do\nlocal node = premake.tree.add(tr, fname)\nend\npremake.tree.sort(tr)\ntr.project = prj\nreturn tr\nend\nfunction premake.eachconfig(prj, platform)\nif prj.project then prj = prj.project end\nlocal cfgs = prj.solution.configurations\nlocal i = 0\nreturn function ()\ni = i + 1\nif i <= #cfgs then\nreturn premake.getconfig(prj, cfgs[i], platform)\nend\nend\nend\nfunction premake.eachfile(prj)\nif not prj.project then prj = premake.getconfig(prj) end\nlocal i = 0\nlocal t = prj.files\nreturn function ()\ni = i + 1\nif (i <= #t) then\nreturn prj.__fileconfigs[t[i]]\nend\nend\nend\nfunction premake.esc(value)\nif (type(value) == \"table\") then\nlocal result = { }\nfor _,v in ipairs(value) do\ntable.insert(result, premake.esc(v))\nend\nreturn result\nelse\nvalue = value:gsub('&',  \"&amp;\")\nvalue = value:gsub('\"',  \"&quot;\")\nvalue = value:gsub(\"'\",  \"&apos;\")\nv"
	"alue = value:gsub('<',  \"&lt;\")\nvalue = value:gsub('>',  \"&gt;\")\nvalue = value:gsub('\\r', \"&#x0D;\")\nvalue = value:gsub('\\n', \"&#x0A;\")\nreturn value\nend\nend\nfunction premake.filterplatforms(sln, map, default)\nlocal result = { }\nlocal keys = { }\nif sln.platforms then\nfor _, p in ipairs(sln.platforms) do\nif map[p] and not table.contains(keys, map[p]) then\ntable.insert(result, p)\ntable.insert(keys, map[p])\nend\nend\nend\nif #result == 0 and default then\ntable.insert(result, default)\nend\nreturn result\nend\nfunction premake.findproject(name)\nfor sln in premake.solution.each() do\nfor prj in premake.solution.eachproject(sln) do\nif (prj.name == name) then\nreturn  prj\nend\nend\nend\nend\nfunction premake.findfile(prj, extension)\nfor _, fname in ipairs(prj.files) do\nif fname:endswith(extension) then return fname end\nend\nend\nfunction premake.getconfig(prj, cfgname, pltname)\nprj = prj.project or prj\nif pltname == \"Native\" or not table.contains(prj.solution.platforms or {}, pltname"
	") then\npltname = nil\nend\nlocal key = (cfgname or \"\")\nif pltname then key = key .. pltname end\nreturn prj.__configs[key]\nend\nfunction premake.getconfigname(cfgname, platform, useshortname)\nif cfgname then\nlocal name = cfgname\nif platform and platform ~= \"Native\" then\nif useshortname then\nname = name .. premake.platforms[platform].cfgsuffix\nelse\nname = name .. \"|\" .. platform\nend\nend\nreturn iif(useshortname, name:lower(), name)\nend\nend\nfunction premake.getdependencies(prj)\nprj = prj.project or prj\nlocal results = { }\nfor _, cfg in pairs(prj.__configs) do\nfor _, link in ipairs(cfg.links) do\nlocal dep = premake.findproject(link)\nif dep and not table.contains(results, dep) then\ntable.insert(results, dep)\nend\nend\nend\nreturn results\nend\nfunction premake.project.getfilename(prj, pattern)\nlocal fname = pattern:gsub(\"%%%%\", prj.name)\nfname = path.join(prj.location, fname)\nreturn path.getrelative(os.getcwd(), fname)\nend\n function premake.getlinks(cfg, kind, part)\nlocal resul"
	"t = iif (part == \"directory\" and kind == \"all\", cfg.libdirs, {})\nlocal cfgname = iif(cfg.name == cfg.project.name, \"\", cfg.name)\nlocal pathstyle = premake.getpathstyle(cfg)\nlocal namestyle = premake.getnamestyle(cfg)\nlocal function canlink(source, target)\nif (kind == \"static\" and target.kind ~= \"StaticLib\") then\nreturn false\nelseif (target.kind ~= \"SharedLib\" and target.kind ~= \"StaticLib\") then \nreturn false\nend\nif premake.iscppproject(source) then\nreturn premake.iscppproject(target)\nelseif premake.isdotnetproject(source) then\nreturn premake.isdotnetproject(target)\nend\nend\nfor _, link in ipairs(cfg.links) do\nlocal item\nlocal prj = premake.findproject(link)\nif prj and kind ~= \"system\" then\nlocal prjcfg = premake.getconfig(prj, cfgname, cfg.platform)\nif kind == \"dependencies\" or canlink(cfg, prjcfg) then\nif (part == \"directory\") then\nitem = path.rebase(prjcfg.linktarget.directory, prjcfg.location, cfg.location)\nelseif (part == \"basename\") then\nitem = prjcfg.linktar"
	"get.basename\nelseif (part == \"fullpath\") then\nitem = path.rebase(prjcfg.linktarget.fullpath, prjcfg.location, cfg.location)\nelseif (part == \"object\") then\nitem = prjcfg\nend\nend\nelseif not prj and (kind == \"system\" or kind == \"all\") then\nif (part == \"directory\") then\nlocal dir = path.getdirectory(link)\nif (dir ~= \".\") then\nitem = dir\nend\nelseif (part == \"fullpath\") then\nitem = link\nif namestyle == \"windows\" then\nif premake.iscppproject(cfg) then\nitem = item .. \".lib\"\nelseif premake.isdotnetproject(cfg) then\nitem = item .. \".dll\"\nend\nend\nif item:find(\"/\", nil, true) then\nitem = path.getrelative(cfg.basedir, item)\nend\nelse\nitem = link\nend\nend\nif item then\nif pathstyle == \"windows\" and part ~= \"object\" then\nitem = path.translate(item, \"\\\\\")\nend\nif not table.contains(result, item) then\ntable.insert(result, item)\nend\nend\nend\nreturn result\nend\nfunction premake.getnamestyle(cfg)\nreturn premake.platforms[cfg.platform].namestyle or premake.gettool(cf"
	"g).namestyle or \"posix\"\nend\nfunction premake.getpathstyle(cfg)\nif premake.action.current().os == \"windows\" then\nreturn \"windows\"\nelse\nreturn \"posix\"\nend\nend\nfunction premake.gettarget(cfg, direction, pathstyle, namestyle, system)\nif system == \"bsd\" or system == \"solaris\" then \nsystem = \"linux\" \nend\nlocal kind = cfg.kind\nif premake.iscppproject(cfg) then\nif (namestyle == \"windows\" or system == \"windows\") and kind == \"SharedLib\" and direction == \"link\" then\nkind = \"StaticLib\"\nend\nif namestyle == \"posix\" and system == \"windows\" and kind ~= \"StaticLib\" then\nnamestyle = \"windows\"\nend\nend\nlocal field   = iif(direction == \"build\", \"target\", \"implib\")\nlocal name    = cfg[field..\"name\"] or cfg.targetname or cfg.project.name\nlocal dir     = cfg[field..\"dir\"] or cfg.targetdir or path.getrelative(cfg.location, cfg.basedir)\nlocal prefix  = \"\"\nlocal suffix  = \"\"\nlocal ext     = \"\"\nlocal bundlepath, bundlename\nif namestyle == \"windows\" then\nif ki"
	"nd == \"ConsoleApp\" or kind == \"WindowedApp\" then\next = \".exe\"\nelseif kind == \"SharedLib\" then\next = \".dll\"\nelseif kind == \"StaticLib\" then\next = \".lib\"\nend\nelseif namestyle == \"posix\" then\nif kind == \"WindowedApp\" and system == \"macosx\" then\nbundlename = name .. \".app\"\nbundlepath = path.join(dir, bundlename)\ndir = path.join(bundlepath, \"Contents/MacOS\")\nelseif kind == \"SharedLib\" then\nprefix = \"lib\"\next = iif(system == \"macosx\", \".dylib\", \".so\")\nelseif kind == \"StaticLib\" then\nprefix = \"lib\"\next = \".a\"\nend\nelseif namestyle == \"PS3\" then\nif kind == \"ConsoleApp\" or kind == \"WindowedApp\" then\next = \".elf\"\nelseif kind == \"StaticLib\" then\nprefix = \"lib\"\next = \".a\"\nend\nend\nprefix = cfg[field..\"prefix\"] or cfg.targetprefix or prefix\nsuffix = cfg[field..\"suffix\"] or cfg.targetsuffix or suffix\next    = cfg[field..\"extension\"] or cfg.targetextension or ext\nlocal result = { }\nresult.basename   = name .. suffix\nresult.name       = "
	"prefix .. name .. suffix .. ext\nresult.directory  = dir\nresult.prefix     = prefix\nresult.suffix     = suffix\nresult.fullpath   = path.join(result.directory, result.name)\nresult.bundlepath = bundlepath or result.fullpath\nif pathstyle == \"windows\" then\nresult.directory = path.translate(result.directory, \"\\\\\")\nresult.fullpath  = path.translate(result.fullpath,  \"\\\\\")\nend\nreturn result\nend\nfunction premake.gettool(cfg)\nif premake.iscppproject(cfg) then\nif _OPTIONS.cc then\nreturn premake[_OPTIONS.cc]\nend\nlocal action = premake.action.current()\nif action.valid_tools then\nreturn premake[action.valid_tools.cc[1]]\nend\nreturn premake.gcc\nelse\nreturn premake.dotnet\nend\nend\nfunction premake.hascppproject(sln)\nfor prj in premake.solution.eachproject(sln) do\nif premake.iscppproject(prj) then\nreturn true\nend\nend\nend\nfunction premake.hasdotnetproject(sln)\nfor prj in premake.solution.eachproject(sln) do\nif premake.isdotnetproject(prj) then\nreturn true\nend\nend\nend\nfunction prem"
	"ake.iscppproject(prj)\nreturn (prj.language == \"C\" or prj.language == \"C++\")\nend\nfunction premake.isdotnetproject(prj)\nreturn (prj.language == \"C#\")\nend\nlocal function walksources(cfg, fn, group, nestlevel, finished)\nlocal grouplen = group:len()\nlocal gname = iif(group:endswith(\"/\"), group:sub(1, -2), group)\nif (nestlevel >= 0) then\nfn(cfg, gname, \"GroupStart\", nestlevel)\nend\nfor _,fname in ipairs(cfg.files) do\nif (fname:startswith(group)) then\nlocal _,split = fname:find(\"[^\\.]/\", grouplen + 1)\nif (split) then\nlocal subgroup = fname:sub(1, split)\nif (not finished[subgroup]) then\nfinished[subgroup] = true\nwalksources(cfg, fn, subgroup, nestlevel + 1, finished)\nend\nend\nend\nend\nfor _,fname in ipairs(cfg.files) do\nif (fname:startswith(group) and not fname:find(\"[^\\.]/\", grouplen + 1)) then\nfn(cfg, fname, \"GroupItem\", nestlevel + 1)\nend\nend\nif (nestlevel >= 0) then\nfn(cfg, gname, \"GroupEnd\", nestlevel)\nend\nend\nfunction premake.walksources(cfg, fn)\nwalksources(cfg"
	", fn, \"\", -1, {})\nend\n",

	/* base/configs.lua */
	"premake.config = { }\nfunction premake.config.isdebugbuild(cfg)\nif cfg.flags.Optimize or cfg.flags.OptimizeSize or cfg.flags.OptimizeSpeed then\nreturn false\nend\nif not cfg.flags.Symbols then\nreturn false\nend\nreturn true\nend\nlocal nocopy = \n{\nblocks    = true,\nkeywords  = true,\nprojects  = true,\n__configs = true,\n}\nlocal nofixup =\n{\nbasedir  = true,\nlocation = true,\n}\nfunction premake.getactiveterms()\nlocal terms = { _ACTION:lower(), os.get() }\nfor key, value in pairs(_OPTIONS) do\nif value ~= \"\" then\ntable.insert(terms, value:lower())\nelse\ntable.insert(terms, key:lower())\nend\nend\nreturn terms\nend\nfunction premake.iskeywordmatch(keyword, terms)\nif keyword:startswith(\"not \") then\nreturn not premake.iskeywordmatch(keyword:sub(5), terms)\nend\nfor _, pattern in ipairs(keyword:explode(\" or \")) do\nfor termkey, term in pairs(terms) do\nif term:match(pattern) == term then\nreturn termkey\nend\nend\nend\nend\nfunction premake.iskeywordsmatch(keywords, terms)\nlocal hasrequired = "
	"false\nfor _, keyword in ipairs(keywords) do\nlocal matched = premake.iskeywordmatch(keyword, terms)\nif not matched then\nreturn false\nend\nif matched == \"required\" then\nhasrequired = true\nend\nend\nif terms.required and not hasrequired then\nreturn false\nelse\nreturn true\nend\nend\nlocal function adjustpaths(location, obj)\nfor name, value in pairs(obj) do\nlocal field = premake.fields[name]\nif field and value and not nofixup[name] then\nif field.kind == \"path\" then\nobj[name] = path.getrelative(location, value) \nelseif field.kind == \"dirlist\" or field.kind == \"filelist\" then\nfor i, p in ipairs(value) do\nvalue[i] = path.getrelative(location, p) \nend\nend\nend\nend\nend\nlocal function mergeobject(dest, src)\nif not src then return end\nfor field, value in pairs(src) do\nif not nocopy[field] then\nif type(value) == \"table\" then\nlocal tbl = dest[field] or { }\nfor _, item in ipairs(value) do\nif not tbl[item] then\ntable.insert(tbl, item)\ntbl[item] = item\nend\nend\ndest[field] = tbl\nels"
	"e\ndest[field] = value\nend\nend\nend\nend\nlocal function merge(dest, obj, basis, terms, cfgname, pltname)\nlocal key = cfgname or \"\"\npltname = pltname or \"Native\"\nif pltname ~= \"Native\" then\nkey = key .. pltname\nend\nterms.config = (cfgname or \"\"):lower()\nterms.platform = pltname:lower()\nlocal cfg = {}\nmergeobject(cfg, basis[key])\nadjustpaths(obj.location, cfg)\nmergeobject(cfg, obj)\nif (cfg.kind) then \nterms.kind = cfg.kind:lower()\nend\nfor _, blk in ipairs(obj.blocks) do\nif (premake.iskeywordsmatch(blk.keywords, terms)) then\nmergeobject(cfg, blk)\nend\nend\ncfg.name      = cfgname\ncfg.platform  = pltname\ncfg.terms     = terms\ndest[key] = cfg\nend\nlocal function collapse(obj, basis)\nlocal result = {}\nbasis = basis or {}\nlocal sln = obj.solution or obj\nlocal terms = premake.getactiveterms()\nmerge(result, obj, basis, terms)\nfor _, cfgname in ipairs(sln.configurations) do\nmerge(result, obj, basis, terms, cfgname, \"Native\")\nfor _, pltname in ipairs(sln.platforms or {}) do\nif "
	"pltname ~= \"Native\" then\nmerge(result, obj, basis, terms, cfgname, pltname)\nend\nend\nend\nreturn result\nend\nlocal function postprocess(prj, cfg)\ncfg.project   = prj\ncfg.shortname = premake.getconfigname(cfg.name, cfg.platform, true)\ncfg.longname  = premake.getconfigname(cfg.name, cfg.platform)\ncfg.location = cfg.location or cfg.basedir\nlocal platform = premake.platforms[cfg.platform]\nif platform.iscrosscompiler then\ncfg.system = cfg.platform\nelse\ncfg.system = os.get()\nend\nif cfg.kind == \"SharedLib\" and platform.nosharedlibs then\ncfg.kind = \"StaticLib\"\nend\nlocal files = { }\nfor _, fname in ipairs(cfg.files) do\nlocal excluded = false\nfor _, exclude in ipairs(cfg.excludes) do\nexcluded = (fname == exclude)\nif (excluded) then break end\nend\nif (not excluded) then\ntable.insert(files, fname)\nend\nend\ncfg.files = files\nfor name, field in pairs(premake.fields) do\nif field.isflags then\nlocal values = cfg[name]\nfor _, flag in ipairs(values) do values[flag] = true end\nend\nend\ncfg._"
	"_fileconfigs = { }\nfor _, fname in ipairs(cfg.files) do\ncfg.terms.required = fname:lower()\nlocal fcfg = {}\nfor _, blk in ipairs(cfg.project.blocks) do\nif (premake.iskeywordsmatch(blk.keywords, cfg.terms)) then\nmergeobject(fcfg, blk)\nend\nend\nfcfg.name = fname\ncfg.__fileconfigs[fname] = fcfg\ntable.insert(cfg.__fileconfigs, fcfg)\nend\nend\nlocal function builduniquedirs()\nlocal num_variations = 4\nlocal cfg_dirs = {}\nlocal hit_counts = {}\nfor sln in premake.solution.each() do\nfor _, prj in ipairs(sln.projects) do\nfor _, cfg in pairs(prj.__configs) do\nlocal dirs = { }\ndirs[1] = path.getabsolute(path.join(cfg.location, cfg.objdir or cfg.project.objdir or \"obj\"))\ndirs[2] = path.join(dirs[1], iif(cfg.platform == \"Native\", \"\", cfg.platform))\ndirs[3] = path.join(dirs[2], cfg.name)\ndirs[4] = path.join(dirs[3], cfg.project.name)\ncfg_dirs[cfg] = dirs\nlocal start = iif(cfg.name, 2, 1)\nfor v = start, num_variations do\nlocal d = dirs[v]\nhit_counts[d] = (hit_counts[d] or 0) + 1\nend\nend\nend"
	"\nend\nfor sln in premake.solution.each() do\nfor _, prj in ipairs(sln.projects) do\nfor _, cfg in pairs(prj.__configs) do\nlocal dir\nlocal start = iif(cfg.name, 2, 1)\nfor v = start, num_variations do\ndir = cfg_dirs[cfg][v]\nif hit_counts[dir] == 1 then break end\nend\ncfg.objectsdir = path.getrelative(cfg.location, dir)\nend\nend\nend\nend\nlocal function buildtargets()\nfor sln in premake.solution.each() do\nfor _, prj in ipairs(sln.projects) do\nfor _, cfg in pairs(prj.__configs) do\nlocal pathstyle = premake.getpathstyle(cfg)\nlocal namestyle = premake.getnamestyle(cfg)\ncfg.buildtarget = premake.gettarget(cfg, \"build\", pathstyle, namestyle, cfg.system)\ncfg.linktarget  = premake.gettarget(cfg, \"link\",  pathstyle, namestyle, cfg.system)\nif pathstyle == \"windows\" then\ncfg.objectsdir = path.translate(cfg.objectsdir, \"\\\\\")\nend\nend\nend\nend\nend\nfunction premake.buildconfigs()\nfor sln in premake.solution.each() do\nfor _, prj in ipairs(sln.projects) do\nprj.location = prj.location or sln.lo"
	"cation or prj.basedir\nadjustpaths(prj.location, prj)\nfor _, blk in ipairs(prj.blocks) do\nadjustpaths(prj.location, blk)\nend\nend\nsln.location = sln.location or sln.basedir\nend\nfor sln in premake.solution.each() do\nlocal basis = collapse(sln)\nfor _, prj in ipairs(sln.projects) do\nprj.__configs = collapse(prj, basis)\nfor _, cfg in pairs(prj.__configs) do\npostprocess(prj, cfg)\nend\nend\nend\nbuilduniquedirs()\nbuildtargets(cfg)\nend\n",

	/* base/api.lua */
	"premake.fields = \n{\nbasedir =\n{\nkind  = \"path\",\nscope = \"container\",\n},\nbuildaction =\n{\nkind  = \"string\",\nscope = \"config\",\nallowed = {\n\"Compile\",\n\"Copy\",\n\"Embed\",\n\"None\"\n}\n},\nbuildoptions =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nconfigurations = \n{\nkind  = \"list\",\nscope = \"solution\",\n},\ncxxtesthdrfiles =\n{\nkind = \"filelist\",\nscope = \"config\",\n},\ncxxtestsrcfiles = \n{\nkind  = \"filelist\",\nscope = \"config\",\n},\ncxxtestoptions =\n{\nkind  = \"string\",\nscope = \"config\",\n},\ncxxtestpath =\n{\nkind  = \"path\",\nscope = \"solution\", \n},\ncxxtestrootfile = \n{\nkind  = \"path\",\nscope = \"config\",\n},\ncxxtestrootoptions =\n{\nkind  = \"string\",\nscope = \"config\",\n},\ndefines =\n{\nkind  = \"list\",\nscope = \"config\",\n},\ndeploymentoptions =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nexcludes =\n{\nkind  = \"filelist\",\nscope = \"config\",\n},\nfiles =\n{\nkind  = \"filelist\",\nscope = \"config\",\n},\nflags =\n{\nkind  = \"lis"
	"t\",\nscope = \"config\",\nisflags = true,\nallowed = {\n\"EnableSSE\",\n\"EnableSSE2\",\n\"ExtraWarnings\",\n\"FatalWarnings\",\n\"FloatFast\",\n\"FloatStrict\",\n\"Managed\",\n\"MFC\",\n\"NativeWChar\",\n\"No64BitChecks\",\n\"NoEditAndContinue\",\n\"NoExceptions\",\n\"NoFramePointer\",\n\"NoImportLib\",\n\"NoManifest\",\n\"NoMinimalRebuild\",\n\"NoNativeWChar\",\n\"NoPCH\",\n\"NoRTTI\",\n\"Optimize\",\n\"OptimizeSize\",\n\"OptimizeSpeed\",\n\"SEH\",\n\"StaticRuntime\",\n\"Symbols\",\n\"Unicode\",\n\"Unsafe\",\n\"WinMain\"\n}\n},\nframework =\n{\nkind = \"string\",\nscope = \"container\",\nallowed = {\n\"1.0\",\n\"1.1\",\n\"2.0\",\n\"3.0\",\n\"3.5\",\n\"4.0\"\n}\n},\ngnuexternals =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nimagepath = \n{\nkind = \"path\",\nscope = \"config\",\n},\nimageoptions =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nimplibdir =\n{\nkind  = \"path\",\nscope = \"config\",\n},\nimplibextension =\n{\nkind  = \"string\",\nscope = \"config\",\n},\nimplibname =\n{\nkind  = \"string"
	"\",\nscope = \"config\",\n},\nimplibprefix =\n{\nkind  = \"string\",\nscope = \"config\",\n},\nimplibsuffix =\n{\nkind  = \"string\",\nscope = \"config\",\n},\nincludedirs =\n{\nkind  = \"dirlist\",\nscope = \"config\",\n},\nkind =\n{\nkind  = \"string\",\nscope = \"config\",\nallowed = {\n\"ConsoleApp\",\n\"WindowedApp\",\n\"StaticLib\",\n\"SharedLib\"\n}\n},\nlanguage =\n{\nkind  = \"string\",\nscope = \"container\",\nallowed = {\n\"C\",\n\"C++\",\n\"C#\"\n}\n},\nlibdirs =\n{\nkind  = \"dirlist\",\nscope = \"config\",\n},\nlinkoptions =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nlinks =\n{\nkind  = \"list\",\nscope = \"config\",\nallowed = function(value)\nif value:find('/', nil, true) then\nvalue = path.getabsolute(value)\nend\nreturn value\nend\n},\nlocation =\n{\nkind  = \"path\",\nscope = \"container\",\n},\nnasmformat =\n{\nkind  = \"string\",\nscope = \"solution\",\n},\nnasmpath =\n{\nkind  = \"path\",\nscope = \"solution\"\n},\nobjdir =\n{\nkind  = \"path\",\nscope = \"config\",\n},\npchheader ="
	"\n{\nkind  = \"path\",\nscope = \"config\",\n},\npchsource =\n{\nkind  = \"path\",\nscope = \"config\",\n},\nplatforms = \n{\nkind  = \"list\",\nscope = \"solution\",\nallowed = table.keys(premake.platforms),\n},\npostbuildcommands =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nprebuildcommands =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nprelinkcommands =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nresdefines =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nresincludedirs =\n{\nkind  = \"dirlist\",\nscope = \"config\",\n},\nresoptions =\n{\nkind  = \"list\",\nscope = \"config\",\n},\ntargetdir =\n{\nkind  = \"path\",\nscope = \"config\",\n},\ntargetextension =\n{\nkind  = \"string\",\nscope = \"config\",\n},\ntargetname =\n{\nkind  = \"string\",\nscope = \"config\",\n},\ntargetprefix =\n{\nkind  = \"string\",\nscope = \"config\",\n},\ntargetsuffix =\n{\nkind  = \"string\",\nscope = \"config\",\n},\ntrimpaths =\n{\nkind = \"dirlist\",\nscope = \"config\",\n},\nuuid =\n{\nkind  = \"string\",\nscope"
	" = \"container\",\nallowed = function(value)\nlocal ok = true\nif (#value ~= 36) then ok = false end\nfor i=1,36 do\nlocal ch = value:sub(i,i)\nif (not ch:find(\"[ABCDEFabcdef0123456789-]\")) then ok = false end\nend\nif (value:sub(9,9) ~= \"-\")   then ok = false end\nif (value:sub(14,14) ~= \"-\") then ok = false end\nif (value:sub(19,19) ~= \"-\") then ok = false end\nif (value:sub(24,24) ~= \"-\") then ok = false end\nif (not ok) then\nreturn nil, \"invalid UUID\"\nend\nreturn value:upper()\nend\n},\n}\nfunction premake.checkvalue(value, allowed)\nif (allowed) then\nif (type(allowed) == \"function\") then\nreturn allowed(value)\nelse\nfor _,v in ipairs(allowed) do\nif (value:lower() == v:lower()) then\nreturn v\nend\nend\nreturn nil, \"invalid value '\" .. value .. \"'\"\nend\nelse\nreturn value\nend\nend\nfunction premake.getobject(t)\nlocal container\nif (t == \"container\" or t == \"solution\") then\ncontainer = premake.CurrentContainer\nelse\ncontainer = premake.CurrentConfiguration\nend\nif t == \"sol"
	"ution\" then\nif type(container) == \"project\" then\ncontainer = container.solution\nend\nif type(container) ~= \"solution\" then\ncontainer = nil\nend\nend\nlocal msg\nif (not container) then\nif (t == \"container\") then\nmsg = \"no active solution or project\"\nelseif (t == \"solution\") then\nmsg = \"no active solution\"\nelse\nmsg = \"no active solution, project, or configuration\"\nend\nend\nreturn container, msg\nend\nfunction premake.setarray(ctype, fieldname, value, allowed)\nlocal container, err = premake.getobject(ctype)\nif (not container) then\nerror(err, 4)\nend\nif (not container[fieldname]) then\ncontainer[fieldname] = { }\nend\nlocal function doinsert(value, depth)\nif (type(value) == \"table\") then\nfor _,v in ipairs(value) do\ndoinsert(v, depth + 1)\nend\nelse\nvalue, err = premake.checkvalue(value, allowed)\nif (not value) then\nerror(err, depth)\nend\ntable.insert(container[fieldname], value)\nend\nend\nif (value) then\ndoinsert(value, 5)\nend\nreturn container[fieldname]\nend\nlocal fun"
	"ction domatchedarray(ctype, fieldname, value, matchfunc)\nlocal result = { }\nfunction makeabsolute(value, depth)\nif (type(value) == \"table\") then\nfor _, item in ipairs(value) do\nmakeabsolute(item, depth + 1)\nend\nelseif type(value) == \"string\" then\nif value:find(\"*\") then\nmakeabsolute(matchfunc(value), depth + 1)\nelse\ntable.insert(result, path.getabsolute(value))\nend\nelse\nerror(\"Invalid value in list: expected string, got \" .. type(value), depth)\nend\nend\nmakeabsolute(value, 3)\nreturn premake.setarray(ctype, fieldname, result)\nend\nfunction premake.setdirarray(ctype, fieldname, value)\nreturn domatchedarray(ctype, fieldname, value, os.matchdirs)\nend\nfunction premake.setfilearray(ctype, fieldname, value)\nreturn domatchedarray(ctype, fieldname, value, os.matchfiles)\nend\nfunction premake.setstring(ctype, fieldname, value, allowed)\nlocal container, err = premake.getobject(ctype)\nif (not container) then\nerror(err, 4)\nend\nif (value) then\nvalue, err = premake.checkvalue(value, allow"
	"ed)\nif (not value) then \nerror(err, 4)\nend\ncontainer[fieldname] = value\nend\nreturn container[fieldname]\nend\nlocal function accessor(name, value)\nlocal kind    = premake.fields[name].kind\nlocal scope   = premake.fields[name].scope\nlocal allowed = premake.fields[name].allowed\nif ((kind == \"string\" or kind == \"path\") and value) then\nif type(value) ~= \"string\" then\nerror(\"string value expected\", 3)\nend\nend\nif (kind == \"string\") then\nreturn premake.setstring(scope, name, value, allowed)\nelseif (kind == \"path\") then\nif value then value = path.getabsolute(value) end\nreturn premake.setstring(scope, name, value)\nelseif (kind == \"list\") then\nreturn premake.setarray(scope, name, value, allowed)\nelseif (kind == \"dirlist\") then\nreturn premake.setdirarray(scope, name, value)\nelseif (kind == \"filelist\") then\nreturn premake.setfilearray(scope, name, value)\nend\nend\nfor name,_ in pairs(premake.fields) do\n_G[name] = function(value)\nreturn accessor(name, value)\nend\nend\nfunction"
	" configuration(terms)\nif not terms then\nreturn premake.CurrentConfiguration\nend\nlocal container, err = premake.getobject(\"container\")\nif (not container) then\nerror(err, 2)\nend\nlocal cfg = { }\ncfg.terms = table.flatten({terms})\ntable.insert(container.blocks, cfg)\npremake.CurrentConfiguration = cfg\ncfg.keywords = { }\nfor _, word in ipairs(cfg.terms) do\ntable.insert(cfg.keywords, path.wildcards(word):lower())\nend\nfor name, field in pairs(premake.fields) do\nif (field.kind ~= \"string\" and field.kind ~= \"path\") then\ncfg[name] = { }\nend\nend\nreturn cfg\nend\nfunction project(name)\nif not name then\nreturn iif(type(premake.CurrentContainer) == \"project\", premake.CurrentContainer, nil)\nend\nlocal sln\nif (type(premake.CurrentContainer) == \"project\") then\nsln = premake.CurrentContainer.solution\nelse\nsln = premake.CurrentContainer\nend\nif (type(sln) ~= \"solution\") then\nerror(\"no active solution\", 2)\nend\npremake.CurrentContainer = sln.projects[name]\nif (not premake.CurrentContai"
	"ner) then\nlocal prj = { }\npremake.CurrentContainer = prj\ntable.insert(sln.projects, prj)\nsln.projects[name] = prj\nsetmetatable(prj, {\n__type = \"project\",\n})\nprj.solution       = sln\nprj.name           = name\nprj.basedir        = os.getcwd()\nprj.uuid           = os.uuid()\nprj.blocks         = { }\nend\nconfiguration { }\nreturn premake.CurrentContainer\nend\nfunction solution(name)\nif not name then\nif type(premake.CurrentContainer) == \"project\" then\nreturn premake.CurrentContainer.solution\nelse\nreturn premake.CurrentContainer\nend\nend\npremake.CurrentContainer = premake.solution.get(name)\nif (not premake.CurrentContainer) then\npremake.CurrentContainer = premake.solution.new(name)\nend\nconfiguration { }\nreturn premake.CurrentContainer\nend\nfunction newaction(a)\npremake.action.add(a)\nend\nfunction newoption(opt)\npremake.option.add(opt)\nend\n",

	/* base/cmdline.lua */
	"newoption \n{\ntrigger     = \"cc\",\nvalue       = \"VALUE\",\ndescription = \"Choose a C/C++ compiler set\",\nallowed = {\n{ \"gcc\", \"GNU GCC (gcc/g++)\" },\n{ \"ow\",  \"OpenWatcom\"        },\n}\n}\nnewoption\n{\ntrigger     = \"dotnet\",\nvalue       = \"VALUE\",\ndescription = \"Choose a .NET compiler set\",\nallowed = {\n{ \"msnet\",   \"Microsoft .NET (csc)\" },\n{ \"mono\",    \"Novell Mono (mcs)\"    },\n{ \"pnet\",    \"Portable.NET (cscc)\"  },\n}\n}\nnewoption\n{\ntrigger     = \"file\",\nvalue       = \"FILE\",\ndescription = \"Read FILE as a Premake script; default is 'premake4.lua'\"\n}\nnewoption\n{\ntrigger     = \"help\",\ndescription = \"Display this information\"\n}\nnewoption\n{\ntrigger     = \"os\",\nvalue       = \"VALUE\",\ndescription = \"Generate files for a different operating system\",\nallowed = {\n{ \"bsd\",      \"OpenBSD, NetBSD, or FreeBSD\" },\n{ \"linux\",    \"Linux\" },\n{ \"macosx\",   \"Apple Mac OS X\" },\n{ \"solaris\",  \"Solaris\" },\n{ \"windows\",  \"Microsoft W"
	"indows\" },\n}\n}\nnewoption\n{\ntrigger     = \"platform\",\nvalue       = \"VALUE\",\ndescription = \"Add target architecture (if supported by action)\",\nallowed = {\n{ \"x32\",         \"32-bit\" },\n{ \"x64\",         \"64-bit\" },\n{ \"universal\",   \"Mac OS X Universal, 32- and 64-bit\" },\n{ \"universal32\", \"Mac OS X Universal, 32-bit only\" },\n{ \"universal64\", \"Mac OS X Universal, 64-bit only\" },\n{ \"ps3\",         \"Playstation 3 (experimental)\" },\n{ \"xbox360\",     \"Xbox 360 (experimental)\" },\n}\n}\nnewoption\n{\ntrigger     = \"scripts\",\nvalue       = \"path\",\ndescription = \"Search for additional scripts on the given path\"\n}\nnewoption\n{\ntrigger     = \"version\",\ndescription = \"Display version information\"\n}\n",

	/* tools/dotnet.lua */
	"premake.dotnet = { }\npremake.dotnet.namestyle = \"windows\"\nlocal flags =\n{\nFatalWarning   = \"/warnaserror\",\nOptimize       = \"/optimize\",\nOptimizeSize   = \"/optimize\",\nOptimizeSpeed  = \"/optimize\",\nSymbols        = \"/debug\",\nUnsafe         = \"/unsafe\"\n}\nfunction premake.dotnet.getbuildaction(fcfg)\nlocal ext = path.getextension(fcfg.name):lower()\nif fcfg.buildaction == \"Compile\" or ext == \".cs\" then\nreturn \"Compile\"\nelseif fcfg.buildaction == \"Embed\" or ext == \".resx\" then\nreturn \"EmbeddedResource\"\nelseif fcfg.buildaction == \"Copy\" or ext == \".asax\" or ext == \".aspx\" then\nreturn \"Content\"\nelse\nreturn \"None\"\nend\nend\nfunction premake.dotnet.getcompilervar(cfg)\nif (_OPTIONS.dotnet == \"msnet\") then\nreturn \"csc\"\nelseif (_OPTIONS.dotnet == \"mono\") then\nif (cfg.framework <= \"1.1\") then\nreturn \"mcs\"\nelseif (cfg.framework >= \"4.0\") then\nreturn \"dmcs\"\nelse \nreturn \"gmcs\"\nend\nelse\nreturn \"cscc\"\nend\nend\nfunction premake.dotnet.getfla"
	"gs(cfg)\nlocal result = table.translate(cfg.flags, flags)\nreturn result\nend\nfunction premake.dotnet.getkind(cfg)\nif (cfg.kind == \"ConsoleApp\") then\nreturn \"Exe\"\nelseif (cfg.kind == \"WindowedApp\") then\nreturn \"WinExe\"\nelseif (cfg.kind == \"SharedLib\") then\nreturn \"Library\"\nend\nend",

	/* tools/gcc.lua */
	"premake.gcc = { }\npremake.gcc.cc     = \"gcc\"\npremake.gcc.cxx    = \"g++\"\npremake.gcc.ar     = \"ar\"\nlocal cflags =\n{\nEnableSSE      = \"-msse\",\nEnableSSE2     = \"-msse2\",\nExtraWarnings  = \"-Wall\",\nFatalWarnings  = \"-Werror\",\nFloatFast      = \"-ffast-math\",\nFloatStrict    = \"-ffloat-store\",\nNoFramePointer = \"-fomit-frame-pointer\",\nOptimize       = \"-O2\",\nOptimizeSize   = \"-Os\",\nOptimizeSpeed  = \"-O3\",\nSymbols        = \"-g\",\n}\nlocal cxxflags =\n{\nEnableSSE      = \"-msse\",\nEnableSSE2     = \"-msse2\",\nExtraWarnings  = \"-Wall\",\nFatalWarnings  = \"-Werror\",\nFloatFast      = \"-ffast-math\",\nFloatStrict    = \"-ffloat-store\",\nNoFramePointer = \"-fomit-frame-pointer\",\nOptimize       = \"-O2\",\nOptimizeSize   = \"-Os\",\nOptimizeSpeed  = \"-O3\",\nSymbols        = \"-g\",\nNoExceptions   = \"-fno-exceptions\",\nNoRTTI         = \"-fno-rtti\",\n}\npremake.gcc.platforms = \n{\nNative = { \ncppflags = \"-MMD -MP\",\n},\nx32 = { \ncppflags = \"-MMD -MP\",\nflags  "
	"  = \"-m32\",\nldflags  = \"-L/usr/lib32\", \n},\nx64 = { \ncppflags = \"-MMD -MP\",\nflags    = \"-m64\",\nldflags  = \"-L/usr/lib64\",\n},\nUniversal = { \ncppflags = \"\",\nflags    = \"-arch i386 -arch x86_64 -arch ppc -arch ppc64\",\n},\nUniversal32 = { \ncppflags = \"\",\nflags    = \"-arch i386 -arch ppc\",\n},\nUniversal64 = { \ncppflags = \"\",\nflags    = \"-arch x86_64 -arch ppc64\",\n},\nPS3 = {\ncc         = \"ppu-lv2-g++\",\ncxx        = \"ppu-lv2-g++\",\nar         = \"ppu-lv2-ar\",\ncppflags   = \"-MMD -MP\",\n}\n}\nlocal platforms = premake.gcc.platforms\nfunction premake.gcc.getcppflags(cfg)\nlocal result = { }\ntable.insert(result, platforms[cfg.platform].cppflags)\nreturn result\nend\nfunction premake.gcc.getcflags(cfg)\nlocal result = table.translate(cfg.flags, cflags)\ntable.insert(result, platforms[cfg.platform].flags)\nif cfg.system ~= \"windows\" and cfg.kind == \"SharedLib\" then\ntable.insert(result, \"-fPIC\")\nend\nreturn result\nend\nfunction premake.gcc.getcxxflags(cfg)\nlocal re"
	"sult = table.translate(cfg.flags, cxxflags)\nif cfg.system ~= \"windows\" and cfg.kind == \"SharedLib\" then\ntable.insert(result, \"-fPIC\")\nend\nreturn result\nend\nfunction premake.gcc.getldflags(cfg)\nlocal result = { }\nif not cfg.flags.Symbols then\nif cfg.system == \"macosx\" then\ntable.insert(result, \"-Wl,-x\")\nelse\ntable.insert(result, \"-s\")\nend\nend\nif cfg.kind == \"SharedLib\" then\nif cfg.system == \"macosx\" then\nresult = table.join(result, { \"-dynamiclib\", \"-flat_namespace\" })\nelse\ntable.insert(result, \"-shared\")\nend\nif cfg.system == \"windows\" and not cfg.flags.NoImportLib then\ntable.insert(result, '-Wl,--out-implib=\"' .. cfg.linktarget.fullpath .. '\"')\nend\nend\nif cfg.kind == \"WindowedApp\" and cfg.system == \"windows\" then\ntable.insert(result, \"-mwindows\")\nend\nlocal platform = platforms[cfg.platform]\ntable.insert(result, platform.flags)\ntable.insert(result, platform.ldflags)\nreturn result\nend\nfunction premake.gcc.getlibdirflags(cfg)\nlocal result = { }\nfo"
	"r _, value in ipairs(premake.getlinks(cfg, \"all\", \"directory\")) do\ntable.insert(result, '-L' .. _MAKE.esc(value))\nend\nreturn result\nend\nfunction premake.gcc.getlinkflags(cfg)\nlocal result = { }\nfor _, value in ipairs(premake.getlinks(cfg, \"all\", \"basename\")) do\nif path.getextension(value) == \".framework\" then\ntable.insert(result, '-framework ' .. _MAKE.esc(path.getbasename(value)))\nelse\ntable.insert(result, '-l' .. _MAKE.esc(value))\nend\nend\nreturn result\nend\nfunction premake.gcc.getdefines(defines)\nlocal result = { }\nfor _,def in ipairs(defines) do\ntable.insert(result, '-D' .. def)\nend\nreturn result\nend\nfunction premake.gcc.getincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, \"-I\" .. _MAKE.esc(dir))\nend\nreturn result\nend\n",

	/* tools/msc.lua */
	"premake.msc = { }\npremake.msc.namestyle = \"windows\"\n",

	/* tools/ow.lua */
	"premake.ow = { }\npremake.ow.namestyle = \"windows\"\npremake.ow.cc     = \"WCL386\"\npremake.ow.cxx    = \"WCL386\"\npremake.ow.ar     = \"ar\"\nlocal cflags =\n{\nExtraWarnings  = \"-wx\",\nFatalWarning   = \"-we\",\nFloatFast      = \"-omn\",\nFloatStrict    = \"-op\",\nOptimize       = \"-ox\",\nOptimizeSize   = \"-os\",\nOptimizeSpeed  = \"-ot\",\nSymbols        = \"-d2\",\n}\nlocal cxxflags =\n{\nNoExceptions   = \"-xd\",\nNoRTTI         = \"-xr\",\n}\npremake.ow.platforms = \n{\nNative = { \nflags = \"\" \n},\n}\nfunction premake.ow.getcppflags(cfg)\nreturn {}\nend\nfunction premake.ow.getcflags(cfg)\nlocal result = table.translate(cfg.flags, cflags)\nif (cfg.flags.Symbols) then\ntable.insert(result, \"-hw\")   -- Watcom debug format for Watcom debugger\nend\nreturn result\nend\nfunction premake.ow.getcxxflags(cfg)\nlocal result = table.translate(cfg.flags, cxxflags)\nreturn result\nend\nfunction premake.ow.getldflags(cfg)\nlocal result = { }\nif (cfg.flags.Symbols) then\ntable.insert(result, \"op symf"
	"\")\nend\nreturn result\nend\nfunction premake.ow.getlinkflags(cfg)\nlocal result = { }\nreturn result\nend\nfunction premake.ow.getdefines(defines)\nlocal result = { }\nfor _,def in ipairs(defines) do\ntable.insert(result, '-D' .. def)\nend\nreturn result\nend\nfunction premake.ow.getincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, '-I \"' .. dir .. '\"')\nend\nreturn result\nend\n",

	/* base/validate.lua */
	"function premake.checkprojects()\nlocal action = premake.action.current()\nfor sln in premake.solution.each() do\nif (#sln.projects == 0) then\nreturn nil, \"solution '\" .. sln.name .. \"' needs at least one project\"\nend\nif (#sln.configurations == 0) then\nreturn nil, \"solution '\" .. sln.name .. \"' needs configurations\"\nend\nfor prj in premake.solution.eachproject(sln) do\nif (not prj.language) then\nreturn nil, \"project '\" ..prj.name .. \"' needs a language\"\nend\nif (action.valid_languages) then\nif (not table.contains(action.valid_languages, prj.language)) then\nreturn nil, \"the \" .. action.shortname .. \" action does not support \" .. prj.language .. \" projects\"\nend\nend\nfor cfg in premake.eachconfig(prj) do\nif (not cfg.kind) then\nreturn nil, \"project '\" ..prj.name .. \"' needs a kind in configuration '\" .. cfg.name .. \"'\"\nend\nif (action.valid_kinds) then\nif (not table.contains(action.valid_kinds, cfg.kind)) then\nreturn nil, \"the \" .. action.shortname .. \" action does not su"
	"pport \" .. cfg.kind .. \" projects\"\nend\nend\nend\nif action.oncheckproject then\naction.oncheckproject(prj)\nend\nend\nend\nreturn true\nend\nfunction premake.checktools()\nlocal action = premake.action.current()\nif (not action.valid_tools) then \nreturn true \nend\nfor tool, values in pairs(action.valid_tools) do\nif (_OPTIONS[tool]) then\nif (not table.contains(values, _OPTIONS[tool])) then\nreturn nil, \"the \" .. action.shortname .. \" action does not support /\" .. tool .. \"=\" .. _OPTIONS[tool] .. \" (yet)\"\nend\nelse\n_OPTIONS[tool] = values[1]\nend\nend\nreturn true\nend\n",

	/* base/help.lua */
	"function premake.showhelp()\nprintf(\"Premake %s, a build script generator\", _PREMAKE_VERSION)\nprintf(_PREMAKE_COPYRIGHT)\nprintf(\"%s %s\", _VERSION, _COPYRIGHT)\nprintf(\"\")\nprintf(\"Usage: premake4 [options] action [arguments]\")\nprintf(\"\")\nprintf(\"OPTIONS\")\nprintf(\"\")\nfor option in premake.option.each() do\nlocal trigger = option.trigger\nlocal description = option.description\nif (option.value) then trigger = trigger .. \"=\" .. option.value end\nif (option.allowed) then description = description .. \"; one of:\" end\nprintf(\" --%-15s %s\", trigger, description) \nif (option.allowed) then\nfor _, value in ipairs(option.allowed) do\nprintf(\"     %-14s %s\", value[1], value[2])\nend\nend\nprintf(\"\")\nend\nprintf(\"ACTIONS\")\nprintf(\"\")\nfor action in premake.action.each() do\nprintf(\" %-17s %s\", action.trigger, action.description)\nend\nprintf(\"\")\nprintf(\"For additional information, see http://industriousone.com/premake\")\nend\n",

	/* base/premake.lua */
	"function premake.generate(obj, filename, callback)\nfilename = premake.project.getfilename(obj, filename)\nprintf(\"Generating %s...\", filename)\nlocal f, err = io.open(filename, \"wb\")\nif (not f) then\nerror(err, 0)\nend\nio.output(f)\ncallback(obj)\nf:close()\nend\n",

	/* actions/codeblocks/_codeblocks.lua */
	"newaction {\ntrigger         = \"codeblocks\",\nshortname       = \"Code::Blocks\",\ndescription     = \"Generate Code::Blocks project files\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\" },\nvalid_languages = { \"C\", \"C++\" },\nvalid_tools     = {\ncc   = { \"gcc\", \"ow\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.workspace\", premake.codeblocks_workspace)\nend,\nonproject = function(prj)\npremake.generate(prj, \"%%.cbp\", premake.codeblocks_cbp)\nend,\noncleansolution = function(sln)\npremake.clean.file(sln, \"%%.workspace\")\nend,\noncleanproject = function(prj)\npremake.clean.file(prj, \"%%.cbp\")\npremake.clean.file(prj, \"%%.depend\")\npremake.clean.file(prj, \"%%.layout\")\nend\n}\n",

	/* actions/codeblocks/codeblocks_workspace.lua */
	"function premake.codeblocks_workspace(sln)\n_p('<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?>')\n_p('<CodeBlocks_workspace_file>')\n_p(1,'<Workspace title=\"%s\">', sln.name)\nfor prj in premake.solution.eachproject(sln) do\nlocal fname = path.join(path.getrelative(sln.location, prj.location), prj.name)\nlocal active = iif(prj.project == sln.projects[1], ' active=\"1\"', '')\n_p(2,'<Project filename=\"%s.cbp\"%s>', fname, active)\nfor _,dep in ipairs(premake.getdependencies(prj)) do\n_p(3,'<Depends filename=\"%s.cbp\" />', path.join(path.getrelative(sln.location, dep.location), dep.name))\nend\n_p(2,'</Project>')\nend\n_p(1,'</Workspace>')\n_p('</CodeBlocks_workspace_file>')\nend\n",

	/* actions/codeblocks/codeblocks_cbp.lua */
	"function premake.codeblocks_cbp(prj)\nlocal cc = premake.gettool(prj)\n_p('<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?>')\n_p('<CodeBlocks_project_file>')\n_p(1,'<FileVersion major=\"1\" minor=\"6\" />')\n_p(1,'<Project>')\n_p(2,'<Option title=\"%s\" />', premake.esc(prj.name))\n_p(2,'<Option pch_mode=\"2\" />')\n_p(2,'<Option compiler=\"%s\" />', _OPTIONS.cc)\nlocal platforms = premake.filterplatforms(prj.solution, cc.platforms, \"Native\")\nfor i = #platforms, 1, -1 do\nif premake.platforms[platforms[i]].iscrosscompiler then\ntable.remove(platforms, i)\nend\nend \n_p(2,'<Build>')\nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\n_p(3,'<Target title=\"%s\">', premake.esc(cfg.longname))\n_p(4,'<Option output=\"%s\" prefix_auto=\"0\" extension_auto=\"0\" />', premake.esc(cfg.buildtarget.fullpath))\n_p(4,'<Option object_output=\"%s\" />', premake.esc(cfg.objectsdir))\n_p(4,'<Option external_deps=\"%s\" />', table.concat(premake.getlinks(cfg, \"siblings\""
	", \"fullpath\"),\";\"))\nlocal types = { WindowedApp = 0, ConsoleApp = 1, StaticLib = 2, SharedLib = 3 }\n_p(4,'<Option type=\"%d\" />', types[cfg.kind])\n_p(4,'<Option compiler=\"%s\" />', _OPTIONS.cc)\nif (cfg.kind == \"SharedLib\") then\n_p(4,'<Option createDefFile=\"0\" />')\n_p(4,'<Option createStaticLib=\"%s\" />', iif(cfg.flags.NoImportLib, 0, 1))\nend\n_p(4,'<Compiler>')\nfor _,flag in ipairs(table.join(cc.getcflags(cfg), cc.getcxxflags(cfg), cc.getdefines(cfg.defines), cfg.buildoptions)) do\n_p(5,'<Add option=\"%s\" />', premake.esc(flag))\nend\nif not cfg.flags.NoPCH and cfg.pchheader then\n_p(5,'<Add option=\"-Winvalid-pch\" />')\n_p(5,'<Add option=\"-include &quot;%s&quot;\" />', premake.esc(cfg.pchheader))\nend\nfor _,v in ipairs(cfg.includedirs) do\n_p(5,'<Add directory=\"%s\" />', premake.esc(v))\nend\n_p(4,'</Compiler>')\n_p(4,'<Linker>')\n_p(5,'<Add option=\"-Wl,--start-group\" />')\nfor _,v in ipairs(premake.getlinks(cfg, \"siblings\", \"fullpath\")) do\n_p(5,'<Add option=\"%s\" />', premake."
	"esc(v))\nend\n_p(5,'<Add option=\"-Wl,--end-group\" />')\nfor _,flag in ipairs(table.join(cc.getldflags(cfg), cfg.linkoptions)) do\n_p(5,'<Add option=\"%s\" />', premake.esc(flag))\nend\nfor _,v in ipairs(premake.getlinks(cfg, \"all\", \"directory\")) do\n_p(5,'<Add directory=\"%s\" />', premake.esc(v))\nend\nfor _,v in ipairs(premake.getlinks(cfg, \"system\", \"basename\")) do\n_p(5,'<Add library=\"%s\" />', premake.esc(v))\nend\n_p(4,'</Linker>')\nif premake.findfile(cfg, \".rc\") then\n_p(4,'<ResourceCompiler>')\nfor _,v in ipairs(cfg.includedirs) do\n_p(5,'<Add directory=\"%s\" />', premake.esc(v))\nend\nfor _,v in ipairs(cfg.resincludedirs) do\n_p(5,'<Add directory=\"%s\" />', premake.esc(v))\nend\n_p(4,'</ResourceCompiler>')\nend\nif #cfg.prebuildcommands > 0 or #cfg.postbuildcommands > 0 then\n_p(4,'<ExtraCommands>')\nfor _,v in ipairs(cfg.prebuildcommands) do\n_p(5,'<Add before=\"%s\" />', premake.esc(v))\nend\nfor _,v in ipairs(cfg.postbuildcommands) do\n_p(5,'<Add after=\"%s\" />', premake.esc(v))\ne"
	"nd\n_p(4,'</ExtraCommands>')\nend\n_p(3,'</Target>')\nend\nend\n_p(2,'</Build>')\nlocal pchheader\nif (prj.pchheader) then\npchheader = path.getrelative(prj.location, prj.pchheader)\nend\nfor _,fname in ipairs(prj.files) do\n_p(2,'<Unit filename=\"%s\">', premake.esc(fname))\nif path.isresourcefile(fname) then\n_p(3,'<Option compilerVar=\"WINDRES\" />')\nelseif path.iscfile(fname) and prj.language == \"C++\" then\n_p(3,'<Option compilerVar=\"CC\" />')\nend\nif not prj.flags.NoPCH and fname == pchheader then\n_p(3,'<Option compilerVar=\"%s\" />', iif(prj.language == \"C\", \"CC\", \"CPP\"))\n_p(3,'<Option compile=\"1\" />')\n_p(3,'<Option weight=\"0\" />')\n_p(3,'<Add option=\"-x c++-header\" />')\nend\n_p(2,'</Unit>')\nend\n_p(2,'<Extensions />')\n_p(1,'</Project>')\n_p('</CodeBlocks_project_file>')\n_p('')\nend\n",

	/* actions/codelite/_codelite.lua */
	"newaction {\ntrigger         = \"codelite\",\nshortname       = \"CodeLite\",\ndescription     = \"Generate CodeLite project files\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\" },\nvalid_languages = { \"C\", \"C++\" },\nvalid_tools     = {\ncc   = { \"gcc\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.workspace\", premake.codelite_workspace)\nend,\nonproject = function(prj)\npremake.generate(prj, \"%%.project\", premake.codelite_project)\nend,\noncleansolution = function(sln)\npremake.clean.file(sln, \"%%.workspace\")\npremake.clean.file(sln, \"%%_wsp.mk\")\npremake.clean.file(sln, \"%%.tags\")\nend,\noncleanproject = function(prj)\npremake.clean.file(prj, \"%%.project\")\npremake.clean.file(prj, \"%%.mk\")\npremake.clean.file(prj, \"%%.list\")\npremake.clean.file(prj, \"%%.out\")\nend\n}\n",

	/* actions/codelite/codelite_workspace.lua */
	"function premake.codelite_workspace(sln)\n_p('<?xml version=\"1.0\" encoding=\"utf-8\"?>')\n_p('<CodeLite_Workspace Name=\"%s\" Database=\"./%s.tags\">', premake.esc(sln.name), premake.esc(sln.name))\nfor i,prj in ipairs(sln.projects) do\nlocal name = premake.esc(prj.name)\nlocal fname = path.join(path.getrelative(sln.location, prj.location), prj.name)\nlocal active = iif(i==1, \"Yes\", \"No\")\n_p('  <Project Name=\"%s\" Path=\"%s.project\" Active=\"%s\" />', name, fname, active)\nend\nlocal platforms = premake.filterplatforms(sln, premake[_OPTIONS.cc].platforms, \"Native\")\nfor i = #platforms, 1, -1 do\nif premake.platforms[platforms[i]].iscrosscompiler then\ntable.remove(platforms, i)\nend\nend \n_p('  <BuildMatrix>')\nfor _, platform in ipairs(platforms) do\nfor _, cfgname in ipairs(sln.configurations) do\nlocal name = premake.getconfigname(cfgname, platform)\n_p('    <WorkspaceConfiguration Name=\"%s\" Selected=\"yes\">', name)\nfor _,prj in ipairs(sln.projects) do\n_p('      <Project Name=\"%s\" ConfigN"
	"ame=\"%s\"/>', prj.name, name)\nend\n_p('    </WorkspaceConfiguration>')\nend\nend\n_p('  </BuildMatrix>')\n_p('</CodeLite_Workspace>')\nend\n",

	/* actions/codelite/codelite_project.lua */
	"function premake.codelite_project(prj)\n_p('<?xml version=\"1.0\" encoding=\"utf-8\"?>')\n_p('<CodeLite_Project Name=\"%s\">', premake.esc(prj.name))\npremake.walksources(prj, premake.codelite_files)\nlocal types = { \nConsoleApp  = \"Executable\", \nWindowedApp = \"Executable\", \nStaticLib   = \"Static Library\",\nSharedLib   = \"Dynamic Library\",\n}\n_p('  <Settings Type=\"%s\">', types[prj.kind])\nlocal platforms = premake.filterplatforms(prj.solution, premake[_OPTIONS.cc].platforms, \"Native\")\nfor i = #platforms, 1, -1 do\nif premake.platforms[platforms[i]].iscrosscompiler then\ntable.remove(platforms, i)\nend\nend \nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\nlocal name = premake.esc(cfg.longname)\nlocal compiler = iif(cfg.language == \"C\", \"gcc\", \"g++\")\n_p('    <Configuration Name=\"%s\" CompilerType=\"gnu %s\" DebuggerType=\"GNU gdb debugger\" Type=\"%s\">', name, compiler, types[cfg.kind])\nlocal fname  = premake.esc(cfg.buildtarget.fullpath)\nloc"
	"al objdir = premake.esc(cfg.objectsdir)\nlocal runcmd = cfg.buildtarget.name\nlocal rundir = cfg.buildtarget.directory\nlocal pause  = iif(cfg.kind == \"WindowedApp\", \"no\", \"yes\")\n_p('      <General OutputFile=\"%s\" IntermediateDirectory=\"%s\" Command=\"./%s\" CommandArguments=\"\" WorkingDirectory=\"%s\" PauseExecWhenProcTerminates=\"%s\"/>', fname, objdir, runcmd, rundir, pause)\nlocal flags = premake.esc(table.join(premake.gcc.getcflags(cfg), premake.gcc.getcxxflags(cfg), cfg.buildoptions))\n_p('      <Compiler Required=\"yes\" Options=\"%s\">', table.concat(flags, \";\"))\nfor _,v in ipairs(cfg.includedirs) do\n_p('        <IncludePath Value=\"%s\"/>', premake.esc(v))\nend\nfor _,v in ipairs(cfg.defines) do\n_p('        <Preprocessor Value=\"%s\"/>', premake.esc(v))\nend\n_p('      </Compiler>')\nflags = premake.esc(table.join(premake.gcc.getldflags(cfg), cfg.linkoptions))\n_p('      <Linker Required=\"yes\" Options=\"%s\">', table.concat(flags, \";\"))\nfor _,v in ipairs(premake.getlinks(cfg, \"al"
	"l\", \"directory\")) do\n_p('        <LibraryPath Value=\"%s\" />', premake.esc(v))\nend\nfor _,v in ipairs(premake.getlinks(cfg, \"all\", \"basename\")) do\n_p('        <Library Value=\"%s\" />', premake.esc(v))\nend\n_p('      </Linker>')\nif premake.findfile(cfg, \".rc\") then\nlocal defines = table.implode(table.join(cfg.defines, cfg.resdefines), \"-D\", \";\", \"\")\nlocal options = table.concat(cfg.resoptions, \";\")\n_p('      <ResourceCompiler Required=\"yes\" Options=\"%s%s\">', defines, options)\nfor _,v in ipairs(table.join(cfg.includedirs, cfg.resincludedirs)) do\n_p('        <IncludePath Value=\"%s\"/>', premake.esc(v))\nend\n_p('      </ResourceCompiler>')\nelse\n_p('      <ResourceCompiler Required=\"no\" Options=\"\"/>')\nend\nif #cfg.prebuildcommands > 0 then\n_p('      <PreBuild>')\nfor _,v in ipairs(cfg.prebuildcommands) do\n_p('        <Command Enabled=\"yes\">%s</Command>', premake.esc(v))\nend\n_p('      </PreBuild>')\nend\nif #cfg.postbuildcommands > 0 then\n_p('      <PostBuild>')\nfor "
	"_,v in ipairs(cfg.postbuildcommands) do\n_p('        <Command Enabled=\"yes\">%s</Command>', premake.esc(v))\nend\n_p('      </PostBuild>')\nend\n_p('      <CustomBuild Enabled=\"no\">')\n_p('        <CleanCommand></CleanCommand>')\n_p('        <BuildCommand></BuildCommand>')\n_p('        <SingleFileCommand></SingleFileCommand>')\n_p('        <MakefileGenerationCommand></MakefileGenerationCommand>')\n_p('        <ThirdPartyToolName>None</ThirdPartyToolName>')\n_p('        <WorkingDirectory></WorkingDirectory>')\n_p('      </CustomBuild>')\n_p('      <AdditionalRules>')\n_p('        <CustomPostBuild></CustomPostBuild>')\n_p('        <CustomPreBuild></CustomPreBuild>')\n_p('      </AdditionalRules>')\n_p('    </Configuration>')\nend\nend\n_p('  </Settings>')\nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\n_p('  <Dependencies name=\"%s\">', cfg.longname)\nfor _,dep in ipairs(premake.getdependencies(prj)) do\n_p('    <Project Name=\"%s\"/>', dep.name)\nend\n_p('  </Depend"
	"encies>')\nend\nend\n_p('</CodeLite_Project>')\nend\nfunction premake.codelite_files(prj, fname, state, nestlevel)\nlocal indent = string.rep(\"  \", nestlevel + 1)\nif (state == \"GroupStart\") then\nio.write(indent .. '<VirtualDirectory Name=\"' .. path.getname(fname) .. '\">\\n')\nelseif (state == \"GroupEnd\") then\nio.write(indent .. '</VirtualDirectory>\\n')\nelse\nio.write(indent .. '<File Name=\"' .. fname .. '\"/>\\n')\nend\nend\n",

	/* actions/make/_make.lua */
	"_MAKE = { }\npremake.make = { }\nfunction _MAKE.esc(value)\nlocal result\nif (type(value) == \"table\") then\nresult = { }\nfor _,v in ipairs(value) do\ntable.insert(result, _MAKE.esc(v))\nend\nreturn result\nelse\nresult = value:gsub(\"\\\\\", \"\\\\\\\\\")\nresult = result:gsub(\" \", \"\\\\ \")\nresult = result:gsub(\"%(\", \"\\\\%(\")\nresult = result:gsub(\"%)\", \"\\\\%)\")\nresult = result:gsub(\"$\\\\%((.-)\\\\%)\", \"$%(%1%)\")\nreturn result\nend\nend\nfunction premake.make_copyrule(source, target)\n_p('%s: %s', target, source)\n_p('\\t@echo Copying $(notdir %s)', target)\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) cp -fR %s %s', source, target)\n_p('else')\n_p('\\t$(SILENT) copy /Y $(subst /,\\\\\\\\,%s) $(subst /,\\\\\\\\,%s)', source, target)\n_p('endif')\nend\nfunction premake.make_mkdirrule(var)\n_p('\\t@echo Creating %s', var)\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) mkdir -p %s', var)\n_p('else')\n_p('\\t$(SILENT) mkdir $(subst /,\\\\\\\\,%s)', var)\n_p('endif')\n_p('')\nend\n"
	"function _MAKE.getmakefilename(this, searchprjs)\nlocal count = 0\nfor sln in premake.solution.each() do\nif (sln.location == this.location) then count = count + 1 end\nif (searchprjs) then\nfor _,prj in ipairs(sln.projects) do\nif (prj.location == this.location) then count = count + 1 end\nend\nend\nend\nif (count == 1) then\nreturn \"Makefile\"\nelse\nreturn this.name .. \".make\"\nend\nend\nfunction _MAKE.getnames(tbl)\nlocal result = table.extract(tbl, \"name\")\nfor k,v in pairs(result) do\nresult[k] = _MAKE.esc(v)\nend\nreturn result\nend\nnewaction {\ntrigger         = \"gmake\",\nshortname       = \"GNU Make\",\ndescription     = \"Generate GNU makefiles for POSIX, MinGW, and Cygwin\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\" },\nvalid_languages = { \"C\", \"C++\", \"C#\" },\nvalid_tools     = {\ncc     = { \"gcc\" },\ndotnet = { \"mono\", \"msnet\", \"pnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, _MAKE.getmakefilename(sln, false), premake.ma"
	"ke_solution)\nend,\nonproject = function(prj)\nlocal makefile = _MAKE.getmakefilename(prj, true)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, makefile, premake.make_csharp)\nelse\npremake.generate(prj, makefile, premake.make_cpp)\nend\nend,\noncleansolution = function(sln)\npremake.clean.file(sln, _MAKE.getmakefilename(sln, false))\nend,\noncleanproject = function(prj)\npremake.clean.file(prj, _MAKE.getmakefilename(prj, true))\nend\n}\n",

	/* actions/make/make_solution.lua */
	"function premake.make_solution(sln)\nlocal cc = premake[_OPTIONS.cc]\nlocal platforms = premake.filterplatforms(sln, cc.platforms, \"Native\")\n_p('# %s solution makefile autogenerated by Premake', premake.action.current().shortname)\n_p('# Type \"make help\" for usage help')\n_p('')\n_p('ifndef config')\n_p('  config=%s', _MAKE.esc(premake.getconfigname(sln.configurations[1], platforms[1], true)))\n_p('endif')\n_p('export config')\n_p('')\n_p('PROJECTS := %s', table.concat(_MAKE.esc(table.extract(sln.projects, \"name\")), \" \"))\n_p('')\n_p('.PHONY: all clean help $(PROJECTS)')\n_p('')\n_p('all: $(PROJECTS)')\n_p('')\nfor _, prj in ipairs(sln.projects) do\n_p('%s: %s', _MAKE.esc(prj.name), table.concat(_MAKE.esc(table.extract(premake.getdependencies(prj), \"name\")), \" \"))\n_p('\\t@echo \"==== Building %s ($(config)) ====\"', prj.name)\n_p('\\t@${MAKE} --no-print-directory -C %s -f %s', _MAKE.esc(path.getrelative(sln.location, prj.location)), _MAKE.esc(_MAKE.getmakefilename(prj, true)))\n_p('')\nend\n_p('c"
	"lean:')\nfor _ ,prj in ipairs(sln.projects) do\n_p('\\t@${MAKE} --no-print-directory -C %s -f %s clean', _MAKE.esc(path.getrelative(sln.location, prj.location)), _MAKE.esc(_MAKE.getmakefilename(prj, true)))\nend\n_p('')\n_p('help:')\n_p(1,'@echo \"Usage: make [config=name] [target]\"')\n_p(1,'@echo \"\"')\n_p(1,'@echo \"CONFIGURATIONS:\"')\nlocal cfgpairs = { }\nfor _, platform in ipairs(platforms) do\nfor _, cfgname in ipairs(sln.configurations) do\n_p(1,'@echo \"   %s\"', premake.getconfigname(cfgname, platform, true))\nend\nend\n_p(1,'@echo \"\"')\n_p(1,'@echo \"TARGETS:\"')\n_p(1,'@echo \"   all (default)\"')\n_p(1,'@echo \"   clean\"')\nfor _, prj in ipairs(sln.projects) do\n_p(1,'@echo \"   %s\"', prj.name)\nend\n_p(1,'@echo \"\"')\n_p(1,'@echo \"For more information, see http://industriousone.com/premake/quick-start\"')\nend\n",

	/* actions/make/make_cpp.lua */
	"premake.make.cpp = { }\nlocal _ = premake.make.cpp\nfunction premake.make_cpp(prj)\nlocal cc = premake.gettool(prj)\nlocal platforms = premake.filterplatforms(prj.solution, cc.platforms, \"Native\")\npremake.gmake_cpp_header(prj, cc, platforms)\nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\npremake.gmake_cpp_config(cfg, cc)\nend\nend\n_p('OBJECTS := \\\\')\nfor _, file in ipairs(prj.files) do\nif path.iscppfile(file) or path.getextension(file) == \".asm\" then\n_p('\\t$(OBJDIR)/%s.o \\\\', _MAKE.esc(path.getbasename(file)))\nend\nend\n_p('')\n \n_p('RESOURCES := \\\\')\nfor _, file in ipairs(prj.files) do\nif path.isresourcefile(file) then\n_p('\\t$(OBJDIR)/%s.res \\\\', _MAKE.esc(path.getbasename(file)))\nend\nend\n_p('')\n \n_p('SHELLTYPE := msdos')\n_p('ifeq (,$(ComSpec)$(COMSPEC))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(SHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('')\n_p('.PHONY: clean prebuild prelink')\n_p('')"
	"\nif os.is(\"MacOSX\") and prj.kind == \"WindowedApp\" then\n_p('all: $(TARGET) $(dir $(TARGETDIR))PkgInfo $(dir $(TARGETDIR))Info.plist')\nelse\n_p('all: $(TARGET)')\nend\n_p('\\t@:')\n_p('')\n_p('$(TARGET): $(OBJECTS) $(LDDEPS) $(RESOURCES) | prelink')\n_p('\\t@echo Linking %s', prj.name)\n_p('\\t$(SILENT) $(LINKCMD)')\n_p('\\t$(POSTBUILDCMDS)')\n_p('')\n_p('$(TARGETDIR):')\npremake.make_mkdirrule(\"$(TARGETDIR)\")\n_p('$(OBJDIR):')\npremake.make_mkdirrule(\"$(OBJDIR)\")\nif os.is(\"MacOSX\") and prj.kind == \"WindowedApp\" then\n_p('$(dir $(TARGETDIR))PkgInfo:')\n_p('$(dir $(TARGETDIR))Info.plist:')\n_p('')\nend\n_p('clean:')\n_p('\\t@echo Cleaning %s', prj.name)\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) rm -f  $(TARGET)')\n_p('\\t$(SILENT) rm -rf $(OBJDIR)')\n_p('else')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(TARGET)) del $(subst /,\\\\\\\\,$(TARGET))')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(OBJDIR)) rmdir /s /q $(subst /,\\\\\\\\,$(OBJDIR))')\n_p('endif')\n_p('')\n_p('prebuild: $"
	"(TARGETDIR) $(OBJDIR)')\n_p('\\t$(PREBUILDCMDS)')\n_p('')\n_p('prelink:')\n_p('\\t$(PRELINKCMDS)')\n_p('')\n_.pchrules(prj)\nfor _, file in ipairs(prj.files) do\nif path.iscppfile(file) then\nlocal gchobj = '$(GCH)'\nlocal pchincludes = '$(PCHINCLUDES)'\nif (path.getextension(file) == \".mm\" or path.getextension(file) == \".m\") then\ngchobj = ''\npchincludes = ''\nend\n_p('$(OBJDIR)/%s.o: %s %s | prebuild', _MAKE.esc(path.getbasename(file)), _MAKE.esc(file), gchobj)\n_p('\\t@echo $(notdir $<)')\nif (path.iscfile(file)) then\n_p('\\t$(SILENT) $(CC) %s $(CFLAGS) -MF $(OBJDIR)/%s.d -MT \"$@\" -o \"$@\" -c \"$<\"', pchincludes, _MAKE.esc(path.getbasename(file)))\nelse\n_p('\\t$(SILENT) $(CXX) %s $(CXXFLAGS) -MF $(OBJDIR)/%s.d -MT \"$@\" -o \"$@\" -c \"$<\"', pchincludes, _MAKE.esc(path.getbasename(file)))\nend\nelseif (path.getextension(file) == \".rc\") then\n_p('$(OBJDIR)/%s.res: %s', _MAKE.esc(path.getbasename(file)), _MAKE.esc(file))\n_p('\\t@echo $(notdir $<)')\n_p('\\t$(SILENT) windres $< -O coff -o \"$@\""
	" $(RESFLAGS)')\nelseif (path.getextension(file) == \".asm\") then\n_p('$(OBJDIR)/%s.o: %s', _MAKE.esc(path.getbasename(file)), _MAKE.esc(file))\n_p('\\t@echo $(notdir $<)')\nlocal opts = ''\nif os.is('windows') then\nopts = ''\nelseif os.is('macosx') then\nopts = '-D OS_UNIX=1'\nelse\nopts = '-D DONT_USE_UNDERLINE=1 -D OS_UNIX=1'\nend\nif not (prj.solution.nasmpath) then\nprj.solution.nasmpath = 'nasm'\nend\n_p('\\t$(SILENT)'.._MAKE.esc(prj.solution.nasmpath)..' '..opts..' -i'.._MAKE.esc(path.getdirectory(file))..'/'..' -f '..\n   _MAKE.esc(prj.solution.nasmformat)..' -o $@ $<\\n\\t')\n_p('\\t$(SILENT)'.._MAKE.esc(prj.solution.nasmpath)..' '..opts..' -i'.._MAKE.esc(path.getdirectory(file))..'/'..\n   ' -M -o $@ $< >$(OBJDIR)/$(<F:%%.asm=%%.d)\\n')\nend\nend\n_p('')\nif(prj.cxxtestpath and prj.cxxtestrootfile and prj.cxxtesthdrfiles and prj.cxxtestsrcfiles) then\nif not(prj.cxxtestrootoptions) then\nprj.cxxtestrootoptions = ''\nend\nif not(prj.cxxtestoptions) then \nprj.cxxtestoptions = ''\nend\n_p(prj.cxxtestr"
	"ootfile..': ')\n_p('\\t@echo $(notdir $<)')\n_p('\\t$(SILENT)'.._MAKE.esc(prj.cxxtestpath)..' --root '..prj.cxxtestrootoptions..' -o '.._MAKE.esc(prj.cxxtestrootfile))\n_p('')\nfor i, file in ipairs(prj.cxxtesthdrfiles) do\n_p('%s: %s', _MAKE.esc(prj.cxxtestsrcfiles[i]), _MAKE.esc(file))\n_p('\\t@echo $(notdir $<)')\n_p('\\t$(SILENT)'.._MAKE.esc(prj.cxxtestpath)..' --part '..prj.cxxtestoptions..' -o ' .._MAKE.esc(prj.cxxtestsrcfiles[i])..' '.._MAKE.esc(file))\nend\n_p('')\nend\n_p('-include $(OBJECTS:%%.o=%%.d)')\n_p('-include $(GCH:%%.h.gch=%%.h.d)')\nend\nfunction premake.gmake_cpp_header(prj, cc, platforms)\n_p('# %s project makefile autogenerated by Premake', premake.action.current().shortname)\n_p('ifndef config')\n_p('  config=%s', _MAKE.esc(premake.getconfigname(prj.solution.configurations[1], platforms[1], true)))\n_p('endif')\n_p('')\n_p('ifndef verbose')\n_p('  SILENT = @')\n_p('endif')\n_p('')\n_p('ifndef CC')\n_p('  CC = %s', cc.cc)\n_p('endif')\n_p('')\n_p('ifndef CXX')\n_p('  CXX = %s', cc.cxx)\n"
	"_p('endif')\n_p('')\n_p('ifndef AR')\n_p('  AR = %s', cc.ar)\n_p('endif')\n_p('')\nend\nfunction premake.gmake_cpp_config(cfg, cc)\n_p('ifeq ($(config),%s)', _MAKE.esc(cfg.shortname))\nlocal platform = cc.platforms[cfg.platform]\nif platform.cc then\n_p('  CC         = %s', platform.cc)\nend\nif platform.cxx then\n_p('  CXX        = %s', platform.cxx)\nend\nif platform.ar then\n_p('  AR         = %s', platform.ar)\nend\nif not(cfg.gnuexternals) then\ncfg.gnuexternal = { }\nend \n_p('  OBJDIR     = %s', _MAKE.esc(cfg.objectsdir))\n_p('  TARGETDIR  = %s', _MAKE.esc(cfg.buildtarget.directory))\n_p('  TARGET     = $(TARGETDIR)/%s', _MAKE.esc(cfg.buildtarget.name))\n_p('  DEFINES   += %s', table.concat(cc.getdefines(cfg.defines), \" \"))\n_p('  INCLUDES  += %s', table.concat(cc.getincludedirs(cfg.includedirs), \" \"))\n_p('  CPPFLAGS  += %s $(DEFINES) $(INCLUDES)', table.concat(cc.getcppflags(cfg), \" \"))\n_.pchconfig(cfg)\n_p('  CFLAGS    += $(CPPFLAGS) %s', table.concat(table.join(cc.getcflags(cfg), cfg.buildopt"
	"ions), \" \"))\n_p('  CXXFLAGS  += $(CPPFLAGS) %s', table.concat(table.join(cc.getcxxflags(cfg), cfg.buildoptions), \" \"))\n_p('  LDFLAGS   += %s', table.concat(table.join(cc.getldflags(cfg), cfg.linkoptions, cc.getlibdirflags(cfg)), \" \"))\n_p('  LIBS      += %s %s', table.concat(cc.getlinkflags(cfg), \" \"), table.concat(cfg.gnuexternals, \" \"))\n_p('  RESFLAGS  += $(DEFINES) $(INCLUDES) %s', table.concat(table.join(cc.getdefines(cfg.resdefines), cc.getincludedirs(cfg.resincludedirs), cfg.resoptions), \" \"))\n_p('  LDDEPS    += %s', table.concat(_MAKE.esc(premake.getlinks(cfg, \"static\", \"fullpath\")), \" \"))\nif cfg.kind == \"StaticLib\" then\nif cfg.platform:startswith(\"Universal\") then\n_p('  LINKCMD    = libtool -o $(TARGET) $(OBJECTS)')\nelse\n_p('  LINKCMD    = $(AR) -rcs $(TARGET) $(OBJECTS)')\nend\nelse\nlocal lddeps = ''\nif os.is('macosx') then\nlddeps = '$(LDDEPS)'\nelse\nlddeps = '-Xlinker --start-group $(LDDEPS) -Xlinker --end-group'\nend\n_p('  LINKCMD    = $(%s) -o $(TARGET) $(OBJECTS"
	") $(LDFLAGS) $(RESOURCES) %s $(LIBS)', \niif(cfg.language == \"C\", \"CC\", \"CXX\"), lddeps)\nend\n_p('  define PREBUILDCMDS')\nif #cfg.prebuildcommands > 0 then\n_p('\\t@echo Running pre-build commands')\n_p('\\t%s', table.implode(cfg.prebuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define PRELINKCMDS')\nif #cfg.prelinkcommands > 0 then\n_p('\\t@echo Running pre-link commands')\n_p('\\t%s', table.implode(cfg.prelinkcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define POSTBUILDCMDS')\nif #cfg.postbuildcommands > 0 then\n_p('\\t@echo Running post-build commands')\n_p('\\t%s', table.implode(cfg.postbuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('endif')\n_p('')\nend\nfunction _.pchconfig(cfg)\nif not cfg.flags.NoPCH and cfg.pchheader then\n_p('  PCH        = %s', _MAKE.esc(cfg.pchheader))\n_p('  GCH        = $(OBJDIR)/%s.gch', _MAKE.esc(path.getname(cfg.pchheader))) \n_p('  PCHINCLUDES = -I$(OBJDIR) -include $(OBJDIR)/%s', _MAKE.esc(path.getname(cfg.pchheade"
	"r)))\nend\nend\nfunction _.pchrules(prj)\n_p('ifneq (,$(PCH))')\n_p('$(GCH): $(PCH) | $(OBJDIR)')\n_p('\\t@echo $(notdir $<)')\n_p('\\t-$(SILENT) cp $< $(OBJDIR)')\nif prj.language == \"C\" then\n_p('\\t$(SILENT) $(CC) $(CFLAGS) -o \"$@\" -c \"$<\"')\nelse\n_p('\\t$(SILENT) $(CXX) $(CXXFLAGS) -x c++-header -o \"$@\" -c \"$<\"')\nend\n_p('endif')\n_p('')\nend\n",

	/* actions/make/make_csharp.lua */
	"local function getresourcefilename(cfg, fname)\nif path.getextension(fname) == \".resx\" then\n    local name = cfg.buildtarget.basename .. \".\"\n    local dir = path.getdirectory(fname)\n    if dir ~= \".\" then \nname = name .. path.translate(dir, \".\") .. \".\"\nend\nreturn \"$(OBJDIR)/\" .. _MAKE.esc(name .. path.getbasename(fname)) .. \".resources\"\nelse\nreturn fname\nend\nend\nfunction premake.make_csharp(prj)\nlocal csc = premake.dotnet\nlocal cfglibs = { }\nlocal cfgpairs = { }\nlocal anycfg\nfor cfg in premake.eachconfig(prj) do\nanycfg = cfg\ncfglibs[cfg] = premake.getlinks(cfg, \"siblings\", \"fullpath\")\ncfgpairs[cfg] = { }\nfor _, fname in ipairs(cfglibs[cfg]) do\nif path.getdirectory(fname) ~= cfg.buildtarget.directory then\ncfgpairs[cfg][\"$(TARGETDIR)/\" .. _MAKE.esc(path.getname(fname))] = _MAKE.esc(fname)\nend\nend\nend\nlocal sources = {}\nlocal embedded = { }\nlocal copypairs = { }\nfor fcfg in premake.eachfile(prj) do\nlocal action = csc.getbuildaction(fcfg)\nif action == \"Compile\" "
	"then\ntable.insert(sources, fcfg.name)\nelseif action == \"EmbeddedResource\" then\ntable.insert(embedded, fcfg.name)\nelseif action == \"Content\" then\ncopypairs[\"$(TARGETDIR)/\" .. _MAKE.esc(path.getname(fcfg.name))] = _MAKE.esc(fcfg.name)\nelseif path.getname(fcfg.name):lower() == \"app.config\" then\ncopypairs[\"$(TARGET).config\"] = _MAKE.esc(fcfg.name)\nend\nend\nlocal paths = table.translate(prj.libdirs, function(v) return path.join(prj.basedir, v) end)\npaths = table.join({prj.basedir}, paths)\nfor _, libname in ipairs(premake.getlinks(prj, \"system\", \"fullpath\")) do\nlocal libdir = os.pathsearch(libname..\".dll\", unpack(paths))\nif (libdir) then\nlocal target = \"$(TARGETDIR)/\" .. _MAKE.esc(path.getname(libname))\nlocal source = path.getrelative(prj.basedir, path.join(libdir, libname))..\".dll\"\ncopypairs[target] = _MAKE.esc(source)\nend\nend\n_p('# %s project makefile autogenerated by Premake', premake.action.current().shortname)\n_p('')\n_p('ifndef config')\n_p('  config=%s', _MAKE.esc(prj.c"
	"onfigurations[1]:lower()))\n_p('endif')\n_p('')\n_p('ifndef verbose')\n_p('  SILENT = @')\n_p('endif')\n_p('')\n_p('ifndef CSC')\n_p('  CSC=%s', csc.getcompilervar(prj))\n_p('endif')\n_p('')\n_p('ifndef RESGEN')\n_p('  RESGEN=resgen')\n_p('endif')\n_p('')\nlocal platforms = premake.filterplatforms(prj.solution, premake[_OPTIONS.cc].platforms)\ntable.insert(platforms, 1, \"\")\nfor cfg in premake.eachconfig(prj) do\npremake.gmake_cs_config(cfg, csc, cfglibs)\nend\n_p('# To maintain compatibility with VS.NET, these values must be set at the project level')\n_p('TARGET     := $(TARGETDIR)/%s', _MAKE.esc(prj.buildtarget.name))\n_p('FLAGS      += /t:%s %s', csc.getkind(prj):lower(), table.implode(_MAKE.esc(prj.libdirs), \"/lib:\", \"\", \" \"))\n_p('REFERENCES += %s', table.implode(_MAKE.esc(premake.getlinks(prj, \"system\", \"basename\")), \"/r:\", \".dll\", \" \"))\n_p('')\n_p('SOURCES := \\\\')\nfor _, fname in ipairs(sources) do\n_p('\\t%s \\\\', _MAKE.esc(path.translate(fname)))\nend\n_p('')\n_p('EMBEDFILES :="
	" \\\\')\nfor _, fname in ipairs(embedded) do\n_p('\\t%s \\\\', getresourcefilename(prj, fname))\nend\n_p('')\n_p('COPYFILES += \\\\')\nfor target, source in pairs(cfgpairs[anycfg]) do\n_p('\\t%s \\\\', target)\nend\nfor target, source in pairs(copypairs) do\n_p('\\t%s \\\\', target)\nend\n_p('')\n_p('SHELLTYPE := msdos')\n_p('ifeq (,$(ComSpec)$(COMSPEC))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(SHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('')\n_p('.PHONY: clean prebuild prelink')\n_p('')\n_p('all: $(TARGETDIR) $(OBJDIR) prebuild $(EMBEDFILES) $(COPYFILES) prelink $(TARGET)')\n_p('')\n_p('$(TARGET): $(SOURCES) $(EMBEDFILES) $(DEPENDS)')\n_p('\\t$(SILENT) $(CSC) /nologo /out:$@ $(FLAGS) $(REFERENCES) $(SOURCES) $(patsubst %%,/resource:%%,$(EMBEDFILES))')\n_p('\\t$(POSTBUILDCMDS)')\n_p('')\n_p('$(TARGETDIR):')\npremake.make_mkdirrule(\"$(TARGETDIR)\")\n_p('$(OBJDIR):')\npremake.make_mkdirrule(\"$(OBJDIR)\")\n_p('clean:')\n_p('\\t@echo Cleaning %s', prj.name)\n_p('i"
	"feq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) rm -f $(TARGETDIR)/%s.* $(COPYFILES)', prj.buildtarget.basename)\n_p('\\t$(SILENT) rm -rf $(OBJDIR)')\n_p('else')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(TARGETDIR)/%s.*) del $(subst /,\\\\\\\\,$(TARGETDIR)/%s.*)', prj.buildtarget.basename, prj.buildtarget.basename)\nfor target, source in pairs(cfgpairs[anycfg]) do\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,%s) del $(subst /,\\\\\\\\,%s)', target, target)\nend\nfor target, source in pairs(copypairs) do\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,%s) del $(subst /,\\\\\\\\,%s)', target, target)\nend\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(OBJDIR)) rmdir /s /q $(subst /,\\\\\\\\,$(OBJDIR))')\n_p('endif')\n_p('')\n_p('prebuild:')\n_p('\\t$(PREBUILDCMDS)')\n_p('')\n_p('prelink:')\n_p('\\t$(PRELINKCMDS)')\n_p('')\n_p('# Per-configuration copied file rules')\nfor cfg in premake.eachconfig(prj) do\n_p('ifneq (,$(findstring %s,$(config)))', _MAKE.esc(cfg.name:lower()))\nfor target, source in pairs(cfgpa"
	"irs[cfg]) do\npremake.make_copyrule(source, target)\nend\n_p('endif')\n_p('')\nend\n_p('# Copied file rules')\nfor target, source in pairs(copypairs) do\npremake.make_copyrule(source, target)\nend\n_p('# Embedded file rules')\nfor _, fname in ipairs(embedded) do \nif path.getextension(fname) == \".resx\" then\n_p('%s: %s', getresourcefilename(prj, fname), _MAKE.esc(fname))\n_p('\\t$(SILENT) $(RESGEN) $^ $@')\nend\n_p('')\nend\nend\nfunction premake.gmake_cs_config(cfg, csc, cfglibs)\n_p('ifneq (,$(findstring %s,$(config)))', _MAKE.esc(cfg.name:lower()))\n_p('  TARGETDIR  := %s', _MAKE.esc(cfg.buildtarget.directory))\n_p('  OBJDIR     := %s', _MAKE.esc(cfg.objectsdir))\n_p('  DEPENDS    := %s', table.concat(_MAKE.esc(premake.getlinks(cfg, \"dependencies\", \"fullpath\")), \" \"))\n_p('  REFERENCES := %s', table.implode(_MAKE.esc(cfglibs[cfg]), \"/r:\", \"\", \" \"))\n_p('  FLAGS      += %s %s', table.implode(cfg.defines, \"/d:\", \"\", \" \"), table.concat(table.join(csc.getflags(cfg), cfg.buildoptions), \" \")"
	")\n_p('  define PREBUILDCMDS')\nif #cfg.prebuildcommands > 0 then\n_p('\\t@echo Running pre-build commands')\n_p('\\t%s', table.implode(cfg.prebuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define PRELINKCMDS')\nif #cfg.prelinkcommands > 0 then\n_p('\\t@echo Running pre-link commands')\n_p('\\t%s', table.implode(cfg.prelinkcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define POSTBUILDCMDS')\nif #cfg.postbuildcommands > 0 then\n_p('\\t@echo Running post-build commands')\n_p('\\t%s', table.implode(cfg.postbuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('endif')\n_p('')\nend\n",

	/* actions/vstudio/_vstudio.lua */
	"_VS = { }  -- deprecated, will remove eventually\npremake.vstudio = { }\nlocal vstudio = premake.vstudio\npremake.vstudio_platforms = { \nany     = \"Any CPU\", \nmixed   = \"Mixed Platforms\", \nNative  = \"Win32\",\nx32     = \"Win32\", \nx64     = \"x64\",\nPS3     = \"PS3\",\nXbox360 = \"Xbox 360\",\n}\nfunction _VS.arch(prj)\nif (prj.language == \"C#\") then\nif (_ACTION < \"vs2005\") then\nreturn \".NET\"\nelse\nreturn \"Any CPU\"\nend\nelse\nreturn \"Win32\"\nend\nend\nfunction _VS.bool(value)\nif (_ACTION < \"vs2005\") then\nreturn iif(value, \"TRUE\", \"FALSE\")\nelse\nreturn iif(value, \"true\", \"false\")\nend\nend\nfunction premake.vstudio_buildconfigs(sln)\nlocal cfgs = { }\nlocal platforms = premake.filterplatforms(sln, premake.vstudio_platforms, \"Native\")\nlocal hascpp    = premake.hascppproject(sln)\nlocal hasdotnet = premake.hasdotnetproject(sln)\nif hasdotnet then\ntable.insert(platforms, 1, \"any\")\nend\nif hasdotnet and hascpp then\ntable.insert(platforms, 2, \"mixed\")\nend\nfor _, buil"
	"dcfg in ipairs(sln.configurations) do\nfor _, platform in ipairs(platforms) do\nlocal entry = { }\nentry.src_buildcfg = buildcfg\nentry.src_platform = platform\nif platform ~= \"PS3\" then\nentry.buildcfg = buildcfg\nentry.platform = premake.vstudio_platforms[platform]\nelse\nentry.buildcfg = platform .. \" \" .. buildcfg\nentry.platform = \"Win32\"\nend\nentry.name = entry.buildcfg .. \"|\" .. entry.platform\nentry.isreal = (platform ~= \"any\" and platform ~= \"mixed\")\ntable.insert(cfgs, entry)\nend\nend\nreturn cfgs\nend\nfunction _VS.cfgtype(cfg)\nif (cfg.kind == \"SharedLib\") then\nreturn 2\nelseif (cfg.kind == \"StaticLib\") then\nreturn 4\nelse\nreturn 1\nend\nend\nfunction premake.vstudio.cleansolution(sln)\npremake.clean.file(sln, \"%%.sln\")\npremake.clean.file(sln, \"%%.suo\")\npremake.clean.file(sln, \"%%.ncb\")\npremake.clean.file(sln, \"%%.userprefs\")\npremake.clean.file(sln, \"%%.usertasks\")\nend\nfunction premake.vstudio.cleanproject(prj)\nlocal fname = premake.project.getfilename(prj, \"%"
	"%\")\nos.remove(fname .. \".vcproj\")\nos.remove(fname .. \".vcproj.user\")\nos.remove(fname .. \".vcxproj\")\nos.remove(fname .. \".vcxproj.user\")\nos.remove(fname .. \".vcxproj.filters\")\nos.remove(fname .. \".csproj\")\nos.remove(fname .. \".csproj.user\")\nos.remove(fname .. \".pidb\")\nos.remove(fname .. \".sdf\")\nend\nfunction premake.vstudio.cleantarget(name)\nos.remove(name .. \".pdb\")\nos.remove(name .. \".idb\")\nos.remove(name .. \".ilk\")\nos.remove(name .. \".vshost.exe\")\nos.remove(name .. \".exe.manifest\")\nend\nlocal function output(indent, value)\n_p(indent .. value)\nend\nlocal function attrib(indent, name, value)\n_p(indent .. \"\\t\" .. name .. '=\"' .. value .. '\"')\nend\nfunction _VS.files(prj, fname, state, nestlevel)\nlocal indent = string.rep(\"\\t\", nestlevel + 2)\nif (state == \"GroupStart\") then\noutput(indent, \"<Filter\")\nattrib(indent, \"Name\", path.getname(fname))\nattrib(indent, \"Filter\", \"\")\noutput(indent, \"\\t>\")\nelseif (state == \"GroupEnd\") then\noutput("
	"indent, \"</Filter>\")\nelse\noutput(indent, \"<File\")\nattrib(indent, \"RelativePath\", path.translate(fname, \"\\\\\"))\noutput(indent, \"\\t>\")\nif (not prj.flags.NoPCH and prj.pchsource == fname) then\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nif cfginfo.isreal then\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\noutput(indent, \"\\t<FileConfiguration\")\nattrib(indent, \"\\tName\", cfginfo.name)\noutput(indent, \"\\t\\t>\")\noutput(indent, \"\\t\\t<Tool\")\nattrib(indent, \"\\t\\tName\", iif(cfg.system == \"Xbox360\", \"VCCLX360CompilerTool\", \"VCCLCompilerTool\"))\nattrib(indent, \"\\t\\tUsePrecompiledHeader\", \"1\")\noutput(indent, \"\\t\\t/>\")\noutput(indent, \"\\t</FileConfiguration>\")\nend\nend\nend\nif (path.getextension(fname) == \".asm\") then\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nif cfginfo.isreal then\nif not (prj.solution.nasmformat) then\nprj.solution.nasmformat = 'win32'\nend\nif not (prj.solution.nasmpath) then\npr"
	"j.solution.nasmpath = 'nasm'\nend\nlocal nasmpath = path.translate(path.getrelative(prj.location, prj.solution.nasmpath), \"\\\\\")\nlocal command = nasmpath..\" -i \"..path.translate(path.getdirectory(fname), \"\\\\\")..\"\\\\ -f \"..prj.solution.nasmformat..\n\" &quot;$(InputPath)&quot; -o &quot;$(IntDir)\\\\$(InputName).obj&quot;\"\noutput(indent, \"\\t<FileConfiguration\")\nattrib(indent, \"\\tName\", cfginfo.name)\noutput(indent, \"\\t\\t>\")\noutput(indent, \"\\t\\t<Tool\")\nattrib(indent, \"\\t\\tName\", \"VCCustomBuildTool\")\nattrib(indent, \"\\t\\tDescription\", \"Assembling $(InputPath)\")\nattrib(indent, \"\\t\\tCommandLine\", command)\nattrib(indent, \"\\t\\tOutputs\", \"$(IntDir)\\\\$(InputName).obj\")\noutput(indent, \"\\t\\t/>\")\noutput(indent, \"\\t</FileConfiguration>\")\nend\nend\nend\noutput(indent, \"</File>\")\nend\nend\nfunction _VS.optimization(cfg)\nlocal result = 0\nfor _, value in ipairs(cfg.flags) do\nif (value == \"Optimize\") then\nresult = 3\nelseif (value == \"OptimizeSize\") t"
	"hen\nresult = 1\nelseif (value == \"OptimizeSpeed\") then\nresult = 2\nend\nend\nreturn result\nend\nfunction _VS.projectfile(prj)\nlocal extension\nif (prj.language == \"C#\") then\nextension = \".csproj\"\nelseif (_ACTION == \"vs2010\"  and prj.language == \"C++\" )then\nextension = \".vcxproj\"\nelseif (_ACTION == \"vs2010\"  and prj.language == \"C\" )then\nextension = \".vcxproj\"\nelse\nextension = \".vcproj\"\nend\nlocal fname = path.join(prj.location, prj.name)\nreturn fname..extension\nend\nfunction _VS.tool(prj)\nif (prj.language == \"C#\") then\nreturn \"FAE04EC0-301F-11D3-BF4B-00C04F79EFBC\"\nelse\nreturn \"8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942\"\nend\nend\nnewaction {\ntrigger         = \"vs2002\",\nshortname       = \"Visual Studio 2002\",\ndescription     = \"Generate Microsoft Visual Studio 2002 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\" },\nvalid_languages = { \"C\", \"C++\", \"C#\" },\nvalid_tools     = {"
	"\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", premake.vs2002_solution)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", premake.vs2002_csproj)\npremake.generate(prj, \"%%.csproj.user\", premake.vs2002_csproj_user)\nelse\npremake.generate(prj, \"%%.vcproj\", premake.vs200x_vcproj)\nend\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget\n}\nnewaction {\ntrigger         = \"vs2003\",\nshortname       = \"Visual Studio 2003\",\ndescription     = \"Generate Microsoft Visual Studio 2003 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\" },\nvalid_languages = { \"C\", \"C++\", \"C#\" },\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln"
	", \"%%.sln\", premake.vs2003_solution)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", premake.vs2002_csproj)\npremake.generate(prj, \"%%.csproj.user\", premake.vs2002_csproj_user)\nelse\npremake.generate(prj, \"%%.vcproj\", premake.vs200x_vcproj)\nend\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget\n}\nnewaction {\ntrigger         = \"vs2005\",\nshortname       = \"Visual Studio 2005\",\ndescription     = \"Generate Microsoft Visual Studio 2005 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\" },\nvalid_languages = { \"C\", \"C++\", \"C#\" },\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", premake.vs2005_solution)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj)"
	" then\npremake.generate(prj, \"%%.csproj\", premake.vs2005_csproj)\npremake.generate(prj, \"%%.csproj.user\", premake.vs2005_csproj_user)\nelse\npremake.generate(prj, \"%%.vcproj\", premake.vs200x_vcproj)\nend\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget\n}\nnewaction {\ntrigger         = \"vs2008\",\nshortname       = \"Visual Studio 2008\",\ndescription     = \"Generate Microsoft Visual Studio 2008 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\" },\nvalid_languages = { \"C\", \"C++\", \"C#\" },\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", premake.vs2005_solution)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", premake.vs2005_csproj)\npremake.generate(prj, \"%%.csproj.us"
	"er\", premake.vs2005_csproj_user)\nelse\npremake.generate(prj, \"%%.vcproj\", premake.vs200x_vcproj)\nend\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget\n}\nnewaction \n{\ntrigger         = \"vs2010\",\nshortname       = \"Visual Studio 2010\",\ndescription     = \"Generate Visual Studio 2010 project files (experimental)\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\" },\nvalid_languages = { \"C++\",\"C\"},\nvalid_tools     = {\ncc     = { \"msc\"   },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", premake.vs_generic_solution)\nend,\nonproject = function(prj)\npremake.generate(prj, \"%%.vcxproj\", premake.vs2010_vcxproj)\npremake.generate(prj, \"%%.vcxproj.user\", premake.vs2010_vcxproj_user)\npremake.generate(prj, \"%%.vcxproj.filters\", premake.vs2010_vcxproj_filters)\nend,\noncleansolution = premake.vstudio.cleansol"
	"ution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget\n}\n",

	/* actions/vstudio/vs2002_solution.lua */
	"function premake.vs2002_solution(sln)\nio.eol = '\\r\\n'\nsln.vstudio_configs = premake.vstudio_buildconfigs(sln)\n_p('Microsoft Visual Studio Solution File, Format Version 7.00')\nfor prj in premake.solution.eachproject(sln) do\nlocal projpath = path.translate(path.getrelative(sln.location, _VS.projectfile(prj)))\n_p('Project(\"{%s}\") = \"%s\", \"%s\", \"{%s}\"', _VS.tool(prj), prj.name, projpath, prj.uuid)\n_p('EndProject')\nend\n_p('Global')\n_p(1,'GlobalSection(SolutionConfiguration) = preSolution')\nfor i, cfgname in ipairs(sln.configurations) do\n_p(2,'ConfigName.%d = %s', i - 1, cfgname)\nend\n_p(1,'EndGlobalSection')\n_p(1,'GlobalSection(ProjectDependencies) = postSolution')\n_p(1,'EndGlobalSection')\n_p(1,'GlobalSection(ProjectConfiguration) = postSolution')\nfor prj in premake.solution.eachproject(sln) do\nfor _, cfgname in ipairs(sln.configurations) do\n_p(2,'{%s}.%s.ActiveCfg = %s|%s', prj.uuid, cfgname, cfgname, _VS.arch(prj))\n_p(2,'{%s}.%s.Build.0 = %s|%s', prj.uuid, cfgname, cfgname, _VS.arch("
	"prj))\nend\nend\n_p(1,'EndGlobalSection')\n_p(1,'GlobalSection(ExtensibilityGlobals) = postSolution')\n_p(1,'EndGlobalSection')\n_p(1,'GlobalSection(ExtensibilityAddIns) = postSolution')\n_p(1,'EndGlobalSection')\n_p('EndGlobal')\nend\n",

	/* actions/vstudio/vs2002_csproj.lua */
	"local function getelements(prj, action, fname)\nif action == \"Compile\" and fname:endswith(\".cs\") then\nreturn \"SubTypeCode\"\nend\nif action == \"EmbeddedResource\" and fname:endswith(\".resx\") then\nlocal basename = fname:sub(1, -6)\nlocal testname = path.getname(basename .. \".cs\")\nif premake.findfile(prj, testname) then\nreturn \"Dependency\", testname\nend\nend\nreturn \"None\"\nend\nfunction premake.vs2002_csproj(prj)\nio.eol = \"\\r\\n\"\n_p('<VisualStudioProject>')\n_p(1,'<CSHARP')\n_p(2,'ProjectType = \"Local\"')\n_p(2,'ProductVersion = \"%s\"', iif(_ACTION == \"vs2002\", \"7.0.9254\", \"7.10.3077\"))\n_p(2,'SchemaVersion = \"%s\"', iif(_ACTION == \"vs2002\", \"1.0\", \"2.0\"))\n_p(2,'ProjectGuid = \"{%s}\"', prj.uuid)\n_p(1,'>')\n_p(2,'<Build>')\n_p(3,'<Settings')\n_p(4,'ApplicationIcon = \"\"')\n_p(4,'AssemblyKeyContainerName = \"\"')\n_p(4,'AssemblyName = \"%s\"', prj.buildtarget.basename)\n_p(4,'AssemblyOriginatorKeyFile = \"\"')\n_p(4,'DefaultClientScript = \"JScript\"')\n_p(4,'DefaultHTML"
	"PageLayout = \"Grid\"')\n_p(4,'DefaultTargetSchema = \"IE50\"')\n_p(4,'DelaySign = \"false\"')\nif _ACTION == \"vs2002\" then\n_p(4,'NoStandardLibraries = \"false\"')\nend\n_p(4,'OutputType = \"%s\"', premake.dotnet.getkind(prj))\nif _ACTION == \"vs2003\" then\n_p(4,'PreBuildEvent = \"\"')\n_p(4,'PostBuildEvent = \"\"')\nend\n_p(4,'RootNamespace = \"%s\"', prj.buildtarget.basename)\nif _ACTION == \"vs2003\" then\n_p(4,'RunPostBuildEvent = \"OnBuildSuccess\"')\nend\n_p(4,'StartupObject = \"\"')\n_p(3,'>')\nfor cfg in premake.eachconfig(prj) do\n_p(4,'<Config')\n_p(5,'Name = \"%s\"', premake.esc(cfg.name))\n_p(5,'AllowUnsafeBlocks = \"%s\"', iif(cfg.flags.Unsafe, \"true\", \"false\"))\n_p(5,'BaseAddress = \"285212672\"')\n_p(5,'CheckForOverflowUnderflow = \"false\"')\n_p(5,'ConfigurationOverrideFile = \"\"')\n_p(5,'DefineConstants = \"%s\"', premake.esc(table.concat(cfg.defines, \";\")))\n_p(5,'DocumentationFile = \"\"')\n_p(5,'DebugSymbols = \"%s\"', iif(cfg.flags.Symbols, \"true\", \"false\"))\n_p(5,'FileAlign"
	"ment = \"4096\"')\n_p(5,'IncrementalBuild = \"false\"')\nif _ACTION == \"vs2003\" then\n_p(5,'NoStdLib = \"false\"')\n_p(5,'NoWarn = \"\"')\nend\n_p(5,'Optimize = \"%s\"', iif(cfg.flags.Optimize or cfg.flags.OptimizeSize or cfg.flags.OptimizeSpeed, \"true\", \"false\"))\n_p(5,'OutputPath = \"%s\"', premake.esc(cfg.buildtarget.directory))\n_p(5,'RegisterForComInterop = \"false\"')\n_p(5,'RemoveIntegerChecks = \"false\"')\n_p(5,'TreatWarningsAsErrors = \"%s\"', iif(cfg.flags.FatalWarnings, \"true\", \"false\"))\n_p(5,'WarningLevel = \"4\"')\n_p(4,'/>')\nend\n_p(3,'</Settings>')\n_p(3,'<References>')\nfor _, ref in ipairs(premake.getlinks(prj, \"siblings\", \"object\")) do\n_p(4,'<Reference')\n_p(5,'Name = \"%s\"', ref.buildtarget.basename)\n_p(5,'Project = \"{%s}\"', ref.uuid)\n_p(5,'Package = \"{%s}\"', _VS.tool(ref))\n_p(4,'/>')\nend\nfor _, linkname in ipairs(premake.getlinks(prj, \"system\", \"fullpath\")) do\n_p(4,'<Reference')\n_p(5,'Name = \"%s\"', path.getbasename(linkname))\n_p(5,'AssemblyName = \"%s\"'"
	", path.getname(linkname))\nif path.getdirectory(linkname) ~= \".\" then\n_p(5,'HintPath = \"%s\"', path.translate(linkname, \"\\\\\"))\nend\n_p(4,'/>')\nend\n_p(3,'</References>')\n_p(2,'</Build>')\n_p(2,'<Files>')\n_p(3,'<Include>')\nfor fcfg in premake.eachfile(prj) do\nlocal action = premake.dotnet.getbuildaction(fcfg)\nlocal fname  = path.translate(premake.esc(fcfg.name), \"\\\\\")\nlocal elements, dependency = getelements(prj, action, fcfg.name)\n_p(4,'<File')\n_p(5,'RelPath = \"%s\"', premake.esc(fname))\n_p(5,'BuildAction = \"%s\"', action)\nif dependency then\n_p(5,'DependentUpon = \"%s\"', premake.esc(path.translate(dependency, \"\\\\\")))\nend\nif elements == \"SubTypeCode\" then\n_p(5,'SubType = \"Code\"')\nend\n_p(4,'/>')\nend\n_p(3,'</Include>')\n_p(2,'</Files>')\n_p(1,'</CSHARP>')\n_p('</VisualStudioProject>')\nend\n",

	/* actions/vstudio/vs2002_csproj_user.lua */
	"function premake.vs2002_csproj_user(prj)\nio.eol = \"\\r\\n\"\n_p('<VisualStudioProject>')\n_p(1,'<CSHARP>')\n_p(2,'<Build>')\nlocal refpaths = table.translate(prj.libdirs, function(v) return path.getabsolute(prj.location .. \"/\" .. v) end)\n_p(3,'<Settings ReferencePath = \"%s\">', path.translate(table.concat(refpaths, \";\"), \"\\\\\"))\nfor cfg in premake.eachconfig(prj) do\n_p(4,'<Config')\n_p(5,'Name = \"%s\"', premake.esc(cfg.name))\n_p(5,'EnableASPDebugging = \"false\"')\n_p(5,'EnableASPXDebugging = \"false\"')\n_p(5,'EnableUnmanagedDebugging = \"false\"')\n_p(5,'EnableSQLServerDebugging = \"false\"')\n_p(5,'RemoteDebugEnabled = \"false\"')\n_p(5,'RemoteDebugMachine = \"\"')\n_p(5,'StartAction = \"Project\"')\n_p(5,'StartArguments = \"\"')\n_p(5,'StartPage = \"\"')\n_p(5,'StartProgram = \"\"')\n_p(5,'StartURL = \"\"')\n_p(5,'StartWorkingDirectory = \"\"')\n_p(5,'StartWithIE = \"false\"')\n_p(4,'/>')\nend\n_p(3,'</Settings>')\n_p(2,'</Build>')\n_p(2,'<OtherProjectSettings')\n_p(3,'CopyProjectDestination"
	"Folder = \"\"')\n_p(3,'CopyProjectUncPath = \"\"')\n_p(3,'CopyProjectOption = \"0\"')\n_p(3,'ProjectView = \"ProjectFiles\"')\n_p(3,'ProjectTrust = \"0\"')\n_p(2,'/>')\n_p(1,'</CSHARP>')\n_p('</VisualStudioProject>')\nend\n",

	/* actions/vstudio/vs200x_vcproj.lua */
	"premake.vstudio.vcproj = { }\nlocal vcproj = premake.vstudio.vcproj\nfunction vcproj.Configuration(name, cfg)\n_p(2,'<Configuration')\n_p(3,'Name=\"%s\"', premake.esc(name))\n_p(3,'OutputDirectory=\"%s\"', premake.esc(cfg.buildtarget.directory))\n_p(3,'IntermediateDirectory=\"%s\"', premake.esc(cfg.objectsdir))\n_p(3,'ConfigurationType=\"%s\"', _VS.cfgtype(cfg))\nif (cfg.flags.MFC) then\n_p(3, 'UseOfMFC=\"2\"')\nend  \n_p(3,'CharacterSet=\"%s\"', iif(cfg.flags.Unicode, 1, 2))\nif cfg.flags.Managed then\n_p(3,'ManagedExtensions=\"1\"')\nend\n_p(3,'>')\nend\nfunction premake.vs200x_vcproj_platforms(prj)\nlocal used = { }\n_p(1,'<Platforms>')\nfor _, cfg in ipairs(prj.solution.vstudio_configs) do\nif cfg.isreal and not table.contains(used, cfg.platform) then\ntable.insert(used, cfg.platform)\n_p(2,'<Platform')\n_p(3,'Name=\"%s\"', cfg.platform)\n_p(2,'/>')\nend\nend\n_p(1,'</Platforms>')\nend\nfunction premake.vs200x_vcproj_symbols(cfg)\nif (not cfg.flags.Symbols) then\nreturn 0\nelse\nif cfg.flags.NoEditAndConti"
	"nue or \n   _VS.optimization(cfg) ~= 0 or \n   cfg.flags.Managed or \n   cfg.platform == \"x64\" then\nreturn 3\nelse\nreturn 4\nend\nend\nend\nfunction premake.vs200x_vcproj_VCCLCompilerTool(cfg)\n_p(3,'<Tool')\n_p(4,'Name=\"%s\"', iif(cfg.platform ~= \"Xbox360\", \"VCCLCompilerTool\", \"VCCLX360CompilerTool\"))\nif #cfg.buildoptions > 0 then\n_p(4,'AdditionalOptions=\"%s\"', table.concat(premake.esc(cfg.buildoptions), \" \"))\nend\n_p(4,'Optimization=\"%s\"', _VS.optimization(cfg))\nif cfg.flags.NoFramePointer then\n_p(4,'OmitFramePointers=\"%s\"', _VS.bool(true))\nend\nif #cfg.includedirs > 0 then\n_p(4,'AdditionalIncludeDirectories=\"%s\"', premake.esc(path.translate(table.concat(cfg.includedirs, \";\"), '\\\\')))\nend\nif #cfg.defines > 0 then\n_p(4,'PreprocessorDefinitions=\"%s\"', premake.esc(table.concat(cfg.defines, \";\")))\nend\nif premake.config.isdebugbuild(cfg) and not cfg.flags.NoMinimalRebuild and not cfg.flags.Managed then\n_p(4,'MinimalRebuild=\"%s\"', _VS.bool(true))\nend\nif cfg.flags.NoExc"
	"eptions then\n_p(4,'ExceptionHandling=\"%s\"', iif(_ACTION < \"vs2005\", \"FALSE\", 0))\nelseif cfg.flags.SEH and _ACTION > \"vs2003\" then\n_p(4,'ExceptionHandling=\"2\"')\nend\nif _VS.optimization(cfg) == 0 and not cfg.flags.Managed then\n_p(4,'BasicRuntimeChecks=\"3\"')\nend\nif _VS.optimization(cfg) ~= 0 then\n_p(4,'StringPooling=\"%s\"', _VS.bool(true))\nend\nlocal runtime\nif premake.config.isdebugbuild(cfg) then\nruntime = iif(cfg.flags.StaticRuntime, 1, 3)\nelse\nruntime = iif(cfg.flags.StaticRuntime, 0, 2)\nend\n_p(4,'RuntimeLibrary=\"%s\"', runtime)\n_p(4,'EnableFunctionLevelLinking=\"%s\"', _VS.bool(true))\nif _ACTION > \"vs2003\" and cfg.platform ~= \"Xbox360\" and cfg.platform ~= \"x64\" then\nif cfg.flags.EnableSSE then\n_p(4,'EnableEnhancedInstructionSet=\"1\"')\nelseif cfg.flags.EnableSSE2 then\n_p(4,'EnableEnhancedInstructionSet=\"2\"')\nend\nend\nif _ACTION < \"vs2005\" then\nif cfg.flags.FloatFast then\n_p(4,'ImproveFloatingPointConsistency=\"%s\"', _VS.bool(false))\nelseif cfg.flags.FloatSt"
	"rict then\n_p(4,'ImproveFloatingPointConsistency=\"%s\"', _VS.bool(true))\nend\nelse\nif cfg.flags.FloatFast then\n_p(4,'FloatingPointModel=\"2\"')\nelseif cfg.flags.FloatStrict then\n_p(4,'FloatingPointModel=\"1\"')\nend\nend\nif _ACTION < \"vs2005\" and not cfg.flags.NoRTTI then\n_p(4,'RuntimeTypeInfo=\"%s\"', _VS.bool(true))\nelseif _ACTION > \"vs2003\" and cfg.flags.NoRTTI then\n_p(4,'RuntimeTypeInfo=\"%s\"', _VS.bool(false))\nend\nif cfg.flags.NativeWChar then\n_p(4,'TreatWChar_tAsBuiltInType=\"%s\"', _VS.bool(true))\nelseif cfg.flags.NoNativeWChar then\n_p(4,'TreatWChar_tAsBuiltInType=\"%s\"', _VS.bool(false))\nend\nif not cfg.flags.NoPCH and cfg.pchheader then\n_p(4,'UsePrecompiledHeader=\"%s\"', iif(_ACTION < \"vs2005\", 3, 2))\n_p(4,'PrecompiledHeaderThrough=\"%s\"', path.getname(cfg.pchheader))\nelse\n_p(4,'UsePrecompiledHeader=\"%s\"', iif(_ACTION > \"vs2003\" or cfg.flags.NoPCH, 0, 2))\nend\n_p(4,'WarningLevel=\"%s\"', iif(cfg.flags.ExtraWarnings, 4, 3))\nif cfg.flags.FatalWarnings then\n_p(4,'Warn"
	"AsError=\"%s\"', _VS.bool(true))\nend\nif _ACTION < \"vs2008\" and not cfg.flags.Managed then\n_p(4,'Detect64BitPortabilityProblems=\"%s\"', _VS.bool(not cfg.flags.No64BitChecks))\nend\n_p(4,'ProgramDataBaseFileName=\"$(OutDir)\\\\%s.pdb\"', path.getbasename(cfg.buildtarget.name))\n_p(4,'DebugInformationFormat=\"%s\"', premake.vs200x_vcproj_symbols(cfg))\nif cfg.language == \"C\" then\n_p(4, 'CompileAs=\"1\"')\nend\n_p(3,'/>')\nend\nfunction premake.vs200x_vcproj_VCLinkerTool(cfg)\n_p(3,'<Tool')\nif cfg.kind ~= \"StaticLib\" then\n_p(4,'Name=\"%s\"', iif(cfg.platform ~= \"Xbox360\", \"VCLinkerTool\", \"VCX360LinkerTool\"))\nif cfg.flags.NoImportLib then\n_p(4,'IgnoreImportLibrary=\"%s\"', _VS.bool(true))\nend\nif #cfg.linkoptions > 0 then\n_p(4,'AdditionalOptions=\"%s\"', table.concat(premake.esc(cfg.linkoptions), \" \"))\nend\nif #cfg.links > 0 then\n_p(4,'AdditionalDependencies=\"%s\"', table.concat(premake.getlinks(cfg, \"all\", \"fullpath\"), \" \"))\nend\n_p(4,'OutputFile=\"$(OutDir)\\\\%s\"', cfg.buildta"
	"rget.name)\n_p(4,'LinkIncremental=\"%s\"', iif(_VS.optimization(cfg) == 0, 2, 1))\n_p(4,'AdditionalLibraryDirectories=\"%s\"', table.concat(premake.esc(path.translate(cfg.libdirs, '\\\\')) , \";\"))\nlocal deffile = premake.findfile(cfg, \".def\")\nif deffile then\n_p(4,'ModuleDefinitionFile=\"%s\"', deffile)\nend\nif cfg.flags.NoManifest then\n_p(4,'GenerateManifest=\"%s\"', _VS.bool(false))\nend\n_p(4,'GenerateDebugInformation=\"%s\"', _VS.bool(premake.vs200x_vcproj_symbols(cfg) ~= 0))\nif premake.vs200x_vcproj_symbols(cfg) ~= 0 then\n_p(4,'ProgramDataBaseFileName=\"$(OutDir)\\\\%s.pdb\"', path.getbasename(cfg.buildtarget.name))\nend\n_p(4,'SubSystem=\"%s\"', iif(cfg.kind == \"ConsoleApp\", 1, 2))\nif _VS.optimization(cfg) ~= 0 then\n_p(4,'OptimizeReferences=\"2\"')\n_p(4,'EnableCOMDATFolding=\"2\"')\nend\nif (cfg.kind == \"ConsoleApp\" or cfg.kind == \"WindowedApp\") and not cfg.flags.WinMain then\n_p(4,'EntryPointSymbol=\"mainCRTStartup\"')\nend\nif cfg.kind == \"SharedLib\" then\nlocal implibname = cfg.li"
	"nktarget.fullpath\n_p(4,'ImportLibrary=\"%s\"', iif(cfg.flags.NoImportLib, cfg.objectsdir .. \"\\\\\" .. path.getname(implibname), implibname))\nend\n_p(4,'TargetMachine=\"%d\"', iif(cfg.platform == \"x64\", 17, 1))\nelse\n_p(4,'Name=\"VCLibrarianTool\"')\nif #cfg.links > 0 then\n_p(4,'AdditionalDependencies=\"%s\"', table.concat(premake.getlinks(cfg, \"all\", \"fullpath\"), \" \"))\nend\n_p(4,'OutputFile=\"$(OutDir)\\\\%s\"', cfg.buildtarget.name)\nif #cfg.libdirs > 0 then\n_p(4,'AdditionalLibraryDirectories=\"%s\"', premake.esc(path.translate(table.concat(cfg.libdirs , \";\"))))\nend\nif #cfg.linkoptions > 0 then\n_p(4,'AdditionalOptions=\"%s\"', table.concat(premake.esc(cfg.linkoptions), \" \"))\nend\nend\n_p(3,'/>')\nend\nfunction premake.vs200x_vcproj_VCCLCompilerTool_GCC(cfg)\n_p(3,'<Tool')\n_p(4,'Name=\"VCCLCompilerTool\"')\nlocal buildoptions = table.join(premake.gcc.getcflags(cfg), premake.gcc.getcxxflags(cfg), cfg.buildoptions)\nif #buildoptions > 0 then\n_p(4,'AdditionalOptions=\"%s\"', premake.esc("
	"table.concat(buildoptions, \" \")))\nend\nif #cfg.includedirs > 0 then\n_p(4,'AdditionalIncludeDirectories=\"%s\"', premake.esc(path.translate(table.concat(cfg.includedirs, \";\"), '\\\\')))\nend\nif #cfg.defines > 0 then\n_p(4,'PreprocessorDefinitions=\"%s\"', table.concat(premake.esc(cfg.defines), \";\"))\nend\n_p(4,'ProgramDataBaseFileName=\"$(OutDir)\\\\%s.pdb\"', path.getbasename(cfg.buildtarget.name))\n_p(4,'DebugInformationFormat=\"0\"')\n_p(4,'CompileAs=\"0\"')\n_p(3,'/>')\nend\nfunction premake.vs200x_vcproj_VCLinkerTool_GCC(cfg)\n_p(3,'<Tool')\nif cfg.kind ~= \"StaticLib\" then\n_p(4,'Name=\"VCLinkerTool\"')\nlocal buildoptions = table.join(premake.gcc.getldflags(cfg), cfg.linkoptions)\nif #buildoptions > 0 then\n_p(4,'AdditionalOptions=\"%s\"', premake.esc(table.concat(buildoptions, \" \")))\nend\nif #cfg.links > 0 then\n_p(4,'AdditionalDependencies=\"%s\"', table.concat(premake.getlinks(cfg, \"all\", \"fullpath\"), \" \"))\nend\n_p(4,'OutputFile=\"$(OutDir)\\\\%s\"', cfg.buildtarget.name)\n_p(4,'Li"
	"nkIncremental=\"0\"')\n_p(4,'AdditionalLibraryDirectories=\"%s\"', table.concat(premake.esc(path.translate(cfg.libdirs, '\\\\')) , \";\"))\n_p(4,'GenerateManifest=\"%s\"', _VS.bool(false))\n_p(4,'ProgramDatabaseFile=\"\"')\n_p(4,'RandomizedBaseAddress=\"1\"')\n_p(4,'DataExecutionPrevention=\"0\"')\nelse\n_p(4,'Name=\"VCLibrarianTool\"')\nlocal buildoptions = table.join(premake.gcc.getldflags(cfg), cfg.linkoptions)\nif #buildoptions > 0 then\n_p(4,'AdditionalOptions=\"%s\"', premake.esc(table.concat(buildoptions, \" \")))\nend\nif #cfg.links > 0 then\n_p(4,'AdditionalDependencies=\"%s\"', table.concat(premake.getlinks(cfg, \"all\", \"fullpath\"), \" \"))\nend\n_p(4,'OutputFile=\"$(OutDir)\\\\%s\"', cfg.buildtarget.name)\nif #cfg.libdirs > 0 then\n_p(4,'AdditionalLibraryDirectories=\"%s\"', premake.esc(path.translate(table.concat(cfg.libdirs , \";\"))))\nend\nend\n_p(3,'/>')\nend\nfunction premake.vs200x_vcproj_VCResourceCompilerTool(cfg)\n_p(3,'<Tool')\n_p(4,'Name=\"VCResourceCompilerTool\"')\nif #cfg.resoption"
	"s > 0 then\n_p(4,'AdditionalOptions=\"%s\"', table.concat(premake.esc(cfg.resoptions), \" \"))\nend\nif #cfg.defines > 0 or #cfg.resdefines > 0 then\n_p(4,'PreprocessorDefinitions=\"%s\"', table.concat(premake.esc(table.join(cfg.defines, cfg.resdefines)), \";\"))\nend\nif #cfg.includedirs > 0 or #cfg.resincludedirs > 0 then\nlocal dirs = table.join(cfg.includedirs, cfg.resincludedirs)\n_p(4,'AdditionalIncludeDirectories=\"%s\"', premake.esc(path.translate(table.concat(dirs, \";\"), '\\\\')))\nend\n_p(3,'/>')\nend\nfunction premake.vs200x_vcproj_VCManifestTool(cfg)\nlocal manifests = { }\nfor _, fname in ipairs(cfg.files) do\nif path.getextension(fname) == \".manifest\" then\ntable.insert(manifests, fname)\nend\nend\n_p(3,'<Tool')\n_p(4,'Name=\"VCManifestTool\"')\nif #manifests > 0 then\n_p(4,'AdditionalManifestFiles=\"%s\"', premake.esc(table.concat(manifests, \";\")))\nend\n_p(3,'/>')\nend\nfunction premake.vs200x_vcproj_VCMIDLTool(cfg)\n_p(3,'<Tool')\n_p(4,'Name=\"VCMIDLTool\"')\nif cfg.platform == \"x64\" t"
	"hen\n_p(4,'TargetEnvironment=\"3\"')\nend\n_p(3,'/>')\nend\nfunction premake.vs200x_vcproj_buildstepsblock(name, steps)\n_p(3,'<Tool')\n_p(4,'Name=\"%s\"', name)\nif #steps > 0 then\n_p(4,'CommandLine=\"%s\"', premake.esc(table.implode(steps, \"\", \"\", \"\\r\\n\")))\nend\n_p(3,'/>')\nend\nlocal blockmap = \n{\nVCCLCompilerTool       = premake.vs200x_vcproj_VCCLCompilerTool,\nVCCLCompilerTool_GCC   = premake.vs200x_vcproj_VCCLCompilerTool_GCC,\nVCLinkerTool           = premake.vs200x_vcproj_VCLinkerTool,\nVCLinkerTool_GCC       = premake.vs200x_vcproj_VCLinkerTool_GCC,\nVCManifestTool         = premake.vs200x_vcproj_VCManifestTool,\nVCMIDLTool             = premake.vs200x_vcproj_VCMIDLTool,\nVCResourceCompilerTool = premake.vs200x_vcproj_VCResourceCompilerTool,\n}\nlocal function getsections(version, platform)\nif version == \"vs2002\" then\nreturn {\n\"VCCLCompilerTool\",\n\"VCCustomBuildTool\",\n\"VCLinkerTool\",\n\"VCMIDLTool\",\n\"VCPostBuildEventTool\",\n\"VCPreBuildEventTool\",\n\"VCPreLinkEventTool\","
	"\n\"VCResourceCompilerTool\",\n\"VCWebServiceProxyGeneratorTool\",\n\"VCWebDeploymentTool\"\n}\nend\nif version == \"vs2003\" then\nreturn {\n\"VCCLCompilerTool\",\n\"VCCustomBuildTool\",\n\"VCLinkerTool\",\n\"VCMIDLTool\",\n\"VCPostBuildEventTool\",\n\"VCPreBuildEventTool\",\n\"VCPreLinkEventTool\",\n\"VCResourceCompilerTool\",\n\"VCWebServiceProxyGeneratorTool\",\n\"VCXMLDataGeneratorTool\",\n\"VCWebDeploymentTool\",\n\"VCManagedWrapperGeneratorTool\",\n\"VCAuxiliaryManagedWrapperGeneratorTool\"\n}\nend\nif platform == \"Xbox360\" then\nreturn {\n\"VCPreBuildEventTool\",\n\"VCCustomBuildTool\",\n\"VCXMLDataGeneratorTool\",\n\"VCWebServiceProxyGeneratorTool\",\n\"VCMIDLTool\",\n\"VCCLCompilerTool\",\n\"VCManagedResourceCompilerTool\",\n\"VCResourceCompilerTool\",\n\"VCPreLinkEventTool\",\n\"VCLinkerTool\",\n\"VCALinkTool\",\n\"VCX360ImageTool\",\n\"VCBscMakeTool\",\n\"VCX360DeploymentTool\",\n\"VCPostBuildEventTool\",\n\"DebuggerTool\",\n}\nend\nif platform == \"PS3\" then\nreturn {\n\"VCPreBuildEventTool\","
	"\n\"VCCustomBuildTool\",\n\"VCXMLDataGeneratorTool\",\n\"VCWebServiceProxyGeneratorTool\",\n\"VCMIDLTool\",\n\"VCCLCompilerTool_GCC\",\n\"VCManagedResourceCompilerTool\",\n\"VCResourceCompilerTool\",\n\"VCPreLinkEventTool\",\n\"VCLinkerTool_GCC\",\n\"VCALinkTool\",\n\"VCManifestTool\",\n\"VCXDCMakeTool\",\n\"VCBscMakeTool\",\n\"VCFxCopTool\",\n\"VCAppVerifierTool\",\n\"VCWebDeploymentTool\",\n\"VCPostBuildEventTool\"\n}\nelse\nreturn {\n\"VCPreBuildEventTool\",\n\"VCCustomBuildTool\",\n\"VCXMLDataGeneratorTool\",\n\"VCWebServiceProxyGeneratorTool\",\n\"VCMIDLTool\",\n\"VCCLCompilerTool\",\n\"VCManagedResourceCompilerTool\",\n\"VCResourceCompilerTool\",\n\"VCPreLinkEventTool\",\n\"VCLinkerTool\",\n\"VCALinkTool\",\n\"VCManifestTool\",\n\"VCXDCMakeTool\",\n\"VCBscMakeTool\",\n\"VCFxCopTool\",\n\"VCAppVerifierTool\",\n\"VCWebDeploymentTool\",\n\"VCPostBuildEventTool\"\n}\nend\nend\nfunction premake.vs200x_vcproj(prj)\nio.eol = \"\\r\\n\"\n_p('<?xml version=\"1.0\" encoding=\"Windows-1252\"?>')\n_p('<VisualStudioP"
	"roject')\n_p(1,'ProjectType=\"Visual C++\"')\nif _ACTION == \"vs2002\" then\n_p(1,'Version=\"7.00\"')\nelseif _ACTION == \"vs2003\" then\n_p(1,'Version=\"7.10\"')\nelseif _ACTION == \"vs2005\" then\n_p(1,'Version=\"8.00\"')\nelseif _ACTION == \"vs2008\" then\n_p(1,'Version=\"9.00\"')\nend\n_p(1,'Name=\"%s\"', premake.esc(prj.name))\n_p(1,'ProjectGUID=\"{%s}\"', prj.uuid)\nif _ACTION > \"vs2003\" then\n_p(1,'RootNamespace=\"%s\"', prj.name)\nend\n_p(1,'Keyword=\"%s\"', iif(prj.flags.Managed, \"ManagedCProj\", \"Win32Proj\"))\n_p(1,'>')\npremake.vs200x_vcproj_platforms(prj)\nif _ACTION > \"vs2003\" then\n_p(1,'<ToolFiles>')\n_p(1,'</ToolFiles>')\nend\n_p(1,'<Configurations>')\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nif cfginfo.isreal then\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\nvcproj.Configuration(cfginfo.name, cfg)\nfor _, block in ipairs(getsections(_ACTION, cfginfo.src_platform)) do\nif blockmap[block] then\nblockmap[block](cfg)\nelseif block == \"V"
	"CPreBuildEventTool\" then\npremake.vs200x_vcproj_buildstepsblock(\"VCPreBuildEventTool\", cfg.prebuildcommands)\nelseif block == \"VCPreLinkEventTool\" then\npremake.vs200x_vcproj_buildstepsblock(\"VCPreLinkEventTool\", cfg.prelinkcommands)\nelseif block == \"VCPostBuildEventTool\" then\npremake.vs200x_vcproj_buildstepsblock(\"VCPostBuildEventTool\", cfg.postbuildcommands)\nelseif block == \"VCX360DeploymentTool\" then\n_p(3,'<Tool')\n_p(4,'Name=\"VCX360DeploymentTool\"')\n_p(4,'DeploymentType=\"0\"')\nif #cfg.deploymentoptions > 0 then\n_p(4,'AdditionalOptions=\"%s\"', table.concat(premake.esc(cfg.deploymentoptions), \" \"))\nend\n_p(3,'/>')\nelseif block == \"VCX360ImageTool\" then\n_p(3,'<Tool')\n_p(4,'Name=\"VCX360ImageTool\"')\nif #cfg.imageoptions > 0 then\n_p(4,'AdditionalOptions=\"%s\"', table.concat(premake.esc(cfg.imageoptions), \" \"))\nend\nif cfg.imagepath ~= nil then\n_p(4,'OutputFileName=\"%s\"', premake.esc(path.translate(cfg.imagepath)))\nend\n_p(3,'/>')\nelseif block == \"DebuggerTool\" then"
	"\n_p(3,'<DebuggerTool')\n_p(3,'/>')\nelse\n_p(3,'<Tool')\n_p(4,'Name=\"%s\"', block)\n_p(3,'/>')\nend\nend\n_p(2,'</Configuration>')\nend\nend\n_p(1,'</Configurations>')\n_p(1,'<References>')\n_p(1,'</References>')\n_p(1,'<Files>')\npremake.walksources(prj, _VS.files)\n_p(1,'</Files>')\n_p(1,'<Globals>')\n_p(1,'</Globals>')\n_p('</VisualStudioProject>')\nend\n",

	/* actions/vstudio/vs2003_solution.lua */
	"function premake.vs2003_solution(sln)\nio.eol = '\\r\\n'\nsln.vstudio_configs = premake.vstudio_buildconfigs(sln)\n_p('Microsoft Visual Studio Solution File, Format Version 8.00')\nfor prj in premake.solution.eachproject(sln) do\nlocal projpath = path.translate(path.getrelative(sln.location, _VS.projectfile(prj)))\n_p('Project(\"{%s}\") = \"%s\", \"%s\", \"{%s}\"', _VS.tool(prj), prj.name, projpath, prj.uuid)\nlocal deps = premake.getdependencies(prj)\nif #deps > 0 then\n_p('\\tProjectSection(ProjectDependencies) = postProject')\nfor _, dep in ipairs(deps) do\n_p('\\t\\t{%s} = {%s}', dep.uuid, dep.uuid)\nend\n_p('\\tEndProjectSection')\nend\n_p('EndProject')\nend\n_p('Global')\n_p('\\tGlobalSection(SolutionConfiguration) = preSolution')\nfor _, cfgname in ipairs(sln.configurations) do\n_p('\\t\\t%s = %s', cfgname, cfgname)\nend\n_p('\\tEndGlobalSection')\n_p('\\tGlobalSection(ProjectDependencies) = postSolution')\n_p('\\tEndGlobalSection')\n_p('\\tGlobalSection(ProjectConfiguration) = postSolution')\nfor prj i"
	"n premake.solution.eachproject(sln) do\nfor _, cfgname in ipairs(sln.configurations) do\n_p('\\t\\t{%s}.%s.ActiveCfg = %s|%s', prj.uuid, cfgname, cfgname, _VS.arch(prj))\n_p('\\t\\t{%s}.%s.Build.0 = %s|%s', prj.uuid, cfgname, cfgname, _VS.arch(prj))\nend\nend\n_p('\\tEndGlobalSection')\n_p('\\tGlobalSection(ExtensibilityGlobals) = postSolution')\n_p('\\tEndGlobalSection')\n_p('\\tGlobalSection(ExtensibilityAddIns) = postSolution')\n_p('\\tEndGlobalSection')\n_p('EndGlobal')\nend\n",

	/* actions/vstudio/vs2005_solution.lua */
	"function premake.vs2005_solution(sln)\nio.eol = '\\r\\n'\nsln.vstudio_configs = premake.vstudio_buildconfigs(sln)\n_p('\\239\\187\\191')\n_p('Microsoft Visual Studio Solution File, Format Version %s', iif(_ACTION == 'vs2005', '9.00', '10.00'))\n_p('# Visual Studio %s', iif(_ACTION == 'vs2005', '2005', '2008'))\nfor prj in premake.solution.eachproject(sln) do\nlocal projpath = path.translate(path.getrelative(sln.location, _VS.projectfile(prj)), \"\\\\\")\n_p('Project(\"{%s}\") = \"%s\", \"%s\", \"{%s}\"', _VS.tool(prj), prj.name, projpath, prj.uuid)\nlocal deps = premake.getdependencies(prj)\nif #deps > 0 then\n_p('\\tProjectSection(ProjectDependencies) = postProject')\nfor _, dep in ipairs(deps) do\n_p('\\t\\t{%s} = {%s}', dep.uuid, dep.uuid)\nend\n_p('\\tEndProjectSection')\nend\n_p('EndProject')\nend\n_p('Global')\npremake.vs2005_solution_platforms(sln)\npremake.vs2005_solution_project_platforms(sln)\npremake.vs2005_solution_properties(sln)\n_p('EndGlobal')\nend\nfunction premake.vs2005_solution_platforms(sl"
	"n)\n_p('\\tGlobalSection(SolutionConfigurationPlatforms) = preSolution')\nfor _, cfg in ipairs(sln.vstudio_configs) do\n_p('\\t\\t%s = %s', cfg.name, cfg.name)\nend\n_p('\\tEndGlobalSection')\nend\nfunction premake.vs2005_solution_project_platforms(sln)\n_p('\\tGlobalSection(ProjectConfigurationPlatforms) = postSolution')\nfor prj in premake.solution.eachproject(sln) do\nfor _, cfg in ipairs(sln.vstudio_configs) do\nlocal mapped\nif premake.isdotnetproject(prj) then\nmapped = \"Any CPU\"\nelse\nif cfg.platform == \"Any CPU\" or cfg.platform == \"Mixed Platforms\" then\nmapped = sln.vstudio_configs[3].platform\nelse\nmapped = cfg.platform\nend\nend\n_p('\\t\\t{%s}.%s.ActiveCfg = %s|%s', prj.uuid, cfg.name, cfg.buildcfg, mapped)\nif mapped == cfg.platform or cfg.platform == \"Mixed Platforms\" then\n_p('\\t\\t{%s}.%s.Build.0 = %s|%s',  prj.uuid, cfg.name, cfg.buildcfg, mapped)\nend\nend\nend\n_p('\\tEndGlobalSection')\nend\nfunction premake.vs2005_solution_properties(sln)\n_p('\\tGlobalSection(SolutionProperties"
	") = preSolution')\n_p('\\t\\tHideSolutionNode = FALSE')\n_p('\\tEndGlobalSection')\nend\n",

	/* actions/vstudio/vs2005_csproj.lua */
	"premake.vstudio.cs2005 = { }\nlocal vstudio = premake.vstudio\nlocal cs2005  = premake.vstudio.cs2005\nlocal function getelements(prj, action, fname)\nif action == \"Compile\" and fname:endswith(\".cs\") then\nif fname:endswith(\".Designer.cs\") then\nlocal basename = fname:sub(1, -13)\nlocal testname = basename .. \".cs\"\nif premake.findfile(prj, testname) then\nreturn \"Dependency\", testname\nend\ntestname = basename .. \".resx\"\nif premake.findfile(prj, testname) then\nreturn \"AutoGen\", testname\nend\nelse\nlocal basename = fname:sub(1, -4)\nlocal testname = basename .. \".Designer.cs\"\nif premake.findfile(prj, testname) then\nreturn \"SubTypeForm\"\nend\nend\nend\nif action == \"EmbeddedResource\" and fname:endswith(\".resx\") then\nlocal basename = fname:sub(1, -6)\nlocal testname = path.getname(basename .. \".cs\")\nif premake.findfile(prj, testname) then\nif premake.findfile(prj, basename .. \".Designer.cs\") then\nreturn \"DesignerType\", testname\nelse\nreturn \"Dependency\", testname\nend\nelse"
	"\ntestname = path.getname(basename .. \".Designer.cs\")\nif premake.findfile(prj, testname) then\nreturn \"AutoGenerated\"\nend\nend\nend\nif action == \"Content\" then\nreturn \"CopyNewest\"\nend\nreturn \"None\"\nend\nfunction cs2005.projectelement(prj)\n_p('<Project DefaultTargets=\"Build\" xmlns=\"http://schemas.microsoft.com/developer/msbuild/2003\"%s>', iif(_ACTION == 'vs2005', '', ' ToolsVersion=\"3.5\"'))\nend\nfunction cs2005.projectsettings(prj)\n_p('  <PropertyGroup>')\n_p('    <Configuration Condition=\" \\'$(Configuration)\\' == \\'\\' \">%s</Configuration>', premake.esc(prj.solution.configurations[1]))\n_p('    <Platform Condition=\" \\'$(Platform)\\' == \\'\\' \">AnyCPU</Platform>')\n_p('    <ProductVersion>%s</ProductVersion>', iif(_ACTION == \"vs2005\", \"8.0.50727\", \"9.0.21022\"))\n_p('    <SchemaVersion>2.0</SchemaVersion>')\n_p('    <ProjectGuid>{%s}</ProjectGuid>', prj.uuid)\n_p('    <OutputType>%s</OutputType>', premake.dotnet.getkind(prj))\n_p('    <AppDesignerFolder>Properties</AppDes"
	"ignerFolder>')\n_p('    <RootNamespace>%s</RootNamespace>', prj.buildtarget.basename)\n_p('    <AssemblyName>%s</AssemblyName>', prj.buildtarget.basename)\nif prj.framework then\n_p('    <TargetFrameworkVersion>v%s</TargetFrameworkVersion>', prj.framework)\nend\n_p('  </PropertyGroup>')\nend\nfunction premake.vs2005_csproj(prj)\nio.eol = \"\\r\\n\"\nlocal vsversion, toolversion\nif _ACTION == \"vs2005\" then\nvsversion   = \"8.0.50727\"\ntoolversion = nil\nelseif _ACTION == \"vs2008\" then\nvsversion   = \"9.0.21022\"\ntoolversion = \"3.5\"\nend\nif toolversion then\n_p('<Project DefaultTargets=\"Build\" xmlns=\"http://schemas.microsoft.com/developer/msbuild/2003\" ToolsVersion=\"%s\">', toolversion)\nelse\n_p('<Project DefaultTargets=\"Build\" xmlns=\"http://schemas.microsoft.com/developer/msbuild/2003\">')\nend\n_p('  <PropertyGroup>')\n_p('    <Configuration Condition=\" \\'$(Configuration)\\' == \\'\\' \">%s</Configuration>', premake.esc(prj.solution.configurations[1]))\n_p('    <Platform Condition=\" \\'$"
	"(Platform)\\' == \\'\\' \">AnyCPU</Platform>')\n_p('    <ProductVersion>%s</ProductVersion>', vsversion)\n_p('    <SchemaVersion>2.0</SchemaVersion>')\n_p('    <ProjectGuid>{%s}</ProjectGuid>', prj.uuid)\n_p('    <OutputType>%s</OutputType>', premake.dotnet.getkind(prj))\n_p('    <AppDesignerFolder>Properties</AppDesignerFolder>')\n_p('    <RootNamespace>%s</RootNamespace>', prj.buildtarget.basename)\n_p('    <AssemblyName>%s</AssemblyName>', prj.buildtarget.basename)\n_p('  </PropertyGroup>')\nfor cfg in premake.eachconfig(prj) do\n_p('  <PropertyGroup Condition=\" \\'$(Configuration)|$(Platform)\\' == \\'%s|AnyCPU\\' \">', premake.esc(cfg.name))\nif cfg.flags.Symbols then\n_p('    <DebugSymbols>true</DebugSymbols>')\n_p('    <DebugType>full</DebugType>')\nelse\n_p('    <DebugType>pdbonly</DebugType>')\nend\n_p('    <Optimize>%s</Optimize>', iif(cfg.flags.Optimize or cfg.flags.OptimizeSize or cfg.flags.OptimizeSpeed, \"true\", \"false\"))\n_p('    <OutputPath>%s</OutputPath>', cfg.buildtarget.directory)\n_p('"
	"    <DefineConstants>%s</DefineConstants>', table.concat(premake.esc(cfg.defines), \";\"))\n_p('    <ErrorReport>prompt</ErrorReport>')\n_p('    <WarningLevel>4</WarningLevel>')\nif cfg.flags.Unsafe then\n_p('    <AllowUnsafeBlocks>true</AllowUnsafeBlocks>')\nend\nif cfg.flags.FatalWarnings then\n_p('    <TreatWarningsAsErrors>true</TreatWarningsAsErrors>')\nend\n_p('  </PropertyGroup>')\nend\n_p('  <ItemGroup>')\nfor _, ref in ipairs(premake.getlinks(prj, \"siblings\", \"object\")) do\n_p('    <ProjectReference Include=\"%s\">', path.translate(path.getrelative(prj.location, _VS.projectfile(ref)), \"\\\\\"))\n_p('      <Project>{%s}</Project>', ref.uuid)\n_p('      <Name>%s</Name>', premake.esc(ref.name))\n_p('    </ProjectReference>')\nend\nfor _, linkname in ipairs(premake.getlinks(prj, \"system\", \"basename\")) do\n_p('    <Reference Include=\"%s\" />', premake.esc(linkname))\nend\n_p('  </ItemGroup>')\n_p('  <ItemGroup>')\nfor fcfg in premake.eachfile(prj) do\nlocal action = premake.dotnet.getbuildaction("
	"fcfg)\nlocal fname  = path.translate(premake.esc(fcfg.name), \"\\\\\")\nlocal elements, dependency = getelements(prj, action, fcfg.name)\nif elements == \"None\" then\n_p('    <%s Include=\"%s\" />', action, fname)\nelse\n_p('    <%s Include=\"%s\">', action, fname)\nif elements == \"AutoGen\" then\n_p('      <AutoGen>True</AutoGen>')\nelseif elements == \"AutoGenerated\" then\n_p('      <SubType>Designer</SubType>')\n_p('      <Generator>ResXFileCodeGenerator</Generator>')\n_p('      <LastGenOutput>%s.Designer.cs</LastGenOutput>', premake.esc(path.getbasename(fcfg.name)))\nelseif elements == \"SubTypeDesigner\" then\n_p('      <SubType>Designer</SubType>')\nelseif elements == \"SubTypeForm\" then\n_p('      <SubType>Form</SubType>')\nelseif elements == \"PreserveNewest\" then\n_p('      <CopyToOutputDirectory>PreserveNewest</CopyToOutputDirectory>')\nend\nif dependency then\n_p('      <DependentUpon>%s</DependentUpon>', path.translate(premake.esc(dependency), \"\\\\\"))\nend\n_p('    </%s>', action)\nend\nend"
	"\n_p('  </ItemGroup>')\n_p('  <Import Project=\"$(MSBuildBinPath)\\\\Microsoft.CSharp.targets\" />')\n_p('  <!-- To modify your build process, add your task inside one of the targets below and uncomment it.')\n_p('       Other similar extension points exist, see Microsoft.Common.targets.')\n_p('  <Target Name=\"BeforeBuild\">')\n_p('  </Target>')\n_p('  <Target Name=\"AfterBuild\">')\n_p('  </Target>')\n_p('  -->')\n_p('</Project>')\nend\n",

	/* actions/vstudio/vs2005_csproj_user.lua */
	"function premake.vs2005_csproj_user(prj)\nio.eol = \"\\r\\n\"\n_p('<Project xmlns=\"http://schemas.microsoft.com/developer/msbuild/2003\">')\n_p('  <PropertyGroup>')\nlocal refpaths = table.translate(prj.libdirs, function(v) return path.getabsolute(prj.location .. \"/\" .. v) end)\n_p('    <ReferencePath>%s</ReferencePath>', path.translate(table.concat(refpaths, \";\"), \"\\\\\"))\n_p('  </PropertyGroup>')\n_p('</Project>')\nend\n",

	/* actions/vstudio/vs_generic_solution.lua */
	"\nlocal vs_format_version = function()\nlocal t =\n{\nvs2005 = '9.00',\n    vs2008 = '10.00',\n    vs2010 = '11.00'\n}\nreturn t[_ACTION]\nend\nlocal vs_version = function()\nlocal t =\n{\nvs2005 = '2005',\n    vs2008 = '2008',\n    vs2010 = '2010'\n}\nreturn t[_ACTION]\nend\nlocal vs_write_version_info = function()\n_p('Microsoft Visual Studio Solution File, Format Version %s', vs_format_version())\n_p('# Visual Studio %s', vs_version() )\nend\nlocal vs_write_projects = function(sln)\nfor prj in premake.solution.eachproject(sln) do\nlocal projpath = path.translate(path.getrelative(sln.location, _VS.projectfile(prj)), \"\\\\\")\n_p('Project(\"{%s}\") = \"%s\", \"%s\", \"{%s}\"', _VS.tool(prj), prj.name, projpath, prj.uuid)\nlocal deps = premake.getdependencies(prj)\nif #deps > 0 then\n_p('\\tProjectSection(ProjectDependencies) = postProject')\nfor _, dep in ipairs(deps) do\n_p('\\t\\t{%s} = {%s}', dep.uuid, dep.uuid)\nend\n_p('\\tEndProjectSection')\nend\n_p('EndProject')\nend\nend\nlocal vs_write_pre_version "
	"= function(sln)\nio.eol = '\\r\\n'\nsln.vstudio_configs = premake.vstudio_buildconfigs(sln)\n_p('\\239\\187\\191')\nend\nfunction premake.vs_generic_solution(sln)\nvs_write_pre_version(sln)\nvs_write_version_info()\nvs_write_projects(sln)\n_p('Global')\npremake.vs2005_solution_platforms(sln)\npremake.vs2005_solution_project_platforms(sln)\npremake.vs2005_solution_properties(sln)\n_p('EndGlobal')\nend",

	/* actions/vstudio/vs2010_vcxproxj.lua */
	"\npremake.vstudio.vs10_helpers = { }\nlocal vs10_helpers = premake.vstudio.vs10_helpers\nfunction vs10_helpers.remove_relative_path(file)\nfile = file:gsub(\"%.%./\",'')\nfile = file:gsub(\"%./\",'')\nfile = file:gsub(\"^source/\",'')\nreturn file\nend\nfunction vs10_helpers.file_path(file)\nfile = vs10_helpers.remove_relative_path(file)\nlocal path = string.find(file,'/[%w%.%_%-]+$')\nif path then\nreturn string.sub(file,1,path-1)\nelse\nreturn nil\nend\nend\nfunction vs10_helpers.list_of_directories_in_path(path)\nlocal list={}\npath = vs10_helpers.remove_relative_path(path)\nif path then\nfor dir in string.gmatch(path,\"[%w%-%_%.]+/\")do\nif #list == 0 then\nlist[1] = dir:sub(1,#dir-1)\nelse\nlist[#list +1] = list[#list] ..\"/\" ..dir:sub(1,#dir-1)\nend\nend\nend\nreturn list\nend\nfunction vs10_helpers.table_of_file_filters(files)\nlocal filters ={}\nfor _, valueTable in pairs(files) do\nfor _, entry in ipairs(valueTable) do\nlocal result = vs10_helpers.list_of_directories_in_path(entry)\nfor __,dir in ipa"
	"irs(result) do\nif table.contains(filters,dir) ~= true then\nfilters[#filters +1] = dir\nend\nend\nend\nend\nreturn filters\nend\nfunction vs10_helpers.get_file_extension(file)\nlocal ext_start,ext_end = string.find(file,\"%.[%w_%-]+$\")\nif ext_start then\nreturn  string.sub(file,ext_start+1,ext_end)\nend\nend\nfunction vs10_helpers.sort_input_files(files,sorted_container)\nlocal types = \n{\nh= \"ClInclude\",\nhpp= \"ClInclude\",\nhxx= \"ClInclude\",\nc= \"ClCompile\",\ncpp= \"ClCompile\",\ncxx= \"ClCompile\",\ncc= \"ClCompile\",\nrc  = \"ResourceCompile\",\nasm = \"ClASM\"\n}\nfor _, current_file in ipairs(files) do\nlocal ext = vs10_helpers.get_file_extension(current_file)\nif ext then\nlocal type = types[ext]\nif type then\ntable.insert(sorted_container[type],current_file)\nelse\ntable.insert(sorted_container.None,current_file)\nend\nend\nend\nend\nlocal function vs2010_config(prj)\n_p(1,'<ItemGroup Label=\"ProjectConfigurations\">')\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\n_p(2,'<Proje"
	"ctConfiguration Include=\"%s\">', premake.esc(cfginfo.name))\n_p(3,'<Configuration>%s</Configuration>',cfginfo.buildcfg)\n_p(3,'<Platform>%s</Platform>',cfginfo.platform)\n_p(2,'</ProjectConfiguration>')\nend\n_p(1,'</ItemGroup>')\nend\nlocal function vs2010_globals(prj)\n_p(1,'<PropertyGroup Label=\"Globals\">')\n_p(2,'<ProjectGuid>{%s}</ProjectGuid>',prj.uuid)\n_p(2,'<RootNamespace>%s</RootNamespace>',prj.name)\n_p(2,'<Keyword>Win32Proj</Keyword>')\n_p(1,'</PropertyGroup>')\nend\nfunction vs10_helpers.config_type(config)\nlocal t =\n{\nSharedLib = \"DynamicLibrary\",\nStaticLib = \"StaticLibrary\",\nConsoleApp = \"Application\",\nWindowedApp = \"Application\"\n}\nreturn t[config.kind]\nend\nlocal function if_config_and_platform()\nreturn 'Condition=\"\\'$(Configuration)|$(Platform)\\'==\\'%s\\'\"'\nend\nlocal function optimisation(cfg)\nlocal result = \"Disabled\"\nfor _, value in ipairs(cfg.flags) do\nif (value == \"Optimize\") then\nresult = \"Full\"\nelseif (value == \"OptimizeSize\") then\nresult = \"Min"
	"Space\"\nelseif (value == \"OptimizeSpeed\") then\nresult = \"MaxSpeed\"\nend\nend\nreturn result\nend\nlocal function config_type_block(prj)\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\n_p(1,'<PropertyGroup '..if_config_and_platform() ..' Label=\"Configuration\">'\n, premake.esc(cfginfo.name))\n_p(2,'<ConfigurationType>%s</ConfigurationType>',vs10_helpers.config_type(cfg))\n_p(2,'<CharacterSet>%s</CharacterSet>',iif(cfg.flags.Unicode,\"Unicode\",\"MultiByte\"))\nif cfg.flags.MFC then\n_p(2,'<UseOfMfc>Dynamic</UseOfMfc>')\nend\n_p(2,'<UseDebugLibraries>%s</UseDebugLibraries>'\n,iif(optimisation(cfg) == \"Disabled\",\"true\",\"false\"))\n_p(1,'</PropertyGroup>')\nend\nend\nlocal function import_props(prj)\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\n_p(1,'<ImportGroup '..if_config_and_platform() ..' Label=\"PropertySheets\">"
	"'\n,premake.esc(cfginfo.name))\n_p(2,'<Import Project=\"$(UserRootDir)\\\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists(\\'$(UserRootDir)\\\\Microsoft.Cpp.$(Platform).user.props\\')\" Label=\"LocalAppDataPlatform\" />')\n_p(1,'</ImportGroup>')\nend\nend\nlocal function incremental_link(cfg,cfginfo)\nif cfg.kind ~= \"StaticLib\" then\nShoudLinkIncrementally = 'false'\nif optimisation(cfg) == \"Disabled\" then\nShoudLinkIncrementally = 'true'\nend\n_p(2,'<LinkIncremental '..if_config_and_platform() ..'>%s</LinkIncremental>'\n,premake.esc(cfginfo.name),ShoudLinkIncrementally)\nend\nend\nlocal function ignore_import_lib(cfg,cfginfo)\nif cfg.kind == \"SharedLib\" then\nlocal shouldIgnore = \"false\"\nif cfg.flags.NoImportLib then shouldIgnore = \"true\" end\n _p(2,'<IgnoreImportLibrary '..if_config_and_platform() ..'>%s</IgnoreImportLibrary>'\n,premake.esc(cfginfo.name),shouldIgnore)\nend\nend\nlocal function intermediate_and_out_dirs(prj)\n_p(1,'<PropertyGroup>')\n_p(2,'<_ProjectFileVersion>10.0.30319."
	"1</_ProjectFileVersion>')\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\n_p(2,'<OutDir '..if_config_and_platform() ..'>%s\\\\</OutDir>'\n, premake.esc(cfginfo.name),premake.esc(cfg.buildtarget.directory) )\n_p(2,'<IntDir '..if_config_and_platform() ..'>%s\\\\</IntDir>'\n, premake.esc(cfginfo.name), premake.esc(cfg.objectsdir))\n_p(2,'<TargetName '..if_config_and_platform() ..'>%s</TargetName>'\n,premake.esc(cfginfo.name),path.getbasename(cfg.buildtarget.name))\nignore_import_lib(cfg,cfginfo)\nincremental_link(cfg,cfginfo)\nif cfg.flags.NoManifest then\n_p(2,'<GenerateManifest '..if_config_and_platform() ..'>false</GenerateManifest>'\n,premake.esc(cfginfo.name))\nend\nend\n_p(1,'</PropertyGroup>')\nend\nlocal function runtime(cfg)\nlocal runtime\nif premake.config.isdebugbuild(cfg) then\nruntime = iif(cfg.flags.StaticRuntime,\"MultiThreadedDebug\", \"MultiThreadedDebugDLL\")\nelse\nruntime = iif(cfg.flags.StaticRuntime,"
	" \"MultiThreaded\", \"MultiThreadedDLL\")\nend\nreturn runtime\nend\nlocal function precompiled_header(cfg)\n      if not cfg.flags.NoPCH and cfg.pchheader then\n_p(3,'<PrecompiledHeader>Use</PrecompiledHeader>')\n_p(3,'<PrecompiledHeaderFile>%s</PrecompiledHeaderFile>', path.getname(cfg.pchheader))\nelse\n_p(3,'<PrecompiledHeader></PrecompiledHeader>')\nend\nend\nlocal function preprocessor(indent,cfg)\nif #cfg.defines > 0 then\n_p(indent,'<PreprocessorDefinitions>%s;%%(PreprocessorDefinitions)</PreprocessorDefinitions>'\n,premake.esc(table.concat(cfg.defines, \";\")))\nelse\n_p(indent,'<PreprocessorDefinitions></PreprocessorDefinitions>')\nend\nend\nlocal function include_dirs(indent,cfg)\nif #cfg.includedirs > 0 then\n_p(indent,'<AdditionalIncludeDirectories>%s;%%(AdditionalIncludeDirectories)</AdditionalIncludeDirectories>'\n,premake.esc(path.translate(table.concat(cfg.includedirs, \";\"), '\\\\')))\nend\nend\nlocal function resource_compile(cfg)\n_p(2,'<ResourceCompile>')\npreprocessor(3,cfg)\ninclude_dir"
	"s(3,cfg)\n_p(2,'</ResourceCompile>')\nend\nlocal function exceptions(cfg)\nif cfg.flags.NoExceptions then\n_p(2,'<ExceptionHandling>false</ExceptionHandling>')\nelseif cfg.flags.SEH then\n_p(2,'<ExceptionHandling>Async</ExceptionHandling>')\nend\nend\nlocal function rtti(cfg)\nif cfg.flags.NoRTTI then\n_p(3,'<RuntimeTypeInfo>false</RuntimeTypeInfo>')\nend\nend\nlocal function wchar_t_buildin(cfg)\nif cfg.flags.NativeWChar then\n_p(3,'<TreatWChar_tAsBuiltInType>true</TreatWChar_tAsBuiltInType>')\nelseif cfg.flags.NoNativeWChar then\n_p(3,'<TreatWChar_tAsBuiltInType>false</TreatWChar_tAsBuiltInType>')\nend\nend\nlocal function sse(cfg)\nif cfg.flags.EnableSSE then\n_p(3,'<EnableEnhancedInstructionSet>StreamingSIMDExtensions</EnableEnhancedInstructionSet>')\nelseif cfg.flags.EnableSSE2 then\n_p(3,'<EnableEnhancedInstructionSet>StreamingSIMDExtensions2</EnableEnhancedInstructionSet>')\nend\nend\nlocal function floating_point(cfg)\n     if cfg.flags.FloatFast then\n_p(3,'<FloatingPointModel>Fast</FloatingPointModel"
	">')\nelseif cfg.flags.FloatStrict then\n_p(3,'<FloatingPointModel>Strict</FloatingPointModel>')\nend\nend\nlocal function debug_info(cfg)\nlocal debug_info = ''\nif cfg.flags.Symbols then\nif optimisation(cfg) ~= \"Disabled\" or cfg.flags.NoEditAndContinue then\ndebug_info = \"ProgramDatabase\"\nelseif cfg.platform ~= \"x64\" then\ndebug_info = \"EditAndContinue\"\nelse\ndebug_info = \"OldStyle\"\nend\nend\n_p(3,'<DebugInformationFormat>%s</DebugInformationFormat>',debug_info)\nend\nlocal function minimal_build(cfg)\nif premake.config.isdebugbuild(cfg) and not cfg.flags.NoMinimalRebuild then\n_p(3,'<MinimalRebuild>true</MinimalRebuild>')\nelse\n_p(3,'<MinimalRebuild>false</MinimalRebuild>')\nend\nend\nlocal function compile_language(cfg)\nif cfg.language == \"C\" then\n_p(3,'<CompileAs>CompileAsC</CompileAs>')\nend\nend\nlocal function vs10_clcompile(cfg)\n_p(2,'<ClCompile>')\nif #cfg.buildoptions > 0 then\n_p(3,'<AdditionalOptions>%s %%(AdditionalOptions)</AdditionalOptions>',\ntable.concat(premake.esc(cfg.bu"
	"ildoptions), \" \"))\nend\n_p(3,'<Optimization>%s</Optimization>',optimisation(cfg))\ninclude_dirs(3,cfg)\npreprocessor(3,cfg)\nminimal_build(cfg)\nif optimisation(cfg) == \"Disabled\" then\n_p(3,'<BasicRuntimeChecks>EnableFastChecks</BasicRuntimeChecks>')\nif cfg.flags.ExtraWarnings then\n_p(3,'<SmallerTypeCheck>true</SmallerTypeCheck>')\nend\nelse\n_p(3,'<StringPooling>true</StringPooling>')\nend\n_p(3,'<RuntimeLibrary>%s</RuntimeLibrary>', runtime(cfg))\n_p(3,'<FunctionLevelLinking>true</FunctionLevelLinking>')\nprecompiled_header(cfg)\nif cfg.flags.ExtraWarnings then\n_p(3,'<WarningLevel>Level4</WarningLevel>')\nelse\n_p(3,'<WarningLevel>Level3</WarningLevel>')\nend\nif cfg.flags.FatalWarnings then\n_p(3,'<TreatWarningAsError>true</TreatWarningAsError>')\nend\nexceptions(cfg)\nrtti(cfg)\nwchar_t_buildin(cfg)\nsse(cfg)\nfloating_point(cfg)\ndebug_info(cfg)\nif cfg.flags.NoFramePointer then\n_p(3,'<OmitFramePointers>true</OmitFramePointers>')\nend\ncompile_language(cfg)\n_p(2,'</ClCompile>')\nend\nlocal func"
	"tion event_hooks(cfg, prj)\nif #cfg.postbuildcommands> 0 then\n    _p(2,'<PostBuildEvent>')\n_p(3,'<Command>%s</Command>',premake.esc(table.implode(cfg.postbuildcommands, \"\", \"\", \"\\r\\n\")))\n_p(2,'</PostBuildEvent>')\nend\nif #cfg.prebuildcommands> 0 or prj.cxxtestrootfile then\n    _p(2,'<PreBuildEvent>')\n_p(3,'<Command>%s</Command>',premake.esc(table.implode(cfg.prebuildcommands, \"\", \"\", \"\\r\\n\")))\nif(prj.solution.cxxtestpath and prj.cxxtestrootfile and prj.cxxtesthdrfiles and prj.cxxtestsrcfiles) then\nlocal cxxtestpath = path.translate(path.getrelative(prj.location, prj.solution.cxxtestpath),\"\\\\\")\nlocal cxxtestrootfile = path.translate(prj.cxxtestrootfile,\"\\\\\")\n_p(3,'<Command>%s --root %s &gt; %s</Command>', cxxtestpath, prj.cxxtestrootoptions, cxxtestrootfile)\nend\n_p(2,'</PreBuildEvent>')\nend\nif #cfg.prelinkcommands> 0 then\n    _p(2,'<PreLinkEvent>')\n_p(3,'<Command>%s</Command>',premake.esc(table.implode(cfg.prelinkcommands, \"\", \"\", \"\\r\\n\")))\n_p(2,'</PreLinkEvent>'"
	")\nend\nend\nlocal function additional_options(indent,cfg)\nif #cfg.linkoptions > 0 then\n_p(indent,'<AdditionalOptions>%s %%(AdditionalOptions)</AdditionalOptions>',\ntable.concat(premake.esc(cfg.linkoptions), \" \"))\nend\nend\nlocal function item_def_lib(cfg)\nif cfg.kind == 'StaticLib' then\n_p(1,'<Lib>')\n_p(2,'<OutputFile>$(OutDir)%s</OutputFile>',cfg.buildtarget.name)\nadditional_options(2,cfg)\n_p(1,'</Lib>')\nend\nend\nlocal function link_target_machine(cfg)\nlocal target\nif cfg.platform == nil or cfg.platform == \"x32\" then target =\"MachineX86\"\nelseif cfg.platform == \"x64\" then target =\"MachineX64\"\nend\n_p(3,'<TargetMachine>%s</TargetMachine>', target)\nend\nlocal function import_lib(cfg)\nif cfg.kind == \"SharedLib\" then\nlocal implibname = cfg.linktarget.fullpath\n_p(3,'<ImportLibrary>%s</ImportLibrary>',iif(cfg.flags.NoImportLib, cfg.objectsdir .. \"\\\\\" .. path.getname(implibname), implibname))\nend\nend\nlocal function common_link_section(cfg)\n_p(3,'<SubSystem>%s</SubSystem>',iif(c"
	"fg.kind == \"ConsoleApp\",\"Console\", \"Windows\"))\nif cfg.flags.Symbols then \n_p(3,'<GenerateDebugInformation>true</GenerateDebugInformation>')\nelse\n_p(3,'<GenerateDebugInformation>false</GenerateDebugInformation>')\nend\nif optimisation(cfg) ~= \"Disabled\" then\n_p(3,'<OptimizeReferences>true</OptimizeReferences>')\n_p(3,'<EnableCOMDATFolding>true</EnableCOMDATFolding>')\nend\nif cfg.flags.Symbols then\n_p(3,'<ProgramDataBaseFileName>$(OutDir)%s.pdb</ProgramDataBaseFileName>'\n, path.getbasename(cfg.buildtarget.name))\nend\nend\nlocal function item_link(cfg)\n_p(2,'<Link>')\nif cfg.kind ~= 'StaticLib' then\nif #cfg.links > 0 then\n_p(3,'<AdditionalDependencies>%s;%%(AdditionalDependencies)</AdditionalDependencies>',\ntable.concat(premake.getlinks(cfg, \"all\", \"fullpath\"), \";\"))\nend\n_p(3,'<OutputFile>$(OutDir)%s</OutputFile>', cfg.buildtarget.name)\n_p(3,'<AdditionalLibraryDirectories>%s%s%%(AdditionalLibraryDirectories)</AdditionalLibraryDirectories>',\ntable.concat(premake.esc(path.translate(cf"
	"g.libdirs, '\\\\')) , \";\"),\niif(cfg.libdirs and #cfg.libdirs >0,';',''))\ncommon_link_section(cfg)\nif vs10_helpers.config_type(cfg) == 'Application' and not cfg.flags.WinMain then\n_p(3,'<EntryPointSymbol>mainCRTStartup</EntryPointSymbol>')\nend\nimport_lib(cfg)\n_p(3,'<TargetMachine>%s</TargetMachine>', iif(cfg.platform == \"x64\", \"MachineX64\", \"MachineX86\"))\nadditional_options(3,cfg)\nelse\ncommon_link_section(cfg)\nend\n_p(2,'</Link>')\nend\nlocal function item_definitions(prj)\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\n_p(1,'<ItemDefinitionGroup ' ..if_config_and_platform() ..'>'\n,premake.esc(cfginfo.name))\nvs10_clcompile(cfg)\nresource_compile(cfg)\nitem_def_lib(cfg)\nitem_link(cfg)\nevent_hooks(cfg, prj)\n_p(1,'</ItemDefinitionGroup>')\nend\nend\n  --     <ProjectReference Include=\"zlibvc.vcxproj\">\n  --       <Project>{8fd826f8-3739-44e6-8cc8-997122e53b8d}</Project>\n  --     </ProjectReference"
	">\n  --   </ItemGroup>\nlocal function write_cxxtestgen_block(prj)\nif(prj.solution.cxxtestpath and prj.cxxtestrootfile and prj.cxxtesthdrfiles and prj.cxxtestsrcfiles) then\nlocal cxxtestpath = path.translate(path.getrelative(prj.location, prj.solution.cxxtestpath),\"\\\\\")\n_p(1,'<ItemGroup>')\nfor i, file in ipairs(prj.cxxtesthdrfiles) do\nlocal cxxtesthdrfile = path.translate(file,\"\\\\\")\nlocal cxxtestsrcfile = path.translate(prj.cxxtestsrcfiles[i],\"\\\\\")\n_p(2,'<CustomBuild Include=\\\"%s\\\">', cxxtesthdrfile)\n      _p(3,'<Message>Generating %s</Message>', path.getname(prj.cxxtestsrcfiles[i]))\n      _p(3,'<Command>%s --part %s -o \\\"%s\\\" \\\"%s\\\"</Command>', \ncxxtestpath, prj.cxxtestoptions, cxxtestsrcfile, cxxtesthdrfile)\n      _p(3,'<Outputs>%s;%%(Outputs)</Outputs>', cxxtestsrcfile)\n_p(2,'</CustomBuild>')\nend\n_p(1,'</ItemGroup>')\nend\nend\nlocal function write_file_type_block(files,group_type)\nif #files > 0  then\n_p(1,'<ItemGroup>')\nfor _, current_file in ipairs(files) do\n_p(2,"
	"'<%s Include=\\\"%s\\\" />', group_type,path.translate(current_file,\"\\\\\"))\nend\n_p(1,'</ItemGroup>')\nend\nend\nlocal function write_file_compile_block(files,prj,configs)\nif #files > 0  then\nlocal config_mappings = {}\nfor _, cfginfo in ipairs(configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\nif cfg.pchheader and cfg.pchsource and not cfg.flags.NoPCH then\nconfig_mappings[cfginfo] = cfg.pchsource\nend\nend\n_p(1,'<ItemGroup>')\nfor _, current_file in ipairs(files) do\n_p(2,'<ClCompile Include=\\\"%s\\\">', path.translate(current_file, \"\\\\\"))\nfor _, cfginfo in ipairs(configs) do\nif config_mappings[cfginfo] and current_file == config_mappings[cfginfo] then \n_p(3,'<PrecompiledHeader '.. if_config_and_platform() .. '>Create</PrecompiledHeader>'\n,premake.esc(cfginfo.name))\nconfig_mappings[cfginfo] = nil\nend\nend\n_p(2,'</ClCompile>')\nend\n_p(1,'</ItemGroup>')\nend\nend\nlocal function write_nasm_asm_block(files, prj, configs)\nif not (prj.solution.nasmfor"
	"mat) then\nprj.solution.nasmformat = 'win32'\nend\nif not (prj.solution.nasmpath) then\nprj.solution.nasmpath = 'nasm'\nend\nif #files > 0 then\n_p(1,'<ItemGroup>')\nlocal nasmpath = path.translate(path.getrelative(prj.location, prj.solution.nasmpath),\"\\\\\")\nfor _, current_file in ipairs(files) do\n_p(2,'<CustomBuild Include=\\\"%s\\\">', path.translate(current_file,\"\\\\\"))\n_p(3,'<Message>Assembling %%(FullPath)</Message>')\n_p(3,'<Command>%s -i %s -f %s \\\"%%(FullPath)\\\" -o \\\"$(IntDir)%%(Filename).obj\\\"</Command>', \nnasmpath, \npath.translate(path.getdirectory(current_file),\"\\\\\")..\"\\\\\", \nprj.solution.nasmformat)\n_p(3,'<Outputs>$(IntDir)%%(Filename).obj;%%(Outputs)</Outputs>')\n_p(2,'</CustomBuild>')\nend\n_p(1,'</ItemGroup>')\nend\nend\nlocal function vcxproj_files(prj)\nlocal sorted =\n{\nClCompile={},\nClInclude={},\nClASM={},\nNone={},\nResourceCompile ={}\n}\ncfg = premake.getconfig(prj)\nvs10_helpers.sort_input_files(cfg.files,sorted)\nwrite_cxxtestgen_block(prj)\nwrite_file_typ"
	"e_block(sorted.ClInclude,\"ClInclude\")\nwrite_file_compile_block(sorted.ClCompile,prj,prj.solution.vstudio_configs)\nwrite_nasm_asm_block(sorted.ClASM, prj, prj.solution.vstudion_configs)\nwrite_file_type_block(sorted.None,'None')\nwrite_file_type_block(sorted.ResourceCompile,'ResourceCompile')\nend\nlocal function write_filter_includes(sorted_table)\nlocal directories = vs10_helpers.table_of_file_filters(sorted_table)\nif #directories >0 then\n_p(1,'<ItemGroup>')\nfor _, dir in pairs(directories) do\n_p(2,'<Filter Include=\"%s\">',path.translate(dir,\"\\\\\"))\n_p(3,'<UniqueIdentifier>{%s}</UniqueIdentifier>',os.uuid())\n_p(2,'</Filter>')\nend\n_p(1,'</ItemGroup>')\nend\nend\nlocal function write_file_filter_block(files,group_type)\nif #files > 0  then\n_p(1,'<ItemGroup>')\nfor _, current_file in ipairs(files) do\nlocal path_to_file = vs10_helpers.file_path(current_file)\nif path_to_file then\n_p(2,'<%s Include=\\\"%s\\\">', group_type,path.translate(current_file, \"\\\\\"))\n_p(3,'<Filter>%s</Filter>',path."
	"translate(path_to_file,\"\\\\\"))\n_p(2,'</%s>',group_type)\nelse\n_p(2,'<%s Include=\\\"%s\\\" />', group_type,path.translate(current_file, \"\\\\\"))\nend\nend\n_p(1,'</ItemGroup>')\nend\nend\nlocal tool_version_and_xmlns = 'ToolsVersion=\"4.0\" xmlns=\"http://schemas.microsoft.com/developer/msbuild/2003\"'\nlocal xml_version_and_encoding = '<?xml version=\"1.0\" encoding=\"utf-8\"?>'\nlocal function vcxproj_filter_files(prj)\nlocal sorted =\n{\nClCompile={},\nClInclude={},\nClASM={},\nNone={},\nResourceCompile ={}\n}\ncfg = premake.getconfig(prj)\nvs10_helpers.sort_input_files(cfg.files,sorted)\nio.eol = \"\\r\\n\"\n_p(xml_version_and_encoding)\n_p('<Project ' ..tool_version_and_xmlns ..'>')\nwrite_filter_includes(sorted)\nwrite_file_filter_block(sorted.ClInclude,\"ClInclude\")\nwrite_file_filter_block(sorted.ClCompile,\"ClCompile\")\nwrite_file_filter_block(prj.cxxtesthdrfiles,\"CustomBuild\")\nwrite_file_filter_block(sorted.ClASM,\"ClASM\")\nwrite_file_filter_block(sorted.None,\"None\")\nwrite_file_filter"
	"_block(sorted.ResourceCompile,\"ResourceCompile\")\n_p('</Project>')\nend\nfunction premake.vs2010_vcxproj(prj)\nio.eol = \"\\r\\n\"\n_p(xml_version_and_encoding)\n_p('<Project DefaultTargets=\"Build\" ' ..tool_version_and_xmlns ..'>')\nvs2010_config(prj)\nvs2010_globals(prj)\n_p(1,'<Import Project=\"$(VCTargetsPath)\\\\Microsoft.Cpp.Default.props\" />')\nconfig_type_block(prj)\n_p(1,'<Import Project=\"$(VCTargetsPath)\\\\Microsoft.Cpp.props\" />')\n_p(1,'<ImportGroup Label=\"ExtensionSettings\">')\n_p(1,'</ImportGroup>')\nimport_props(prj)\n_p(1,'<PropertyGroup Label=\"UserMacros\" />')\nintermediate_and_out_dirs(prj)\nitem_definitions(prj)\nvcxproj_files(prj)\n_p(1,'<Import Project=\"$(VCTargetsPath)\\\\Microsoft.Cpp.targets\" />')\n_p(1,'<ImportGroup Label=\"ExtensionTargets\">')\n_p(1,'</ImportGroup>')\n_p('</Project>')\nend\nfunction premake.vs2010_vcxproj_user(prj)\n_p(xml_version_and_encoding)\n_p('<Project ' ..tool_version_and_xmlns ..'>')\n_p('</Project>')\nend\nfunction premake.vs2010_vcxproj_filters"
	"(prj)\nvcxproj_filter_files(prj)\nend\n",

	/* actions/xcode/_xcode.lua */
	"premake.xcode = { }\nnewaction \n{\ntrigger         = \"xcode3\",\nshortname       = \"Xcode 3\",\ndescription     = \"Generate Apple Xcode 3 project files (experimental)\",\nos              = \"macosx\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"SharedLib\", \"StaticLib\" },\nvalid_languages = { \"C\", \"C++\" },\nvalid_tools     = {\ncc     = { \"gcc\" },\n},\nvalid_platforms = { \nNative = \"Native\", \nx32 = \"Native 32-bit\", \nx64 = \"Native 64-bit\", \nUniversal32 = \"32-bit Universal\", \nUniversal64 = \"64-bit Universal\", \nUniversal = \"Universal\",\n},\ndefault_platform = \"Universal\",\nonsolution = function(sln)\npremake.xcode.preparesolution(sln)\nend,\nonproject = function(prj)\npremake.generate(prj, \"%%.xcodeproj/project.pbxproj\", premake.xcode.project)\nend,\noncleanproject = function(prj)\npremake.clean.directory(prj, \"%%.xcodeproj\")\nend,\noncheckproject = function(prj)\nlocal last\nfor cfg in premake.eachconfig(prj) do\nif last and last ~= cfg.kind then\nerror(\"Project '"
	"\" .. prj.name .. \"' uses more than one target kind; not supported by Xcode\", 0)\nend\nlast = cfg.kind\nend\nend,\n}\nnewaction \n{\ntrigger         = \"xcode4\",\nshortname       = \"Xcode 4\",\ndescription     = \"Generate Apple Xcode 4 project files (experimental)\",\nos              = \"macosx\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"SharedLib\", \"StaticLib\" },\nvalid_languages = { \"C\", \"C++\" },\nvalid_tools     = {\ncc     = { \"gcc\" },\n},\nvalid_platforms = { \nNative = \"Native\", \nx32 = \"Native 32-bit\", \nx64 = \"Native 64-bit\", \nUniversal32 = \"32-bit Universal\", \nUniversal64 = \"64-bit Universal\", \nUniversal = \"Universal\",\n},\ndefault_platform = \"Universal\",\nonsolution = function(sln)\npremake.generate(sln, \"%%.xcworkspace/contents.xcworkspacedata\", premake.xcode4.workspace_generate)\nend,\nonproject = function(prj)\npremake.generate(prj, \"%%.xcodeproj/project.pbxproj\", premake.xcode.project)\nend,\noncleanproject = function(prj)\npremake.clean.directory"
	"(prj, \"%%.xcodeproj\")\npremake.clean.directory(prj, \"%%.xcworkspace\")\nend,\noncheckproject = function(prj)\nlocal last\nfor cfg in premake.eachconfig(prj) do\nif last and last ~= cfg.kind then\nerror(\"Project '\" .. prj.name .. \"' uses more than one target kind; not supported by Xcode\", 0)\nend\nlast = cfg.kind\nend\nend,\n}\n",

	/* actions/xcode/xcode_common.lua */
	"local xcode = premake.xcode\nlocal tree  = premake.tree\nfunction xcode.getbuildcategory(node)\nlocal categories = {\n[\".a\"] = \"Frameworks\",\n[\".c\"] = \"Sources\",\n[\".cc\"] = \"Sources\",\n[\".cpp\"] = \"Sources\",\n[\".cxx\"] = \"Sources\",\n[\".dylib\"] = \"Frameworks\",\n[\".framework\"] = \"Frameworks\",\n[\".m\"] = \"Sources\",\n[\".mm\"] = \"Sources\",\n[\".strings\"] = \"Resources\",\n[\".nib\"] = \"Resources\",\n[\".xib\"] = \"Resources\",\n[\".icns\"] = \"Resources\",\n}\nreturn categories[path.getextension(node.name)]\nend\nfunction xcode.getconfigname(cfg)\nlocal name = cfg.name\nif #cfg.project.solution.xcode.platforms > 1 then\nname = name .. \" \" .. premake.action.current().valid_platforms[cfg.platform]\nend\nreturn name\nend\nfunction xcode.getfiletype(node)\nlocal types = {\n[\".c\"]         = \"sourcecode.c.c\",\n[\".cc\"]        = \"sourcecode.cpp.cpp\",\n[\".cpp\"]       = \"sourcecode.cpp.cpp\",\n[\".css\"]       = \"text.css\",\n[\".cxx\"]       = \"sourcecode.cpp.cpp\",\n[\".fram"
	"ework\"] = \"wrapper.framework\",\n[\".gif\"]       = \"image.gif\",\n[\".h\"]         = \"sourcecode.c.h\",\n[\".html\"]      = \"text.html\",\n[\".lua\"]       = \"sourcecode.lua\",\n[\".m\"]         = \"sourcecode.c.objc\",\n[\".mm\"]        = \"sourcecode.cpp.objc\",\n[\".nib\"]       = \"wrapper.nib\",\n[\".pch\"]       = \"sourcecode.c.h\",\n[\".plist\"]     = \"text.plist.xml\",\n[\".strings\"]   = \"text.plist.strings\",\n[\".xib\"]       = \"file.xib\",\n[\".icns\"]      = \"image.icns\",\n}\nreturn types[path.getextension(node.path)] or \"text\"\nend\nfunction xcode.getproducttype(node)\nlocal types = {\nConsoleApp  = \"com.apple.product-type.tool\",\nWindowedApp = \"com.apple.product-type.application\",\nStaticLib   = \"com.apple.product-type.library.static\",\nSharedLib   = \"com.apple.product-type.library.dynamic\",\n}\nreturn types[node.cfg.kind]\nend\nfunction xcode.gettargettype(node)\nlocal types = {\nConsoleApp  = \"\\\"compiled.mach-o.executable\\\"\",\nWindowedApp = \"wrapper.application\","
	"\nStaticLib   = \"archive.ar\",\nSharedLib   = \"\\\"compiled.mach-o.dylib\\\"\",\n}\nreturn types[node.cfg.kind]\nend\nfunction xcode.getxcodeprojname(prj)\nlocal fname = premake.project.getfilename(prj, \"%%.xcodeproj\")\nreturn fname\nend\nfunction xcode.isframework(fname)\nreturn (path.getextension(fname) == \".framework\")\nend\nfunction xcode.newid()\nreturn string.format(\"%04X%04X%04X%04X%04X%04X\",\nmath.random(0, 32767),\nmath.random(0, 32767),\nmath.random(0, 32767),\nmath.random(0, 32767),\nmath.random(0, 32767),\nmath.random(0, 32767))\nend\nfunction xcode.preparesolution(sln)\nsln.xcode = { }\nsln.xcode.platforms = premake.filterplatforms(sln, premake.action.current().valid_platforms, \"Universal\")\nfor prj in premake.solution.eachproject(sln) do\nlocal cfg = premake.getconfig(prj, prj.configurations[1], sln.xcode.platforms[1])\nlocal node = premake.tree.new(path.getname(cfg.buildtarget.bundlepath))\nnode.cfg = cfg\nnode.id = premake.xcode.newid(node, \"product\")\nnode.targetid = premake.xcode."
	"newid(node, \"target\")\nprj.xcode = {}\nprj.xcode.projectnode = node\nend\nend\nfunction xcode.printlist(list, tag)\nif #list > 0 then\n_p(4,'%s = (', tag)\nfor _, item in ipairs(list) do\n_p(5, '\"%s\",', item)\nend\n_p(4,');')\nend\nend\nfunction xcode.Header()\n_p('// !$*UTF8*$!')\n_p('{')\n_p(1,'archiveVersion = 1;')\n_p(1,'classes = {')\n_p(1,'};')\n_p(1,'objectVersion = 45;')\n_p(1,'objects = {')\n_p('')\nend\nfunction xcode.PBXBuildFile(tr)\n_p('/* Begin PBXBuildFile section */')\ntree.traverse(tr, {\nonnode = function(node)\nif node.buildid then\n_p(2,'%s /* %s in %s */ = {isa = PBXBuildFile; fileRef = %s /* %s */; };', \nnode.buildid, node.name, xcode.getbuildcategory(node), node.id, node.name)\nend\nend\n})\n_p('/* End PBXBuildFile section */')\n_p('')\nend\nfunction xcode.PBXContainerItemProxy(tr)\nif #tr.projects.children > 0 then\n_p('/* Begin PBXContainerItemProxy section */')\nfor _, node in ipairs(tr.projects.children) do\n_p(2,'%s /* PBXContainerItemProxy */ = {', node.productproxyid)\n_p(3,'"
	"isa = PBXContainerItemProxy;')\n_p(3,'containerPortal = %s /* %s */;', node.id, path.getname(node.path))\n_p(3,'proxyType = 2;')\n_p(3,'remoteGlobalIDString = %s;', node.project.xcode.projectnode.id)\n_p(3,'remoteInfo = \"%s\";', node.project.xcode.projectnode.name)\n_p(2,'};')\n_p(2,'%s /* PBXContainerItemProxy */ = {', node.targetproxyid)\n_p(3,'isa = PBXContainerItemProxy;')\n_p(3,'containerPortal = %s /* %s */;', node.id, path.getname(node.path))\n_p(3,'proxyType = 1;')\n_p(3,'remoteGlobalIDString = %s;', node.project.xcode.projectnode.targetid)\n_p(3,'remoteInfo = \"%s\";', node.project.xcode.projectnode.name)\n_p(2,'};')\nend\n_p('/* End PBXContainerItemProxy section */')\n_p('')\nend\nend\nfunction xcode.PBXFileReference(tr)\n_p('/* Begin PBXFileReference section */')\ntree.traverse(tr, {\nonleaf = function(node)\nif not node.path then\nreturn\nend\nif node.kind == \"product\" then\n_p(2,'%s /* %s */ = {isa = PBXFileReference; explicitFileType = %s; includeInIndex = 0; name = \"%s\"; path = \"%s\"; sour"
	"ceTree = BUILT_PRODUCTS_DIR; };',\nnode.id, node.name, xcode.gettargettype(node), node.name, path.getname(node.cfg.buildtarget.bundlepath))\nelseif node.parent.parent == tr.projects then\nlocal relpath = path.getrelative(tr.project.location, node.parent.project.location)\n_p(2,'%s /* %s */ = {isa = PBXFileReference; lastKnownFileType = \"wrapper.pb-project\"; name = \"%s\"; path = \"%s\"; sourceTree = SOURCE_ROOT; };',\nnode.parent.id, node.parent.name, node.parent.name, path.join(relpath, node.parent.name))\nelse\nlocal pth, src\nif xcode.isframework(node.path) then\nif string.find(node.path,'/')  then\nif string.find(node.path,'^%.')then\nerror('relative paths are not currently supported for frameworks')\nend\npth = node.path\nelse\npth = \"/System/Library/Frameworks/\" .. node.path\nend\nsrc = \"absolute\"\nelse\nsrc = \"group\"\nif node.parent.isvpath then\npth = node.cfg.name\nelse\npth = tree.getlocalpath(node)\nend\nend\n_p(2,'%s /* %s */ = {isa = PBXFileReference; lastKnownFileType = %s; name = \"%s\";"
	" path = \"%s\"; sourceTree = \"<%s>\"; };',\nnode.id, node.name, xcode.getfiletype(node), node.name, pth, src)\nend\nend\n})\n_p('/* End PBXFileReference section */')\n_p('')\nend\nfunction xcode.PBXFrameworksBuildPhase(tr)\n_p('/* Begin PBXFrameworksBuildPhase section */')\n_p(2,'%s /* Frameworks */ = {', tr.products.children[1].fxstageid)\n_p(3,'isa = PBXFrameworksBuildPhase;')\n_p(3,'buildActionMask = 2147483647;')\n_p(3,'files = (')\ntree.traverse(tr.frameworks, {\nonleaf = function(node)\n_p(4,'%s /* %s in Frameworks */,', node.buildid, node.name)\nend\n})\ntree.traverse(tr.projects, {\nonleaf = function(node)\n_p(4,'%s /* %s in Frameworks */,', node.buildid, node.name)\nend\n})\n_p(3,');')\n_p(3,'runOnlyForDeploymentPostprocessing = 0;')\n_p(2,'};')\n_p('/* End PBXFrameworksBuildPhase section */')\n_p('')\nend\nfunction xcode.PBXGroup(tr)\n_p('/* Begin PBXGroup section */')\ntree.traverse(tr, {\nonnode = function(node)\nif (node.path and #node.children == 0) or node.kind == \"vgroup\" then\nreturn\nend\n"
	"if node.parent == tr.projects then\n_p(2,'%s /* Products */ = {', node.productgroupid)\nelse\n_p(2,'%s /* %s */ = {', node.id, node.name)\nend\n_p(3,'isa = PBXGroup;')\n_p(3,'children = (')\nfor _, childnode in ipairs(node.children) do\n_p(4,'%s /* %s */,', childnode.id, childnode.name)\nend\n_p(3,');')\nif node.parent == tr.projects then\n_p(3,'name = Products;')\nelse\n_p(3,'name = \"%s\";', node.name)\nif node.path and not node.isvpath then\nlocal p = node.path\nif node.parent.path then\np = path.getrelative(node.parent.path, node.path)\nend\n_p(3,'path = \"%s\";', p)\nend\nend\n_p(3,'sourceTree = \"<group>\";')\n_p(2,'};')\nend\n}, true)\n_p('/* End PBXGroup section */')\n_p('')\nend\nfunction xcode.PBXNativeTarget(tr)\n_p('/* Begin PBXNativeTarget section */')\nfor _, node in ipairs(tr.products.children) do\nlocal name = tr.project.name\n_p(2,'%s /* %s */ = {', node.targetid, name)\n_p(3,'isa = PBXNativeTarget;')\n_p(3,'buildConfigurationList = %s /* Build configuration list for PBXNativeTarget \"%s\" */;"
	"', node.cfgsection, name)\n_p(3,'buildPhases = (')\nif #tr.project.prebuildcommands > 0 then\n_p(4,'9607AE1010C857E500CD1376 /* Prebuild */,')\nend\n_p(4,'%s /* Resources */,', node.resstageid)\n_p(4,'%s /* Sources */,', node.sourcesid)\nif #tr.project.prelinkcommands > 0 then\n_p(4,'9607AE3510C85E7E00CD1376 /* Prelink */,')\nend\n_p(4,'%s /* Frameworks */,', node.fxstageid)\nif #tr.project.postbuildcommands > 0 then\n_p(4,'9607AE3710C85E8F00CD1376 /* Postbuild */,')\nend\n_p(3,');')\n_p(3,'buildRules = (')\n_p(3,');')\n_p(3,'dependencies = (')\nfor _, node in ipairs(tr.projects.children) do\n_p(4,'%s /* PBXTargetDependency */,', node.targetdependid)\nend\n_p(3,');')\n_p(3,'name = \"%s\";', name)\nlocal p\nif node.cfg.kind == \"ConsoleApp\" then\np = \"$(HOME)/bin\"\nelseif node.cfg.kind == \"WindowedApp\" then\np = \"$(HOME)/Applications\"\nend\nif p then\n_p(3,'productInstallPath = \"%s\";', p)\nend\n_p(3,'productName = \"%s\";', name)\n_p(3,'productReference = %s /* %s */;', node.id, node.name)\n_p(3,'produ"
	"ctType = \"%s\";', xcode.getproducttype(node))\n_p(2,'};')\nend\n_p('/* End PBXNativeTarget section */')\n_p('')\nend\nfunction xcode.PBXProject(tr)\n_p('/* Begin PBXProject section */')\n_p(2,'08FB7793FE84155DC02AAC07 /* Project object */ = {')\n_p(3,'isa = PBXProject;')\n_p(3,'buildConfigurationList = 1DEB928908733DD80010E9CD /* Build configuration list for PBXProject \"%s\" */;', tr.name)\n_p(3,'compatibilityVersion = \"Xcode 3.2\";')\n_p(3,'hasScannedForEncodings = 1;')\n_p(3,'mainGroup = %s /* %s */;', tr.id, tr.name)\n_p(3,'projectDirPath = \"\";')\nif #tr.projects.children > 0 then\n_p(3,'projectReferences = (')\nfor _, node in ipairs(tr.projects.children) do\n_p(4,'{')\n_p(5,'ProductGroup = %s /* Products */;', node.productgroupid)\n_p(5,'ProjectRef = %s /* %s */;', node.id, path.getname(node.path))\n_p(4,'},')\nend\n_p(3,');')\nend\n_p(3,'projectRoot = \"\";')\n_p(3,'targets = (')\nfor _, node in ipairs(tr.products.children) do\n_p(4,'%s /* %s */,', node.targetid, node.name)\nend\n_p(3,');')\n_p(2,'};"
	"')\n_p('/* End PBXProject section */')\n_p('')\nend\nfunction xcode.PBXReferenceProxy(tr)\nif #tr.projects.children > 0 then\n_p('/* Begin PBXReferenceProxy section */')\ntree.traverse(tr.projects, {\nonleaf = function(node)\n_p(2,'%s /* %s */ = {', node.id, node.name)\n_p(3,'isa = PBXReferenceProxy;')\n_p(3,'fileType = %s;', xcode.gettargettype(node))\n_p(3,'path = \"%s\";', node.path)\n_p(3,'remoteRef = %s /* PBXContainerItemProxy */;', node.parent.productproxyid)\n_p(3,'sourceTree = BUILT_PRODUCTS_DIR;')\n_p(2,'};')\nend\n})\n_p('/* End PBXReferenceProxy section */')\n_p('')\nend\nend\nfunction xcode.PBXResourcesBuildPhase(tr)\n_p('/* Begin PBXResourcesBuildPhase section */')\nfor _, target in ipairs(tr.products.children) do\n_p(2,'%s /* Resources */ = {', target.resstageid)\n_p(3,'isa = PBXResourcesBuildPhase;')\n_p(3,'buildActionMask = 2147483647;')\n_p(3,'files = (')\ntree.traverse(tr, {\nonnode = function(node)\nif xcode.getbuildcategory(node) == \"Resources\" then\n_p(4,'%s /* %s in Resources */,', nod"
	"e.buildid, node.name)\nend\nend\n})\n_p(3,');')\n_p(3,'runOnlyForDeploymentPostprocessing = 0;')\n_p(2,'};')\nend\n_p('/* End PBXResourcesBuildPhase section */')\n_p('')\nend\nfunction xcode.PBXShellScriptBuildPhase(tr)\nlocal wrapperWritten = false\nlocal function doblock(id, name, which)\nlocal prjcmds = tr.project[which]\nlocal commands = table.join(prjcmds, {})\nfor _, cfg in ipairs(tr.configs) do\nlocal cfgcmds = cfg[which]\nif #cfgcmds > #prjcmds then\ntable.insert(commands, 'if [ \"${CONFIGURATION}\" = \"' .. xcode.getconfigname(cfg) .. '\" ]; then')\nfor i = #prjcmds + 1, #cfgcmds do\ntable.insert(commands, cfgcmds[i])\nend\ntable.insert(commands, 'fi')\nend\nend\nif #commands > 0 then\nif not wrapperWritten then\n_p('/* Begin PBXShellScriptBuildPhase section */')\nwrapperWritten = true\nend\n_p(2,'%s /* %s */ = {', id, name)\n_p(3,'isa = PBXShellScriptBuildPhase;')\n_p(3,'buildActionMask = 2147483647;')\n_p(3,'files = (')\n_p(3,');')\n_p(3,'inputPaths = (');\n_p(3,');');\n_p(3,'name = %s;', name);\n_p"
	"(3,'outputPaths = (');\n_p(3,');');\n_p(3,'runOnlyForDeploymentPostprocessing = 0;');\n_p(3,'shellPath = /bin/sh;');\n_p(3,'shellScript = \"%s\";', table.concat(commands, \"\\\\n\"):gsub('\"', '\\\\\"'))\n_p(2,'};')\nend\nend\ndoblock(\"9607AE1010C857E500CD1376\", \"Prebuild\", \"prebuildcommands\")\ndoblock(\"9607AE3510C85E7E00CD1376\", \"Prelink\", \"prelinkcommands\")\ndoblock(\"9607AE3710C85E8F00CD1376\", \"Postbuild\", \"postbuildcommands\")\nif wrapperWritten then\n_p('/* End PBXShellScriptBuildPhase section */')\nend\nend\nfunction xcode.PBXSourcesBuildPhase(tr)\n_p('/* Begin PBXSourcesBuildPhase section */')\nfor _, target in ipairs(tr.products.children) do\n_p(2,'%s /* Sources */ = {', target.sourcesid)\n_p(3,'isa = PBXSourcesBuildPhase;')\n_p(3,'buildActionMask = 2147483647;')\n_p(3,'files = (')\ntree.traverse(tr, {\nonleaf = function(node)\nif xcode.getbuildcategory(node) == \"Sources\" then\n_p(4,'%s /* %s in Sources */,', node.buildid, node.name)\nend\nend\n})\n_p(3,');')\n_p(3,'runOnlyForDeployme"
	"ntPostprocessing = 0;')\n_p(2,'};')\nend\n_p('/* End PBXSourcesBuildPhase section */')\n_p('')\nend\nfunction xcode.PBXVariantGroup(tr)\n_p('/* Begin PBXVariantGroup section */')\ntree.traverse(tr, {\nonbranch = function(node)\nif node.kind == \"vgroup\" then\n_p(2,'%s /* %s */ = {', node.id, node.name)\n_p(3,'isa = PBXVariantGroup;')\n_p(3,'children = (')\nfor _, lang in ipairs(node.children) do\n_p(4,'%s /* %s */,', lang.id, lang.name)\nend\n_p(3,');')\n_p(3,'name = %s;', node.name)\n_p(3,'sourceTree = \"<group>\";')\n_p(2,'};')\nend\nend\n})\n_p('/* End PBXVariantGroup section */')\n_p('')\nend\nfunction xcode.PBXTargetDependency(tr)\nif #tr.projects.children > 0 then\n_p('/* Begin PBXTargetDependency section */')\ntree.traverse(tr.projects, {\nonleaf = function(node)\n_p(2,'%s /* PBXTargetDependency */ = {', node.parent.targetdependid)\n_p(3,'isa = PBXTargetDependency;')\n_p(3,'name = \"%s\";', node.name)\n_p(3,'targetProxy = %s /* PBXContainerItemProxy */;', node.parent.targetproxyid)\n_p(2,'};')\nend\n})"
	"\n_p('/* End PBXTargetDependency section */')\n_p('')\nend\nend\nfunction xcode.XCBuildConfiguration_Target(tr, target, cfg)\nlocal cfgname = xcode.getconfigname(cfg)\n_p(2,'%s /* %s */ = {', cfg.xcode.targetid, cfgname)\n_p(3,'isa = XCBuildConfiguration;')\n_p(3,'buildSettings = {')\n_p(4,'ALWAYS_SEARCH_USER_PATHS = NO;')\nif not cfg.flags.Symbols then\n_p(4,'DEBUG_INFORMATION_FORMAT = \"dwarf-with-dsym\";')\nend\nif cfg.kind ~= \"StaticLib\" and cfg.buildtarget.prefix ~= \"\" then\n_p(4,'EXECUTABLE_PREFIX = %s;', cfg.buildtarget.prefix)\nend\nlocal outdir = path.getdirectory(cfg.buildtarget.bundlepath)\nif outdir ~= \".\" then\n_p(4,'CONFIGURATION_BUILD_DIR = %s;', outdir)\nend\n_p(4,'GCC_DYNAMIC_NO_PIC = NO;')\n_p(4,'GCC_MODEL_TUNING = G5;')\nif tr.infoplist then\n_p(4,'INFOPLIST_FILE = \"%s\";', tr.infoplist.path)\nend\ninstallpaths = {\nConsoleApp = '/usr/local/bin',\nWindowedApp = '\"$(HOME)/Applications\"',\nSharedLib = '/usr/local/lib',\nStaticLib = '/usr/local/lib',\n}\n_p(4,'INSTALL_PATH = %s;', inst"
	"allpaths[cfg.kind])\n_p(4,'PRODUCT_NAME = \"%s\";', cfg.buildtarget.basename)\n_p(3,'};')\n_p(3,'name = \"%s\";', cfgname)\n_p(2,'};')\nend\nfunction xcode.XCBuildConfiguration_Project(tr, cfg)\nlocal cfgname = xcode.getconfigname(cfg)\n_p(2,'%s /* %s */ = {', cfg.xcode.projectid, cfgname)\n_p(3,'isa = XCBuildConfiguration;')\n_p(3,'buildSettings = {')\nlocal archs = {\nNative = \"$(NATIVE_ARCH_ACTUAL)\",\nx32    = \"i386\",\nx64    = \"x86_64\",\nUniversal32 = \"$(ARCHS_STANDARD_32_BIT)\",\nUniversal64 = \"$(ARCHS_STANDARD_64_BIT)\",\nUniversal = \"$(ARCHS_STANDARD_32_64_BIT)\",\n}\n_p(4,'ARCHS = \"%s\";', archs[cfg.platform])\nlocal targetdir = path.getdirectory(cfg.buildtarget.bundlepath)\nif targetdir ~= \".\" then\n_p(4,'CONFIGURATION_BUILD_DIR = \"$(SYMROOT)\";');\nend\n_p(4,'CONFIGURATION_TEMP_DIR = \"$(OBJROOT)\";')\nif cfg.flags.Symbols then\n_p(4,'COPY_PHASE_STRIP = NO;')\nend\n_p(4,'GCC_C_LANGUAGE_STANDARD = gnu99;')\nif cfg.flags.NoExceptions then\n_p(4,'GCC_ENABLE_CPP_EXCEPTIONS = NO;')\nend\nif c"
	"fg.flags.NoRTTI then\n_p(4,'GCC_ENABLE_CPP_RTTI = NO;')\nend\nif _ACTION ~= \"xcode4\" and cfg.flags.Symbols and not cfg.flags.NoEditAndContinue then\n_p(4,'GCC_ENABLE_FIX_AND_CONTINUE = YES;')\nend\nif cfg.flags.NoExceptions then\n_p(4,'GCC_ENABLE_OBJC_EXCEPTIONS = NO;')\nend\nif cfg.flags.Optimize or cfg.flags.OptimizeSize then\n_p(4,'GCC_OPTIMIZATION_LEVEL = s;')\nelseif cfg.flags.OptimizeSpeed then\n_p(4,'GCC_OPTIMIZATION_LEVEL = 3;')\nelse\n_p(4,'GCC_OPTIMIZATION_LEVEL = 0;')\nend\nif cfg.pchheader and not cfg.flags.NoPCH then\n_p(4,'GCC_PRECOMPILE_PREFIX_HEADER = YES;')\n_p(4,'GCC_PREFIX_HEADER = \"%s\";', cfg.pchheader)\nend\nxcode.printlist(cfg.defines, 'GCC_PREPROCESSOR_DEFINITIONS')\n_p(4,'GCC_SYMBOLS_PRIVATE_EXTERN = NO;')\nif cfg.flags.FatalWarnings then\n_p(4,'GCC_TREAT_WARNINGS_AS_ERRORS = YES;')\nend\n_p(4,'GCC_WARN_ABOUT_RETURN_TYPE = YES;')\n_p(4,'GCC_WARN_UNUSED_VARIABLE = YES;')\nxcode.printlist(cfg.includedirs, 'HEADER_SEARCH_PATHS')\nxcode.printlist(cfg.libdirs, 'LIBRARY_SEARCH_PATHS')\n_p"
	"(4,'OBJROOT = \"%s\";', cfg.objectsdir)\n_p(4,'ONLY_ACTIVE_ARCH = %s;',iif(premake.config.isdebugbuild(cfg),'YES','NO'))\nlocal checks = {\n[\"-ffast-math\"]          = cfg.flags.FloatFast,\n[\"-ffloat-store\"]        = cfg.flags.FloatStrict,\n[\"-fomit-frame-pointer\"] = cfg.flags.NoFramePointer,\n}\nlocal flags = { }\nfor flag, check in pairs(checks) do\nif check then\ntable.insert(flags, flag)\nend\nend\nxcode.printlist(table.join(flags, cfg.buildoptions), 'OTHER_CFLAGS')\nflags = { }\nfor _, lib in ipairs(premake.getlinks(cfg, \"system\")) do\nif not xcode.isframework(lib) then\ntable.insert(flags, \"-l\" .. lib)\nend\nend\nflags = table.join(flags, cfg.linkoptions)\nxcode.printlist(flags, 'OTHER_LDFLAGS')\nif cfg.flags.StaticRuntime then\n_p(4,'STANDARD_C_PLUS_PLUS_LIBRARY_TYPE = static;')\nend\nif targetdir ~= \".\" then\n_p(4,'SYMROOT = \"%s\";', targetdir)\nend\nif cfg.flags.ExtraWarnings then\n_p(4,'WARNING_CFLAGS = \"-Wall\";')\nend\n_p(3,'};')\n_p(3,'name = \"%s\";', cfgname)\n_p(2,'};')\nend\nfunct"
	"ion xcode.XCBuildConfiguration(tr)\n_p('/* Begin XCBuildConfiguration section */')\nfor _, target in ipairs(tr.products.children) do\nfor _, cfg in ipairs(tr.configs) do\nxcode.XCBuildConfiguration_Target(tr, target, cfg)\nend\nend\nfor _, cfg in ipairs(tr.configs) do\nxcode.XCBuildConfiguration_Project(tr, cfg)\nend\n_p('/* End XCBuildConfiguration section */')\n_p('')\nend\nfunction xcode.XCBuildConfigurationList(tr)\nlocal sln = tr.project.solution\n_p('/* Begin XCConfigurationList section */')\nfor _, target in ipairs(tr.products.children) do\n_p(2,'%s /* Build configuration list for PBXNativeTarget \"%s\" */ = {', target.cfgsection, target.name)\n_p(3,'isa = XCConfigurationList;')\n_p(3,'buildConfigurations = (')\nfor _, cfg in ipairs(tr.configs) do\n_p(4,'%s /* %s */,', cfg.xcode.targetid, xcode.getconfigname(cfg))\nend\n_p(3,');')\n_p(3,'defaultConfigurationIsVisible = 0;')\n_p(3,'defaultConfigurationName = \"%s\";', xcode.getconfigname(tr.configs[1]))\n_p(2,'};')\nend\n_p(2,'1DEB928908733DD80010E9CD /*"
	" Build configuration list for PBXProject \"%s\" */ = {', tr.name)\n_p(3,'isa = XCConfigurationList;')\n_p(3,'buildConfigurations = (')\nfor _, cfg in ipairs(tr.configs) do\n_p(4,'%s /* %s */,', cfg.xcode.projectid, xcode.getconfigname(cfg))\nend\n_p(3,');')\n_p(3,'defaultConfigurationIsVisible = 0;')\n_p(3,'defaultConfigurationName = \"%s\";', xcode.getconfigname(tr.configs[1]))\n_p(2,'};')\n_p('/* End XCConfigurationList section */')\n_p('')\nend\nfunction xcode.Footer()\n_p(1,'};')\n_p('\\trootObject = 08FB7793FE84155DC02AAC07 /* Project object */;')\n_p('}')\nend\n",

	/* actions/xcode/xcode_project.lua */
	"local xcode = premake.xcode\nlocal tree = premake.tree\nfunction xcode.buildprjtree(prj)\nlocal tr = premake.project.buildsourcetree(prj)\ntr.configs = {}\nfor _, cfgname in ipairs(prj.solution.configurations) do\nfor _, platform in ipairs(prj.solution.xcode.platforms) do\nlocal cfg = premake.getconfig(prj, cfgname, platform)\ncfg.xcode = {}\ncfg.xcode.targetid = xcode.newid(prj.xcode.projectnode, cfgname)\ncfg.xcode.projectid = xcode.newid(tr, cfgname)\ntable.insert(tr.configs, cfg)\nend\nend\ntree.traverse(tr, {\nonbranch = function(node)\nif path.getextension(node.name) == \".lproj\" then\nlocal lang = path.getbasename(node.name)  -- \"English\", \"French\", etc.\nfor _, filenode in ipairs(node.children) do\nlocal grpnode = node.parent.children[filenode.name]\nif not grpnode then\ngrpnode = tree.insert(node.parent, tree.new(filenode.name))\ngrpnode.kind = \"vgroup\"\nend\nfilenode.name = path.getbasename(lang)\ntree.insert(grpnode, filenode)\nend\ntree.remove(node)\nend\nend\n})\ntr.frameworks = tree.new(\""
	"Frameworks\")\nfor cfg in premake.eachconfig(prj) do\nfor _, link in ipairs(premake.getlinks(cfg, \"system\", \"fullpath\")) do\nlocal name = path.getname(link)\nif xcode.isframework(name) and not tr.frameworks.children[name] then\nnode = tree.insert(tr.frameworks, tree.new(name))\nnode.path = link\nend\nend\nend\nif #tr.frameworks.children > 0 then \ntree.insert(tr, tr.frameworks)\nend\ntr.products = tree.insert(tr, tree.new(\"Products\"))\ntr.projects = tree.new(\"Projects\")\nfor _, dep in ipairs(premake.getdependencies(prj, \"sibling\", \"object\")) do\nlocal xcpath = xcode.getxcodeprojname(dep)\nlocal xcnode = tree.insert(tr.projects, tree.new(path.getname(xcpath)))\nxcnode.path = xcpath\nxcnode.project = dep\nxcnode.productgroupid = xcode.newid(xcnode, \"prodgrp\")\nxcnode.productproxyid = xcode.newid(xcnode, \"prodprox\")\nxcnode.targetproxyid  = xcode.newid(xcnode, \"targprox\")\nxcnode.targetdependid = xcode.newid(xcnode, \"targdep\")\nlocal cfg = premake.getconfig(dep, prj.configurations[1])\nnode = "
	"tree.insert(xcnode, tree.new(cfg.linktarget.name))\nnode.path = cfg.linktarget.fullpath\nnode.cfg = cfg\nend\nif #tr.projects.children > 0 then\ntree.insert(tr, tr.projects)\nend\ntree.traverse(tr, {\nonnode = function(node)\nnode.id = xcode.newid(node)\nif xcode.getbuildcategory(node) then\nnode.buildid = xcode.newid(node, \"build\")\nend\nif string.endswith(node.name, \"Info.plist\") then\ntr.infoplist = node\nend\nend\n}, true)\nnode = tree.insert(tr.products, prj.xcode.projectnode)\nnode.kind = \"product\"\nnode.path = node.cfg.buildtarget.fullpath\nnode.cfgsection = xcode.newid(node, \"cfg\")\nnode.resstageid = xcode.newid(node, \"rez\")\nnode.sourcesid  = xcode.newid(node, \"src\")\nnode.fxstageid  = xcode.newid(node, \"fxs\")\nreturn tr\nend\nfunction premake.xcode.project(prj)\nlocal tr = xcode.buildprjtree(prj)\nxcode.Header(tr)\nxcode.PBXBuildFile(tr)\nxcode.PBXContainerItemProxy(tr)\nxcode.PBXFileReference(tr)\nxcode.PBXFrameworksBuildPhase(tr)\nxcode.PBXGroup(tr)\nxcode.PBXNativeTarget(tr)\nxcode.P"
	"BXProject(tr)\nxcode.PBXReferenceProxy(tr)\nxcode.PBXResourcesBuildPhase(tr)\nxcode.PBXShellScriptBuildPhase(tr)\nxcode.PBXSourcesBuildPhase(tr)\nxcode.PBXVariantGroup(tr)\nxcode.PBXTargetDependency(tr)\nxcode.XCBuildConfiguration(tr)\nxcode.XCBuildConfigurationList(tr)\nxcode.Footer(tr)\nend\n",

	/* actions/xcode/xcode4_workspace.lua */
	"premake.xcode4 = {}\nlocal xcode4 = premake.xcode4\nfunction xcode4.workspace_head()\n_p('<?xml version=\"1.0\" encoding=\"UTF-8\"?>')\n_p('<Workspace')\n_p(1,'version = \"1.0\">')\nend\nfunction xcode4.workspace_tail()\n_p('</Workspace>')\nend\nfunction xcode4.workspace_file_ref(prj)\nlocal projpath = path.getrelative(prj.solution.location, prj.location)\nif projpath == '.' then projpath = '' \nelse projpath = projpath ..'/' \nend\n_p(1,'<FileRef')\n_p(2,'location = \"group:%s\">',projpath .. prj.name .. '.xcodeproj')\n_p(1,'</FileRef>')\nend\nfunction xcode4.workspace_generate(sln)\npremake.xcode.preparesolution(sln)\nxcode4.workspace_head()\nfor prj in premake.solution.eachproject(sln) do\nxcode4.workspace_file_ref(prj)\nend\nxcode4.workspace_tail()\nend\n",

	/* actions/clean/_clean.lua */
	"premake.clean = { }\nfunction premake.clean.directory(obj, pattern)\nlocal fname = premake.project.getfilename(obj, pattern)\nos.rmdir(fname)\nend\nfunction premake.clean.file(obj, pattern)\nlocal fname = premake.project.getfilename(obj, pattern)\nos.remove(fname)\nend\nnewaction {\ntrigger     = \"clean\",\ndescription = \"Remove all binaries and generated files\",\nonsolution = function(sln)\nfor action in premake.action.each() do\nif action.oncleansolution then\naction.oncleansolution(sln)\nend\nend\nend,\nonproject = function(prj)\nfor action in premake.action.each() do\nif action.oncleanproject then\naction.oncleanproject(prj)\nend\nend\nif (prj.objectsdir) then\npremake.clean.directory(prj, prj.objectsdir)\nend\nlocal platforms = prj.solution.platforms or { }\nif not table.contains(platforms, \"Native\") then\nplatforms = table.join(platforms, { \"Native\" })\nend\nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\npremake.clean.directory(prj, cfg.objectsdir)\nprema"
	"ke.clean.file(prj, premake.gettarget(cfg, \"build\", \"posix\", \"windows\", \"windows\").fullpath)\npremake.clean.file(prj, premake.gettarget(cfg, \"build\", \"posix\", \"posix\", \"linux\").fullpath)\npremake.clean.file(prj, premake.gettarget(cfg, \"build\", \"posix\", \"posix\", \"macosx\").fullpath)\npremake.clean.file(prj, premake.gettarget(cfg, \"build\", \"posix\", \"PS3\", \"windows\").fullpath)\nif cfg.kind == \"WindowedApp\" then\npremake.clean.directory(prj, premake.gettarget(cfg, \"build\", \"posix\", \"posix\", \"linux\").fullpath .. \".app\")\nend\npremake.clean.file(prj, premake.gettarget(cfg, \"link\", \"windows\", \"windows\", \"windows\").fullpath)\npremake.clean.file(prj, premake.gettarget(cfg, \"link\", \"posix\", \"posix\", \"linux\").fullpath)\nlocal target = path.join(premake.project.getfilename(prj, cfg.buildtarget.directory), cfg.buildtarget.basename)\nfor action in premake.action.each() do\nif action.oncleantarget then\naction.oncleantarget(target)\nend\nend\nend\nend\nend\n}\n",

	/* _premake_main.lua */
	"local scriptfile    = \"premake4.lua\"\nlocal shorthelp     = \"Type 'premake4 --help' for help\"\nlocal versionhelp   = \"premake4 (Premake Build Script Generator) %s\"\nlocal function injectplatform(platform)\nif not platform then return true end\nplatform = premake.checkvalue(platform, premake.fields.platforms.allowed)\nfor sln in premake.solution.each() do\nlocal platforms = sln.platforms or { }\nif #platforms == 0 then\ntable.insert(platforms, \"Native\")\nend\nif not table.contains(platforms, \"Native\") then\nreturn false, sln.name .. \" does not target native platform\\nNative platform settings are required for the --platform feature.\"\nend\nif not table.contains(platforms, platform) then\ntable.insert(platforms, platform)\nend\nsln.platforms = platforms\nend\nreturn true\nend\nfunction _premake_main(scriptpath)\nif (scriptpath) then\nlocal scripts  = dofile(scriptpath .. \"/_manifest.lua\")\nfor _,v in ipairs(scripts) do\ndofile(scriptpath .. \"/\" .. v)\nend\nend\npremake.action.set(_ACTION)\nmath.r"
	"andomseed(os.time())\nlocal fname = _OPTIONS[\"file\"] or scriptfile\nif (os.isfile(fname)) then\ndofile(fname)\nend\nif (_OPTIONS[\"version\"]) then\nprintf(versionhelp, _PREMAKE_VERSION)\nreturn 1\nend\nif (_OPTIONS[\"help\"]) then\npremake.showhelp()\nreturn 1\nend\nif (not _ACTION) then\nprint(shorthelp)\nreturn 1\nend\nif (not os.isfile(fname)) then\nerror(\"No Premake script (\"..scriptfile..\") found!\", 2)\nend\naction = premake.action.current()\nif (not action) then\nerror(\"Error: no such action '\" .. _ACTION .. \"'\", 0)\nend\nok, err = premake.option.validate(_OPTIONS)\nif (not ok) then error(\"Error: \" .. err, 0) end\nok, err = premake.checktools()\nif (not ok) then error(\"Error: \" .. err, 0) end\nok, err = injectplatform(_OPTIONS[\"platform\"])\nif (not ok) then error(\"Error: \" .. err, 0) end\nprint(\"Building configurations...\")\npremake.buildconfigs()\nok, err = premake.checkprojects()\nif (not ok) then error(\"Error: \" .. err, 0) end\nprintf(\"Running action '%s'...\", action.trigger)"
	"\npremake.action.call(action.trigger)\nprint(\"Done.\")\nreturn 0\nend\n",

	0
};
