# Part of the A-A-P recipe executive: Testing of :produce

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

#
# Note: this requires a working C compiler
#

import sys, os, shutil, glob

def runaap(args):
    return os.system("%s ..%sMain.py %s" % (sys.argv[1], os.sep, args))

os.chdir("rectest")

# Create a recipe with a different filetype for the target, so that a different
# build action will be used.
# Check that the right action is used.
rec = "rectest.aap"
inp = "rectest.c"
prog = "rectestprog"
myprog = "myrectestprog.exe"
out = "rectest.out"

msg = "Building %s done." % myprog

def cleanup():
    for file in [ rec, inp, prog, out, myprog ]:
	try:
	    os.remove(file)
	except:
	    pass
    try:
	for dir in glob.glob('build-*'):
	    shutil.rmtree(dir)
    except:
	pass

cleanup()

f = open(rec, "w")
f.write("""
targetattr = {targetsuffix = .exe} {targetprefix = my}
                    {buildaction = dobuild}
:produce myproggy {objectsuffix = .o} {objecttype = object}
    $targetattr %s : %s
:action dobuild myproggy object
    :do build {filetype = program} $source
    :print Building $-target done.
""" % (prog, inp))
f.close()

f = open(inp, "w")
f.write("""
#include <stdio.h>
int main() { printf("Hello World!\\n"); return 0;}
""")
f.close()

def doit(text):
    res = runaap("-f %s" % rec)
    f = open("AAPDIR/log")
    actual = f.read()
    f.close()

    import string
    if string.find(actual, text) < 0:
	res = 1
        print 'Did not find remark in log file: "%s"' % text
    return res

# Compile the program.
res = doit(msg)

cleanup()

sys.exit(res)


# vim: set sw=4 et sts=4 tw=79 fo+=l:
