# Part of the A-A-P recipe executive: Setup using MingW

# Copyright (c) 2002-2003 stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

#
# This module sets up variables and actions for using the Microsoft Visual C
# compiler tools.
#

from RecPython import *
import Global
from Action import action_add
from Dictlist import str2dictlist
from RecPos import RecPos


def exists():
    """
    Return TRUE when the MingW toolchain can be found.
    """
    return program_path("mingw32-gcc")


def define_actions():
    """
    Define the actions that MingW can accomplish.
    """
    rd = Global.globals
    rpstack = [ RecPos("compile_mingw action") ]
    action_add(rpstack, rd, str2dictlist(rpstack, "compile_mingw object c"),
            ":sys $MINGCC $CPPFLAGS $?DEFINE $?INCLUDE `cflags_normal()` "
                "$CFLAGS -o $target -c $source")
    if not rd.get("MINGCC"):
        rd["MINGCC"] = "gcc"


def use_actions(scope):
    """
    Setup variables so that the default actions use the MingW actions.
    """
    scope["C_COMPILE_ACTION"] = "compile_mingw"
    scope["CXX_COMPILE_ACTION"] = "compile_mingw"

# vim: set sw=4 et sts=4 tw=79 fo+=l:
