
/*
 *  Copyright (c) 1998 - 1999, 2001 Karel Zak "Zakkr" <zakkr@zf.jcu.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  $Id: select_file.c,v 1.2 2001/01/02 14:16:15 zakkr Exp $
 */

#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <dirent.h>
#include <string.h>

#include "aca.h"
#include "aca_dlg.h"
#include "aca_widget.h"

#define Y(a)	(a+y)
#define X(a)	(a+x)

static int 	yn=16, xn=43;
static char	curr_dir[BUFSIZ];

   static int dlg_stat(char *dir, char *file)
   {
      struct stat	st;
      char		filename[BUFSIZ];
   
      sprintf(filename, "%s%s", dir, file);
      if (stat((const char *) filename, &st) == -1)  
         return FALSE;
      return st.st_mode;
   }

   static int select_dir(const struct dirent *d)
   {
      if (d->d_name[0] == '.' && d->d_name[1] == '\0')
         return 0; 
      if ( d->d_name[ strlen(d->d_name) -1 ] == '~')
         return 0;	
      return d->d_ino;
   }

   static int dir_sort(struct dirent **a, struct dirent **b)
   {
      int 	amode = dlg_stat(curr_dir, (*a)->d_name),
      bmode = dlg_stat(curr_dir, (*b)->d_name);
   
      if (S_ISDIR(amode) && S_ISDIR(bmode)) 
         return strcmp((*a)->d_name, (*b)->d_name);		
      else if (S_ISDIR(amode))
         return -1;
      else if (S_ISDIR(bmode))	
         return TRUE;
      else 
         return strcmp((*a)->d_name, (*b)->d_name);			
   }	

   static int fill_filelist(char *dirname, struct dirent ***namelist)
   {
      int		num;	
      if ((num = scandir((const char *) dirname, namelist, select_dir, 
		(int (*)(const void *, const void *)) dir_sort)) != -1) 
         --num; 
      return num;
   }

   static void mpr_dir (Wmenu *m, Widget *w, int line, int cols, int item)
   {
      struct dirent	**p;        
      char		*x;
      int		mode;
      WidgetColor	*color = &TplC->menu_in;
   
      _D( " mpr_dir()" );
   
      p = (struct dirent **) m->list;
      x = (*(p+item))->d_name;
      clean_hline(line, cols-1, 26, 
      		(m->item_act == item ? color->sel : color->nsel)); 
   
      if (!(mode=dlg_stat(curr_dir, x)))
         mvprintw (line, cols, "!%.24s", x);
      else if (S_ISDIR(mode))
         mvprintw (line, cols, "/%.24s", x);	
      else
         mvprintw (line, cols, " %.24s", x);	
   }



   int set_dir_poz(char *str, struct dirent **p, int max)
   {
      int	i;
      for(i=0; i<=max; i++) {
         if (!strcmp(str, (*(p+i))->d_name))
            return --i;
      }
      return FALSE;
   }

   char *Dlg_SelectFile(char *dirname, char *header, char *exten, char *selfile)
   {
      struct dirent	**namelist;
      int		x = COLS/2 - xn/2,				
      			y = LINES/2 - yn/2,				
      			re, mode;
      char		*loc, *loc2, last_d[256],  file[256];		
      Wmenu   menu = {
	      chN, 0, M_COLORIN | M_OPEN | M_NOTOUT | M_BORDER | M_TITLE | M_STILLV,
	      0,0,0,10,0,0,0,0,0,0, alistN, (void *) namelist, mpr_dir
      };
      Winput	input = { _aca("|F|ile: "), 0, file, 0, 0, 0, 30 };
      Widget	w[] = {
	      { '/',  Y(1), X(2), 11,25, menu_fn,   (void *) &menu,  			Wf_DEFAULT, _aca_text_domain },
	      { TRUE, Y(15),X(2), 0, 37, input_fn,  (void *) &input, 			Wf_DEFAULT, _aca_text_domain },
	      { TRUE, Y(3), X(31),0,  5, button_fn, (void *) &def_button[_BUTT_OK],    	Wf_DEFAULT, _aca_text_domain },
	      { TRUE, Y(5), X(31),0,  9, button_fn, (void *) &def_button[_BUTT_CANCEL],	Wf_DEFAULT, _aca_text_domain },
      		W_NULL
      };
      SessW	s;
   
#define _SET_SELFILE_POZ {				\
      x = COLS/2 - xn/2;				\
      y = LINES/2 - yn/2;				\
      w[0].y = Y(1); w[0].x = X(2);			\
      w[1].y = Y(15);w[1].x = X(2);             	\
      w[2].y = Y(3); w[2].x = X(31);            	\
      w[3].y = Y(5); w[3].x = X(31);            	\
      aca_border(Y(0), X(0), yn, xn, TplC->dlg_bgr);  	\
      clean_box(Y(1), X(1), yn-2, xn-2, TplC->dlg_bgr);	\
      bold;  aca_c(TplC->dlg_header); 			\
      mvaddstr( Y(0), COLS/2 - strlen(header)/2, header);\
      ubold;						\
}      

      if (!dirname) 
         return chN;
      
      strncpy(curr_dir, dirname, BUFSIZ-1); 
      
      re = strlen(curr_dir);
      if (*(curr_dir+(re-1)) != '/')
      	 strcat(curr_dir, "/");	
      
      if ((menu.item_max = fill_filelist(curr_dir, &namelist)) == -1) {
         ErrorOpen(curr_dir);	
         return chN;
      }
      
      *file = '\0';
      menu.list	= (void *) namelist;
      menu.astr = strlen(curr_dir) < 25 ? curr_dir : curr_dir + (strlen(curr_dir)-25);
      
      _SET_SELFILE_POZ;
      
      init_sessw(&s, 0, TRUE, w, NULL, Sf_NOT_BGR);
   
      W_redraw_session(&s);
      do {
         if (s.key == K_SCREEN_RESIZED) {
         	_SET_SELFILE_POZ;
         	W_redraw_session(&s);
         	continue;
         }	
         re = 0;
         re = run_act_widget(&s);
      
         W_key_to_widgets(&s);		
         W_default_go(&s);
      
         if (exten && s.actual !=1 && file[0]) {
            if (!strstr(file, exten)) {
               strcat(file, exten);
               input.a_size = input.poz = strlen(file);
               W_redraw_session(&s);
            }
         }			     	
        /* OK */   	
         if ((re & Wr_BUTTON_PRESS) && s.actual == 2) {
            if (curr_dir) strncpy(dirname, curr_dir, BUFSIZ);
            if (!*file) 
               return chN;
            sprintf(selfile, "%s%s", curr_dir, file);
            return selfile;
         }
         /* Cancel */   	
         else if ((re & Wr_BUTTON_PRESS) && s.actual == 3) { 
            if (curr_dir) strncpy(dirname, curr_dir, BUFSIZ);
            return chN;		
         /* press menu */	
         } 
         else if (re & Wr_MENU_PRESS) {
            *last_d = '\0';	
            loc = (*(namelist + menu.item_act))->d_name;
            if ((strcmp(curr_dir, "/") || strcmp(loc, "..")) &&
            ((strlen(curr_dir) + strlen(loc)) < BUFSIZ )  &&
            (mode=dlg_stat(curr_dir, loc))) {
               if (S_ISDIR(mode)) {
                  if ((loc2 = strrchr(curr_dir, '/')))
                     *loc2 = '\0';
                  if (!strcmp(loc, "..")) {
                     if ((loc2 = strrchr(curr_dir, '/'))) {
                        strncpy(last_d, (++loc2), 128);
                        *loc2 = '\0';
                     }
                  } 
                  else 
                     sprintf(curr_dir, "%s/%s/", curr_dir, loc);
                  if ((menu.item_max = fill_filelist(curr_dir, &namelist)) == -1) 
                     ErrorOpen(curr_dir);
                  if (*last_d) 
                     menu_dummy_go(w, &menu, KEY_DOWN, 
                        set_dir_poz(last_d, namelist, menu.item_max));
                  else 		
                     ACA_RESET_MENU((&menu));
                  menu.list  = (void *) namelist;
                  menu.astr  = strlen(curr_dir) < 25 ? curr_dir : 
                     curr_dir + (strlen(curr_dir)-25);
               } 
               else if (S_ISREG(mode)) {
                  strncpy(file, loc, 128);
                  if (exten)
                     if (!strstr(file, exten)) 
                        strcat(file, exten);
                  input.a_size = input.poz = strlen(file);
                  set_widget(w, &s, 1);
               }	
            }
            W_redraw_session(&s);
         }
      } while((s.key = get_k()) != KEY_F(10)); 
      curs_set(0);
      return chN;
   }
