
/*
 *  Copyright (c) 1998 - 1999, 2001 Karel Zak "Zakkr" <zakkr@zf.jcu.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  $Id: colors.c,v 1.2 2001/01/02 14:16:15 zakkr Exp $
 */

#include "aca.h"

#include <stdlib.h>

   aca_COLORS	*GL_c;
   TemplateColor	*TplC;

   inline void aca_c(int x)
   {
      if (!aca.color) attroff(A_REVERSE); 
   
      attron  ((aca.color ? (*(GL_c+x)).color : (*(GL_c+x)).bw));
   }

   TemplateColor *set_TplC( TemplateColor *t)
   {
      return (TplC = t);
   }

   int aca_init_color(int num)
   {
      _D( "aca_init_color()" );
   
      if ((GL_c = (aca_COLORS *) calloc(num+1, sizeof(aca_COLORS))) == NULL) 
         return FALSE;
   
      return TRUE;
   }

   void aca_init_pair(int color_num, int fc, int bc, int bw)
   {
      _D( "aca_init_pair()");
   
      init_pair(color_num, fc, bc);
   
      GL_c[color_num].color 	= COLOR_PAIR(color_num);
      GL_c[color_num].fc 	= fc;
      GL_c[color_num].bc 	= bc;
      GL_c[color_num].bw 	= bw;		/* black / white mode 	*/
   }
