
/*
 *  Copyright (c) 1998 - 1999, 2001 Karel Zak "Zakkr" <zakkr@zf.jcu.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  $Id: utils.c,v 1.2 2001/01/02 14:16:15 zakkr Exp $
 */

#include "aca.h"
#include "aca_dlg.h"

#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>

#ifdef HAVE_MOUSE
	extern	int init_mouse();
#endif

   /* Global ACA direct struct */
   ACA	aca;

   char *_aca_text_domain = "aca";

   int	GL_winch_flag		= FALSE,
   	GL_interrupt_flag	= FALSE;

   static void winch_handler();

   static void interrupt_handler(int dummy);

   void end_aca()
   {
      _D( " end_aca()");
   
      erase();
      refresh();
      endwin();	
   }

   void init_winch()
   {
      struct sigaction act, oldact;	
   
      _D( " init_winch()");
   
      act.sa_handler	= winch_handler;
      sigemptyset (&act.sa_mask);
      act.sa_flags = 0;
   #ifdef SA_RESTART
        act.sa_flags |= SA_RESTART;
   #endif
      sigaction(SIGWINCH, &act, &oldact);	
   }

   void aca_default()
   {
      _D( " aca_default()");
   
      aca.line			= TRUE;
      aca.keypad		= TRUE;
      aca.forcekey		= FALSE;
      aca.color			= has_colors();
      aca.getch_timeout		= 80;
      aca.fallasleep		= 0;
      aca.fallasleep_incr	= 0;
      aca.extra_timeout_call	= FALSE;	
      aca.extra_resize		= FALSE;	      
   }

   void init_aca(int def)
   {
      struct sigaction act, oldact;	
   
      _D( " init_aca()");
   
      init_winch();
      initscr();
      atexit((void *) end_aca);
      start_color();
      cbreak();
      noecho();
      curs_set(0);
      meta(stdscr, TRUE);
      GL_term_name	= termname();
   
      if (def)
         aca_default();
   
      if (aca.forcekey)		aca_keypad(FALSE);
      else if (aca.keypad)	aca_keypad(TRUE);		
   
   #ifdef HAVE_MOUSE
      init_mouse();
   #endif
      act.sa_handler	= interrupt_handler;
      act.sa_flags	= 0;
      sigaction(SIGINT, &act, &oldact);		
   }

   void set_inout_bits (int output_7bit_only, int input_8bit)
   {
      _D( " set_inout_bits()");
   
      aca.output_7bit_only	=  output_7bit_only;
      aca.input_8bit 		=  input_8bit;
      if (aca.input_8bit)	meta(stdscr, TRUE);
      else			meta(stdscr, FALSE);
   }

   void cur_pre_exec()
   {
      _D( " cur_pre_exec()");
   
      reset_shell_mode ();
      keypad (stdscr, FALSE);
      endwin ();
   }

   void cur_post_exec()
   {
      _D( " cur_post_exec()");
   
      reset_prog_mode ();
      doupdate();
      aca_keypad (aca.keypad);
      curs_set(0);
   }


   void screen_resizer()
   {
      struct winsize size;
   
      _D( " screen_resizer()");
   
      size.ws_row = size.ws_col = 0;
   
      ioctl(0, TIOCGWINSZ, &size); 
      if (size.ws_row && size.ws_col) {
         LINES	= size.ws_row;
         COLS	= size.ws_col;	
         resizeterm(size.ws_row, size.ws_col);
         clearok(stdscr,TRUE);
      }
      touchwin(stdscr); 
      refresh();
            
      if (aca.extra_resize) {
      	_D("CALL EXTRA RESIZE FUNC.");
      	aca.extra_resize_call_fn( aca.extra_resize_data );
      }	
   }

   static void winch_handler(int dummy)
   {
      GL_winch_flag	= TRUE;
   }


   static void interrupt_handler(int dummy)
   {
      GL_interrupt_flag = TRUE;
   }

   FILE *aca_fileopen(char *filename, char *mode, int errors)
   {
      FILE	*new;
   
      _D( " aca_fileopen()");
   
      if ((new = fopen(filename, mode)) == NULL) {
      	if (errors) 
      		ErrorOpen(filename);
      	return (FILE *) NULL;
      } 
      return new;
   }

   char *aca_loadfile(int fd, int *flag)
   {
      int		size=0, i;
      char		*fbuff, dummy[10];
      struct stat	st;
      FILE		*f;
   
      _D( " aca_loadfile()");
   
      if (fstat(fd, &st) < 0) {
      	 _D( "  bad fstat");
         return (char *) NULL;
      }
      size = st.st_size;
   
   /* Hmm.. example in /proc is st.st_size = 0, 
   	try load to memory hardly via read.. */ 
      if (!size) {
         if ((f = fdopen(fd, "r")) == NULL) { 
            _D(" can't fdopen");
            return (char *) NULL;
         }   
      /* go to end-of-file (very stupid) - needful for /proc/... */ 
         do {
            i = fread(dummy, sizeof(char), 10, f);
            size += i;
         } while(i > 0);
         rewind(f);
         if (!size) {
            _D("size of file is 0");
            return (char *) NULL;
         }  
         if ((fbuff = (char *) calloc(size+2, sizeof(char))) == NULL) {
            _D("can't calloc");
            return (char *) NULL;
         }   
         fread((void *) fbuff, size, sizeof(char), f);	
         /* replace '\0' in file string instead '\n' */
         for(i=0; i<=size; i++) {
         	if (*(fbuff+i) == '\0')
         		*(fbuff+i) = '\n';
         }
         fbuff[size] = '\0';	
         *flag = READ_LOAD;
         fclose(f);
      } 
      else {
         fbuff= (char *) mmap(0, size, PROT_READ, MAP_SHARED, fd, 0); 
         *flag = MMAP_LOAD;
      }
      return fbuff;
   }

   void aca_unloadfile(char *fbuff, int flag)
   {
      _D( " aca_unloadfile()");
   
      if (flag == READ_LOAD)
         free((void *) fbuff);
      if (flag == MMAP_LOAD)
         munmap(0, strlen(fbuff));
   }


   int lines_instr(char *str)
   {
      int	a=0;
      char	*p;
   
      _D( " lines_instr()");
   
      if (str == NULL || *str == '\0') 
         return 0;
   
      for (p = str; *p != '\0'; p++) 	
         if (*p == '\n') ++a;
      return a;
   }

/*
	Return lines number in string and set *size of longest line in string
*/	
   int linesize_instr(char *str, int *size)
   {
      int	a=0, 
      curr=0;
      char	*p;
   
      _D( " linesize_instr()");
   
      if (str == NULL || *str == '\0') 
         return 0;

      for (p = str, *size=0; *p != '\0'; p++) {
         if (*p == '\n') { 
            ++a; 
            *size = curr > *size ? curr : *size; 
            curr=0; 
         } 
         else 
            curr++;
      }
      return a;
   }

   char *get_line(char *str, int num)
   {
      int	a=0;
      char	*p, *line;
   
      _D( " get_line()");
   
      if (str == NULL || *str == '\0') 
         return NULL;
   
      for (p = str, line = str; *p != '\0'; p++) {
         if (a == num) 
            return line;
         if (*p == '\n') {
            ++a;
            if (*(line = (p+1)) == '\0')
               break;
         }
      }	
      return (char *) NULL;
   }


   int line_len(char *str)
   {
      char	*p;
      int	a;
   
      _D( " line_len()");
   
      if (str == NULL || *str == '\0' || *str == '\n') 
         return 0;
   
      for (p=str, a=0; *p!='\0' && *p!='\n'; p++, a++);
   
      return a; 		
   }

   int get_linepoz(char *str, int line, int item)
   {
      char	*p;
      int	a=0, r, i=0;
   
      _D( " get_linepoz()");
   
      for (p=str, r=0; *p!='\0'; p++, r++) {
         if (a == line) {
            if (i<item) i++;
            else 
               break;
         }
         if (*p == '\n') {
            a++;
            i = 0;
         }		
      }
      return r;		
   }

   char *separe_str(char *value, int sep)
   {
      char	*p, *content;
   
      _D( " separe_str()");
   
      if ((content = strchr(value, sep)) == NULL) 
         return (content = chN);
      *content = '\0';
      ++content;
      if ((p = strchr(content, '\n')) != NULL) 
         *p = '\0';
      return content;
   }


/* 
	(U)Set in unsigned (b) bit (n) to 0 or 1 
*/  
   void set_bit(unsigned int *b, int n, int set)
   {
      unsigned int bit_field[] = 
      { 
      0x01,      0x02,      0x04,      0x08,      0x10,      0x20,      0x40,      0x80, 
      0x0100,    0x0200,    0x0400,    0x0800,    0x1000,    0x2000,    0x4000,    0x8000,
      0x010000,  0x020000,  0x040000,  0x080000,  0x100000,  0x100000,  0x400000,  0x800000,  
      0x01000000,0x02000000,0x04000000,0x08000000,0x10000000,0x10000000,0x40000000,0x80000000  
      };
   
      _D( " set_bit()");
   
      if (set == 1) *b |= bit_field[n]; 
      else *b ^= bit_field[n]; 
   }


/* Show (n) bit in (x) */
   int show_bit(int unsigned x, int unsigned n) 
   {
      _D( " show_bit()");
   
      if (n >= sizeof(x) * ACA_BITNUM) 
         return(RE_ERROR);   
      else
         return((x >> n) & CLEAN_BIT);
   }

   void print_aca_setting(FILE *f)
  {
	fprintf(f, "\nACA SETTING:\n");
	fprintf(f, "\taca.extra_resize:\t%s\n", 	aca.extra_resize 	? "TRUE" : "FALSE");
      	fprintf(f, "\taca.line:\t%s\n", 		aca.line		? "TRUE" : "FALSE");
      	fprintf(f, "\taca.keypad:\t%s\n", 		aca.keypad		? "TRUE" : "FALSE");
      	fprintf(f, "\taca.forcekey:\t%s\n", 		aca.forcekey		? "TRUE" : "FALSE");
      	fprintf(f, "\taca.color:\t%d\n",		aca.color		);
      	fprintf(f, "\taca.getch_timeout:\t%d\n",	aca.getch_timeout	);
      	fprintf(f, "\taca.fallasleep:\t%d\n",		aca.fallasleep		);
      	fprintf(f, "\taca.fallasleep_incr:\t%d\n",	aca.fallasleep_incr	);
      	fprintf(f, "\taca.extra_timeout_call:\t%s\n",	aca.extra_timeout_call	? "TRUE" : "FALSE");  	
  	fprintf(f, "\n");
  }
