/**
 * @file Echo_Handler.cpp
 *
 * Echo_Handler.cpp,v 1.2 2004/03/24 04:57:53 bala Exp
 *
 * @author Carlos O'Ryan <coryan@atdesk.com>
 */
#include "Echo_Handler.h"


ACE_RCSID (AMI,
           Echo_Handler,
           "Echo_Handler.cpp,v 1.2 2004/03/24 04:57:53 bala Exp")


Echo_Handler::Echo_Handler(void)
  : replies_ (0)
{
}

void
Echo_Handler::echo_operation (char const *
                              ACE_ENV_ARG_DECL_NOT_USED)
  ACE_THROW_SPEC((CORBA::SystemException))
{
  ++this->replies_;
}

void
Echo_Handler::echo_operation_excep (Test::AMI_EchoExceptionHolder *
                                    ACE_ENV_ARG_DECL_NOT_USED)
  ACE_THROW_SPEC((CORBA::SystemException))
{
}

void
Echo_Handler::shutdown (ACE_ENV_SINGLE_ARG_DECL_NOT_USED)
  ACE_THROW_SPEC((CORBA::SystemException))
{
}

void
Echo_Handler::shutdown_excep (Test::AMI_EchoExceptionHolder *
                              ACE_ENV_ARG_DECL_NOT_USED)
  ACE_THROW_SPEC((CORBA::SystemException))
{
}

CORBA::ULong
Echo_Handler::replies (void) const
{
  return this->replies_;
}
