#include "tao/LF_CH_Event.h"

ACE_RCSID(tao,
          LF_Invocation_Event,
          "$Id: LF_CH_Event.cpp 72638 2006-05-14 02:38:11Z mesnier_p $")

TAO_BEGIN_VERSIONED_NAMESPACE_DECL

TAO_LF_CH_Event::TAO_LF_CH_Event (void)
  : TAO_LF_Event (),
    prev_state_ (TAO_LF_Event::LFS_IDLE)

{
}

TAO_LF_CH_Event::~TAO_LF_CH_Event (void)
{
}

void
TAO_LF_CH_Event::state_changed_i (int new_state)
{
  if (this->state_ == new_state)
    return;

    // Validate the state change
  if (this->state_ == TAO_LF_Event::LFS_IDLE)
    {
      // From the LFS_IDLE state we can only become active.
      if (new_state == TAO_LF_Event::LFS_CONNECTION_WAIT)
        {
          this->prev_state_ = this->state_;
          this->state_ = new_state;
        }
      return;
    }
  else if (this->state_ == TAO_LF_Event::LFS_CONNECTION_WAIT)
    {
      // Only a few states are possible from CONNECTION_WAIT states
      if (new_state == TAO_LF_Event::LFS_CONNECTION_CLOSED
          || new_state == TAO_LF_Event::LFS_SUCCESS)
        {
          this->prev_state_ = this->state_;
          this->state_ = new_state;
        }

      return;
    }
  else if (this->state_ == TAO_LF_Event::LFS_SUCCESS)
    {
      if (new_state == TAO_LF_Event::LFS_CONNECTION_CLOSED)
        {
          this->prev_state_ = this->state_;
          this->state_ = new_state;
        }
      return;
    }
  else if (this->state_ == TAO_LF_Event::LFS_TIMEOUT)
    {
      if (new_state == TAO_LF_Event::LFS_CONNECTION_CLOSED)
        {
          // Dont reset the previous state
          this->state_ = new_state;
        }
    }
  return;
}


int
TAO_LF_CH_Event::successful (void) const
{
  if (this->prev_state_ == TAO_LF_Event::LFS_CONNECTION_WAIT)
    return this->state_ == TAO_LF_Event::LFS_SUCCESS;

  return this->state_ == TAO_LF_Event::LFS_CONNECTION_CLOSED;
}

int
TAO_LF_CH_Event::error_detected (void) const
{
  if (this->prev_state_ == TAO_LF_Event::LFS_CONNECTION_WAIT)
    return this->state_ == TAO_LF_Event::LFS_CONNECTION_CLOSED;

  return this->state_ == TAO_LF_Event::LFS_TIMEOUT;
}

void
TAO_LF_CH_Event::set_state (int new_state)
{
  // @@ NOTE: Is this still required?
  if (this->is_state_final () == 0
      && new_state == TAO_LF_Event::LFS_TIMEOUT)
    {
      this->state_ = new_state;
    }
}

int
TAO_LF_CH_Event::is_state_final (void)
{
  return this->state_ == TAO_LF_Event::LFS_CONNECTION_CLOSED;
}

TAO_END_VERSIONED_NAMESPACE_DECL
