/* -*- c++ -*- */

//=============================================================================
/**
 *  @file    be_eventtype.h
 *
 *  $Id: be_eventtype.h 89076 2010-02-18 22:54:36Z parsons $
 *
 *  Extension of class AST_EventType and be_valuetype that provides
 *  additional means for C++ mapping of an valuetype.
 *
 *
 */
//=============================================================================

#ifndef TAO_BE_EVENTTYPE_H
#define TAO_BE_EVENTTYPE_H

#include "be_valuetype.h"
#include "ast_eventtype.h"

class be_eventtype : public virtual be_valuetype,
                     public virtual AST_EventType
{
  // = TITLE
  //    Backend-class for eventtypes
  //
  // = DESCRIPTION
  //    Extends be_valuetype.
  //
public:
  be_eventtype (UTL_ScopedName *n,
                AST_Type **inherits,
                long n_inherits,
                AST_Type *inherits_concrete,
                AST_Interface **inherits_flat,
                long n_inherits_flat,
                AST_Type **supports,
                long n_supports,
                AST_Type *supports_concrete,
                bool abstract,
                bool truncatable,
                bool custom);

  ~be_eventtype (void);

  // Visiting.
  virtual int accept (be_visitor *visitor);

  // Cleanup.
  virtual void destroy (void);

  // Narrowing.
  DEF_NARROW_FROM_DECL (be_eventtype);
  DEF_NARROW_FROM_SCOPE (be_eventtype);
};

#endif  // if !defined
