// $Id: Port_Activator_T.cpp 92267 2010-10-20 07:21:45Z johnnyw $

#ifndef CIAO_PORT_ACTIVATOR_T_CPP
#define CIAO_PORT_ACTIVATOR_T_CPP

#include "Port_Activator_T.h"
#include "tao/CORBA_String.h"

#include "ace/OS_NS_string.h"

namespace CIAO
{
  template <typename SERV,
            typename EXEC,
            typename CONTEXT,
            typename COMP_SERV>
  Port_Activator_T<SERV, EXEC, CONTEXT, COMP_SERV>::Port_Activator_T (
      const char *oid,
      const char *name,
      Port_Activator_Types::Type t,
      typename EXEC::_ptr_type e,
      typename CONTEXT::_ptr_type c,
      COMP_SERV *cc)
    : Port_Activator_i (oid, name, t)
    , executor_ (EXEC::_duplicate (e))
    , context_ (CONTEXT::_duplicate (c))
    , comp_serv_ (cc)
  {
  }

  template <typename SERV,
            typename EXEC,
            typename CONTEXT,
            typename COMP_SERV>
  void
  Port_Activator_T<SERV, EXEC, CONTEXT, COMP_SERV>::deactivate (
      PortableServer::Servant servant, CORBA::Boolean)
  {
    SERVANT *s = dynamic_cast<SERVANT *> (servant);
    if (s)
      {
        s->_remove_ref ();
      }
  }

  template <typename SERV,
            typename EXEC,
            typename CONTEXT,
            typename COMP_SERV>
  PortableServer::Servant
  Port_Activator_T<SERV, EXEC, CONTEXT, COMP_SERV>::activate (
      const PortableServer::ObjectId &oid)
  {
    CORBA::String_var str = PortableServer::ObjectId_to_string (oid);

    // An additional check, may not be necessary. Being on the safe
    // side.
    if (ACE_OS::strcmp (this->oid_.in (), str.in ()) == 0)
      {
        if (this->t_ == Port_Activator_Types::FACET && ::CORBA::is_nil (this->executor_.in ()))
          {
            ::CORBA::Object_var tmp =
              this->comp_serv_->get_facet_executor (this->name_.in ());

            this->executor_ = EXEC::_narrow (tmp.in ());
          }

        SERVANT *s = 0;

        ACE_NEW_THROW_EX (s,
                          SERVANT (this->executor_.in (),
                                   this->context_.in ()),
                          ::CORBA::NO_MEMORY ());

        return s;
      }

    throw ::CORBA::OBJECT_NOT_EXIST ();
  }
}

#endif /*SERVANT_ACTIVATOR_T_CPP*/
