<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000, 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: routines to manipulate shared state (session
 *          information)   
 *
 */

function InitArray(&$a, $dim1, $dim2, $value)
{
   $a = "";
   /* determine the number of dimensions in the array */
   if ( $dim2 == 0 )   /* 1-dim */
      for ( $i = 0; $i < $dim2; $i++ ) 
         $a[$i] = $value;
   else                /* 2-dim */
      for ( $i = 0; $i < $dim1; $i++ )
         for ( $j = 0; $j < $dim2; $j++ )
            $a[$i][$j] = $value;
}

function InitGlobalState()
{
  GLOBAL $time, $time_cnt, $sig, $sig_class, $sensor, $ag,
         $ip_addr, $ip_addr_cnt, $ip_field, $ip_field_cnt,
         $tcp_port, $tcp_port_cnt, $tcp_flags, $tcp_field, $tcp_field_cnt,
         $udp_port, $udp_port_cnt, $udp_field, $udp_field_cnt,
         $icmp_field, $icmp_field_cnt,
         $have_meta, $have_ip, $have_tcp, $have_udp, $have_icmp, $have_data,
         $layer4, $data, $data_cnt, $data_encode, $save_criteria,
         $join_sql, $where_sql, $criteria_sql, $sql, $debug_mode, 
         $back_list, $back_list_cnt;
   GLOBAL $MAX_ROWS;

   $caller = "";
   $layer4 = "";

   InitArray($back_list, 1, 3, "");
   $back_list_cnt = 0;

   $ag = "";
   $sensor = "";
   InitArray($sig, 3, 0, ""); 
   $sig_class = "";
   InitArray($time, $MAX_ROWS, TIME_CFCNT, "");
   $time_cnt = 0;

   InitArray($ip_addr, $MAX_ROWS, IPADDR_CFCNT, "");
   $ip_addr_cnt = 0;
   InitArray($ip_field, $MAX_ROWS, PROTO_CFCNT, "");  
   $ip_field_cnt = 0;

   InitArray($tcp_port, $MAX_ROWS, PROTO_CFCNT, "");
   $tcp_port_cnt = 0;
   InitArray($tcp_flags, $MAX_ROWS, TCPFLAGS_CFCNT, "");
   InitArray($tcp_field, $MAX_ROWS, PROTO_CFCNT, "");
   $tcp_field_cnt = 0;

   InitArray($udp_port, $MAX_ROWS, PROTO_CFCNT, "");
   $udp_port_cnt = 0;
   InitArray($udp_field, $MAX_ROWS, PROTO_CFCNT, "");
   $udp_field_cnt = 0;

   InitArray($icmp_field, $MAX_ROWS, PROTO_CFCNT, "");
   $icmp_field_cnt = 0;

   InitArray($data_encode, 2, 0, "");
   InitArray($data, $MAX_ROWS, PAYLOAD_CFCNT, "");
   $data_cnt = 0;
}

function RegisterGlobalState()
{
  GLOBAL $time, $time_cnt, $sig, $sensor, $ag,
         $ip_addr, $ip_addr_cnt, $ip_field, $ip_field_cnt,
         $tcp_port, $tcp_port_cnt, $tcp_flags, $tcp_field, $tcp_field_cnt,
         $udp_port, $udp_port_cnt, $udp_field, $udp_field_cnt,
         $icmp_field, $icmp_field_cnt,
         $have_meta, $have_ip, $have_tcp, $have_udp, $have_icmp, $have_data,
         $layer4, $data, $data_cnt, $data_encode, $save_criteria,
         $join_sql, $where_sql, $criteria_sql, $sql, $debug_mode,
         $back_list, $back_list_cnt;

   GLOBAL $MAX_ROWS;

   session_start();

   session_register('back_list');
   session_register('back_list_cnt');
   session_register('layer4');

   session_register('ag');
   session_register('sig_type');
   session_register('sig');
   session_register('sig_class');
   session_register('sensor');
   session_register('time');
   session_register('time_cnt');

   session_register('ip_addr');
   session_register('ip_addr_cnt');
   session_register('ip_field');
   session_register('ip_field_cnt');

   session_register('tcp_port');
   session_register('tcp_port_cnt');
   session_register('tcp_flags');
   session_register('tcp_field');
   session_register('tcp_field_cnt');

   session_register('udp_port');
   session_register('udp_port_cnt');
   session_register('udp_field');
   session_register('udp_field_cnt');

   session_register('icmp_field');
   session_register('icmp_field_cnt');

   session_register('data_encode');
   session_register('data');
   session_register('data_cnt');

   if ( $debug_mode > 0 )
      echo '<FONT COLOR="#FF0000">Session Registered</FONT><BR>';
}

function ImportGlobalState()
{
  GLOBAL $time, $time_cnt, $sig, $sig_type, $sig_class, $sensor, $ag,
         $ip_addr, $ip_addr_cnt, $ip_field, $ip_field_cnt,
         $tcp_port, $tcp_port_cnt, $tcp_flags, $tcp_field, $tcp_field_cnt,
         $udp_port, $udp_port_cnt, $udp_field, $udp_field_cnt,
         $icmp_field, $icmp_field_cnt,
         $have_meta, $have_ip, $have_tcp, $have_udp, $have_icmp, $have_data,
         $layer4, $data, $data_cnt, $data_encode, $save_criteria,
         $join_sql, $where_sql, $criteria_sql, $sql, $debug_mode,
         $caller, $layer4, $back_list, $back_list_cnt, $HTTP_SESSION_VARS;

      $ip_addr = SetSessionVar('ip_addr', $ip_addr);
      $ip_addr_cnt = SetSessionVar('ip_addr_cnt', $ip_addr_cnt);

      /* expand IP into octets */
      for ( $i = 0; $i < $ip_addr_cnt; $i++ )
      {
        if ( (isset ($ip_addr[$i][3])) &&
             (ereg("([0-9]*)\.([0-9]*)\.([0-9]*)\.([0-9]*)", $ip_addr[$i][3])) )
        {
           $tmp_ip_str = $ip_addr[$i][7] = $ip_addr[$i][3];
           $ip_addr[$i][3] = strtok($tmp_ip_str, ".");
           $ip_addr[$i][4] = strtok(".");
           $ip_addr[$i][5] = strtok(".");
           $ip_addr[$i][6] = strtok("/");
           $ip_addr[$i][10] = strtok("");
        }
      } 

      //$back_list = $HTTP_SESSION_VARS["back_list"];
      //$back_list_cnt = $HTTP_SESSION_VARS["back_list_cnt"];

      $ag = SetSessionVar("ag", $ag);
      $sig = SetSessionVar("sig", $sig);
      $sig_type = SetSessionVar("sig_type", $sig_type);
      $sig_class = SetSessionVar("sig_class", $sig_class);
      $sensor = SetSessionVar('sensor', $sensor);
      $time = SetSessionVar('time', $time);
      $time_cnt = SetSessionVar('time_cnt', $time_cnt);

      $ip_field = SetSessionVar('ip_field', $ip_field);
      $ip_field_cnt = SetSessionVar('ip_field_cnt', $ip_field_cnt);

      $tcp_port = SetSessionVar('tcp_port', $tcp_port);
      $tcp_port_cnt = SetSessionVar('tcp_port_cnt', $tcp_port_cnt);
      $tcp_flags = SetSessionVar('tcp_flags', $tcp_flags);
      $tcp_field = SetSessionVar('tcp_field', $tcp_field);
      $tcp_field_cnt = SetSessionVar('tcp_field_cnt', $tcp_field_cnt);

      $udp_port = SetSessionVar('udp_port', $udp_port);
      $udp_port_cnt = SetSessionVar('udp_port_cnt', $udp_port_cnt);
      $udp_field = SetSessionVar('udp_field', $udp_field);
      $udp_field_cnt = SetSessionVar('udp_field_cnt', $udp_field_cnt);

      $icmp_field = SetSessionVar('icmp_field', $icmp_field);
      $icmp_field_cnt = SetSessionVar('icmp_field_cnt', $icmp_field_cnt);

      $data_encode = SetSessionVar('data_encode', $data_encode);
      $data = SetSessionVar('data', $data);
      $data_cnt = SetSessionVar('data_cnt', $data_cnt);

      $layer4 = SetSessionVar('layer4', $layer4);
      //$caller = SetSessionVar('caller', $caller);
      // $sort_order = SetSessionVar('sort_order', $sort_order);
}

function SanitizeVariable($item, $validchars)
{
   $len = strlen($item);

   for ( $i = 0; $i < $len; $i++ );
      
}

function CleanVariable($item, $method)
{
   return $item;
   switch ($method)
   {
      case 0:     /* only numbers */
         return ereg_replace ("^0123456789", "", $item);

      case 1:     /* IP address */
         return ereg_replace ("^0123456789\.", "", $item);
   }

}

function SetSessionVar($var_name, $old_value)
{
   GLOBAL $HTTP_POST_VARS, $HTTP_GET_VARS, $debug_mode;

   if ( isset($HTTP_POST_VARS[$var_name]) ) 
   {
      if ( $debug_mode > 0 )  echo "importing POST var '$var_name'<BR>";
      return $HTTP_POST_VARS[$var_name];
   }
   else if ( isset($HTTP_GET_VARS[$var_name]) )
   { 
      if ( $debug_mode > 0 )  echo "importing GET var '$var_name'<BR>";
      return $HTTP_GET_VARS[$var_name];
   }
   else
      return $old_value;  
}

function ImportHTTPVar($var_name)
{
   GLOBAL $HTTP_POST_VARS, $HTTP_GET_VARS, $debug_mode;

   if ( isset($HTTP_POST_VARS[$var_name]) ) 
   {
      //if ( $debug_mode > 0 )  echo "importing POST var '$var_name'<BR>";
      return $HTTP_POST_VARS[$var_name];
   }
   else if ( isset($HTTP_GET_VARS[$var_name]) )
   { 
      //if ( $debug_mode > 0 )  echo "importing GET var '$var_name'<BR>";
      return $HTTP_GET_VARS[$var_name];
   }
   else
      return "";  
}

function ExportHTTPVar ($var_name, $var_value)
{
  echo "<INPUT TYPE=\"hidden\" NAME=\"$var_name\" VALUE=\"$var_value\">\n";
}

?>
