(in-package "ACL2")

;Necessary definitions:

(DEFUN FL (X) (FLOOR X 1))
(in-theory (disable fl))

(local (include-book "fl2"))

(defun or-dist-induct (y n)
  (if (and (integerp n) (>= n 0))
      (if (= n 0)
	  y
	(or-dist-induct (fl (/ y 2)) (1- n)))
    ()))

(defun log-induct (i j)
  (if (and (integerp i) (>= i 0)
	   (integerp j) (>= j 0))
      (if (or (= i 0) (= j 0))
	  ()
	(log-induct (fl (/ i 2)) (fl (/ j 2))))
    ()))

(DEFUN logand-three-args-induct (I J K)
  (declare (xargs :measure (ACL2-COUNT (abs i))
                  :hints (("Goal" :in-theory (enable abs)))))
  (IF (AND (INTEGERP I)
           (INTEGERP J)
           (INTEGERP K)
           )
      (IF (OR (= I 0) (= J 0) (= K 0)
              (= I -1) (= J -1) (= K -1))
          NIL
          (logand-three-args-induct
           (FL (/ I 2))
           (FL (/ J 2))
           (FL (/ K 2))))
      NIL))


(DEFUN LOG-INDUCT-allows-negatives (i j)
  (IF (AND (INTEGERP i)
           (INTEGERP j)
           )
      (IF (OR (= i 0) (= j 0) (= i -1) (= j -1))
          NIL
          ( LOG-INDUCT-allows-negatives (FL (/ i 2)) (FL (/ j 2))))
      NIL))

(defun op-dist-induct (i j n)
  (if (and (integerp n) (>= n 0))
      (if  (= n 0)
	  (list i j)
	(op-dist-induct (fl (/ i 2)) (fl (/ j 2)) (1- n)))
    ()))