(in-package "ACL2")

;setbits should include setbits2, not the other way around, as currently
;this book shouldn't include merge?

(include-book "rtl")

(local (include-book "arith2"))
(local (include-book "bits2"))
(local (include-book "cat"))
;(local (include-book "ash"))
(local (include-book "bits"))
;(local (include-book "integerp"))
;(local (include-book "expt2"))
;(local (include-book "expt"))
;(local (include-book "fl2"))
;(local (include-book "mod2"))

;the new outer call to bits only effects things if the indices i,j are bad.
;it forces setbits to return something of the advertised size w
(defun setbits (x w i j y)
  (bits (cat (bits x (1- w) (1+ i))
             (cat (bits y (- i j) 0)
                  (bits x (1- j) 0)
                  j)
             (1+ i))
        (1- w)
        0))

#| old defn
(defun setbits (x i j y)
  (cat (cat (ash x (- (1+ i)))
	    y
	    (1+ (- i j)))
       (bits x (1- j) 0)
       j))
|#

(in-theory (disable setbits))

(defthm setbits-nonnegative-integer-type
  (and (integerp (setbits x w i j y))
       (<= 0 (setbits x w i j y)))
  :hints (("Goal" :in-theory (enable setbits)))
  :rule-classes (:type-prescription)
  )

;this rule is no better than setbits-nonnegative-integer-type and might be worse:
(in-theory (disable (:type-prescription setbits)))

(defthm setbits-natp
  (natp (setbits x w i j y)))

;could gen this somewhat?
;nicer proof?
(defthm setbits-upper-bound
  (< (setbits x w i j y) (expt 2 w))
  :otf-flg t
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable setbits)
                              '(BITS-UPPER-BOUND BITS-UPPER-BOUND-2))
           :use (:instance BITS-UPPER-BOUND
                           (x (cat (bits x (1- w) (1+ i))
                                   (cat (bits y (- i j) 0)
                                        (bits x (1- j) 0)
                                        j)
                                   (1+ i)))
                           (i (+ -1 w))
                           (j 0)))))

;it may happen that setbitn is called with an index which is a signal rather than a constant.
;in that case, we probably don't want it to expand to setbits. 
;thus, we always expect the indices in setbits calls to be constants

(local (include-book "merge"))

;all hyps are about indices and should always be true
;could eventually drop some hyps?
(defthm setbits-rewrite
  (implies (and (syntaxp (not (and (quotep j) (equal (cadr j) 0)))) ;setbits-rewrite-2 handles this
                (case-split (natp i))
                (case-split (natp j))
                (case-split (natp w))
;                (case-split (<= 1 w))
                (case-split (< i w))
                (case-split (<= j i))
                )
  (equal (setbits x w i j y)
         (cat (bits x (1- w) (1+ i))
              (cat (bits y (- i j) 0)
                   (bits x (1- j) 0)
                   j)
              (+ 1 i))))
  :hints (("Goal" :in-theory (enable natp setbits bits-bits))))

;when j is 0, there is no lower part of x.
;all hyps are about indices and should always be true
;could eventually drop some hyps?
(defthm setbits-rewrite-when-j-is-0
  (implies (and (case-split (natp i))
                (case-split (natp w))
                (case-split (<= 1 w))
                (case-split (< i w)))
           (equal (setbits x w i 0 y) ;note the 0
                  (cat (bits x (1- w) (1+ i))
                       (bits y i 0)
                       (+ 1 i))))
  :hints (("Goal" :in-theory (enable setbits))))

(defthm setbits-bvecp-simple
  (bvecp (setbits x w i j y) w)
  :hints (("goal" :use setbits-upper-bound
           :in-theory (set-difference-theories
                       (enable bvecp)
                       '(setbits-upper-bound)))))

(local (include-book "bvecp"))

(defthm setbits-bvecp
  (implies (and (<= w k)
                (case-split (integerp k))
                )
           (bvecp (setbits x w i j y) k))
  :hints (("goal" :use setbits-bvecp-simple
           :in-theory (disable setbits-bvecp-simple))))

#|

;wow.  there must be a nicer proof without enabling so much
(defthm setbits-does-nothing
  (implies (and (case-split (integerp x))
                (case-split (<= 0 x))
                (case-split (integerp i))
                (case-split (integerp j))
                (case-split (<= 0 j)) ;gen?
                (case-split (<= j i))
                (case-split (natp w))
                )
           (equal (setbits x w i j (bits x i j))
                  x))
  :hints (("Goal" :in-theory (enable setbits))))

  :hints (("Goal" :use ((:instance fl-def-linear-part-1 (x (* 1/2 X (/ (EXPT 2 I)))))
                        (:instance fl-def-linear-part-1 (x (* X (/ (EXPT 2 J))))))
           :in-theory (set-difference-theories
                       (enable ;expt-split
                               setbits
                               ;cat
                               ;ash
                               ;bits
                               ;mod
                               )
                       '(fl-def-linear FL-DEF-LINEAR-PART-1 FL-DEF-LINEAR-QUOTIENT
                                       FL-WEAK-MONOTONE
                                       LESS-THAN-MULTIPLY-THROUGH-BY-FRACCOEFF-FROM-LEFT-HAND-SIDE)
                       ))))

|#

#| old, prove the two match for bvecps
(defun oldsetbits (x i j y)
  (cat (cat (ash x (- (1+ i)))
	    y
	    (1+ (- i j)))
       (bits x (1- j) 0)
       j))

;we had this before
(skip-proofs
(defthm oldsetbits-rewrite-1
    (implies (and (bvecp x n)
		  (natp n)
		  (> n 0)
		  (natp i)
		  (natp j)
		  (<= j i)
		  (bvecp y (1+ (- i j))))
	     (equal (oldsetbits x i j y)
		    (cat (cat (bits x (1- n) (1+ i))
			      y
			      (1+ (- i j)))
			 (bits x (1- j) 0)
			 j)))))

(defthm setbits-match
  (implies (and (bvecp x n)
                (natp n)
                (> n 0)
                (natp w)
                (<= n w)
                (bvecp y (1+ (- i j)))
                (natp i)
                (natp j)
                (<= j i))
           (equal (oldsetbits x i j y)
                  (setbits x w i j y)))
  :otf-flg t
  :hints (("Goal" :in-theory (enable setbits oldsetbits bits-does-nothing
                                     natp))))

|#