(defconst *tilde-replacement-table*
  '(("~l["        . "~lxxxxx[") ;"See :DOC ~sa"
    ("~pl["       . "~plxxxx[") ;"see :DOC ~sa"

; and now, the ones that are too long:

    ("~-[]"       . "~9")
    ("~ilc["      . "~0")
    ("~terminal[" . "~1")
    ("~bv[]"      . "~2")
    ("~ev[]"      . "~3")
    ("~bf[]"      . "~4")
    ("~ef[]"      . "~5")
    ("~bq[]"      . "~6")
    ("~eq[]"      . "~7")
    ("~c["        . "~8")))

; Note:  it's important that replacement always works from the end towards the
; beginning, not the other way around.  At one time there was a bug because we
; saved the end of the paragraph before starting the replacements, and by the
; time we got near the end of the paragraph, the end point had changed.

(defun replace-tildes (old-string replacement beg)
  (goto-char beg)
  (forward-paragraph)
  (let (point)
    (while (and (< beg (point))
                (setq point (and (search-backward old-string beg t)
                                 ;; For compatibility with emacs 18:
				 (point))))
      (replace-match replacement t t)
      (goto-char point))))

(defconst *acl2-doc-fill-column* 68)

(defun tilde-fill-prefix ()
  (save-excursion
    (beginning-of-line)
    (let ((saved-point (point)))
      (re-search-forward "[^ ]")
      (buffer-substring saved-point (1- (point))))))

(defun fill-wrt-tildes ()
  (interactive)
  (save-excursion
    (let ((fill-prefix (tilde-fill-prefix)))
      (let ((fill-column (+ (length fill-prefix) *acl2-doc-fill-column*))
            (tab *tilde-replacement-table*)
            entry
            (beg (progn (forward-char) (backward-paragraph) (point))))
        (while tab
          (setq entry (car tab))
          (setq tab (cdr tab))
          (replace-tildes (car entry) (cdr entry) beg))
        (goto-char beg)
        (forward-char 1)
        (fill-paragraph nil)
        (let ((tab *tilde-replacement-table*))
          (while tab
            (setq entry (car tab))
            (setq tab (cdr tab))
            (replace-tildes (cdr entry) (car entry) beg)))))))
