#ifndef MULTISLIDER_H
#define MULTISLIDER_H

#include <stdio.h>
#include <stdlib.h>
#include <QtWidgets/QSlider>
#include "model.h"
#include "modslider.h"

class MultiSlider : public ModSlider
{
  Q_OBJECT

  private:
    Model *model; 
    int numLayer, layer;  
    int *buf, *modBuf[MAX_POLY];  

  public:
    MultiSlider(Model *p_model, int p_numLayer, Qt::Orientation orientation, QWidget* parent=0);
    ~MultiSlider();
    void setLayer(int p_layer);
    int getLayer();
    void readBufValue(int p_layer, int& p_value, int& p_modValue);
    void writeBufValue(int p_layer, int p_value, int p_modValue);
    void readBufValue(int p_layer, int& p_value, int voiceIndex, int& p_modValue);
    void writeBufValue(int p_layer, int p_value, int voiceIndex, int p_modValue);
    void updateSlider();

  protected:
    virtual void sliderChange(SliderChange change);
    
  public slots:
    void writeValue(int p_value, int p_modValue);  
};
  
#endif
