#ifndef VOICESYNTH_H
#define VOICESYNTH_H

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <QtCore/QThread>
#include "voicedata.h"
#include "model.h"

class VoiceSynth : public QThread
{
  Q_OBJECT

  private:
    Model *model;
    VoiceData *voiceData;
    double *shbuf[MAX_PARAMS];
    double *modelFilter[2];
    double *a, *a1, *a2, *da;
    double *f[2];
    double pb, pb1, pb2, dpb, lfo, lfo1, lfo2, dlfo;
    double v1, v2, v, dv;
    int bufIndex;
    int noise_note;

  public:
    double *dbuf[2], *vbuf;

  protected:
    void initVoiceSynth();
    void envStep();
    void filterStep(int filterIndex, int harmonicIndex);
    virtual void run();

  public:
    VoiceSynth(Model *p_model, QThread *parent=0);
    ~VoiceSynth();
    void loadVoiceData(int index);
};
  
#endif
