#include <stdio.h>
#include <stdlib.h>
#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtGui/QColor>
#include <QtWidgets>
#include <QtXml/QXmlContentHandler>
#include "voicedata.h"
#include "xmlhandler.h"

XmlHandler::XmlHandler(Model *p_model, int p_voiceIndex) : QXmlDefaultHandler() {

  token << "MasterVolume" << "PitchLfoFreq" << "PitchLfoDepth" << "Morphing" << "Compressor" << "Panning" << "PanMode" << "EvenOdd" << "Noise";
  token << "NoiseSubHarmonicMode" << "NoiseFreqDiffusion" << "Osc3Mode" << "Osc3FreqDiffusion" << "Detune" << "VolumeTracking" << "VelocityDepth" << "offsetDetune";
  token << "SpectrumOffset" << "SpectrumSpacing" << "SpectrumOffsetIndex" << "SpectrumSpacingIndex" << "HarmonicSplit";
  token << "Scale" << "ControlPointY" << "H" << "FilterMix" << "FilterMixSwitch";
  token << "Cutoff" << "Spacing" << "KeyTracking" << "FilterDepth" << "FilterCutoffIndex" << "FilterSpacingIndex" << "FilterTrackingIndex" << "F";
  token << "FilterMod" << "FilterModSwitch" << "TEXT";
  model = p_model;
  voiceIndex = p_voiceIndex;
  index1 = 0;
  index2 = 0;
  index3 = 0;
  tokenCode = NONE;
  parameterFlag = false;
  sourceFlag = false;
  filterFlag = false;
  filterModFlag = false;
  controlGroupFlag = false;
}

XmlHandler::~XmlHandler() {

}

bool XmlHandler::startDocument() {

  return(true);
}

bool XmlHandler::endDocument() {

  return(true);
}

bool XmlHandler::startElement(const QString &namespaceURI, const QString &localName, const QString &qName, const QXmlAttributes &atts) {

  int i1;

  QStringList qsl = qName.split("_");
  tokenCode = NONE;
  for (i1 = 0; i1 < token.count(); i1++) {
    if (qsl.at(0).compare(token.at(i1)) == 0) {
      tokenCode = tokenCodeEnum(i1);
      if (qsl.count() > 1) { 
        index2 = qsl.at(1).toInt();
      }  
    }
  }
  if (qsl.at(0).compare("Parameter") == 0) {
    parameterFlag = true;
    index1 = qsl.at(1).toInt();
  }
  if (qsl.at(0).compare("Source") == 0) {
    sourceFlag = true;
    index1 = qsl.at(1).toInt();
  }
  if (qsl.at(0).compare("Filter") == 0) {
    filterFlag = true;
    index1 = qsl.at(1).toInt();
  }
  if (qsl.at(0).compare("FilterModulation") == 0) {
    filterModFlag = true;
    index1 = qsl.at(1).toInt();
  }
  if (qsl.at(0).compare("ControlGroup") == 0) {
    controlGroupFlag = true;
    index3 = qsl.at(1).toInt();
  }
  return(true);
}

bool XmlHandler::endElement(const QString &namespaceURI, const QString &localName, const QString &qName) {

  QStringList qsl = qName.split("_");
  
  if (parameterFlag && (qsl.at(0).compare("Parameter") == 0)) {
    parameterFlag = false;
  }
  if (sourceFlag && (qsl.at(0).compare("Source") == 0)) {
    sourceFlag = false;
  }
  if (filterFlag && (qsl.at(0).compare("Filter") == 0)) {
    filterFlag = false;
  }
  if (filterModFlag && (qsl.at(0).compare("FilterModulation") == 0)) {
    filterModFlag = false;
  }
  if (controlGroupFlag && (qsl.at(0).compare("ControlGroup") == 0)) {
    controlGroupFlag = false;
  }
  tokenCode = NONE;
  return(true);
}

bool XmlHandler::characters(const QString &ch) {

  VoiceData *vd;
  int vStart, vEnd;

  model->getEditRange(vStart, vEnd);
  vd = model->getVoiceData(voiceIndex);
  if (tokenCode == TEXT) {
    vd->setComment(ch);
  } else {
    model->sendXmlData(tokenCode, index1, index2, index3, voiceIndex, ch.toDouble()); 
  }  
  return(true);
}
