#!/usr/bin/perl -w
#
# $Id: s.PluginLoader.pm 1.10 03/08/17 14:50:22+02:00 liar@furrynet.org $
# 
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License Version 2 as
#  published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
#  USA.
#
# This file is part of adduser-ng program.
#
# Copyright (C) 2003 Bartosz Oler <liar@bzimage.us>
# Copyright (C) 2003 Robert Olejnik <robert@zaron.debian.pl>
#

package AddUser::PluginLoader;

use strict;
require Exporter;
use Carp;

our @ISA=qw(Exporter);
our @EXPORT=qw(load_workplugins);

our $VERSION = '0.0.1';


sub new {
        my ($c, %args) = @_;
        my $class = ref($c) || $c;

        if (not exists $args{'plugins_dir'}) {
                croak ("Error: plugins dir not specified.\n");
        }
        
        bless \%args, $class;
}


# load_workplugins($dir, @list)
#
# Load WorkPlugins given in @list.
# 
# {{{

sub load_workplugins {
        my ($self, @plugins_list) = @_;
	my @plugins;
        my @dirs;
        my $load;

        @dirs = split(qw(/), $self->{plugins_dir});
        $load = join("::", @dirs);

	for my $plug (@plugins_list) {
		print "Loading ${load}::${plug}'\n" if $self->{verbose};

                my $p = eval {
	                do "$self->{plugins_dir}/$plug.pm";
			my $p = "${load}::${plug}"->new(plugins_options => $self->{'plugins_options'});
		};

		if ($@) {
			print "ERROR: Unable to load plugin: $plug\n";
			print $@ if $self->{verbose};
                        print "Or maybe you gave wrong 'plugins_dir' value. Please check this first.\n";
		} else {
			push(@plugins, $p);
			print "OK: Loaded plugin: $plug\n" if $self->{verbose};
		}
	}
	return @plugins;
}
# }}}


1;

__END__

=head1 NAME

AddUser::plugins - AddUser module for loading plugins

=head1 SYNOPSIS

    use AddUser::PluginLoader;
    
    my $ph = new AddUser::PluginLoader( plugins_dir => '/path/to/plugins/directory', plugins_options => \%options, verbose => 0 );
    my @plugins = $ph->load_workplugins(@list_of_plugins_to_load);

    foreach my $plugin (@plugins) {
        $plugin->method_in_plugin();
    }

=head1 DESCRIPTION

    This module is part of adduser-ng program.

    This module makes it possible to use extensions (plugins) for programs
    written in perl. Of course you can write perl modules, but if you use
    this module you'll get same effort quicker and in a very simple way,
    and besides, not always writing perl modules is a good idea (as in case of
    adduser-ng program).

    ...

    Write the rest ;)

=head1 AUTHORS

Bartosz Oler   E<lt>F<liar@bzimage.us>E<gt>
Robert Olejnik E<lt>F<robert@zaron.debian.pl>E<gt>

=cut



