#!/usr/bin/perl -w
#
# $Id: s.StdLib.pm 1.15 03/10/19 17:03:18+02:00 liar@furrynet.org $
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License Version 2 as
#  published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
#  USA.
#
# This file is part of adduser-ng program.
#
# Copyright (C) 2003 Bartosz Oler <liar@bzimage.us>
# Copyright (C) 2003 Robert Olejnik <robert@zaron.debian.pl>
#

package AddUser::StdLib;

use strict;
require Exporter;
use Carp;
use POSIX;
use XML::Simple;

use AddUser::GroupConfig;

our @ISA=qw(Exporter);
our @EXPORT=qw(%ERRNO wrapper_getlong wrapper_getsingle wrapper_getpassword get_documentation create_file au_move);

our %ERRNO = (
	OK => 0,
	ERROR => 1,
	NOGROUPGIVEN => 2,
	NOSUCHGROUP => 3,
	NOTROOT => 4,
	APIVERSION => 5,
        WRONG_KEYWORD => 6,
	DONE => 7,
);

# wrapper_getlong($self, $plugin_name, $option_name)
#
# Get value for option $option_name.
#
# {{{
#
# Value is stored in object's structure ($self) and also returned.
#
# If option is not defined in the configuration then use $UI->get_long
# to ask user.

sub wrapper_getlong
{
	my $self     = shift;
	my $plugname = shift;
	my $optname  = shift;
        my $ui       = $self->{plugins_options}{UI};
        my $verbose  = $self->{plugins_options}{verbose};
	my $docs     = $self->{plugins_options}{docs};

	my $tmp = GroupConfig_get_value($self, $plugname, $optname);

	if (not defined $tmp) {
		$tmp = $ui->get_long($plugname, $optname, $docs->{$optname}{synopsis},
		    $docs->{$optname}{description}, $self->{opts}{$optname});
	}
        $self->{opts}{$optname} = $tmp;

        GroupConfig_update_keywords($self->{plugins_options}, $plugname, $optname, $tmp);

        return $tmp;

}
# }}}


# wrapper_getsingle($self, $plugin_name, $option_name, @answers)
#
# Get value for option $option_name.
#
# {{{
#
# Value is stored in object's structure ($self) and also returned.
#
# If option is not defined in the configuration then use $UI->get_single
# to ask user.

sub wrapper_getsingle
{
	my $self     = shift;
	my $plugname = shift;
	my $optname  = shift;
        my @answers  = @_;
        my $ui       = $self->{plugins_options}{UI};
        my $verbose  = $self->{plugins_options}{verbose};
	my $docs     = $self->{plugins_options}{docs};

	my $tmp = GroupConfig_get_value($self, $plugname, $optname);

	if (not defined $tmp) {
		$tmp = $ui->get_single($plugname, $optname, $docs->{$optname}{synopsis},
		    $docs->{$optname}{description}, $self->{opts}{$optname}, @answers);
	}
        $self->{opts}{$optname} = $tmp;

        GroupConfig_update_keywords($self->{plugins_options}, $plugname, $optname, $tmp);

        return $tmp;

}
# }}}


# wrapper_getpassword($self, $plugin_name, $option_name)
#
# Get value for option $option_name.
#
# {{{
#
# Value is stored in object's structure ($self) and also returned.
#
# If option is not defined in the configuration then use $UI->get_password
# to ask user.

sub wrapper_getpassword
{
	my $self     = shift;
	my $plugname = shift;
	my $optname  = shift;
        my $ui       = $self->{plugins_options}{UI};
        my $verbose  = $self->{plugins_options}{verbose};
	my $docs     = $self->{plugins_options}{docs};

	my $tmp = GroupConfig_get_value($self, $plugname, $optname);

	if (not defined $tmp) {
		$tmp = $ui->get_password($plugname, $optname, $docs->{$optname}{synopsis},
		    $docs->{$optname}{description}, $self->{opts}{$optname});
	}
        $self->{opts}{$optname} = $tmp;

        GroupConfig_update_keywords($self->{plugins_options}, $plugname, $optname, $tmp);

        return $tmp;

}
# }}}


# get_documentation($docsdir, $pluginname)
#
# Return reference to the documentation object.
#
# {{{
#
# Get documentation from XML file: $docsdir/$pluginname.xml
# 
sub get_documentation
{
	my ($docsdir, $plugin) = @_;

	my $xml = XMLin($docsdir . "/" . $plugin . ".xml");

	return $xml;
}
# }}}


# create_file($path, $prefix)
# 
# Create file in a secure way.
# 
# {{{
#
# Create file in directory $path with name prefixed with $prefix.
#
# Return name of the created file.
#
sub create_file
{
	my $path = shift;
	my $prefix = shift;
	my $file;

	do {
		$file = '';
		for (0 .. 9) {
			$file .= (0..9, 'A'..'Z', 'a'..'z')[rand 62];
		}
	} until sysopen(FH, "$path/$prefix$file", O_RDWR|O_CREAT|O_EXCL);
	close FH;

	return "$path/$prefix$file";
}
# }}}

# au_move($src, $dst)
#
# See function 'move' in: perldoc File::Copy
#
# {{{
sub au_move
{
	my ($src, $dst) = @_;

	use File::Copy;
	return File::Copy::move($src, $dst);
}
# }}}


1;
__END__
