#include <adept/extendablelist.h>

namespace adept {

ExtendableListView::ExtendableListView ( ExtendingDelegate *delegate, QWidget *parent )
    : QTreeView( parent )
{
    setRootIsDecorated( false );
    setEditTriggers( 0 );
    setAlternatingRowColors( true );
    setAutoScroll( true );
    setVerticalScrollMode ( QAbstractItemView::ScrollPerPixel );
    new adept::ExtendingEditorBuddy( this, delegate );
}


QSize ExtendingDelegate::expandedSizeHint(
    const QStyleOptionViewItem &opt,
    const QModelIndex &idx ) const
{
    QWidget *ed = m_editors[ idx ];
    int w = ed->width();
    int h = ed->heightForWidth( w );
    return QSize( w, retractedSizeHint( opt, idx ).height() + h );
}

QWidget *ExtendingDelegate::createEditor( QWidget *parent,
                                           const QStyleOptionViewItem &opt,
                                           const QModelIndex &idx ) const {
    assert ( !m_extended.contains( idx ) );

    QWidget *w = createEditorWidget( parent, opt, idx );
    if ( !w )
        return 0;

    m_extended.insert( idx );
    QRect geom = opt.rect;
    geom.setTop( geom.top() + retractedSizeHint( opt, idx ).height() );
    w->setGeometry( geom );
    m_editors[ idx ] = w;

    updateItem( idx );
    return w;
}

void ExtendingDelegate::updateEditorGeometry (
    QWidget * editor,
    const QStyleOptionViewItem & opt,
    const QModelIndex & idx ) const
{
    QRect old = editor->geometry();
    QRect geom = opt.rect;
    geom.setTop( geom.top() + retractedSizeHint( opt, idx ).height() );
    editor->setGeometry( geom );
    editor->resize( geom.size() );
    if ( old != editor->geometry() )
        editorGeometryUpdated();
}

void ExtendingDelegate::closeEditor( const QModelIndex &i ) {
    QObject *obj = m_editors[ i ];
    QWidget *w = qobject_cast< QWidget * >( obj );
    assert( w );
    m_extended.remove( i );
    m_editors.remove( i );
    updateItem( i );
}

ExtendingEditorBuddy::ExtendingEditorBuddy( ExtendableListView *v, ExtendingDelegate *d ) {
        m_updates = 0;
        m_updateTimer = new QTimer( this );
        m_view = v;
        connect( m_view, SIGNAL( closeAllEditorsRequested() ),
                 this, SLOT( closeAll() ) );
        m_delegate = d;
        v->setItemDelegate( d );
        assert( m_delegate );
        connect( v, SIGNAL( destroyed() ), this, SLOT( deleteLater() ) );

        connect( v, SIGNAL( clicked( const QModelIndex & ) ),
                 this, SLOT( toggleExtended( const QModelIndex & ) ) );

        connect( m_delegate, SIGNAL( editorGeometryUpdated() ),
                 this, SLOT( updateAll() ) );
        connect( m_delegate, SIGNAL( updateItem( const QModelIndex & ) ),
                 this, SLOT( update( const QModelIndex & ) ) );

        connect( m_updateTimer, SIGNAL( timeout() ),
                 this, SLOT( doUpdate() ) );
        m_updateTimer->setSingleShot( true );
}

void ExtendingEditorBuddy::update( const QModelIndex &m ) {
    m_update.append( m );
    if ( !m_updates )
        m_view->setUpdatesEnabled( false );
    ++ m_updates;
    m_updateTimer->start( 0 );
}

void ExtendingEditorBuddy::doUpdate() {
    while ( !m_update.empty() ) { 
        -- m_updates;
        m_view->dataChanged( m_update.front(), m_update.front() );
        m_delegate->sizeHintChanged( m_update.front() );
        m_update.pop_front();
    }
    if ( !m_updates )
        m_view->setUpdatesEnabled( true );
    // m_view->updateEditorGeometries();
    m_view->updateGeometries();
    m_updateDone = true;
}

void ExtendingEditorBuddy::toggleExtended( const QModelIndex &m ) {
    if ( m_delegate->extended( m ) ) {
        m_view->closePersistentEditor( m );
        m_delegate->closeEditor( m );
    } else {
        m_view->openPersistentEditor( m );
        m_view->scrollTo( m );
    }
}

void ExtendingEditorBuddy::closeAll() {
    std::set< QPersistentModelIndex >::iterator i;
    std::set< QPersistentModelIndex > toClose;

    std::copy( m_delegate->extendedBegin(), m_delegate->extendedEnd(),
               std::inserter( toClose, toClose.begin() ) );

    for ( i = toClose.begin(); i != toClose.end(); ++i )
        toggleExtended( *i );

    if ( toClose.empty() )
        return;

    m_updateDone = false;
    while ( !m_updateDone )
        QCoreApplication::processEvents();
}

void ExtendingEditorBuddy::updateAll() {
    QSet< QPersistentModelIndex >::iterator i;
    for ( i = m_delegate->extendedBegin();
          i != m_delegate->extendedEnd(); ++i )
        update( *i );
}
}
