# Tech note: common licenses incompatibility matrix

# Background

The Debian-native `adequate` package, among other things, flags binary packages
for shipping binaries that link against libraries with an incompatible license.
To be able to do so reliably, we need an (in)compatibility matrix of
/usr/share/common-licenses (modulo documentation licenses).

The intent here is to flag link-time incompatibilities with high confidence, at
the expense of erring on the side of false negatives. In other words, the matrix
below omits entries for combinations of licenses that might be link-time
incompatible but human judgement is required to determine whether that is
actually the case.

DEP5 defines a machine readable copyright format, and requires the use of
license identifiers (partially) compatible with the ones defined by SPDX.

# The matrix

In the following, the license before the colon is that of the binary and may be
combined with any common license *except* the ones listed to the right of the
colon (library licenses).

	Apache-2.0: GPL-2
	Artistic: GPL-2, GPL-2+, GPL-3, GPL-3+
	BSD:
	GPL-2: Apache-2.0, Artistic, GPL-3, GPL-3+, LGPL-3, LGPL-3+, MPL-1.1
	GPL-2+: Artistic, MPL-1.1
	GPL-3: Artistic, GPL-2, MPL-1.1
	GPL-3+: Artistic, GPL-2, MPL-1.1
	LGPL-2:
	LGPL-2+:
	LGPL-2.1:
	LGPL-2.1+:
	LGPL-3: GPL-2
	LGPL-3+: GPL-2
	MPL-1.1: GPL-2, GPL-2+, GPL-3, GPL-3+
	MPL-2.0: (none for our purposes, see note below)
	OpenSSL:

# FAQ

## Aren't GPL licenses incompatible with the OpenSSL license?

The OpenSSL license used to be the license of OpenSSL, until version 3.0.0,
where it switched to the Apache-2.0 license. The incompatibility of the
GPL licenses with the OpenSSL license is well-known. However, depending on
the interpretation of the System Library Exception of the GPL licenses,
the incompatibility could be considered relevant or irrelevant for the
OpenSSL library. We assume compatibility for our purposes.

## What about MPL-2 with no-copyleft exception?

We only cover MPL-2 here, assuming that Exhibit B of the license text is
not being used. MPL-2-with-no-copyleft-exception is basically a distinct
license with a distinct SPDX identifier.

## How confident are you in the matrix?

None of the people that have been involved in drafting and reviewing this
document are lawyers. We are confident in that the matrix is non-exhaustive
(e.g. MPL-2 might be incompatible with some GPL licenses depending on the MPL-2
flavor) and err on the side of false negatives.

# References

 * https://www.debian.org/doc/packaging-manuals/copyright-format/1.0/
 * https://spdx.dev/
 * https://www.gnu.org/licenses/gpl-faq.html#AllCompatibility
 * https://en.wikipedia.org/wiki/File:Floss-license-slide-image.svg
 * https://www.gnu.org/licenses/gpl-faq.html#SystemLibraryException

# Metadata

	author: sez@
	author: invernomuto@paranoici.org
	contributor: nsteeves@gmail.com  
	review-thread: <D2DN2OVXOJKF.2Z8Y03PVNW3A@debian.org>

	reviewer: invernomuto@paranoici.org
	review-status: approved
	review-context: debian-legal@
