/*--- xwindow.h ----------------------------------------------------------------
Copyright (C) 2004, 2005 Sylvain Fourmanoit <syfou@users.sourceforge.net>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.   
------------------------------------------------------------------------------*/
/* Regroup in one place all graphics-related includes, 
   and miscellaneous X routines. 
 */

/*----------------------------------------------------------------------------*/
#ifndef HAVE_XWINDOW_H
#define HAVE_XWINDOW_H

#ifndef HAVE_CONFIG_H
#error Autogenerated config.h should be used.
#endif

/*----------------------------------------------------------------------------*/
#include "config.h"			/* Autoconf */

#ifndef X_DISPLAY_MISSING
#include <X11/Xlib.h>			/* XLib */
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#else					/* Fake types definitions */
typedef int Display;
typedef int Window;
typedef int Visual;
typedef int Colormap;
typedef int Drawable;
typedef int Pixmap;
#endif

#ifdef HAVE_FONTCONFIG_FONTCONFIG_H
#include <fontconfig/fontconfig.h>      /* Fontconfig */
#endif

#ifdef HAVE_STDIO_H			/* fprintf() */
#include <stdio.h>
#endif

#include <Imlib2.h>			/* Enlightment Image Library 2 */

#include "error.h"                      /* Error handling */
#include "cfgfile.h"			/* For window characteristics */

/*----------------------------------------------------------------------------*/
/* Base event mask for main window */
#ifndef X_DISPLAY_MISSING
#define BASE_EVENT_MASK StructureNotifyMask | ExposureMask | ButtonPressMask 
#else
#define BASE_EVENT_MASK 0
#endif

/*----------------------------------------------------------------------------*/
/* Defines for xwindow_context_save and xwindow_context_restore 
*/
#define IMLIB_DISPLAY  		(1<<0)
#define IMLIB_VISUAL   		(1<<1)
#define IMLIB_COLORMAP 		(1<<2)
#define IMLIB_DRAWABLE 		(1<<3)
#define IMLIB_MASK     		(1<<4)
#define IMLIB_DITHER_MASK	(1<<5)
#define IMLIB_ANTI_ALIAS	(1<<6)
#define IMLIB_DITHER		(1<<7)
#define IMLIB_BLEND		(1<<8)
#define IMLIB_COLOR_MODIFIER    (1<<9) 
#define IMLIB_OPERATION         (1<<10)
#define IMLIB_FONT              (1<<11)
#define IMLIB_DIRECTION		(1<<12)
#define IMLIB_ANGLE		(1<<13)
#define IMLIB_COLOR		(1<<14)
#define IMLIB_IMAGE		(1<<15)
#define IMLIB_COLOR_RANGE       (1<<16)
#define IMLIB_FILTER            (1<<17)

/*----------------------------------------------------------------------------*/
#ifndef X_DISPLAY_MISSING
extern XSetWindowAttributes XDefaultWindowAttributes;
#endif

/*----------------------------------------------------------------------------*/
void        xwindow_locate_truetype_fonts(void);

#ifndef X_DISPLAY_MISSING
int         xwindow_non_fatal_error_handler(Display *, XErrorEvent *);
void        xwindow_error_reset(void);
int         xwindow_error_check(void);
int         xwindow_window_size(Display *, Window, uint *, uint *);
int         xwindow_window_moved_or_resized(int, int, int, int);
int         xwindow_updated_background(Display *, Window, Atom);
Imlib_Image xwindow_grab_background(Display *, int, Window);
void        xwindow_update_window(Window, Imlib_Updates *, 
				  Imlib_Image, Imlib_Image, int);
int         xwindow_move_window(Display *, Window, Window, cfgfile_item*);
int         xwindow_resize_window(Display *, Window, cfgfile_item*, 
				  int, int, int);
Window      xwindow_get_root_window(Display *, int);
#endif
void        xwindow_context_save(long);
void        xwindow_context_restore(void);

/*----------------------------------------------------------------------------*/
#endif
