# Builtin functions actually called by the interpreter.
#
# Author::    Yutaka Yanoh <mailto:yanoh@users.sourceforge.net>
# Copyright:: Copyright (C) 2010-2012, OGIS-RI Co.,Ltd.
# License::   GPLv3+: GNU General Public License version 3 or later
#
# Owner::     Yutaka Yanoh <mailto:yanoh@users.sourceforge.net>

#--
#     ___    ____  __    ___   _________
#    /   |  / _  |/ /   / / | / /__  __/           Source Code Static Analyzer
#   / /| | / / / / /   / /  |/ /  / /                   AdLint - Advanced Lint
#  / __  |/ /_/ / /___/ / /|  /  / /
# /_/  |_|_____/_____/_/_/ |_/  /_/   Copyright (C) 2010-2012, OGIS-RI Co.,Ltd.
#
# This file is part of AdLint.
#
# AdLint is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# AdLint is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# AdLint.  If not, see <http://www.gnu.org/licenses/>.
#
#++

require "adlint/c/type"
require "adlint/c/object"

module AdLint #:nodoc:
module C #:nodoc:

  class BuiltinFunction < NamedFunction
    def initialize(type_table, name)
      super(nil, type_table.builtin_function_type, name)
    end

    def explicit?
      true
    end

    def builtin?
      true
    end

    def call(interpreter, funcall_expr, args)
      interpreter.temporary_variable(type.return_type)
    end
  end

  class InspectFunction < BuiltinFunction
    def initialize(type_table)
      super(type_table, "__adlint__inspect")
    end

    def call(interpreter, funcall_expr, args)
      puts "__adlint__inspect"
      args.each { |arg, expr| pp arg }
      puts "EOM"
      super
    end
  end

  class EvalFunction < BuiltinFunction
    def initialize(type_table)
      super(type_table, "__adlint__eval")
    end

    def call(interpreter, funcall_expr, args)
      puts "__adlint__eval"
      char_array = interpreter.pointee_of(args.first.first)
      if char_array.type.array?
        without_nil = char_array.value.to_single_value.values[0..-2]
        program_text = without_nil.map { |char| char.unique_sample.chr }.join
        if program_text.empty?
          puts "no program text"
        else
          eval program_text
        end
        puts "EOM"
      end
      super
    end
  end

end
end
