/*
   Project: Adun

   Copyright (C) 2006 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#ifndef _ULSTATUSTABLE_
#define _ULSTATUSTABLE_
#include <AppKit/AppKit.h>
#include "ULFramework/ULProcessManager.h"
#include "ULPropertiesPanel.h"
#include "ULPasteboard.h"

/**
Controls the status table in the main Adun window.

\todo Modify initial notification registration to be safer.
\ingroup interface
*/

@interface ULStatusTable : NSObject
{
	BOOL isActive;
	id processManager;
	id statusTable;
	id selectedProcesses;
}

- (void) awakeFromNib;
- (void) export: (id) sender;
- (void) remove: (id) sender;
- (void) setProcessManager: (id) object;
- (void) setActive: (BOOL) value;
- (BOOL) isActive;
//Pasteboard delegate
- (NSArray*) availableTypes;
- (id) objectForType: (NSString*) type;
- (NSArray*) objectsForType: (NSString*) type;
- (int) countOfObjectsForType: (NSString*) type;
@end

#endif
