# ----------------------------------------------------------
# AdvaS Advanced Search 
# synonym module
#
# (C) 2002 - 2005 Frank Hofmann, Chemnitz, Germany
# email fh@efho.de
# ----------------------------------------------------------

# changed 2004-11-16

from io import get_file_contents
import string
from basicStrings import is_comment

def synonym_of (term, dictionary_file):
	"returns the synonyms of the given term"

	# works with OpenThesaurus (plain text version)
	# requires an OpenThesaurus release later than 2003-10-23
	# requires lines sorted in alphabetical order
	# http://thesaurus.kdenews.org

	word_list = get_file_contents (dictionary_file)
	if (word_list==-1) or (term == ""):
		# can't read from given file name or an empty term
		return []
	# end if

	# ignore comments at the beginning
	list_length = len(word_list) - 1
	right = list_length
	left = 0
	while (right>left):
		if is_comment(word_list[left]):
			left += 1
		else:
			break
	# end while

	list_left = left
	list_right = right
	
	# use a binary search to find the given item (index term)
	while (right>left):
		middle = (right + left) / 2

		# extract line and remove any whitespace at the beginning
		line = string.lstrip(string.rstrip(word_list[middle]))

		# split into chunks
		pieces = line.split(";")

		# compare ...
		v = cmp_strings(pieces[0], term)
		# print pieces[0], term, v
		if (v==0):
			# both strings are equal - find lines containing the same index term
			# an item can have several meanings
			left = middle - 1
			right = middle + 1
			while (left>0):
				line = string.lstrip(string.rstrip(word_list[left]))
				pieces = line.split(";")
				if(cmp_strings(pieces[0], term)==0):
					left -= 1
				else:
					break
				# end if
			# end while

			while (right<list_length):
				line = string.lstrip(string.rstrip(word_list[right]))
				pieces = line.split(";")
				if(cmp_strings(pieces[0], term)==0):
					right += 1
				else:
					break
				# end if
			# end while
			
			# get all relevant lines 
			synonyms = word_list[left+1:right]

			# remove space and special chars
			for i in range(len(synonyms)):
				synonyms[i] = string.lstrip(string.rstrip(synonyms[i]))
			# end for

			return synonyms

		elif (v==-1):
			# term follows piece
			left = middle + 1
		else:
			# piece follows term
			right = middle
		# end if
	# end while

	# still not found - check each line
	synonyms = []
	
	i = list_left
	while i < list_length:
		line = string.lstrip(string.rstrip(word_list[i]))
		pieces = line.split(";")
		
		if term in pieces:
			synonyms.append(line)
		# end if
		
		i += 1
	# end while
	
	return synonyms

def is_synonym_of (term1, term2, dictionary_file):
	"returns true if term1 and term2 have the same meaning"

	# works with OpenThesaurus (plain text version)
	# requires an OpenThesaurus release later than 2003-10-23
	# requires lines sorted in alphabetical order
	# http://thesaurus.kdenews.org

	word_list = get_file_contents (dictionary_file)
	if (word_list==-1) or (term1 == "") or (term2 == ""):
		# can't read from given file name or compare empty terms
		return 0
	# end if

	# ignore comments at the beginning
	list_length = len(word_list) - 1
	right = list_length
	left = 0
	while (right>left):
		if is_comment(word_list[left]):
			left += 1
		else:
			break
	# end while

	list_left = left
	list_right = right
	
	i = list_left
	while i < list_length:
		line = string.lstrip(string.rstrip(word_list[i]))
		pieces = line.split(";")
		
		if ((term1 in pieces) and (term2 in pieces)):
			return 1
		# end if
		
		i += 1
	# end while

	return 0

