/*
    Copyright (C) 2003-2005 Fons Adriaensen <fons.adriaensen@skynet.be>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __AUDIO_H
#define __AUDIO_H


#include <stdlib.h>
#include <clthreads.h>
#include <clalsadrv.h>
#include <jack/jack.h>
#include "asection.h"
#include "division.h"
#include "lfqueue.h"
#include "reverb.h"
#include "global.h"


class Audio : public A_thread
{
public:

    Audio (const char *name);
    virtual ~Audio (void);

    void  init_alsa (int ncapt, int nplay, bool bform, const char *device, int fsamp, int fsize, int nfrag);
    void  init_jack (int ncapt, int nplay, bool bform);

    int policy (void) const { return _policy; }
    int prioty (void) const { return _prioty; }
    Lfq_u32 *qnote (void) { return &_qnote; }
    Lfq_u32 *qcomm (void) { return &_qcomm; }

private:
   
    enum { VOLUME, REVSIZE, REVTIME, STPOSIT };

    void init_audio (void);
    void close_alsa (void);
    void close_jack (void);
//    void update_div (unsigned int, unsigned int); 
//    void update_all (unsigned int *, unsigned int *);
 
    virtual void thr_main (void);
    void jack_shutdown (void);
    int  jack_callback (jack_nframes_t);

    void proc_comm (Lfq_u32 *);
    void proc_mesg (void);
    void proc_synth (unsigned long);
    void proc_update (void);

    void note_off (int n, int b)
    {
        _keys [n] &= ~b;
        _keys [n] |= 128;
    }

    void note_on (int n, int b)
    {
        _keys [n] |= b;
        _keys [n] |= 128;
    }

    static void jack_static_shutdown (void *);
    static int  jack_static_callback (jack_nframes_t, void *);

    const char     *_name;
    volatile bool   _run_alsa;
    volatile bool   _run_jack;
    Alsa_driver    *_alsa_handle;
    jack_client_t  *_jack_handle;
    jack_port_t    *_jack_in  [8];
    jack_port_t    *_jack_out [8];
    int             _policy;
    int             _prioty;
    bool            _bform;
    int             _ncapt;
    int             _nplay;
    unsigned int    _fsamp;
    unsigned int    _fsize;
    Lfq_u32         _qnote; 
    Lfq_u32         _qcomm; 
    int             _nasect;
    int             _ndivis;
    Asection       *_asectp [NASECT];
    Division       *_divisp [NDIVIS];
    Reverb          _reverb;
    float          *_out [8];
    unsigned char   _keys [NNOTES];
    Fparm           _apar [4];
    float           _revsize;
    float           _revtime;
};


#endif

