/* aewm - An Exiguous Window Manager - vim:sw=4:ts=4:et
 *
 * Copyright 1998-2006 Decklin Foster <decklin@red-bean.com>. This
 * program is free software; please see LICENSE for details. */

#include <locale.h>
#include <stdlib.h>
#include <stdio.h>
#include <X11/Xatom.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include "common.h"
#include "atom.h"
#include "menu.h"

void make_launch_menu_item(void *, char *, char *); 
void *make_launch_sub_menu(void *, char *);
void make_client_menu_item(Window, Widget);
void popup_cb(Widget, XtPointer, XtPointer);
void raise_win_cb(Widget, XtPointer, XtPointer);
void fork_exec_cb(Widget, XtPointer, XtPointer);

int main(int argc, char **argv)
{
    Widget toplevel, main_menu;
    int i, mode = LAUNCH;
    char *opt_config = NULL;
    unsigned long read, left;
    Window w;

    setlocale(LC_ALL, "");
    toplevel = XtInitialize(argv[0], "AeMenu", NULL, 0, &argc, argv);

    for (i = 1; i < argc; i++) {
        if ARG("config", "rc", 1)  {
            opt_config = argv[++i];
        } else if ARG("launch", "l", 0)   {
            mode = LAUNCH;
        } else if ARG("switch", "s", 0)   {
            mode = SWITCH;
        } else {
            fprintf(stderr,
                "usage: aemenu [--switch|-s] [--config|-rc <file>]\n");
            exit(2);
        }
    }

    dpy = XtDisplay(toplevel);
    root = DefaultRootWindow(dpy);
    main_menu = XtVaCreatePopupShell("menu",
        simpleMenuWidgetClass, toplevel, NULL);

    if (mode == LAUNCH) {
        make_launch_menu(opt_config, main_menu,
            make_launch_menu_item, make_launch_sub_menu);
    } else /* mode == SWITCH */ {
        setup_switch_atoms();
        for (i = 0, left = 1; left; i += read) {
            read = get_atoms(root, net_client_list, XA_WINDOW, i,
                &w, 1, &left);
            if (read)
                make_client_menu_item(w, main_menu);
            else
                break;
        }
    }

    popup_cb(NULL, main_menu, NULL);
    XtMainLoop();
    return 0;
}

void make_launch_menu_item(void *menu, char *label, char *cmd)
{
    Widget menu_item = XtVaCreateManagedWidget(label,
        smeBSBObjectClass, menu, NULL);
    XtAddCallback(menu_item, XtNcallback, fork_exec_cb, cmd);
}

void *make_launch_sub_menu(void *menu, char *label)
{
    Widget new_menu, menu_item;
    new_menu = XtVaCreatePopupShell(label,
        simpleMenuWidgetClass, menu, NULL);
    menu_item = XtVaCreateManagedWidget(label,
        smeBSBObjectClass, menu,
        XtNmenuName, label, NULL);
    XtAddCallback(menu_item,
        XtNcallback, popup_cb, (XtPointer)new_menu);
    return new_menu;
}

void make_client_menu_item(Window w, Widget menu)
{
    char buf[BUF_SIZE];
    Widget menu_item;

    if (is_on_cur_desk(w) && !is_skip(w)) {
        snprint_wm_name(buf, sizeof buf, w);
        menu_item = XtVaCreateManagedWidget(buf,
            smeBSBObjectClass, menu, NULL);
        XtAddCallback(menu_item,
            XtNcallback, raise_win_cb, (XtPointer)w);
    }
}

void popup_cb(Widget w, XtPointer data, XtPointer call)
{
    int x, y;

    get_pointer(&x, &y);
    XtVaSetValues((Widget)data, XtNx, x, XtNy, y, NULL);
    XtPopup((Widget)data, XtGrabExclusive);
}

void raise_win_cb(Widget w, XtPointer data, XtPointer call)
{
    raise_win((Window)data);
    exit(0);
}

void fork_exec_cb(Widget w, XtPointer data, XtPointer call)
{
    fork_exec(data);
    exit(0);
}
