/* aewm - An Exiguous Window Manager - vim:sw=4:ts=4:et
 *
 * Copyright 1998-2006 Decklin Foster <decklin@red-bean.com>. This
 * program is free software; please see LICENSE for details. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/types.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include "common.h"
#include "parser.h"
#include "atom.h"
#include "menu.h"

void setup_switch_atoms()
{
    utf8_string = XInternAtom(dpy, "UTF8_STRING", False);
    wm_state = XInternAtom(dpy, "WM_STATE", False);
    net_client_list = XInternAtom(dpy, "_NET_CLIENT_LIST", False);
    net_cur_desk = XInternAtom(dpy, "_NET_CURRENT_DESKTOP", False);
    net_wm_name = XInternAtom(dpy, "_NET_WM_NAME", False);
    net_wm_desktop = XInternAtom(dpy, "_NET_WM_DESKTOP", False);
    net_wm_state = XInternAtom(dpy, "_NET_WM_STATE", False);
    net_wm_state_skipt = XInternAtom(dpy, "_NET_WM_STATE_SKIP_TASKBAR", False);
    net_wm_state_skipp = XInternAtom(dpy, "_NET_WM_STATE_SKIP_PAGER", False);
    net_wm_wintype = XInternAtom(dpy, "_NET_WM_WINDOW_TYPE", False);
    net_wm_type_dock = XInternAtom(dpy, "_NET_WM_WINDOW_TYPE_DOCK", False);
    net_wm_type_desk = XInternAtom(dpy, "_NET_WM_WINDOW_TYPE_DESKTOP", False);
}

void snprint_wm_name(char *buf, size_t len, Window w)
{
    char *n = get_wm_name(w);

    if (n) {
        if (get_wm_state(w) == NormalState) {
            if (snprintf(buf, len, "%s", n) > len)
                strcpy(buf+len-4, "...");
        } else {
            if (snprintf(buf, len, "[%s]", n) > len)
                strcpy(buf+len-5, "...]");
        }
        XFree(n);
    } else {
        snprintf(buf, len, "(%#lx)", w);
    }
}

/* The WM receives the ClientMessage here sets the property in response, so we
 * only do this after the PropertyNotify. */

int is_on_cur_desk(Window w)
{
    unsigned long w_desk, cur_desk, l;

    if (get_atoms(w, net_wm_desktop, XA_CARDINAL, 0, &w_desk, 1, &l) &&
            get_atoms(root, net_cur_desk, XA_CARDINAL, 0, &cur_desk, 1, &l))
        return IS_ON_DESK(w_desk, cur_desk);
    else
        return 1;
}

int is_skip(Window w)
{
    Atom win_type, state;
    int i, skip = 0;
    unsigned long read;

    for (i = 0, read = 1; read; i += read)
        read = get_atoms(w, net_wm_state, XA_ATOM, i, &state, 1, NULL);
        if (read && (state == net_wm_state_skipt ||
                state == net_wm_state_skipp))
            skip = 1;

    if (get_atoms(w, net_wm_wintype, XA_ATOM, 0, &win_type, 1, NULL) &&
            (win_type == net_wm_type_dock || win_type == net_wm_type_desk))
        skip = 1;

    return skip;
}

void raise_win(Window w)
{
    XMapRaised(dpy, w);
    XSync(dpy, False);
}

/* FIXME: this needs some error handling. and documentation. */

static void make_launch_menu_helper(FILE *rc, void *menu,
    add_item_func add_item_cb, add_submenu_func add_submenu_cb)
{
    char buf[BUF_SIZE], token[BUF_SIZE], *p;

    while (get_rc_line(buf, sizeof buf, rc)) {
        p = buf;
        while (get_token(&p, token)) {

            /* start a new sub-menu */
            if (strcmp(token, "menu") == 0) {
                void *newmenu;
                if (get_token(&p, token)) {
                    newmenu = add_submenu_cb(menu, token);
                    make_launch_menu_helper(rc, newmenu, add_item_cb,
                        add_submenu_cb);
                } else {
                    /* XXX: err? */
                }
            }

            /* Add a menu item.
             *
             * FIXME: We free the label token, because once the tookit
             * does its thing with it, we assume it has its own copy.
             * However, we do _not_ free the command token, because all
             * we will do with it is hand a pointer to the toolkit, that
             * the toolkit will then give us back later when the
             * appropriate menu item is clicked (which is at some
             * unspecified time in the future, of course, and the
             * pointer still needs to point to something valid when that
             * happens). This is problematic because I want to be able
             * to re-build the menu on SIGHUP, but that would cause
             * leaks unless a list of all such strings we are holding on
             * to is maintained so that they can be freed later on.
             * Sigh. I should have picked a language with garbage
             * collection.
             *
             * XXX: perhaps we can use the toolkit to get at this? it
             * obviously has to know where all the pointers are, and
             * should be able to walk the menu and enumerate them
             * without too much trouble, before destroying the menu.
             * GTK+ might even allow a "destroy" event callback, or
             * something like that... but we still have to deal with
             * Xaw... ramble ramble ramble... */
            if (strcmp(token, "cmd") == 0) {
                if (get_token(&p, token)) {
                    char *label = strdup(token);
                    if (get_token(&p, token))
                        add_item_cb(menu, label, strdup(token));
//                  /* PLEASE NOTE THAT THE FOLLOWING FUNNY LINES OF
//                   * CODE DO NOT IN FACT WORK */
//                  if (get_token(&p, token)) {
//                      char *cmd = strdup(token);
//                      add_item_cb(menu, label, cmd);
//                      free(cmd);
//                  }
                    free(label);
                } else {
                    /* XXX: err? */
                }
            }

            /* include another menu file */
            if (strcmp(token, "include") == 0) {
                if (get_token(&p, token)) {
                    FILE *f = fopen(token, "r");
                    if (f) {
                        make_launch_menu_helper(f, menu,
                            add_item_cb, add_submenu_cb);
                        fclose(f);
                    } else {
                        /* XXX: err? */
                    }
                } else {
                    /* XXX: err? */
                }
            }

            /* back out of this sub-menu if we are done */
            if (strcmp(token, "end") == 0)
                return;
        }
    }
}

void make_launch_menu(char *rcfile, void *menu, add_item_func add_item_cb,
    add_submenu_func add_submenu_cb)
{
    FILE *rc;

    if ((rc = open_rc(rcfile, "clientsrc"))) {
        make_launch_menu_helper(rc, menu, add_item_cb, add_submenu_cb);
        fclose(rc);
    } else {
        fprintf(stderr, "can't find any rc files\n");
        exit(1);
    }
}
