#!/bin/csh -f
################### Start of $RCSfile: Install,v $ ##################
#
# $Source: /home/alb/afbackup/afbackup-3.3.7/RCS/Install,v $
# $Id: Install,v 1.3 2002/06/14 16:55:26 alb Exp alb $
# $Date: 2002/06/14 16:55:26 $
# $Author: alb $
#
#
####### description ################################################
#
#
#
####################################################################

set OSNAME=`uname -s|sed 's/[^a-zA-Z1-9]//g'`

unalias cd
unalias cp
unalias mv

umask 22

set servicename="afbackup"

if (-r Install.cache) then
  set noglob
  source Install.cache
  unset noglob
endif

set varstosave=(servinstdir username userid groupid defdev servvarinstdir clntinstdir clntvarinstdir port use_des des_header des_include des_lib des_libdir disable_threads orduserrestore runclientconfig runserverconfig servicename activate_mserver mservicename mport add_mservice use_zlib zlib_include zlib_libdir usegcc chown_server_var libdesbug_enabled do_install optimizer_flags servnamalias)

set exitst=0

set pathext=(/usr/bin /bin /usr/ccs/bin /usr/ccs/lib /opt/gnu/bin /usr/local/bin /usr/local/gnu/bin /opt/bin /opt/gnu)

foreach newdir ($pathext)
  if (! -d $newdir) continue

  set found=0
  foreach dir ($path)
    if ($dir == $newdir) then
      set found=1
      break
    endif
  end
  if (! $found) then
    set path=($path $newdir)
  endif
end

rehash

set stack=()
alias gosub 'set stack=(\!:3 $stack); set __args=(\!:2) ; goto \!:1'
alias return 'set __lab=$stack[1] ; set stack=($stack[2-]) ; goto $__lab'
alias matches 'echo \!:1 |egrep -i \!:2|wc -l'
alias issymlink 'ls -l \!:1 |grep '^l'|wc -l'
alias do_exit 'goto exitlabel'
alias find_program 'sh -c '"'"'if [ `echo \!:1|grep /|wc -l` -gt 0 ] ; then echo \!:1 ; else P=`basename \!:1` ; for d in `echo $PATH|tr : " "` ; do if [ -x $d/$P ] ; then echo $d/$P ; break ; fi ; done ; fi'"'"
alias get_xinetd_entry "sed -n '/^\([ 	]\)\?service[	 ][	 ]*'"'"\!:1"'"'\([	 ].*\)\?/,/^[	 ]*[}][	 ]*/ p' \!:2"
alias get_xinetd_param "sed -n '/^\([ 	]\)\?service[	 ][	 ]*'"'"\!:1"'"'\([	 ].*\)\?/,/^[	 ]*[}][	 ]*/ p' \!:3|grep '^[ 	]*'"'"\!:2"'"'[ 	]*=[ 	]*'|sed 's/^[^=]*=[	 ]*//g'"
alias strip_xinetd_entry "sed '/^\([ 	]\)\?service[	 ][	 ]*'"'"\!:1"'"'\([	 ].*\)\?/,/^[	 ]*[}][	 ]*/ d' \!:2"
alias comb_empty_lines "awk 'BEGIN{s = 0;}{if(NF == 0){if(s == 0)print; s = 1}else{s = 0; print}}'"

set PS1="ps -ef"
set PS2="ps -fp"

if (`matches $OSNAME linux` || `matches $OSNAME FreeBSD` || `matches $OSNAME OpenBSD`) then
  set PS1="ps -uxa"
  set PS2="ps"
endif
if (`matches $OSNAME sunos`) then
  set REV=`uname -r|sed 's/[.].*$//g'`
  if ($REV < 5) then
    set PS1="ps -uxa"
    set PS2="ps"
  endif
endif

#foreach p ($path)
#  if (-x $p/cc) then
#    setenv CC cc
#    break
#  endif
#  if (-x $p/gcc) then
#    setenv CC gcc
#    break
#  endif
#end

set CONF_INTERPR=""
if (`matches $OSNAME HPUX`) set CONF_INTERPR=ksh

set adminprefix=/etc

set inetdfile=$adminprefix/inetd.conf

set use_xinetd=0
set xinetd_running=`$PS1 | grep -v grep | grep xinetd | wc -l`
if (-f $adminprefix/xinetd.conf && $xinetd_running) then
  set use_xinetd=1
  set inetdfile=$adminprefix/xinetd.conf
endif

while (`ls -ld $inetdfile|cut -c1` == l)
  set syml=`ls -l $inetdfile|sed 's/^.*->[ 	]*//g'`
  if (`echo "$syml"|cut -c1` == "/") then
    set inetdfile="$syml"
  else
    set inetdfile=`dirname $inetdfile`/"$syml"
  endif
end

set tmpfile=core.tmp.$$
set tmpfile2=core.tmp2.$$

set saved_files=""

set modes=(servonly clntonly clntrem all)

gosub which_make "" know_make
know_make:
set MAKEOPTS="EXTRA_CFLAGS=-DORIG_DEFAULTS"
set MAKECMD="make"
if ($?GNU_MAKE) then
  set MAKEOPTS="$MAKEOPTS MAKECMD=$GNU_MAKE"
  set MAKECMD=$GNU_MAKE
endif

set configure_options=""

clear
echo " "
echo 'Welcome to the installation procedure for'
echo " "
echo "AF's backup system *"
echo '=================='
echo " "
echo ' '
echo '(* People accustomed to Microsoft-publications please'
echo '   insert: hyper-optimized, ultra-reliable, turbo-speed,'
echo '   multimedia, leading technology, highest performance ...)'
echo ' '
echo 'You can interrupt this program at any time hitting Ctrl-C. With'
echo 'some of the following questions a default answer will be offered'
echo "in square brackets. If you don't want to change this or if you"
echo "are unsure, just hit the Return key."
echo " "
echo "First you have to decide, which functionality you"
echo 'would like to have on this machine.'
echo " "
echo '(1) Backup server only'
echo '(2) Backup client only (also to start backups on other hosts)'
echo '(3) Backup client only with remote start option'
echo '(4) Backup server, client and client remote start option'
echo " "

set sel=0
while (! `matches $sel '^[1-4]$'`)
  echo -n 'Please enter your choice [1-4]: '
  set sel=$<
  if (! `matches $sel '^[1-4]$'`) then
    echo "This is not a valid choice. Please try again."
    echo " "
  endif
end

set mode=$modes[$sel]

onintr exitlabel

if (`matches $OSNAME SunOS` || `matches $OSNAME HPUX`) then
  set the_gcc=`find_program gcc`
  echo ' '
  echo 'Shall we use gcc to build afbackup (strongly recommended) ?'
  set defaultusegcc=Yes
  if (`echo $the_gcc | wc -w` < 1) then
    echo '(Unfortunately gcc is not found in the current $PATH)'
    set defaultusegcc=No
  endif
  if (! $?usegcc) then
    set usegcc=$defaultusegcc
  endif
  gosub yes_no $usegcc usegccchecked

  usegccchecked:
  set usegcc="$yesno"
  if ($usegcc == "yes") then
    setenv CC gcc
  endif
endif

switch ($sel)
  case 1:
		gosub server_only "" contlab
		breaksw
  case 2:
		gosub client_only "" contlab
		breaksw
  case 3:
		gosub remclient "" contlab
		breaksw
  case 4:
		gosub all "" contlab
		breaksw
endsw

contlab:
echo " "

if ($sel == 2 || $sel == 4) then
  echo "When the server has been configured properly, the following"
  echo "commands can be used to do backup, verify and restore (all"
  echo "in $clntinstdir/client/bin):"
  echo " full_backup        to make a full backup"
  echo " incr_backup        to make an incremental backup"
  echo " afverify           to verify the latest backup"
  echo " afrestore ...      to make restores"
  echo "For more information see the INTRO file and the manual pages."
endif

echo 'All done. The input supplied during this installation procedure'
echo 'is saved in the file "Install.cache". This file can be copied'
echo 'somewhere else to have the input present as default for the next'
echo 'upgrade or installation on other architectures. The file will be'
echo 'erased when you do a "make distclean".'

if (`echo $saved_files | wc -w` > 0) then
  echo " "
  echo "The following files are safety copies of files, that"
  echo "are crucial for your system. If up to now everything"
  echo "worked fine then you can safely remove them:"
  echo " "
  echo $saved_files
  echo ' '
endif

exitlabel:

set noglob
/bin/rm -f Install.cache
touch Install.cache
foreach var ($varstosave)
  eval 'set exists=$?'"$var"
  if ($exists) then
    set valuestr=`eval echo '$'$var`
    echo set $var"=($valuestr)" >> Install.cache
  endif
end

exit $exitst

### SERVER ONLY ###

server_only:
echo " "
echo "Ok, we're going to install only the server side on this"
echo -n "machine. "

gosub server_install "" end_server_only

end_server_only:
return

### CLIENT ONLY ###

client_only:
echo " "
echo "Ok, we're going to install only the client side on this"
echo -n "machine. "

gosub client_install "" end_client_only

end_client_only:
return

### REMOTELY STARTED CLIENT ###

remclient:
echo " "
echo "Ok, we're going to install the client with remote start"
echo -n "option. "

gosub server_install "" end_remclient
end_remclient:
return

### CLIENT, SERVER AND REMOTE START OPTION ###

all:
echo " "
echo "Ok, we will install the client, server and remote start"
echo -n "option. "

gosub server_install "" end_allinst
end_allinst:
return

################ SERVER INSTALLATION #################

server_install:

if (! $?servinstdir) then
  set servinstdir=/usr/local/afbackup
endif

echo "First you have to specify where to install the"
echo "files and programs. Please enter a directory of"
echo 'your choice (you may supply the same directory'
echo 'as for the client side).'
ask_for_servinstdir:
echo "If '$servinstdir' is fine enter yes."
echo 'Otherwise enter an alternate directory, please.'

choose_servinstdir:
echo " "
set choice="blub"
while (! `matches $choice '^(ye?s?|no?|/.*)$'`)
  echo -n 'Your choice (Yes/No/path) [Yes]: '
  set choice=$<
  if ("$choice" == "") set choice="yes"
  if (! `matches $choice '^(ye?s?|no?|/.*)$'`) then
    echo " "
    echo "That's no valid choice. Please Try again."
  endif
end
if (`matches $choice '^no?$'`) then
  echo "Please enter the directory."
  goto choose_servinstdir
endif
if (`matches $choice '^/'`) then
  set servinstdir=$choice
endif

gosub choose_DES "" chosen_DES_servonly
chosen_DES_servonly:
echo " "

gosub choose_ZLIB "" chosen_ZLIB_servonly
chosen_ZLIB_servonly:
echo " "

if (! $?orduserrestore) then
  set orduserrestore=No
endif
if ($mode != "clntrem" && $mode != "servonly") then
  echo " "
  echo "Do you want ordinary users to be able to restore their"
  echo "own files and/or directories without administrator help ?"
  ordusersclnt:
  echo ' '
  echo -n "Your choice (Yes/No) [$orduserrestore]: "
  set c=blub
  while (! `matches $c '^(ye?s?|no?)$'`)
    set c=$<
    if ("$c" == "") set c=$orduserrestore
    while (! `matches $c '^(ye?s?|no?)$'`)
      echo ' '
      echo "Invalid choice. Please try again."
      goto ordusersclnt
    end
  end
  set orduserrestore=$c
endif

gosub choose_threads "" chosen_threads_servonly
chosen_threads_servonly:

gosub choose_optimization "" chosen_optimization_servonly
chosen_optimization_servonly:

echo " "
echo "Now we have to build the programs. Please stand by"
echo "and watch for error messages. If any occur you have"
echo "a problem. Warnings can usually be ignored. If errors"
echo 'occur, drop a mail to the author (af@muc.de)'
echo 'with the fault message(s) of make or try to patch the'
echo "stuff yourself. If you succeed, please also drop a"
echo "mail to the author, so your changes can be added to the"
echo "distribution."
echo " "
echo "Running configure now ..."
echo " "
$CONF_INTERPR ./configure -prefix="$servinstdir" --without-prefixext \
		--with-rexecdir="$servinstdir"/server/rexec \
		$configure_options
set s=$status
echo " "
if ($s != 0) then
  echo "Damn. Something went wrong. Please contact the author."
  echo "Stopping here."
  set exitst=1
  do_exit
endif

if ($?libdesbug_enabled) then
  if (`matches $libdesbug_enabled '^yes$'`) then
    if (`grep LIBDESBUG_COMPATIBILITY des_aux.h|wc -l` < 1) then
      echo '#define	LIBDESBUG_COMPATIBILITY	1' >> des_aux.h
    endif
  endif
endif

echo "Running make now ..."
echo " "
if ($mode == "all" || $mode == "clntrem") then
  $MAKECMD $MAKEOPTS OPTIMIZE="$optimizer_flags"
  set s=$status
else
  $MAKECMD server $MAKEOPTS OPTIMIZE="$optimizer_flags"
  set s=$status
endif

echo " "
if ($s != 0) then
  echo "Damn. Something went wrong. Please contact the author."
  echo "Stopping here."
  set exitst=1
  do_exit
endif

gosub ask_install Yes serv_install_asked

serv_install_asked:

echo " "
echo "We're now going to install the files and programs."
echo " "
if ($mode == "all" || $mode == "clntrem") then
  $MAKECMD install install.rclient $MAKEOPTS OPTIMIZE="$optimizer_flags"
  set s=$status
else
  $MAKECMD install.server $MAKEOPTS OPTIMIZE="$optimizer_flags"
  set s=$status
endif

if ($s == 0 && `matches $orduserrestore 'ye?s?'`) then
  $MAKECMD install.userrestore $MAKEOPTS OPTIMIZE="$optimizer_flags"
  set s=$status
#    /bin/rm -f $servinstdir/client/bin/afrestore \
#		$servinstdir/client/bin/afbackout \
#		$servinstdir/client/bin/backout \
#		$servinstdir/client/bin/restore
#    cp $servinstdir/client/bin/full_backup \
#		$servinstdir/client/bin/afrestore
#    ln $servinstdir/client/bin/afrestore $servinstdir/client/bin/afbackout
#    ln -s afbackout $servinstdir/client/bin/backout
#    ln -s afrestore $servinstdir/client/bin/restore
#    chmod 4755 $servinstdir/client/bin/afrestore
#    chmod 755 $servinstdir/client/bin/xafrestore $servinstdir/client/bin/__packpats
endif

echo " "
if ($s != 0) then
  echo "Oops, something went wrong.  Maybe your directory choice is"
  echo "somewhat problematic. Choose one of:"
  set c=b
  while (! `matches $c '^[ar]'`)
    echo -n 'Abort, Retry (A/R) [R]: '
    set c=$<
    if ("$c" == "" ) set c=r
  end
  if ($c == "a" || $c == "A") then
    set exitst=1
    do_exit
  else
    echo ' '
    goto ask_for_servinstdir
  endif
endif

\rm -f $tmpfile

gosub add_backup_service "servicename port" serv_serv_added

serv_serv_added:

if (! $?username) then
  if ($mode == "all" || $mode == "clntrem") then
    set username=root
  else
    set username=backup
  endif
endif

echo ' '

gosub add_inetd_entry "$servicename nowait afserver" inst_mserver

inst_mserver:
echo ' '

echo 'Do you want to activate the multi stream server ?'
if (! $?activate_mserver) then
  set activate_mserver=Yes
endif
if (! $?mservicename) then
  set mservicename=afmbackup
endif
gosub yes_no $activate_mserver activate_mserver

activate_mserver:
set activate_mserver=$yesno
if ($yesno == "no") then
  goto sel_buserver_usrgrp
endif

echo ' '
echo 'The multi-stream server should use a different port than the'
echo 'normal server, so we now configure the appropriate entries'
echo 'for the system files.'

gosub add_backup_service "mservicename mport" serv_mserv_added

serv_mserv_added:

echo ' '
gosub add_inetd_entry "$mservicename wait afmserver" sel_buserver_usrgrp

sel_buserver_usrgrp:

echo ' '

gosub add_user_group "username userid groupid" chowntapedev

chowntapedev:

set RESTRSERVERFILES="afmserver afserver label_tape cartready"
foreach SF ($RESTRSERVERFILES)
  chown $username $servinstdir/server/bin/$SF
end

if ("$username" != "root") then
  echo ' '
  echo "The user ID the server will run under is not root."
  echo "So we are now going do change the ownership of the"
  echo "directory containing varying serverside files and"
  echo "storing persistent information for the server to the"
  echo "user $username. Furthermore all the files residing in"
  echo "this directory will change the owner the same way. If"
  echo "we wouldn't do so, the server would not be able to modify"
  echo "these files. That could result in really bad situations."
  echo "If you consider this as dangerous or disadvantageous, or "
  echo "if there's any reason to not like it then enter no now."
  echo ' '
  echo "Change owner of $servinstdir/server/var/* to $username ?"
  if (! $?chown_server_var) then
    set chown_server_var=Yes
  endif
  gosub yes_no $chown_server_var got_chown_var_server

 got_chown_var_server:
  set chown_server_var=$yesno
  if ($chown_server_var == yes) then
    chown $username $servinstdir/server/var $servinstdir/server/var/*
  endif
  echo ' '
endif

if ($mode != "clntrem") then
  echo " "
  echo "Now we should change the owner of your tape device"
  echo "to user $username and grant him exclusive access to it."
  echo "You may now enter a filename pattern or no if you"
  echo "want to skip this step. Here are the usual streamer"
  echo "device name patterns for some OS-es:"
  echo " "
  echo "Solaris:       /dev/rmt/[0-9]*"
  echo "AIX:           /dev/rmt[0-9]*"
  echo "IRIX:          /dev/rmt/tps[0-9]*"
  echo "HP-UX:         /dev/rmt/[0-9]*"
  echo "Linux:         /dev/st[0-9]* /dev/nst[0-9]*"
  echo "Digital UNIX:  /dev/rmt[0-9]* /dev/nrmt[0-9]*"
  echo "FreeBSD:       /dev/rst[0-9]* /dev/nrst[0-9]*"
  echo "OpenBSD:       /dev/rst[0-9]* /dev/nrst[0-9]*"

  if (! $?defdev) then
    switch ($OSNAME)
      case SunOS:
		set defdev="/dev/rmt/0*"
		breaksw
      case AIX:
		set defdev="/dev/rmt0*"
		breaksw
      case IRIX:
		set defdev="/dev/rmt/tps0d4*"
		breaksw
      case HPUX:
		set defdev="/dev/rmt/0*"
		breaksw
      case Linux:
		set defdev="/dev/st0* /dev/nst0*"
		breaksw
      case OSF1:
		set defdev="/dev/rmt0* /dev/nrmt0*"
		breaksw
      case FreeBSD:
		set defdev="/dev/sa0* /dev/nsa0*"
		breaksw
      case OpenBSD:
		set defdev="/dev/rst0* /dev/nrst0*"
		breaksw
      default:
		set defdev=""
    endsw
  endif

 seldev:
  echo " "
  echo -n "Your choice [$defdev]: "
  set c=""
  set c=$<
  if ("$c" == "") set c="$defdev"
  if (! `matches "$c" '^no?$'`) then
    chown $username $c
    set r=$status
    chmod 600 $c
    set r2=$status
    if ($r || $r2) then
      echo "Oops, this did not work. Please do it manually by "
      echo 'entering the following and replacing <devicenames> '
      echo 'with your device-names pattern:'
      echo " "
      echo " chown $username <devicenames>"
      echo " chmod 600 <devicenames>"
      echo " "
      echo "Please hit return when you are done with it or"
      echo "want to skip this step."
      set c=$<
    endif
  endif
  set defdev="$c"
endif


echo ' '

set inetdline=("`$PS1|grep -v grep|grep inetd`")
set running_inetds=`$PS1|grep -v grep|grep inetd|wc -l`
if ($running_inetds == 0) then
  echo "Sorry, i'm unable to determine the process ID of "
  echo 'inetd.  Would you do me a favour and enter it here?'
  askforinetdpid:
  echo ' '
  echo -n 'Process ID: '
  set pid=""
  set pid=$<
  if ("$pid" == "" || ! `matches $pid '^[0-9][0-9]*$'`) then
    echo ' '
    echo "Invalid input. Please try again."
    goto askforinetdpid
  endif
  $PS2 $pid >& /dev/null
  if ($status) then
    echo ' '
    echo "This is not the pid of the inetd. Please try again."
    goto askforinetdpid
  endif
  set inetdline=("`$PS2 $pid|grep -v grep|grep inetd`")
endif
if ($running_inetds > 1) then
  echo "Sorry, I found several processes looking like inetd."
  echo "Would you please give me a hint and tell me the real"
  echo 'process ID ? You may evaluate the following lines:'
  echo ' '
  $PS1|grep -v grep|grep inetd
  askfipid2:
  echo ' '
  echo -n 'Process ID: '
  set pid=""
  set pid=$<
  if ("$pid" == "" || ! `matches $pid '^[0-9][0-9]*$'`) then
    echo ' '
    echo "Invalid input. Please try again."
    goto askfipid2
  endif
  $PS2 $pid >& /dev/null
  if ($status) then
    echo ' '
    echo "This is not the pid of the inetd. Please try again."
    goto askfipid2
  endif
  set inetdline=("`$PS2 $pid|grep -v grep|grep inetd`")
endif
set inetdline=(`echo "$inetdline"|sed 's/[?*\[]/_/g;s/\]/_/g'`)
if ($running_inetds == 1) then
  set pid=$inetdline[2]
endif

echo ' '
echo "The process ID of the inetd seems to be $pid, the"
echo "appropriate entry in the process list is:"
echo ' '
echo "$inetdline"
asksendhup:
echo ' '
if (! $use_xinetd) then
  echo "To activate the backup service we can now send a HUP signal"
  echo -n 'to inetd. Do you want to do this (Yes/No) [Yes] ? '
  set SIG="HUP"
else
  echo "To activate the backup service we can now send a USR2 signal"
  echo -n 'to xinetd. Do you want to do this (Yes/No) [Yes] ? '
  set SIG="USR2"
endif
set c=blub
while (! `matches $c '^(ye?s?|no?)$'`)
  set c=$<
  if ("$c" == "") set c=Yes
  if (! `matches $c '^(ye?s?|no?)$'`) then
    echo ' '
    echo "Invalid choice. Please try again."
    goto asksendhup
  endif
end
if (`matches $c '^ye?s?$'`) then
  sh -c "kill -$SIG $pid"
endif

if (! $?servvarinstdir) then
  set servvarinstdir=/var/logs/backup
endif
echo " "
echo "You might now want to move the variable part of the"
if ($mode == "all" || $mode == "clntrem") then
  echo -n "backup service"
else
  echo -n "server side"
endif
echo " installation to the /var-directory. The"
echo "default directory is $servvarinstdir. If you want to"
echo "do this and this directory is ok, just enter yes. If"
echo 'the directory is not ok, enter the desired one (you'
echo 'may supply the same as for the client side). If you'
echo "want to skip this step, just enter no."
mvservvar:
echo ' '
echo -n 'Your choice (Yes/No/path) [No]: '
set c=blub
while (! `matches $c '^(ye?s?|no?|/.*)$'`)
  set c=$<
  if ("$c" == "") set c=no
  if (! `matches $c '^(ye?s?|no?|/.*)$'`) then
    echo ' '
    echo "Invalid choice. Please try again."
    goto mvservvar
  endif
end
if (`matches $c '^/'`) then
  set servvarinstdir=$c
endif
if (! `matches $c '^no?$'`) then
  mkdir -p $servvarinstdir
  set curwd=`pwd`
  cd $servinstdir/server
  if (`issymlink var`) then
    echo "Warning: The directory seems to have already been moved."
    echo "         Please check where $servinstdir/server/var"
    echo "         points to. Not moving anything."
    goto eosvmove
  endif
  tar cf - var | (cd $servvarinstdir; tar xf -)
  mv $servvarinstdir/var $servvarinstdir/server
  \rm -rf var
  ln -s $servvarinstdir/server var
  eosvmove:

  if ($mode == "all" || $mode == "clntrem") then
    cd $servinstdir/client
    if (`issymlink var`) then
      echo "Warning: The directory seems to have already been moved."
      echo "         Please check, where $servinstdir/client/var"
      echo "         points to. Not moving anything."
      goto eoclsvmove
    endif
    tar cf - var | (cd $servvarinstdir; tar xf -)
    mv $servvarinstdir/var $servvarinstdir/client
    \rm -rf var
    ln -s $servvarinstdir/client var
    eoclsvmove:
  endif

  cd $curwd
endif

if ($mode == "all" || $mode == "servonly") then
  if (! $?runserverconfig) then
    set runserverconfig=Yes
  endif
  echo ' '
  echo "Now we may run the program $servinstdir/server/bin/serverconfig"
  echo "so you can configure the server side of the backup system. Would"
  echo 'you like to do this now ?'
  confserv:
  echo ' '
  echo -n "Your choice (Yes/No) [$runserverconfig]: "
  set c=blub
  while (! `matches $c '^(ye?s?|no?)$'`)
    set c=$<
    if ("$c" == "") set c=$runserverconfig
    if (! `matches $c '^(ye?s?|no?)$'`) then
      echo ' '
      echo "Invalid choice. Please try again."
      goto serv
    endif
  end
  set runserverconfig="$c"
  if (`matches $c 'ye?s?'`) then
    $servinstdir/server/bin/serverconfig
  endif
endif

if ($mode == "all" || $mode == "clntrem") then
  if (! $?runclientconfig) then
    set runclientconfig=Yes
  endif
  echo ' '
  echo "Now we may run the program $servinstdir/client/bin/clientconfig"
  echo "so you can configure the client side of the backup system. Would"
  echo 'you like to do this now ?'
  confsclnt:
  echo ' '
  echo -n "Your choice (Yes/No) [$runclientconfig]: "
  set c=blub
  while (! `matches $c '^(ye?s?|no?)$'`)
    set c=$<
    if ("$c" == "") set c=$runclientconfig
    if (! `matches $c '^(ye?s?|no?)$'`) then
      echo ' '
      echo "Invalid choice. Please try again."
      goto confsclnt
    endif
  end
  set runclientconfig="$c"
  if (`matches $c 'ye?s?'`) then
    $servinstdir/client/bin/clientconfig
  endif
endif

return


################## CLIENT INSTALLATION ##################

client_install:
if (! $?clntinstdir) then
  set clntinstdir=/usr/local/afbackup
endif

echo "First you have to choose where we should install"
echo "the files and programs. Please enter a directory"
echo 'of your choice (you may supply the same directory'
echo 'as for the server side).'
ask_for_clntinstdir:
echo 'Enter yes if '$clntinstdir' is ok.'
echo 'Otherwise please enter an alternate directory.'

choose_clntinstdir:
echo " "
set choice="blub"
while (! `matches $choice '^(ye?s?|no?|/.*)$'`)
  echo -n 'Your choice (Yes/No/path) [Yes]: '
  set choice=$<
  if ("$choice" == "") set choice="yes"
  if (! `matches $choice '^(ye?s?|no?|/.*)$'`) then
    echo " "
    echo "This is not a valid choice. Please Try again."
  endif
end
if (`matches $choice '^no?$'`) then
  echo "Please enter the directory."
  goto choose_clntinstdir
endif
if (`matches $choice '^/'`) then
  set clntinstdir=$choice
endif

gosub choose_DES "" chosen_DES_clnt
chosen_DES_clnt:
echo " "

gosub choose_ZLIB "" chosen_ZLIB_clnt
chosen_ZLIB_clnt:
echo " "

gosub choose_optimization "" chosen_optimization_clnt
chosen_optimization_clnt:

if (! $?orduserrestore) then
  set orduserrestore=No
endif
echo " "
echo "Do you want ordinary users to be able to restore their"
echo "own files and/or directories without administrator help ?"
orduserclnt:
echo ' '
echo -n "Your choice (Yes/No) [$orduserrestore]: "
set c=blub
while (! `matches $c '^(ye?s?|no?)$'`)
  set c=$<
  if ("$c" == "") set c=$orduserrestore
  while (! `matches $c '^(ye?s?|no?)$'`)
    echo ' '
    echo "Invalid choice. Please try again."
    goto orduserclnt
  end
  set orduserrestore=$c
end

echo " "
echo "Now we have to build the programs. Please stand by"
echo "and watch for error messages. If any occur you have"
echo "a problem. Warnings can usually be ignored. If errors"
echo "occur, drop a mail to the author"
echo '(af@muc.de)'
echo 'with the fault message(s) of make or try to patch the'
echo "stuff yourself. If you succeed, please also drop a"
echo "mail to the author, so your changes can be added to the"
echo "distribution."
echo " "
echo "Running configure now ..."
echo " "
$CONF_INTERPR ./configure -prefix="$clntinstdir" --without-prefixext \
		--with-rexecdir="$clntinstdir"/server/rexec \
		$configure_options
set s=$status
echo " "
if ($s != 0) then
  echo "Damn. Something went wrong. Please contact the author."
  echo "Stopping here."
  set exitst=1
  do_exit
endif

if ($?libdesbug_enabled) then
  if (`matches $libdesbug_enabled '^yes$'`) then
    if (`grep LIBDESBUG_COMPATIBILITY des_aux.h|wc -l` < 1) then
      echo '#define	LIBDESBUG_COMPATIBILITY	1' >> des_aux.h
    endif
  endif
endif

echo "Running make now ..."
echo " "
$MAKECMD client $MAKEOPTS OPTIMIZE="$optimizer_flags"
set s=$status
echo " "
if ($s != 0) then
  echo "Damn. Something went wrong. Please contact the author."
  echo "Stopping here."
  set exitst=1
  do_exit
endif

gosub ask_install Yes clnt_install_asked

clnt_install_asked:

echo " "
echo "We're now going to install the files and programs."
echo " "
$MAKECMD install.client $MAKEOPTS OPTIMIZE="$optimizer_flags"
set s=$status

if ($s == 0 && `matches $orduserrestore 'ye?s?'`) then
  $MAKECMD install.userrestore $MAKEOPTS OPTIMIZE="$optimizer_flags"
  set s=$status
#  /bin/rm -f $clntinstdir/client/bin/afrestore \
#		$clntinstdir/client/bin/afbackout \
#		$clntinstdir/client/bin/backout \
#		$clntinstdir/client/bin/restore
#  cp $clntinstdir/client/bin/full_backup \
#		$clntinstdir/client/bin/afrestore
#  ln $clntinstdir/client/bin/afrestore $clntinstdir/client/bin/afbackout
#  ln -s afbackout $clntinstdir/client/bin/backout
#  ln -s afrestore $clntinstdir/client/bin/restore
#  chmod 4755 $clntinstdir/client/bin/afrestore
#  chmod 755 $clntinstdir/client/bin/xafrestore $clntinstdir/client/bin/__packpats
endif

echo " "
if ($s != 0) then
  echo "Oops. This failed. Maybe your directory choice is"
  echo "somewhat problematic. Choose one of:"
  set c=b
  while (! `matches $c '^[ar]'`)
    echo -n 'Abort, Retry (A/R) [R]: '
    set c=$<
    if ("$c" == "" ) set c=r
  end
  if ($c == "a" || $c == "A") then
    return
  else
    echo ' '
    goto ask_for_clntinstdir
  endif
endif

gosub add_backup_service "servicename port" clnt_add_mservice

clnt_add_mservice:

echo ' '
echo 'Do you want to add an entry to '"$adminprefix/services"
echo 'for the multi stream server ?'

if (! $?add_mservice) then
  set add_mservice=Yes
endif
if (! $?mservicename) then
  set mservicename=afmbackup
endif

gosub yes_no $add_mservice clnt_mservice_added
clnt_mservice_added:
set add_mservice=$yesno
if ($yesno == "no") then
  goto clnt_chvardir
endif

gosub add_backup_service "mservicename mport" clnt_chvardir

clnt_chvardir:

if (! $?clntvarinstdir) then
  set clntvarinstdir=/var/logs/backup
endif
echo " "
echo "You might now want to move the variable part of the"
echo "client side installation to the /var-directory. The"
echo "default directory is $clntvarinstdir. If you want to"
echo "do this and this directory is ok, just enter yes. If"
echo 'the directory is not ok, enter the desired one (you'
echo 'may supply the same as for the server side). If you'
echo "want to skip this step, just enter no."
mvclntvar:
echo ' '
echo -n 'Your choice (Yes/No/path) [No]: '
set c=blub
while (! `matches $c '^(ye?s?|no?|/.*)$'`)
  set c=$<
  if ("$c" == "") set c=no
  if (! `matches $c '^(ye?s?|no?|/.*)$'`) then
    echo ' '
    echo "Invalid choice. Please try again."
    goto mvclntvar
  endif
end
if (`matches $c '^/'`) then
  set clntvarinstdir=$c
endif
if (! `matches $c '^no?$'`) then
  mkdir -p $clntvarinstdir
  set curwd=`pwd`
  cd $clntinstdir/client
  if (`issymlink var`) then
    echo " "
    echo "Warning: The directory seems to have been moved already."
    echo "         Please check where $clntinstdir/client/var"
    echo "         points to. Not moving anything."
    goto eoclmove
  endif
  tar cf - var | (cd $clntvarinstdir; tar xf -)
  mv $clntvarinstdir/var $clntvarinstdir/client
  \rm -rf var
  ln -s $clntvarinstdir/client var
  eoclmove:
  cd $curwd
endif

if (! $?runclientconfig) then
  set runclientconfig=Yes
endif
echo ' '
echo "Now we may run the program $clntinstdir/client/bin/clientconfig"
echo "so you can configure the client side of the backup system. Would"
echo 'you like to do this now ?'
confclnt:
echo ' '
echo -n "Your choice (Yes/No) [$runclientconfig]: "
set c=blub
while (! `matches $c '^(ye?s?|no?)$'`)
  set c=$<
  if ("$c" == "") set c=$runclientconfig
  if (! `matches $c '^(ye?s?|no?)$'`) then
    echo ' '
    echo "Invalid choice. Please try again."
    goto confclnt
  endif
end
set runclientconfig="$c"
if (`matches $c 'ye?s?'`) then
  $clntinstdir/client/bin/clientconfig
endif

return

####### add user and group entry to /etc/passwd and /etc/group

add_user_group:

set usrnamvar=`echo $__args|awk '{print $1}'`
set usridvar=`echo $__args|awk '{print $2}'`
set grpidvar=`echo $__args|awk '{print $3}'`
eval set usrnam='$'$usrnamvar
eval set usridexists='$?'"$usridvar"
if ($usridexists) then
  eval set usrid='$'"$usridvar"
else
  unset usrid
endif
eval set grpidexists='$?'"$grpidvar"
if ($grpidexists) then
  eval set grpid='$'"$grpidvar"
else
  unset grpid
endif

set passwdfile=$adminprefix/passwd
if (`matches $OSNAME OpenBSD`) then
  set passwdfile=$adminprefix/master.passwd
endif

if (`grep '[ 	]*'"$usrnam": $passwdfile |wc -l` < 1) then
  echo "No user entry found for $usrnam in $passwdfile."
  askadduser:
  echo ' '
  echo -n 'Should we add an entry (Yes/No) [Yes] ? '
  set c=blub
  while (! `matches $c '^(ye?s?|no?)$'`)
    set c=$<
    if ("$c" == "") set c=Yes
    if (! `matches $c '^(ye?s?|no?)$'`) then
      echo ' '
      echo "Invalid choice. Please try again."
      goto askadduser
    endif
  end
  if (`matches $c '^ye?s?$'`) then
    if (! $?usrid) then
      set usrid=2988
    endif
    while (`cut -f3 -d: $passwdfile|grep "^$usrid"'$'|wc -l` > 0)
      @ usrid++
    end
    echo " "
    echo "The default user-ID is $usrid. If this is ok, just"
    echo "enter yes. If not, enter the desired ID."
    set c=blub
    askforuserid:
    while (! `matches $c '^(ye?s?|no?|[0-9][0-9]*)$'`)
      echo " "
      echo -n 'Your choice (Yes/No/userid) [Yes]: '
      set c=$<
      if ("$c" == "") set c='Yes'
      if (! `matches $c '^(ye?s?|no?|[0-9][0-9]*)$'`) then
        echo ' '
        echo 'This is not a valid choice. Please try again.'
      endif
    end
    if (`matches $c '^[0-9][0-9]*$'`) then
      set usrid=$c
    else
      if (`matches $c '^n'`) then
        echo "Please enter the desired user-ID."
        goto askforuserid
      endif
    endif
    if (`cut -f3 -d: $passwdfile|grep "^$usrid"'$'|wc -l` > 0) then
      echo "Warning: A user entry with the user-ID $usrid already exists"
      echo "     on the system. Using it nonetheless."
    endif

    if (! $?grpid) then
      set grpid=14
    endif
    while (`cut -f3 -d: $adminprefix/group|grep "^$grpid"'$'|wc -l` < 1)
      @ grpid--
      if ($grpid == 0) then
        break
      endif
    end
    while (`cut -f3 -d: $adminprefix/group|grep "^$grpid"'$'|wc -l` < 1)
      @ grpid++
    end
    echo " "
    echo "The default group-ID is $grpid. If this is ok, just"
    echo "enter yes. If not, enter the desired ID."
    set c=blub
    askforgroupid:
    while (! `matches $c '^(ye?s?|no?|[0-9][0-9]*)$'`)
      echo " "
      echo -n 'Your choice (Yes/No/groupid) [Yes]: '
      set c=$<
      if ("$c" == "") set c='Yes'
      if (! `matches $c '^(ye?s?|no?|[0-9][0-9]*)$'`) then
        echo ' '
        echo 'This is not a valid choice. Please try again.'
      endif
    end
    if (`matches $c '^[0-9][0-9]*$'`) then
      set grpid=$c
      if (`cut -f3 -d: $adminprefix/group|grep "^$grpid"'$'|wc -l` < 1) then
	echo "Warning: A group entry with this group-ID does not exist"
	echo "    in the system. Using it nonetheless."
      endif
    else
      if (`matches $c '^n'`) then
        echo "Please enter the desired group-ID."
        goto askforgroupid
      endif
    endif

    set panic=0
    cp $passwdfile $passwdfile.$$
    set saved_files=($saved_files $passwdfile.$$)
    set tmppasswdfile=$passwdfile.tmp.$$

    if (! -e $passwdfile.$$) then
      echo "Panic: cannot make backup copy of $passwdfile."
      echo "I'll not go on to add the user. You have to do it yourself."
      set panic=1
    else
      if (`grep '^+' $passwdfile|wc -l` > 0) then
        \rm -f $tmpfile $tmpfile2
        echo "/^+/ i\\" >! $tmpfile
        echo "$usrnam":x:"$usrid":"$grpid":"Backup Server:$servinstdir/server:" \
  		>> $tmpfile
        sed -f $tmpfile $passwdfile >! $tmpfile2
        if ($status) then
	  echo "Error: adding the user to the system file failed."
  	  set panic=1
        else
	  if (! `matches $OSNAME OpenBSD`) then
  	    cp $tmpfile2 $passwdfile
	  else
	    /bin/cp $tmpfile2 $tmppasswdfile \
	     && pwd_mkdb $tmppasswdfile \
	     && /bin/cp $tmpfile2 $tmppasswdfile \
	     && pwd_mkdb -p $tmppasswdfile \
	     && /bin/rm -f $tmppasswdfile # just in case pwd_mkdb forgets it
	  endif
          if ($status) then
  	    echo "Error: adding the user to the system file failed."
  	    set panic=1
	  endif
        endif
      else
        if (! `matches $OSNAME OpenBSD`) then
	  echo "$usrnam":x:"$usrid":"$grpid":"Backup Server:$servinstdir/server:" \
		>> $passwdfile
	else
	  \rm -f $tmpfile \
	   && /bin/cp $passwdfile $tmpfile \
	   && echo "$usrnam":x:"$usrid":"$grpid":"Backup Server:$servinstdir/server:" \
		>> $tmpfile \
	   && /bin/cp $tmpfile $tmppasswdfile \
	   && pwd_mkdb $tmppasswdfile \
	   && /bin/cp $tmpfile $tmppasswdfile \
	   && pwd_mkdb -p $tmppasswdfile # just in case pwd_mkdb forgets it
          if ($status) then
  	    echo "Error: adding the user to the system file failed."
  	    set panic=1
	  endif
	endif
      endif
    endif

    if ($panic) then
      echo "The following line must be added to $passwdfile"
      echo '(before the line starting with a +, if present):'
      echo ' '
      echo "$usrnam":x:"$usrid":"$grpid":"Backup Server:$servinstdir/server:"
      echo " "
      echo "Please hit enter when you are done with it."
      set a=$<
    endif
  endif
endif

eval set "$usrnamvar"=$usrnam
if ($?usrid) then
  eval set "$usridvar"=$usrid
endif
if ($?grpid) then
  eval set "$grpidvar"=$grpid
endif

return


####### add afbackup entry to /etc/services

add_backup_service:

set servnamvar=`echo $__args|awk '{print $1}'`
set portnumvar=`echo $__args|awk '{print $2}'`
set portnumexists=`eval echo '$?'$portnumvar`
eval set servnam='$'"$servnamvar"
if ($portnumexists) then
  eval set portnum='$'"$portnumvar"
else
  unset portnum
endif
echo ' '
echo 'An entry for the backup service is necessary in the system'
echo "file $adminprefix/services."
add_service:
set servicesline=`egrep '^[ 	]*('"$servnam"'|[^ 	][^ 	]*[ 	][ 	]*[^ 	].*[ 	]'"$servnam"')([ 	].*)?$' $adminprefix/services`
set serviceslinen=`echo $servicesline|wc -w`
if ($serviceslinen > 0) then
  echo "There exists an entry for this service in $adminprefix/services."
  echo "It looks like this:"
  echo ' '
  echo $servicesline
  echo ' '
  echo 'Should we remove this entry and create a new one, or add another ?'
  serventry:
  echo ' '
  echo -n 'Your choice (Yes/No/Add) [No]: '
  set c=blub
  while (! `matches $c '^(ye?s?|no?|ad?d?)$'`)
    set c=$<
    if ("$c" == "") set c=no
    if (! `matches $c '^(ye?s?|no?|ad?d?)$'`) then
      echo ' '
      echo "Invalid choice. Please try again."
      goto serventry
    endif
  end
  if (`matches $c '^ad?d?'`) then
   newservname:
    echo " "
    echo -n "Enter a name for the new service: "
    set c=@
    set c=$<
    if (! `matches $c '^[a-zA-Z0-9_-]*$'`) then
      echo " "
      echo "A service name should contain only A-Z, a-z, 0-9, _ or -"
      echo "Please try again."
      goto newservname
    endif
    set servnam="$c"
    goto add_service
  endif
  if (`matches $c '^ye?s?$'`) then
    set panic=0
    cp $adminprefix/services $adminprefix/services.$$
    set saved_files=($saved_files $adminprefix/services.$$)

    if (! -e $adminprefix/services.$$) then
      echo "Panic: cannot make backup copy of $adminprefix/services."
      echo "I'll not go on to add the entry. You have to do it yourself."
      set panic=1
    else
      egrep -v '^[ 	]*('"$servnam"'|[^ 	][^ 	]*[ 	][ 	]*[^ 	].*[ 	]'"$servnam"')([ 	].*)?$' $adminprefix/services >! $tmpfile
      if (! -e $tmpfile) then
	echo "Error: removing entry from the system file failed."
	set panic=1
      else
        cp $tmpfile $adminprefix/services
	if ($status) then
	  echo "Error: removing entry from the system file failed."
	  set panic=1
	endif
      endif
    endif
    if ($panic) then
      echo "The following line must be removed from $adminprefix/services"
      echo ' '
      egrep '^[ 	]*('"$servnam"'|[^ 	][^ 	]*[ 	][ 	]*[^ 	].*[ 	]'"$servnam"')([ 	].*)?$'
      echo " "
      echo "Please hit enter when you are done with it."
      set a=$<
    endif
    goto add_service
  endif    
  if (`matches $c '^no?$'`) then
    set portnum=`echo $servicesline|awk '{print $2}'|cut -d/ -f1|awk '{print $1}'`
  endif
else
  if (! $?portnum) then
    set portnum=2988
  endif
  while (`grep -i $portnum/tcp $adminprefix/services|grep -v $servnam|wc -l` > 0)
    @ portnum++
  end
 portserviceselection:
  if ($portnum == 2988) then
    set hint=' (hex 0xbac)'
  else
    set hint=''
  endif
  echo ' '
  echo "Should we add an entry to $adminprefix/services for this"
  echo 'service ? Default port number is '$portnum$hint'. If'
  echo 'you do not want to add an entry, just enter no. If you'
  echo 'would like to use a different port number, enter it. If'
  echo 'you want a service name different from '"$servnam"','
  echo 'enter it (all lowercase letters, numbers or -, please).'
  echo 'If everything is ok, enter yes.'
  set c="_-_"
  while (! `matches $c '^(ye?s?|no?|[0-9][0-9]*|[a-z][a-z0-9-]*)$'`)
    echo " "
    echo -n 'Your choice (Yes/No/port/servicename) [Yes]: '
    set c=$<
    if ($c == "") set c='Yes'
    if (! `matches $c '^(ye?s?|no?|[0-9][0-9]*|[a-z][a-z0-9-]*)$'`) then
      echo ' '
      echo 'This is not a valid choice. Please try again.'
    endif
  end
  if (`matches $c '^[0-9][0-9]*$'`) then
    set portnum=$c
    echo " "
    echo "Ok, port number changed to $c."
    if (`grep '^[ 	]*[a-z][a-z0-9-]*[ 	][ 	]*'"$c/"'[tT][Cc][Pp]' $adminprefix/services|wc -l` > 0) then
      echo "Warning: Port number $c is already used in $adminprefix/services."
    endif
    goto portserviceselection
  endif
  if (`matches $c '^[a-z][a-z0-9-]*$'` && ! `matches $c '^(ye?s?|no?)$'`) then
    set servnam="$c"
    echo " "
    echo "Ok, service name changed to $c."
    if (`egrep '^[ 	]*('"$c"'[ 	][ 	]*[1-9][0-9]*/[tT][Cc][Pp]|[^ 	][^ 	]*[ 	][ 	]*[1-9][0-9]*/[tT][Cc][Pp].*[ 	]'"$c"')([ 	].*)?$' $adminprefix/services|wc -l` > 0) then
      echo "Error: Service name $c is already used in $adminprefix/services."
      goto add_service
    endif
    goto portserviceselection
  endif
  if (! `matches $c '^no?$'`) then
    set servicesline=`egrep '^[ 	]*[a-z][a-z0-9-]*[ 	][ 	]*'"$portnum/"'[tT][Cc][Pp]([ 	].*)?$' $adminprefix/services | egrep -v '^(.*[ 	])?'"$servnam"'([ 	].*)?$'`
    set lineadded=no
    if (`echo $servicesline | wc -w` > 0) then
      echo ' '
      echo "Warning: The port number $portnum is already used in $adminprefix/services,"
      echo "but without an entry for the name $servnam. It looks like this:"
      echo ' '
      echo "$servicesline"
      echo ' '
      echo "Should the existing entry be extended with $servnam as an alias name ?"
      if (! $?servnamalias) then
	set servnamalias=Yes
      endif
      gosub yes_no $servnamalias have_servnamalias_choice
     have_servnamalias_choice:
      set servnamalias=$yesno
      if ($yesno == "yes") then
	cp $adminprefix/services $adminprefix/services.$$
	set saved_files=($saved_files $adminprefix/services.$$)

	if (! -e $adminprefix/services.$$) then
	  echo "Panic: cannot make backup copy of $adminprefix/services."
	  echo "I'll not go on to add the entry. Please do it yourself"
	  echo "and press Return, when done."
	  set v=$<
	else
	  set tmpfile=/tmp/serviceline.$$
	  /bin/rm -f $tmpfile
	  if ( -e $tmpfile) then
	    echo "Error: Cannot remove $tmpfile. Please do that manually and"
	    echo "press Return, when done."
	    set v=$<
	  endif
	  egrep '^[ 	]*[a-z][a-z0-9-]*[ 	][ 	]*'"$portnum/"'[tT][Cc][Pp]([ 	].*)?$' $adminprefix/services | egrep -v '^(.*[ 	])?'"$servnam"'([ 	].*)?$' > $tmpfile
	  set servlineno=`egrep -n '^[ 	]*[a-z][a-z0-9-]*[ 	][ 	]*'"$portnum/"'[tT][Cc][Pp]([ 	].*)?$' $adminprefix/services | sed 's/:.*$//g'`
	  set comment="`cat $tmpfile|grep '#'|sed 's/^[^#]*#/	#/g'`"
	  set thebeef="`cat $tmpfile |sed 's/[ 	]*#.*//g'`"
	  /bin/rm -f $tmpfile
	  awk '{if(NR == '"$servlineno"') printf "%s '"$servnam"'%s\n","'"$thebeef"'","'"$comment"'"; else print $0}' $adminprefix/services.$$ > $adminprefix/services.$$.2
	  set NDIFF1=`diff $adminprefix/services.$$ $adminprefix/services.$$.2 | grep '^< ' | wc -l`
	  set NDIFF2=`diff $adminprefix/services.$$ $adminprefix/services.$$.2 | grep '^> ' | wc -l`
	  if ($NDIFF1 == 1 && $NDIFF2 == 1) then
	    /bin/mv $adminprefix/services.$$.2 $adminprefix/services
	  else
	    /bin/rm -f $adminprefix/services.$$.2
	    echo "Error: Could not modify $adminprefix/services correctly."
	    echo "Please do it manually and press Return afterwards."
	    set v=$<
	  endif
	endif

	set lineadded=yes
      endif
    endif
    if ($lineadded == no) then
      echo "$servnam		$portnum/tcp" >> $adminprefix/services
    endif
  endif
endif
eval set "$servnamvar"=$servnam
eval set "$portnumvar"=$portnum

\rm -f $tmpfile

return

################### add entry to /etc/inetd.conf file

add_inetd_entry:

set servnam=`echo $__args|awk '{print $1}'`
set waitforexit=`echo $__args|awk '{print $2}'`
set prognam=`echo $__args|awk '{print $3}'`

set waityesno=no
if ($waitforexit == "wait") set waityesno=yes

echo 'An entry for this service is necessary in the system'
echo "file $inetdfile."
add_inetdentry:
if ($use_xinetd) then
  set inetdentry="`get_xinetd_entry $servnam $inetdfile`"
else
  set inetdentry=(`egrep '^[ 	]*'"$servnam"'([ 	].*)?$' $inetdfile`)
endif
set inetdentryn=`echo $inetdentry|wc -w`
if ($inetdentryn > 0) then
  echo "There exists an entry in $inetdfile."
  echo "It looks like this:"
  echo ' '
  if ($use_xinetd) then
    get_xinetd_entry $servnam $inetdfile
  else
    echo "$inetdentry"
  endif
  echo ' '
  set def=No
  if(! $use_xinetd) then
    set i=($inetdentry)
    if (! `matches $i[6]"/" ^$servinstdir"/"`) then
      echo 'The directory path in this entry seems to be wrong (It'
      echo 'should be '$servinstdir'/... )'
      set def="Yes"
    endif
    if (! `matches $i[6] /$prognam'$'` || ! `matches $i[7] /$prognam'$'`) then
      echo "The program name in this entry is wrong (it must be $prognam)."
      set def="Yes"
    endif
    if (! `matches $i[7]"/" ^$servinstdir"/"`) then
      echo 'The program path in this entry is wrong (it must be '$servinstdir'/$prognam).'
      set def="Yes"
    endif
    if ($i[5] != $username) then
      echo 'The username in this entry is wrong (should be '$username').'
      set def="Yes"
    endif
    if ($i[3] != "tcp" || $i[4] != "$waitforexit" || $i[2] != "stream") then
      echo 'The protocol in this entry is wrong (we are allowing'
      if ("$waitforexit" == "nowait") then
        echo 'several server processes).'
      else
        echo 'only one server process)'
      endif
      set def="Yes"
    endif
  else
    # xinetd
    set server="`get_xinetd_param $servnam server $inetdfile`"
    if (! `matches $server"/" ^$servinstdir"/"`) then
      echo 'The directory path in this entry seems to be wrong (It'
      echo 'should be '$servinstdir'/... )'
      set def="Yes"
    endif
    set server_args=(`get_xinetd_param $servnam server_args $inetdfile`)
    if (! `matches $server /$prognam'$'` || ! `matches $server_args[1] /$prognam'$'`) then
      echo "The program name in this entry is wrong (it must be $prognam)."
      set def="Yes"
    endif
    if (! `matches $server_args[1]"/" ^$servinstdir"/"`) then
      echo 'The program path in this entry is wrong (it must be '$servinstdir'/$prognam).'
      set def="Yes"
    endif
    set user="`get_xinetd_param $servnam user $inetdfile`"
    if ($user != $username) then
      echo 'The username in this entry is wrong (should be '$username').'
      set def="Yes"
    endif
    set prot="`get_xinetd_param $servnam protocol $inetdfile`"
    set wait="`get_xinetd_param $servnam wait $inetdfile`"
    set sockt="`get_xinetd_param $servnam socket_type $inetdfile`"
    if ($prot != "tcp" || $wait != "$waityesno" || $sockt != "stream") then
      echo 'The protocol in this entry is wrong (we are allowing'
      if ("$waitforexit" == "nowait") then
        echo 'several server processes).'
      else
        echo 'only one server process)'
      endif
      set def="Yes"
    endif
    set flags="`get_xinetd_param $servnam flags $inetdfile`"
    echo "$flags" | egrep '^(.* )?REUSE( .*$)?' >/dev/null
    set reuse=$status
    echo "$flags" | egrep '^(.* )?NAMEINARGS( .*$)?' >/dev/null
    set nameinargs=$status
    if ($nameinargs != 0 || $reuse != 0) then
      echo 'The flags in this entry are wrong (REUSE and NAMEINARGS must be set)'
      set def="Yes"
    endif
  endif

  if ($def != "No") then
    echo " "
  endif
  echo 'Should we remove this entry and create a new one ?'
  inetdentry:
  echo ' '
  echo -n 'Your choice (Yes/No) ['$def']: '
  set c=blub
  while (! `matches $c '^(ye?s?|no?)$'`)
    set c=$<
    if ("$c" == "") set c=$def
    if (! `matches $c '^(ye?s?|no?)$'`) then
      echo ' '
      echo "Invalid choice. Please try again."
     goto inetdentry
    endif
  end
  if (`matches $c '^ye?s?$'`) then
    set panic=0
    cp $inetdfile $inetdfile.$$
    set saved_files=($saved_files $inetdfile.$$)

    if (! -e $inetdfile.$$) then
      echo "Panic: cannot make backup copy of $inetdfile."
      echo "I'll not go on to add the entry. You have to do it yourself."
      set panic=1
    else
      if ($use_xinetd) then
        strip_xinetd_entry $servnam $inetdfile | comb_empty_lines >! $tmpfile
      else
        egrep -v '^[ 	]*'"$servnam"'([ 	].*)?$' $inetdfile >! $tmpfile
      endif
      if (! -e $tmpfile) then
	echo "Error: removing entry from the system file failed."
	set panic=1
      else
        cp $tmpfile $inetdfile
	if ($status) then
	  echo "Error: removing entry from the system file failed."
	  set panic=1
	endif
      endif
    endif
    if ($panic) then
      echo "The following line must be removed from $inetdfile"
      echo ' '
      echo "$inetdline"
      echo " "
      echo "Please hit enter when you are done with it."
      set a=$<
    endif
    goto add_inetdentry
  else
    if ($use_xinetd) then
      set user="`get_xinetd_param $servnam user $inetdfile`"
    else
      set line=(`egrep '^[ 	]*'"$servnam"'([ 	].*)?$' $inetdfile`)
      set username=$line[5]
    endif
  endif
else
  echo ' '
  echo "Should we add an entry to $inetdfile for this"
  echo 'service ? Default username is '$username'. If you do not'
  echo 'want to add an entry, just enter no. If you would like'
  echo 'to run the server under a different username, enter it.'
  echo 'If everything is ok, enter yes.'
  askaddinetd:
  echo ' '
  echo -n "Your choice (Yes/No/username) [Yes]: "
  set c=""
  set c=$<
  if ("$c" == "") set c=Yes
  if (! `matches $c '^(ye?s?|no?)$'`) then
    set username=$c
  endif
  if (! `matches $c '^no?$'`) then
    if ($use_xinetd) then
      cut -c10- >> $inetdfile << EOF
       > 
       > service $servnam
       > {
       >         flags           = REUSE NAMEINARGS
       >         socket_type     = stream
       >         protocol        = tcp
       >         wait            = $waityesno
       >         user            = $username
       >         server          = $servinstdir/server/bin/$prognam
       >         server_args     = $servinstdir/server/bin/$prognam $servinstdir/server/etc/backup.conf
       > }
EOF
    else
      echo "$servnam	stream	tcp	$waitforexit	$username	$servinstdir/server/bin/$prognam $servinstdir/server/bin/$prognam $servinstdir/server/etc/backup.conf" >> $inetdfile
    endif
  endif
endif

return

#########################
which_make:
set gmake=`find_program gmake`
if (`echo "$gmake" | wc -w` > 0) then
  if (`matches "$gmake" "^/"`) then
    setenv GNU_MAKE gmake
    return
  endif
endif

make -v -n >& /dev/null
if ($status) then
  unsetenv GNU_MAKE
  return
endif

if (`make -v -n|grep GNU|wc -l` > 0) then
  setenv GNU_MAKE make
  return
endif

setenv GNU_MAKE gmake

return

###########################################################################

choose_threads:

echo " "
echo "Do you wish to disable threads even if they are"
echo "available on your system?  If unsure enter no."

if (! $?disable_threads) then
  set disable_threads=No
endif

gosub yes_no $disable_threads threads_yesno
threads_yesno:

set disable_threads=$yesno
if ($yesno == "no") then
  return
endif

set configure_options="$configure_options --disable-threads"

return

###########################################################################

choose_optimization:

echo " "
echo "On some systems with some compilers high optimization seems to"
echo "corrupt the coded algorithms, so the behaviour of the program is"
echo "not like intended by the programmer. Then it might be desirable"
echo "to reduce the level of optimization. Performance loss should"
echo "be small as most of the time the CPU spends in system calls or"
echo "library functions (e.g. libz calls). Please enter the desired"
echo "compiler flags, if different from the default:"

set defaultsel="-O2"
if (! $?optimizer_flags) then
  set optimizer_flags="$defaultsel"
else
  set defaultsel="$optimizer_flags"
endif

echo " "
echo -n 'Your choice ['"$optimizer_flags"']: '
set optimizer_flags="$<"
if ("$optimizer_flags" == "") set optimizer_flags="$defaultsel"

echo ."$optimizer_flags" | grep '^.-' >/dev/null
if ($status != 0) then
  set optimizer_flags="-$optimizer_flags"
endif

return

###########################################################################

choose_DES:

echo " "
echo "Will we use 128 Bit DES encryption for authenticating the"
echo "client to the server ? (Eric Young's DES library (currently"
echo "version 4.04b) is required and by default expected in the"
echo "directory ../libdes. Alternative is the libcrypto from the"
echo "openssl project (see www.openssl.org) The defaults can be"
echo "modified in the following section, when answering yes. If"
echo "no, the old style encryption is performed."

if (! $?use_des) then
  set use_des=No
endif

gosub yes_no $use_des DES_yesno
DES_yesno:

set use_des=$yesno
if ($yesno == "no") then
  return
endif

set configure_options="$configure_options --with-des"

if (! $?des_header) then
  set des_header=des.h
endif

echo " "
echo "Please enter the name of the DES-library's header file"
gosub mult_choice "$des_header [^ ]*" DES_have_header
DES_have_header:

set des_header="$the_choice"

if (! $?des_include) then
  set des_include=../libdes
endif

echo " "
echo "Please enter the directory where "$des_header" can be found or no,"
echo "if it resides in a place where it is found by default (don't"
echo "supply /usr/include, when comiling with gcc)"

gosub mult_choice "$des_include [^ ]*" DES_have_include
DES_have_include:

set des_include="$the_choice"

if (`matches $des_include '^no?$'`) then
  set des_include="."
else
  if (! -e $des_include/$des_header) then
    echo " "
    echo "Warning: File '$des_include/$des_header' does not exist."
  endif
endif

set configure_options="$configure_options --with-des-include=$des_include"
set configure_options="$configure_options --with-des-header=$des_header"

if (! $?des_lib) then
  set des_lib=-ldes
endif

echo " "
echo "Please enter the specifier of the DES-library for linking"
gosub mult_choice "$des_lib [^ ]*" DES_have_lib
DES_have_lib:

set des_lib="$the_choice"
if (`matches "$des_lib" '^lib'`) then
  set des_lib=`echo $des_lib|sed 's#^lib#-l#g;s#[.].*##g'`
endif
set deslibfile=`echo $des_lib|sed 's#^-l#lib#g'`'.*'

if (! $?des_libdir) then
  if ($?des_include) then
    if ($des_include == ".") then
      set des_libdir=no
    else
      set des_libdir=`echo $des_include|sed 's#/include$#/lib#g'`
    endif
  else
    set des_libdir=../libdes
  endif
endif

echo " "
echo "Please enter the directory where the DES library can be found,"
echo "or no if it resides in a place, where it is found by default"

gosub mult_choice "$des_libdir [^ ]*" DES_have_libdir
DES_have_libdir:

set des_libdir="$the_choice"

if (`matches $des_libdir '^no?$'`) then
  set des_libdir="."
else
  ls $des_libdir/$deslibfile >& /dev/null
  if ($status) then
    echo " "
    echo "Warning: File '$des_libdir/$deslibfile' does not exist."
  else
    set deslibfile=`basename $des_libdir/$deslibfile`
  endif
endif

set configure_options="$configure_options --with-des-libdir=$des_libdir"
set configure_options="$configure_options --with-des-ldflag=$des_lib"

echo " "
echo "Changes in the encryption routines were necessary due to a bug"
echo "in all libdes versions. Thus the newly built programs are unable"
echo "to authenticate successfully with existing installations."
echo "Furthermore if the __descrpt program was used to encrypt files,"
echo "they cannot be decrypted with this program any longer."
echo "Nonetheless it is possible to build the package using the buggy"
echo "function, so backward compatibility for existing installations"
echo "is provided. Should the buggy function be used ?"

if (! $?libdesbug_enabled) then
  set libdesbug_enabled=No
endif

gosub yes_no $libdesbug_enabled libdesbug_yesno
libdesbug_yesno:

set libdesbug_enabled=$yesno

return

###########################################################################

choose_ZLIB:

echo " "
echo "Will we use the libz compression library to have"
echo "built-in compression available ?"

if (! $?use_zlib) then
  set use_zlib=No
endif

gosub yes_no $use_zlib ZLIB_yesno
ZLIB_yesno:

set use_zlib=$yesno
if ($yesno == "no") then
  return
endif

set configure_options="$configure_options --with-zlib"

if (! $?zlib_include) then
  set zlib_include=/usr/local/include
endif

echo " "
echo "Please enter the directory where zlib.h can be found or no,"
echo "if it resides in a place where it is found by default (don't"
echo "supply /usr/include when comiling with gcc)"

gosub mult_choice "$zlib_include [^ ]*" ZLIB_have_include
ZLIB_have_include:

set zlib_include="$the_choice"

if (`matches $zlib_include '^no?$'`) then
  set zlib_include="."
else
  if ( ! -e $zlib_include/zlib.h) then
    echo " "
    echo "Warning: File '$zlib_include/zlib.h' does not exist."
  endif
endif

set configure_options="$configure_options --with-zlib-include=$zlib_include"

if (! $?zlib_libdir) then
  if ($?zlib_include) then
    if ($zlib_include == ".") then
      set zlib_libdir="no"
    else
      set zlib_libdir=`echo $zlib_include|sed 's#/include$#/lib#g'`
    endif
  else
    set zlib_libdir=/usr/local/lib
  endif
endif

echo " "
echo "Please enter the directory where the libz library can be found"
echo "or no, if it resides in a place where it is found by default"

gosub mult_choice "$zlib_libdir [^ ]*" ZLIB_have_libdir
ZLIB_have_libdir:

set zlib_libdir="$the_choice"

if (`matches $zlib_libdir '^no?$'`) then
  set zlib_libdir="."
else
  ls $zlib_libdir/libz.* >& /dev/null
  if ($status) then
    echo " "
    echo "Warning: File '$zlib_libdir/libz.*' does not exist."
  endif
endif

set configure_options="$configure_options --with-zlib-libdir=$zlib_libdir"

return

###########################################################################

yes_no:

set yesno=blub
echo " "
echo -n 'Your choice (Yes/No) ['$__args']: '
set yesno=$<
if ($yesno == "") set yesno=$__args
if (! `matches $yesno '^(ye?s?|no?)$'`) then
  echo ' '
  echo 'This is not a valid choice. Please try again.'
  goto yes_no
endif

if (`matches $yesno '^ye?s?$'`) then
  set yesno="yes"
else
  set yesno="no"
endif

return

###########################################################################

mult_choice:

set noglob
set defaultsel=`echo "$__args"|awk '{print $1}'`
set validch=`echo "$__args"|awk '{printf "%s",$2; for(i=3;i<=NF;i++) printf " %s", $i}'`

echo " "
set the_choice=blub
echo -n 'Your choice ['$defaultsel']: '
set the_choice="$<"
if ("$the_choice" == "") set the_choice=$defaultsel
if (! `matches "$the_choice" '^'"$validch"'$'`) then
  echo ' '
  echo 'This is not a valid choice. Please try again.'
  goto mult_choice
endif
unset noglob

return

##########################################################################

ask_install:

if (! $?do_install) then
  set do_install=Yes
endif

echo ' '
echo 'Now we are going to install the software. If you want to'
echo 'stop here for whatever reason, enter no.'
echo ' '
echo -n 'Install the software now ? '
gosub yes_no "$do_install" install_asked_yesno
install_asked_yesno:
set do_install=$yesno

if ($do_install == no) then
  set exitst=0
  goto exitlabel
endif

return
