#include "afflib.h"			
#include "afflib_i.h"			// grab the internal versions
#include "aimage.h"
#include "imager.h"

#include "ident.h"

void ident::init()
{
    filename = 0;
    opened = 0;
    memset(&scsi,0,sizeof(scsi));
    memset(&ata,0,sizeof(ata));
    memset(&params,0,sizeof(params));
}

ident::ident(int fd_)
{
    init();
    fd = fd_;
}

ident::ident(const char *fn)
{
    init();
    filename = strdup(fn);
}

ident::~ident()
{
    if(opened) close(fd);
    if(filename) free(filename);
    if(params.manufacturer) free(params.manufacturer);
    if(params.model) free(params.model);
    if(params.sn) free(params.sn);
    if(params.firmware) free(params.firmware);
    if(params.human) free(params.human);
}


/* is_scsi:
 * If we were given a filename, check to see if this is a scsi device and,
 * if it is, set all of the various values.
 */
char *ident::append(char *base,char *add)
{
    if(base==0){
	base = (char *)malloc(1);
	base[0] = 0;
	return base;
    }

    base = (char *)realloc(base,strlen(base)+strlen(add)+4);
    strcat(base,add);
    return base;
}


#ifdef linux
#include "ident_linux.cpp"
#endif

#ifdef __FreeBSD__
#include "ident_freebsd.cpp"
#endif

#ifdef __APPLE__
#include "ident_apple.cpp"
#endif

#ifdef UNIX
#include "ident_unix.cpp"
#endif


#ifdef HAS_STATFS
/* ident-specific things for FreeBSD */
long long ident::freebytes()
{
    if(!opened){
	fd = open(filename,O_RDONLY,0666);	// need file opened for this
	if(fd>0){
	    opened = true;
	}
    }

    if(opened){
	struct statfs sbuf;
	if(fstatfs(fd,&sbuf)==0){
	    return (long long)sbuf.f_bavail * (long long)sbuf.f_bsize;
	}
    }
    return -1;
}
#else
long long ident::freebytes()
{
    return 0;				// eventually, call "df"
}
#endif

