#include "ident.h"
#include <stdio.h>
#include <regex.h>


#ifndef IDENT_IS_SCSI
bool ident::is_scsi()
{
    return false;
}
#endif

#ifndef IDENT_IS_ATA
bool ident::is_ata()
{
    return false;
}
#endif




char *pat="([0-9a-f][0-9a-f]:[0-9a-f][0-9a-f]:[0-9a-f][0-9a-f]:"
"[0-9a-f][0-9a-f]:[0-9a-f][0-9a-f]:[0-9a-f][0-9a-f])";

int in_path(const char *cmd)
{
    char *path = strdup(getenv("PATH"));
    char *pathi = path;
    char *check;
    char *last = 0;
    while((check = strtok_r(pathi,":",&last))!=0){
	char buf[MAXPATHLEN+1];
	strcpy(buf,check);
	strcat(buf,"/");
	strcat(buf,cmd);
	if(access(buf,R_OK)==0){
	    free(path);
	    return 1;
	}
	pathi= 0;
    }
    free(path);
    return 0;
}

char *ident::mac_addresses()
{
    char *buf = append(0,0);
    
    if(!in_path("ifconfig")) return buf; // no ifconfig command
    FILE *f = popen("ifconfig","r");
    if(!f) return buf;

    regex_t r;
    if(regcomp(&r,pat,REG_EXTENDED|REG_ICASE)) err(1,"regcomp");

    while(!feof(f)){
	char line[1024];
	regmatch_t pm[2];
	memset(pm,0,sizeof(pm));
	if(fgets(line,sizeof(line),f)){
	    if(regexec(&r,line,2,pm,0)==0){
		char mac[16];
		memset(mac,0,sizeof(mac));
		strncpy(mac,line+pm[1].rm_so,pm[1].rm_eo-pm[1].rm_so);
		buf = append(buf,mac);
		buf = append(buf,"\n");
	    }
	}
    }
    pclose(f);
    return buf;
}

/* Return the results of dmesg */
char *ident::dmesg()
{
    char *buf = append(0,0);
    FILE *f = popen("dmesg 2>/dev/null","r");
    if(!f) return buf;

    while(!feof(f)){
	char line[1024];
	if(fgets(line,sizeof(line),f)){
	    buf = append(buf,line);
	}
    }
    pclose(f);
    return buf;

}
