# ----------------------------------------------------------------------------
# - afnix-docs                                                               -
# - afnix documentation rule makefile configuration                          -
# ----------------------------------------------------------------------------
# - This program is  free software;  you can  redistribute it and/or  modify -
# - it provided that this copyright notice is kept intact.                   -
# -                                                                          -
# - This  program  is  distributed in the hope  that it  will be useful, but -
# - without  any   warranty;  without  even   the   implied    warranty   of -
# - merchantability  or fitness for a particular purpose. In not event shall -
# - the copyright holder be  liable for  any direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.      -
# ----------------------------------------------------------------------------
# - copyright (c) 1999-2007 amaury darsch                                    -
# ----------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# - documentation definitions                                                -
# ----------------------------------------------------------------------------

DOCETC		= $(DIRDOC)/etc
DOCDTD		= $(DIRDOC)/dtd
DOCXML		= $(DIRDOC)/xml

REFCSS		= $(DOCETC)/style.css
REFIMG		= $(DOCETC)/afnix.png
REFDTD		= $(DOCDTD)/axmxa.dtd

# ----------------------------------------------------------------------------
# - documentation control                                                    -
# ----------------------------------------------------------------------------

ADPLIB		= $(BLDPRJ)/afnix-adp.axl
ADPEXE		= "axi"
XHTMAN		= $(MANUAL:.xml=.xht)
XHTOPT		= "-f assert -i $(ADPLIB) adp-start -x -o $(XHTMAN)"
MANOPT		= "-f assert -i $(ADPLIB) adp-start -m -o $(MANMAN)"

# ----------------------------------------------------------------------------
# - documentation rules                                                      -
# ----------------------------------------------------------------------------

ifneq ($(MANUAL),)
doc: xht man
	@$(MKDIR) $(DOCXHT)
	@$(CP) $(REFCSS)           $(DOCXHT)
	@$(CP) $(REFIMG)           $(DOCXHT)
	@$(CP) $(MANUAL:.xml=.xht) $(DOCXHT)
.PHONY: doc

# rule: xht
# this rule generate a xhtml documentation

xht:
	@$(AEXEC) --prefix=$(BLDDIR) \
                  --binexe=$(ADPEXE) --binopt=$(XHTOPT) $(MANUAL)
.PHONY: xht

# rule: man
# this rule generate a groff documentation

ifeq ($(MANMAN),)
man:
.PHONY: man
else
man:
	@$(AEXEC) --prefix=$(BLDDIR) \
                  --binexe=$(ADPEXE) --binopt=$(MANOPT) $(MANUAL)
	@$(MKDIR) $(DOCMAN)
	@$(CP) $(MANMAN) $(DOCMAN)

.PHONY: man
endif

endif

# ----------------------------------------------------------------------------
# - generic clean                                                            -
# ----------------------------------------------------------------------------

clean::
	@$(RM) *~ core *.core
.PHONY: clean
