// ---------------------------------------------------------------------------
// - Launch.cpp                                                              -
// - afnix engine - thread builtin functions implementation                  -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Cons.hpp"
#include "Builtin.hpp"
#include "Runnable.hpp"
#include "Exception.hpp"

namespace afnix {

  // launch reserved function implementation

  Object* builtin_launch (Runnable* robj, Nameset* nset, Cons* args) {
    Object* form = (args == nilp) ? nilp : args->getcar ();
    if (form == nilp) return nilp;
    Object* fobj = Cons::mkform (robj, nset, form);
    return robj->launch (fobj);
  }

  // daemon reserved function implementation

  Object* builtin_daemon (Runnable* robj, Nameset* nset, Cons* args) {
    Object* form = (args == nilp) ? nilp : args->getcar ();
    if (form == nilp) return nilp;
    return robj->daemon (Cons::mkform (robj, nset, form));
  }

  // synchronize reserved function implementation

  Object* builtin_sync (Runnable* robj, Nameset* nset, Cons* args) {
    Object* form = (args == nilp) ? nilp : args->getcar ();
    if (form == nilp) return nilp;
    // make sure we have a form - if not - we simply eval
    Cons* cons = dynamic_cast <Cons*> (form);
    if (cons == nilp) return cons->eval (robj, nset);
    // synchronize the form and eval
    cons->mksync ();
    return cons->eval (robj, nset);
  }
}
