// ---------------------------------------------------------------------------
// - Md5.hpp                                                                 -
// - afnix cryptography - MD5 message digest class definition                -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_MD5_HPP
#define  AFNIX_MD5_HPP

#ifndef  AFNIX_HASHER_HPP
#include "Hasher.hpp"
#endif

namespace afnix {

  /// The Md5 class is a class that can be used to compute a message
  /// digest based on the MD5 algorithm. The algorithm used here is the
  /// one described by Ron Rivest in RFC 1321. This implementation is also
  /// very inspired from RFC 1321.
  /// @author amaury darsch

  class Md5 : public Hasher {
  private:
    // MD5 ABCD states
    t_quad d_state[4];

  public:
    /// create an MD5 hasher
    Md5 (void);

    /// @return the class name
    String repr (void) const;

    /// reset this hasher
    void reset (void);
 
  private:
    // make the copy constructor private
    Md5 (const Md5&);
    // make the assignment operator private
    Md5& operator = (const Md5&);
    // update the message state with the buffer data
    void update  (void);
    // process a message by data and size
    void process  (const t_byte*, const long);
    // process a message with an input stream
    void process  (Input&);
    // finish the message by padding the data
    void finish   (void);
    // return the formatted message hash
    String format (void) const;

  public:
    /// cerate a new object in a generic way
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);
  };
}

#endif
