// ---------------------------------------------------------------------------
// - P000E.hxx                                                               -
// - unicode database (ucd) library definitions: plane E                     -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "cucd.hpp"

namespace afnix {
  // the plane size
  const long  UCD_PSIZE_000E   = 337;
  // the plane data
  const ucd_s UCD_PLANE_000E[] = {
    {
      0x000E0001,
      "LANGUAGE TAG",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0020,
      "TAG SPACE",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0021,
      "TAG EXCLAMATION MARK",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0022,
      "TAG QUOTATION MARK",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0023,
      "TAG NUMBER SIGN",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0024,
      "TAG DOLLAR SIGN",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0025,
      "TAG PERCENT SIGN",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0026,
      "TAG AMPERSAND",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0027,
      "TAG APOSTROPHE",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0028,
      "TAG LEFT PARENTHESIS",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0029,
      "TAG RIGHT PARENTHESIS",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E002A,
      "TAG ASTERISK",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E002B,
      "TAG PLUS SIGN",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E002C,
      "TAG COMMA",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E002D,
      "TAG HYPHEN-MINUS",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E002E,
      "TAG FULL STOP",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E002F,
      "TAG SOLIDUS",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0030,
      "TAG DIGIT ZERO",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0031,
      "TAG DIGIT ONE",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0032,
      "TAG DIGIT TWO",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0033,
      "TAG DIGIT THREE",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0034,
      "TAG DIGIT FOUR",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0035,
      "TAG DIGIT FIVE",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0036,
      "TAG DIGIT SIX",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0037,
      "TAG DIGIT SEVEN",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0038,
      "TAG DIGIT EIGHT",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0039,
      "TAG DIGIT NINE",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E003A,
      "TAG COLON",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E003B,
      "TAG SEMICOLON",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E003C,
      "TAG LESS-THAN SIGN",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E003D,
      "TAG EQUALS SIGN",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E003E,
      "TAG GREATER-THAN SIGN",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E003F,
      "TAG QUESTION MARK",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0040,
      "TAG COMMERCIAL AT",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0041,
      "TAG LATIN CAPITAL LETTER A",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0042,
      "TAG LATIN CAPITAL LETTER B",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0043,
      "TAG LATIN CAPITAL LETTER C",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0044,
      "TAG LATIN CAPITAL LETTER D",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0045,
      "TAG LATIN CAPITAL LETTER E",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0046,
      "TAG LATIN CAPITAL LETTER F",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0047,
      "TAG LATIN CAPITAL LETTER G",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0048,
      "TAG LATIN CAPITAL LETTER H",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0049,
      "TAG LATIN CAPITAL LETTER I",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E004A,
      "TAG LATIN CAPITAL LETTER J",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E004B,
      "TAG LATIN CAPITAL LETTER K",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E004C,
      "TAG LATIN CAPITAL LETTER L",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E004D,
      "TAG LATIN CAPITAL LETTER M",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E004E,
      "TAG LATIN CAPITAL LETTER N",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E004F,
      "TAG LATIN CAPITAL LETTER O",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0050,
      "TAG LATIN CAPITAL LETTER P",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0051,
      "TAG LATIN CAPITAL LETTER Q",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0052,
      "TAG LATIN CAPITAL LETTER R",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0053,
      "TAG LATIN CAPITAL LETTER S",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0054,
      "TAG LATIN CAPITAL LETTER T",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0055,
      "TAG LATIN CAPITAL LETTER U",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0056,
      "TAG LATIN CAPITAL LETTER V",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0057,
      "TAG LATIN CAPITAL LETTER W",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0058,
      "TAG LATIN CAPITAL LETTER X",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0059,
      "TAG LATIN CAPITAL LETTER Y",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E005A,
      "TAG LATIN CAPITAL LETTER Z",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E005B,
      "TAG LEFT SQUARE BRACKET",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E005C,
      "TAG REVERSE SOLIDUS",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E005D,
      "TAG RIGHT SQUARE BRACKET",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E005E,
      "TAG CIRCUMFLEX ACCENT",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E005F,
      "TAG LOW LINE",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0060,
      "TAG GRAVE ACCENT",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0061,
      "TAG LATIN SMALL LETTER A",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0062,
      "TAG LATIN SMALL LETTER B",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0063,
      "TAG LATIN SMALL LETTER C",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0064,
      "TAG LATIN SMALL LETTER D",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0065,
      "TAG LATIN SMALL LETTER E",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0066,
      "TAG LATIN SMALL LETTER F",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0067,
      "TAG LATIN SMALL LETTER G",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0068,
      "TAG LATIN SMALL LETTER H",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0069,
      "TAG LATIN SMALL LETTER I",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E006A,
      "TAG LATIN SMALL LETTER J",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E006B,
      "TAG LATIN SMALL LETTER K",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E006C,
      "TAG LATIN SMALL LETTER L",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E006D,
      "TAG LATIN SMALL LETTER M",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E006E,
      "TAG LATIN SMALL LETTER N",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E006F,
      "TAG LATIN SMALL LETTER O",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0070,
      "TAG LATIN SMALL LETTER P",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0071,
      "TAG LATIN SMALL LETTER Q",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0072,
      "TAG LATIN SMALL LETTER R",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0073,
      "TAG LATIN SMALL LETTER S",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0074,
      "TAG LATIN SMALL LETTER T",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0075,
      "TAG LATIN SMALL LETTER U",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0076,
      "TAG LATIN SMALL LETTER V",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0077,
      "TAG LATIN SMALL LETTER W",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0078,
      "TAG LATIN SMALL LETTER X",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0079,
      "TAG LATIN SMALL LETTER Y",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E007A,
      "TAG LATIN SMALL LETTER Z",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E007B,
      "TAG LEFT CURLY BRACKET",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E007C,
      "TAG VERTICAL LINE",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E007D,
      "TAG RIGHT CURLY BRACKET",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E007E,
      "TAG TILDE",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E007F,
      "CANCEL TAG",
      0x61, 0, 0x0E, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0100,
      "VARIATION SELECTOR-17",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0101,
      "VARIATION SELECTOR-18",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0102,
      "VARIATION SELECTOR-19",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0103,
      "VARIATION SELECTOR-20",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0104,
      "VARIATION SELECTOR-21",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0105,
      "VARIATION SELECTOR-22",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0106,
      "VARIATION SELECTOR-23",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0107,
      "VARIATION SELECTOR-24",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0108,
      "VARIATION SELECTOR-25",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0109,
      "VARIATION SELECTOR-26",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E010A,
      "VARIATION SELECTOR-27",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E010B,
      "VARIATION SELECTOR-28",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E010C,
      "VARIATION SELECTOR-29",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E010D,
      "VARIATION SELECTOR-30",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E010E,
      "VARIATION SELECTOR-31",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E010F,
      "VARIATION SELECTOR-32",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0110,
      "VARIATION SELECTOR-33",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0111,
      "VARIATION SELECTOR-34",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0112,
      "VARIATION SELECTOR-35",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0113,
      "VARIATION SELECTOR-36",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0114,
      "VARIATION SELECTOR-37",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0115,
      "VARIATION SELECTOR-38",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0116,
      "VARIATION SELECTOR-39",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0117,
      "VARIATION SELECTOR-40",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0118,
      "VARIATION SELECTOR-41",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0119,
      "VARIATION SELECTOR-42",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E011A,
      "VARIATION SELECTOR-43",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E011B,
      "VARIATION SELECTOR-44",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E011C,
      "VARIATION SELECTOR-45",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E011D,
      "VARIATION SELECTOR-46",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E011E,
      "VARIATION SELECTOR-47",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E011F,
      "VARIATION SELECTOR-48",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0120,
      "VARIATION SELECTOR-49",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0121,
      "VARIATION SELECTOR-50",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0122,
      "VARIATION SELECTOR-51",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0123,
      "VARIATION SELECTOR-52",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0124,
      "VARIATION SELECTOR-53",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0125,
      "VARIATION SELECTOR-54",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0126,
      "VARIATION SELECTOR-55",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0127,
      "VARIATION SELECTOR-56",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0128,
      "VARIATION SELECTOR-57",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0129,
      "VARIATION SELECTOR-58",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E012A,
      "VARIATION SELECTOR-59",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E012B,
      "VARIATION SELECTOR-60",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E012C,
      "VARIATION SELECTOR-61",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E012D,
      "VARIATION SELECTOR-62",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E012E,
      "VARIATION SELECTOR-63",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E012F,
      "VARIATION SELECTOR-64",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0130,
      "VARIATION SELECTOR-65",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0131,
      "VARIATION SELECTOR-66",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0132,
      "VARIATION SELECTOR-67",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0133,
      "VARIATION SELECTOR-68",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0134,
      "VARIATION SELECTOR-69",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0135,
      "VARIATION SELECTOR-70",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0136,
      "VARIATION SELECTOR-71",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0137,
      "VARIATION SELECTOR-72",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0138,
      "VARIATION SELECTOR-73",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0139,
      "VARIATION SELECTOR-74",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E013A,
      "VARIATION SELECTOR-75",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E013B,
      "VARIATION SELECTOR-76",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E013C,
      "VARIATION SELECTOR-77",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E013D,
      "VARIATION SELECTOR-78",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E013E,
      "VARIATION SELECTOR-79",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E013F,
      "VARIATION SELECTOR-80",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0140,
      "VARIATION SELECTOR-81",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0141,
      "VARIATION SELECTOR-82",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0142,
      "VARIATION SELECTOR-83",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0143,
      "VARIATION SELECTOR-84",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0144,
      "VARIATION SELECTOR-85",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0145,
      "VARIATION SELECTOR-86",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0146,
      "VARIATION SELECTOR-87",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0147,
      "VARIATION SELECTOR-88",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0148,
      "VARIATION SELECTOR-89",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0149,
      "VARIATION SELECTOR-90",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E014A,
      "VARIATION SELECTOR-91",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E014B,
      "VARIATION SELECTOR-92",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E014C,
      "VARIATION SELECTOR-93",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E014D,
      "VARIATION SELECTOR-94",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E014E,
      "VARIATION SELECTOR-95",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E014F,
      "VARIATION SELECTOR-96",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0150,
      "VARIATION SELECTOR-97",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0151,
      "VARIATION SELECTOR-98",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0152,
      "VARIATION SELECTOR-99",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0153,
      "VARIATION SELECTOR-100",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0154,
      "VARIATION SELECTOR-101",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0155,
      "VARIATION SELECTOR-102",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0156,
      "VARIATION SELECTOR-103",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0157,
      "VARIATION SELECTOR-104",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0158,
      "VARIATION SELECTOR-105",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0159,
      "VARIATION SELECTOR-106",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E015A,
      "VARIATION SELECTOR-107",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E015B,
      "VARIATION SELECTOR-108",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E015C,
      "VARIATION SELECTOR-109",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E015D,
      "VARIATION SELECTOR-110",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E015E,
      "VARIATION SELECTOR-111",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E015F,
      "VARIATION SELECTOR-112",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0160,
      "VARIATION SELECTOR-113",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0161,
      "VARIATION SELECTOR-114",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0162,
      "VARIATION SELECTOR-115",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0163,
      "VARIATION SELECTOR-116",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0164,
      "VARIATION SELECTOR-117",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0165,
      "VARIATION SELECTOR-118",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0166,
      "VARIATION SELECTOR-119",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0167,
      "VARIATION SELECTOR-120",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0168,
      "VARIATION SELECTOR-121",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0169,
      "VARIATION SELECTOR-122",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E016A,
      "VARIATION SELECTOR-123",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E016B,
      "VARIATION SELECTOR-124",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E016C,
      "VARIATION SELECTOR-125",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E016D,
      "VARIATION SELECTOR-126",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E016E,
      "VARIATION SELECTOR-127",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E016F,
      "VARIATION SELECTOR-128",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0170,
      "VARIATION SELECTOR-129",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0171,
      "VARIATION SELECTOR-130",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0172,
      "VARIATION SELECTOR-131",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0173,
      "VARIATION SELECTOR-132",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0174,
      "VARIATION SELECTOR-133",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0175,
      "VARIATION SELECTOR-134",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0176,
      "VARIATION SELECTOR-135",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0177,
      "VARIATION SELECTOR-136",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0178,
      "VARIATION SELECTOR-137",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0179,
      "VARIATION SELECTOR-138",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E017A,
      "VARIATION SELECTOR-139",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E017B,
      "VARIATION SELECTOR-140",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E017C,
      "VARIATION SELECTOR-141",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E017D,
      "VARIATION SELECTOR-142",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E017E,
      "VARIATION SELECTOR-143",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E017F,
      "VARIATION SELECTOR-144",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0180,
      "VARIATION SELECTOR-145",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0181,
      "VARIATION SELECTOR-146",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0182,
      "VARIATION SELECTOR-147",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0183,
      "VARIATION SELECTOR-148",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0184,
      "VARIATION SELECTOR-149",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0185,
      "VARIATION SELECTOR-150",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0186,
      "VARIATION SELECTOR-151",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0187,
      "VARIATION SELECTOR-152",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0188,
      "VARIATION SELECTOR-153",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0189,
      "VARIATION SELECTOR-154",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E018A,
      "VARIATION SELECTOR-155",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E018B,
      "VARIATION SELECTOR-156",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E018C,
      "VARIATION SELECTOR-157",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E018D,
      "VARIATION SELECTOR-158",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E018E,
      "VARIATION SELECTOR-159",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E018F,
      "VARIATION SELECTOR-160",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0190,
      "VARIATION SELECTOR-161",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0191,
      "VARIATION SELECTOR-162",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0192,
      "VARIATION SELECTOR-163",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0193,
      "VARIATION SELECTOR-164",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0194,
      "VARIATION SELECTOR-165",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0195,
      "VARIATION SELECTOR-166",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0196,
      "VARIATION SELECTOR-167",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0197,
      "VARIATION SELECTOR-168",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0198,
      "VARIATION SELECTOR-169",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E0199,
      "VARIATION SELECTOR-170",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E019A,
      "VARIATION SELECTOR-171",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E019B,
      "VARIATION SELECTOR-172",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E019C,
      "VARIATION SELECTOR-173",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E019D,
      "VARIATION SELECTOR-174",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E019E,
      "VARIATION SELECTOR-175",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E019F,
      "VARIATION SELECTOR-176",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01A0,
      "VARIATION SELECTOR-177",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01A1,
      "VARIATION SELECTOR-178",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01A2,
      "VARIATION SELECTOR-179",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01A3,
      "VARIATION SELECTOR-180",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01A4,
      "VARIATION SELECTOR-181",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01A5,
      "VARIATION SELECTOR-182",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01A6,
      "VARIATION SELECTOR-183",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01A7,
      "VARIATION SELECTOR-184",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01A8,
      "VARIATION SELECTOR-185",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01A9,
      "VARIATION SELECTOR-186",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01AA,
      "VARIATION SELECTOR-187",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01AB,
      "VARIATION SELECTOR-188",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01AC,
      "VARIATION SELECTOR-189",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01AD,
      "VARIATION SELECTOR-190",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01AE,
      "VARIATION SELECTOR-191",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01AF,
      "VARIATION SELECTOR-192",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01B0,
      "VARIATION SELECTOR-193",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01B1,
      "VARIATION SELECTOR-194",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01B2,
      "VARIATION SELECTOR-195",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01B3,
      "VARIATION SELECTOR-196",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01B4,
      "VARIATION SELECTOR-197",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01B5,
      "VARIATION SELECTOR-198",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01B6,
      "VARIATION SELECTOR-199",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01B7,
      "VARIATION SELECTOR-200",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01B8,
      "VARIATION SELECTOR-201",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01B9,
      "VARIATION SELECTOR-202",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01BA,
      "VARIATION SELECTOR-203",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01BB,
      "VARIATION SELECTOR-204",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01BC,
      "VARIATION SELECTOR-205",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01BD,
      "VARIATION SELECTOR-206",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01BE,
      "VARIATION SELECTOR-207",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01BF,
      "VARIATION SELECTOR-208",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01C0,
      "VARIATION SELECTOR-209",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01C1,
      "VARIATION SELECTOR-210",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01C2,
      "VARIATION SELECTOR-211",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01C3,
      "VARIATION SELECTOR-212",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01C4,
      "VARIATION SELECTOR-213",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01C5,
      "VARIATION SELECTOR-214",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01C6,
      "VARIATION SELECTOR-215",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01C7,
      "VARIATION SELECTOR-216",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01C8,
      "VARIATION SELECTOR-217",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01C9,
      "VARIATION SELECTOR-218",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01CA,
      "VARIATION SELECTOR-219",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01CB,
      "VARIATION SELECTOR-220",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01CC,
      "VARIATION SELECTOR-221",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01CD,
      "VARIATION SELECTOR-222",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01CE,
      "VARIATION SELECTOR-223",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01CF,
      "VARIATION SELECTOR-224",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01D0,
      "VARIATION SELECTOR-225",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01D1,
      "VARIATION SELECTOR-226",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01D2,
      "VARIATION SELECTOR-227",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01D3,
      "VARIATION SELECTOR-228",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01D4,
      "VARIATION SELECTOR-229",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01D5,
      "VARIATION SELECTOR-230",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01D6,
      "VARIATION SELECTOR-231",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01D7,
      "VARIATION SELECTOR-232",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01D8,
      "VARIATION SELECTOR-233",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01D9,
      "VARIATION SELECTOR-234",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01DA,
      "VARIATION SELECTOR-235",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01DB,
      "VARIATION SELECTOR-236",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01DC,
      "VARIATION SELECTOR-237",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01DD,
      "VARIATION SELECTOR-238",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01DE,
      "VARIATION SELECTOR-239",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01DF,
      "VARIATION SELECTOR-240",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01E0,
      "VARIATION SELECTOR-241",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01E1,
      "VARIATION SELECTOR-242",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01E2,
      "VARIATION SELECTOR-243",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01E3,
      "VARIATION SELECTOR-244",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01E4,
      "VARIATION SELECTOR-245",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01E5,
      "VARIATION SELECTOR-246",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01E6,
      "VARIATION SELECTOR-247",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01E7,
      "VARIATION SELECTOR-248",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01E8,
      "VARIATION SELECTOR-249",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01E9,
      "VARIATION SELECTOR-250",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01EA,
      "VARIATION SELECTOR-251",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01EB,
      "VARIATION SELECTOR-252",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01EC,
      "VARIATION SELECTOR-253",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01ED,
      "VARIATION SELECTOR-254",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01EE,
      "VARIATION SELECTOR-255",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x000E01EF,
      "VARIATION SELECTOR-256",
      0x10, 0, 0x0D, 0x00,
      0x00,
      {0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    }
  };
};
