# ---------------------------------------------------------------------------
# - SYS0007.als                                                             -
# - afnix:sys module test unit                                              -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2007 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   date class test unit
# @author amaury darsch

# get the module
interp:library "afnix-sys"

# simple date class
const  date (afnix:sys:Date 0)
assert true (afnix:sys:date-p date)

# check access methods
assert 0 (date:year)
assert 1 (date:month)
assert 1 (date:day)
assert 1 (date:year-day)
assert 0 (date:get-time)
assert 0 (date:hours)
assert 0 (date:minutes)
assert 0 (date:seconds)
# check the mapping
assert "Sat" (date:map-day)
assert "Jan" (date:map-month)

# check the format
assert "0000-01-01"           (date:to-date)
assert "00:00:00"             (date:to-time true)
assert "0000-01-01T00:00:00Z" (date:to-iso  true)
assert "Sat Jan 1 00:00:00 0" (date:format  true)

# check the epoch (1970-1-1 is a thursday)
date:set-date 1970 1 1
assert 1970 (date:year)
assert 1    (date:month)
assert 1    (date:day)
assert 1    (date:year-day)
# check the mapping
assert "Thu" (date:map-day)
assert "Jan" (date:map-month)

# check the format
assert "1970-01-01"              (date:to-date)
assert "00:00:00"                (date:to-time true)
assert "1970-01-01T00:00:00Z"    (date:to-iso  true)
assert "Thu Jan 1 00:00:00 1970" (date:format  true)

# add some year and month and check again
date:add-years 30
assert "2000-01-01"              (date:to-date)
date:add-months 13
assert "2001-02-01"              (date:to-date)
