/*******************************************************************************
 *  PROJECT: GNOME Colorscheme
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2005 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/

#ifndef _GCS_SCHEME_H
#define _GCS_SCHEME_H

#include <memory>   // for std::auto_ptr
#include "gcs-color-group.h"

namespace gcs
{

    /** The different types of color scheme algorithms that are supported by
     * the library.
     */
    typedef enum
    {
        SCHEME_COMPLEMENTS,
        SCHEME_SPLIT_COMPLEMENTS,
        SCHEME_TRIADS,
        SCHEME_TETRADS,
        SCHEME_ANALOGOUS,
        SCHEME_MONOCHROMATIC
    } tSchemeType;


    /** A class for storing a colorscheme
     */
    class Scheme : public ColorGroup 
    {
        public:
            Scheme(ColorPtr c, tSchemeType schemeType);

            bool operator==(const Scheme& other);

            void set_color(ColorPtr c);
            ColorPtr get_color(void) { return m_color; }
            void set_scheme_type(tSchemeType t);
            tSchemeType get_scheme_type(void) { return m_schemeType; }

        protected:
            void init(void);
            ColorPtr m_color;
            tSchemeType m_schemeType;
    };

    typedef std::auto_ptr<Scheme> ref_scheme_type;

} // namespace gcs

#endif // _GCS_SCHEME_H
