/*******************************************************************************
 *  PROJECT: GNOME Colorscheme
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2005 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/
#ifndef __GCS_CONF_H
#define _GCS_CONF_H

#include <glibmm/ustring.h>
#include "core/gcs-color.h"
#include "core/gcs-scheme.h"

namespace gcs
{

    class Conf
    {
        public:
            static Glib::ustring get_last_save_dir(void);
            static void set_last_save_dir(Glib::ustring uri);
            static ColorPtr get_last_color(void);
            static void set_last_color(ColorPtr clr);
            static void set_last_scheme_type(tSchemeType t);
            static tSchemeType get_last_scheme_type(void);

            static int get_window_width(void);
            static void set_window_width(int w);
            static int get_window_height(void);
            static void set_window_height(int h);

            static Glib::ustring get_favorites_file(void);
            static Glib::ustring get_conf_dir(void);

            static const Glib::ustring APP_DIR;
            static const Glib::ustring KEY_LAST_SAVE_DIR;
            static const Glib::ustring KEY_LAST_COLOR;
            static const Glib::ustring KEY_LAST_SCHEME_TYPE;
            static const Glib::ustring KEY_WINDOW_WIDTH;
            static const Glib::ustring KEY_WINDOW_HEIGHT;
            static const Glib::ustring FAVORITES_FILE;
            static const Glib::ustring GCS_CONF_DIR;

            // window / ui settings
            static const int WINDOW_BORDER;
            static const int UI_SPACING_SMALL;
            static const int UI_SPACING_MEDIUM;
            static const int UI_SPACING_LARGE;
    };
} // namespace gcs

#endif // __GCS_CONF_H
