/*******************************************************************************
 *  PROJECT: Agave
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2005 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/
#ifndef __GCS_UTIL_H
#define __GCS_UTIL_H

#include <glibmm/ustring.h>
#include <cstddef>
#include <boost/shared_ptr.hpp>
 
namespace gcs
{

    // General tool to strip spaces from both ends of a string
    // from Bruce Eckel's "Thinking in C++" book
    inline Glib::ustring trim(const Glib::ustring& s) {
        const Glib::ustring whitespace(" \a\b\f\n\r\t\v");
        if(s.length() == 0)
            return s;
        std::size_t beg = s.find_first_not_of(whitespace);
        std::size_t end = s.find_last_not_of(whitespace);
        if(beg == Glib::ustring::npos) // No non-spaces
            return "";
        return Glib::ustring(s, beg, end - beg + 1);
    }


    inline boost::shared_ptr<Gdk::Color> get_dropped_color(const Gtk::SelectionData& selection_data)
    {
        boost::shared_ptr<Gdk::Color> c;
        std::string target = selection_data.get_target();

        // Gimp sends data in application/x-color format, and a lot of GNOME
        // applications accept it (for instance drop it to a terminal window
        // and it changes the background color)
        if (target == "application/x-color")
        {
            debug("Trying to set dropped color from application/x-color: ");
            // application/x-color is a 16-bit format
            const guint16* data =
                reinterpret_cast<const guint16*>(selection_data.get_data());
            // it's easy to use this data with a Gdk::Color type
            c.reset(new Gdk::Color);
            c->set_red(data[0]);
            c->set_green(data[1]);
            c->set_blue(data[2]);
            // alpha value is data[3] but we don't use it yet
        }

        return c;
    }


} // namespace gcs

#endif // __GCS_UTIL_H
