#! /usr/bin/env python3
# -*- coding: utf-8 -*-

#Do not change these during runtime!

METADATA={
    #The pretty name of this program. Used for NSM display and Jack client name
    #Can contain everything a linux file/path supports. Never change this or it will break the
    #session, making your file unable to load and destroying saved Jack connections.
    "name" : "Agordejo",

    #Set this to the name the user types into a terminal.
    #MUST be the same as the binary name as well as the name in configure.
    #Program reports that as proc title so you can killall it by name.
    #Should not contain spaces or special characters. We use this as save file extension as well
    #to distinguish between compatible program versions. In basic programs this will just be e.g.
    #patroneo. But in complex programs with a bright future it will be "laborejo1" "laborejo2" etc.
    "shortName" : "agordejo",

    #A very short description used in various places: Desktop file, overview on the website,
    #release announcements, entries in software directories etc.
    "tagline" : 'Music and audio production session manager based on NSM.',

    "version" : "0.4.0",
    "year" : "2022",
    "author" : "Laborejo Software Suite",
    "url" : "https://www.laborejo.org/agordejo",

    #English is automatic.
    "supportedLanguages" : {"German":"de.qm", "Italian":"it.qm", },

    #Show the About Dialog the first time the program starts up. This is the initial state for a
    #new instance in NSM, not the saved state! Decide on how annoying it would be for every new
    #instance to show about. Fluajho does not show it because you add it many times into a session.
    #Patroneo does because its only added once.
    "showAboutDialogFirstStart" : False,

    "preferredClients" : {"data":"nsm-data", "connections":"jackpatch", "proxy":"nsm-proxy"},

    #Various strings for the README
    #Extra whitespace will be stripped so we don't need to worry about docstring indentation
    "description" : """
Agordejo (Esperanto: 'place to set things up') is a music production session manager.
It is used to start your programs, remember their (JACK) interconnections and make your life easier
in general.
""" + "\n" + """
You can create a session, or project, add programs to it and then use commands to save, start/stop,
hide/show all programs at once, or individually. At a later date you can then re-open
the session and continue where you left off.
""" + "\n" + """
Agordejo does not re-invent the wheel but instead uses the New-Session-Manager daemon and enhances
it with some tricks of its own, that always remain 100% compatible with the original sessions.
""", #this is the dict-comma.

    "dependencies" : "\n".join("* "+dep for dep in ("nsmd: New Session Manager", "pyxdg: python-xdg")),

}
