.TH AHCPD 8
.SH NAME
ahcpd \- ad-hoc configuration daemon
.SH SYNOPSIS
.B ahcpd
.IR option ...
[
.B \-\-
]
.IR interface ...
.SH DESCRIPTION
AHCP is a configuration protocol that can replace DHCP on networks without
transitive connectivity, such as mesh networks.
.SH OPTIONS
.TP
.BI \-m " multicast-address"
Specify the link-local multicast address to be used by AHCP.  The
default is ff02::cca6:c0f9:e182:5359.
.TP
.BI \-p " port"
Specify the UDP port number to be used by AHCP.  The default is 5359.
.TP
.B \-n
Operate as a forwarder: participate in the flooding protocol, but don't
actually perform any configuration.
.TP
.B \-4
Only attempt to configure IPv4 addresses.
.TP
.B \-6
Only attempt to configure IPv6 addresses.
.TP
.B \-N
Do not configure DNS.
.TP
.BI \-t " time"
Specify the time, in seconds, for which leases are requested.  The default
is slightly over one hour.  Must be between five minutes and a year.
.TP
.BI \-s " script"
Specify the configuration script to run.  The default is
.BR /etc/ahcp/ahcp-config.sh .
.TP
.BI \-d " level"
Set the debug level to
.I level
(default 1).
.TP
.BI \-i " filename"
Specify the filename containing this host's unique id.  The default is
.BR /var/lib/ahcp\-unique\-id .
If it doesn't exist, it will be created by
.BR ahcpd .
.TP
.BI \-c " filename"
Specify the name of the configuration file.
.TP
.BI \-C " statement"
Specify a configuration statement directly on the command line.
.TP
.B \-D
Daemonise at startup.
.TP
.BI \-L " logfile"
Specify a file to log random ``how do you do?'' messages to.  This
defaults to standard error if not daemonising, and to
.B /var/log/ahcpd.log
otherwise.
.TP
.BI \-I " pidfile"
Specify a file to write our process id to.  The default is
.B /var/run/ahcpd.pid.
.SH CONFIGURATION FILE FORMAT
The configuration is a sequence of lines, each of which starts with
one of the keywords below.  Blank lines are ignored.  Comments are
introduced with an octothorp
.RB `` # ''
and terminate at the end of the line.

The following keywords are recognised:
.TP
.BR mode " " server | client | forwarder
Specifies whether the daemon operates as a server, a client, or
a forwarder.  If omitted, the default is to operate as a client, unless
the
.B \-n
flag is present on the command line.  If present, this must be the first
line in the configuration file.
.TP
.BI prefix " prefix"
Specifies a prefix to use for configuring clients.  This keyword is only
valid in server configurations, and may be specified twice, once for
IPv4 and once for IPv6.
.TP
.BI lease-dir " directory"
Specifies a directory to store lease files.  This keyword is only valid
in server configurations.
.TP
.BI name-server " address"
Specifies the address of a DNS server to configure clients with.  This
keyword is only valid in server configurations, and may be repeated
multiple times.
.TP
.BI ntp-server " address"
Specifies the address of an NTP server to configure clients with.  This
keyword is only valid in server configurations, and may be repeated
multiple times.
.SH FILES
.TP
.B /var/lib/ahcp\-unique\-id
An 8-byte long file containing this host's unique id.  If it doesn't exist,
a new unique id will be generated from an interface's MAC address.
.TP
.BR /etc/ahcp/ahcp\-config.sh
The script that performs the actual configuration.  It will be passed one
argument, which is either
.B start
or
.BR stop .
.TP
.B /etc/ahcp/ahcp\-local.sh
If this is an executable script, it will be called by
.B ahcp\-config.sh
just after configuring or deconfiguring. It will be passed one
argument, which is either
.B start
or
.BR stop .
.SH SIGNALS
.TP
.B SIGUSR1
Print
.BR ahcpd 's
status to standard output or to the log file.
.TP
.B SIGUSR2
Check all interfaces for status changes, then reopen the log file.
.SH NOTES
Since the AHCP protocol is designed for mesh networks, it doesn't have any
provisions for setting routing parameters such as a default gateway, the
IPv4 network mask and the IPv6 list of on-link prefixes; these are expected
to be provided by a full-fledged routing protocol for mesh nodes, and by
router advertisements for ordinary nodes.

The AHCP server should use NTP to synchronise its clock.  If a server
instance of
.B ahcpd
doesn't detect time synchronisation, it will only give out leases for
a short period of time, and be extremely conservative about releasing them.
Note that an SNTP client is not enough \[em]
.B ahcpd
actually checks with the kernel for time synchronisation, so real NTP is
necessary.
.SH SEE ALSO
.BR dhcpcd (8),
.BR dhclient (8),
.BR babeld (8),
.BR olsrd (8),
.BR ntpd (8),
.IR "The Ad-Hoc Configuration Protocol" .
.SH AUTHOR
Juliusz Chroboczek.
