#ifndef _BOOK_H
#define _BOOK_H

#include "strings.h"
#include "item.h"
#include "builder.h"
#include "mudobject.h"
#include "moveable.h"

class Book : public Moveable 
{
public:

   Book(char *the_name, char *the_area);
   virtual ~Book();

   virtual void write_object(FILE *the_file, int build_format);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   int     read_book(MudObject *the_user);
   int     set_book_subject(char *subject);
   char    *get_book_subject();
   Book    *operator = (Book *copy_from); 
   int     read_book_attrib(FILE *read_file, ErrLog *error_log);
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();

private:

   Book();
   Strings the_booksubject;
};

#endif
