#ifndef _ENTITY_H
#define _ENTITY_H

#include "strings.h"
#include "linkedlist.h"
#include "errlog.h"

class Builder;

class Entity
{
public:

   Entity();
   virtual ~Entity();
   char *get_name();   /* gets the name of the object */
   int  get_type();  /* returns the number of the object */
   int  is_modified(void);
   void set_modified(int the_val);
   int  trylock(void);
   int  unlock(void);
   Entity  *operator = (Entity *copy_from); 

   int  is_a_mudobject();
   int  is_a_moveable();
   int  is_merger();
   int  is_an_item();
   int  is_an_ability();
   int  is_an_individual();

   int  set_area(char *the_area);
   char *get_area(void);
   Entity *copy_obj(char *new_name);

   virtual void write_object(FILE *the_file, int build_format);
   virtual void describe(Player *the_player);
   virtual void describe(Builder *the_builder);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();

   int     get_mem_size_entity();

protected:

   int set_name(char *the_name);

   int             obj_type;          /* the object type */ 

private:

   Strings         name;              /* the object name */
   Strings         area;              /* the object's area it came from */

   int             modified;          /* has this object been modified from
                                         the original */

};

#endif

