#ifndef _GETTEXT_H_
#define _GETTEXT_H_

// If they do have gettext
#ifdef HAVE_GETTEXT

#include <libintl.h>
#define _(String) gettext(String)

#ifdef gettext_noop
#define N_(String) gettext_noop(String)
#else
#define N_(String) (String)
#endif

// If they don't have gettext
#else

#define _(String) (String)
#define N_(String) (String)

#endif

#endif


