#ifndef _MASK_H
#define _MASK_H

#include "mudtypes.h"
#include "strings.h"
#include "errlog.h"
#include "parse.h"
#include "flags.h"
#include "entity.h"


class Mask : public Entity {
 public:

   Mask();
   virtual ~Mask();
   Mask(char *mask_name);

   int load_mask(FILE *the_file, ErrLog *error_log, int is_builder);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   void write_object(FILE *the_file, int is_builder);
   int is_modified();
   void set_modified(int the_num);

   Flags *get_comflags();
   Flags *get_admflags();
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();


 private:

   int modified;

   Flags *com_flags;
   Flags *adm_flags;
};

#endif
