#ifndef _MONEY_H
#define _MONEY_H

#include "strings.h"
#include "merger.h"
#include "builder.h"

class Money : public Merger
{
public:

   Money(char *the_name, char *the_area);
   virtual ~Money();

   virtual void write_object(FILE *the_file, int build_format);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   int      set_money_index(int the_num);
   int      get_money_index();

   int      get_total_sum_index();

   int      copy_money(Money *copy_from);
   Money    *operator = (Money *copy_from);
   int      read_money_attrib(FILE *read_file, ErrLog *error_log);
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();

 protected:

   Money();

 private:

   int      money_index;
};

#endif
